/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToByteNodeGen;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.BiFunction;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class})
public abstract class CastToByteNode
extends Node {
    public static final CastToByteNode UNCACHED_INSTANCE = CastToByteNode.create();
    @Node.Child
    private PRaiseNode raiseNode;
    private final BiFunction<Object, PRaiseNode, Byte> rangeErrorHandler;
    private final BiFunction<Object, PRaiseNode, Byte> typeErrorHandler;
    protected final boolean coerce;

    protected CastToByteNode(BiFunction<Object, PRaiseNode, Byte> rangeErrorHandler, BiFunction<Object, PRaiseNode, Byte> typeErrorHandler, boolean coerce) {
        this.rangeErrorHandler = rangeErrorHandler;
        this.typeErrorHandler = typeErrorHandler;
        this.coerce = coerce;
    }

    public abstract byte execute(VirtualFrame var1, Object var2);

    @Specialization
    protected static byte doByte(byte value) {
        return value;
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static byte doShort(short value) throws OverflowException {
        return PInt.byteValueExact(value);
    }

    @Specialization(replaces={"doShort"})
    protected byte doShortOvf(short value) {
        try {
            return PInt.byteValueExact(value);
        }
        catch (OverflowException e) {
            return this.handleRangeError(value);
        }
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static byte doInt(int value) throws OverflowException {
        return PInt.byteValueExact(value);
    }

    @Specialization(replaces={"doInt"})
    protected byte doIntOvf(int value) {
        try {
            return PInt.byteValueExact(value);
        }
        catch (OverflowException e) {
            return this.handleRangeError(value);
        }
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static byte doLong(long value) throws OverflowException {
        return PInt.byteValueExact(value);
    }

    @Specialization(replaces={"doLong"})
    protected byte doLongOvf(long value) {
        try {
            return PInt.byteValueExact(value);
        }
        catch (OverflowException e) {
            return this.handleRangeError(value);
        }
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static byte doPInt(PInt value) throws OverflowException {
        return PInt.byteValueExact(value.longValueExact());
    }

    @Specialization(replaces={"doPInt"})
    protected byte doPIntOvf(PInt value) {
        try {
            return PInt.byteValueExact(value.longValueExact());
        }
        catch (OverflowException | ArithmeticException e) {
            return this.handleRangeError(value);
        }
    }

    @Specialization
    protected static byte doBoolean(boolean value) {
        return value ? (byte)1 : 0;
    }

    @Specialization
    protected byte doBytes(PBytesLike value, @Cached SequenceStorageNodes.GetItemNode getItemNode) {
        if (this.coerce) {
            return this.doIntOvf(getItemNode.executeKnownInt(value.getSequenceStorage(), 0));
        }
        return this.doError(value);
    }

    @Specialization
    protected byte doObject(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached CastToByteNode recursive) {
        if (indexCheckNode.execute(inliningTarget, value)) {
            return recursive.execute(frame, indexNode.execute((Frame)frame, inliningTarget, value));
        }
        return this.doError(value);
    }

    private byte doError(Object val) {
        if (this.raiseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
        }
        if (this.typeErrorHandler != null) {
            return (Byte)this.typeErrorHandler.apply(val, this.raiseNode);
        }
        throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INTEGER_REQUIRED_GOT, val);
    }

    private byte handleRangeError(Object val) {
        if (this.raiseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
        }
        if (this.rangeErrorHandler != null) {
            return (Byte)this.rangeErrorHandler.apply(val, this.raiseNode);
        }
        throw this.raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
    }

    @NeverDefault
    public static CastToByteNode create() {
        return CastToByteNodeGen.create(null, null, false);
    }

    public static CastToByteNode getUncached() {
        return UNCACHED_INSTANCE;
    }

    @NeverDefault
    public static CastToByteNode create(boolean coerce) {
        return CastToByteNodeGen.create(null, null, coerce);
    }

    @NeverDefault
    public static CastToByteNode create(BiFunction<Object, PRaiseNode, Byte> rangeErrorHandler, BiFunction<Object, PRaiseNode, Byte> typeErrorHandler) {
        return CastToByteNodeGen.create(rangeErrorHandler, typeErrorHandler, false);
    }

    @NeverDefault
    public static CastToByteNode create(BiFunction<Object, PRaiseNode, Byte> rangeErrorHandler, BiFunction<Object, PRaiseNode, Byte> typeErrorHandler, boolean coerce) {
        return CastToByteNodeGen.create(rangeErrorHandler, typeErrorHandler, coerce);
    }
}

