/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.Session;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.result.SimpleRowValue;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.TableView;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    public static final String TABLE_LINK = "TABLE LINK";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    protected Column[] columns;
    protected int memoryPerRow;
    private final HashMap columnMap = new HashMap();
    private final boolean persistent;
    private ObjectArray triggers;
    private ObjectArray constraints;
    private ObjectArray sequences;
    private ObjectArray views;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Row nullRow;

    Table(Schema schema, int n, String string, boolean bl) {
        this.initSchemaObjectBase(schema, n, string, "table");
        this.persistent = bl;
    }

    public void rename(String string) throws SQLException {
        super.rename(string);
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = (Constraint)this.constraints.get(i);
            constraint.rebuild();
        }
    }

    public abstract void lock(Session var1, boolean var2, boolean var3) throws SQLException;

    public abstract void close(Session var1) throws SQLException;

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, IndexColumn[] var4, IndexType var5, int var6, String var7) throws SQLException;

    public abstract void removeRow(Session var1, Row var2) throws SQLException;

    public abstract void truncate(Session var1) throws SQLException;

    public abstract void addRow(Session var1, Row var2) throws SQLException;

    public abstract void checkSupportAlter() throws SQLException;

    public abstract String getTableType();

    public abstract Index getScanIndex(Session var1) throws SQLException;

    public abstract Index getUniqueIndex();

    public abstract ObjectArray getIndexes();

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public abstract boolean canGetRowCount();

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1) throws SQLException;

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.getInternalError();
    }

    public void addDependencies(HashSet hashSet) {
        if (this.sequences != null) {
            for (int i = 0; i < this.sequences.size(); ++i) {
                hashSet.add(this.sequences.get(i));
            }
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(7);
        expressionVisitor.setDependencies(hashSet);
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].isEverything(expressionVisitor);
        }
    }

    public ObjectArray getChildren() {
        ObjectArray objectArray = new ObjectArray();
        ObjectArray objectArray2 = this.getIndexes();
        if (objectArray2 != null) {
            objectArray.addAll(objectArray2);
        }
        if (this.constraints != null) {
            objectArray.addAll(this.constraints);
        }
        if (this.triggers != null) {
            objectArray.addAll(this.triggers);
        }
        if (this.sequences != null) {
            objectArray.addAll(this.sequences);
        }
        if (this.views != null) {
            objectArray.addAll(this.views);
        }
        ObjectArray objectArray3 = this.database.getAllRights();
        for (int i = 0; i < objectArray3.size(); ++i) {
            Right right = (Right)objectArray3.get(i);
            if (right.getGrantedTable() != this) continue;
            objectArray.add(right);
        }
        return objectArray;
    }

    protected void setColumns(Column[] columnArray) throws SQLException {
        this.columns = columnArray;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        int n = 0;
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            int n2 = column.getType();
            if (n2 == -1) {
                throw Message.getSQLException(50004, column.getSQL());
            }
            n += DataType.getDataType((int)n2).memory;
            column.setTable(this, i);
            String string = column.getName();
            if (this.columnMap.get(string) != null) {
                throw Message.getSQLException(42121, string);
            }
            this.columnMap.put(string, column);
        }
        this.memoryPerRow = n;
    }

    public void renameColumn(Column column, String string) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column2 = this.columns[i];
            if (column2 == column || !column2.getName().equals(string)) continue;
            throw Message.getSQLException(42121, string);
        }
        this.columnMap.remove(column.getName());
        column.rename(string);
        this.columnMap.put(string, column);
    }

    boolean isLockedExclusivelyBy(Session session) {
        return false;
    }

    public void updateRows(Prepared prepared, Session session, RowList rowList) throws SQLException {
        Row row;
        rowList.reset();
        while (rowList.hasNext()) {
            prepared.checkCanceled();
            row = rowList.next();
            rowList.next();
            this.removeRow(session, row);
            session.log(this, (short)1, row);
        }
        rowList.reset();
        while (rowList.hasNext()) {
            prepared.checkCanceled();
            rowList.next();
            row = rowList.next();
            this.addRow(session, row);
            session.log(this, (short)0, row);
        }
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        Object object;
        while (this.views != null && this.views.size() > 0) {
            object = (TableView)this.views.get(0);
            this.views.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.triggers != null && this.triggers.size() > 0) {
            object = (TriggerObject)this.triggers.get(0);
            this.triggers.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            object = (Constraint)this.constraints.get(0);
            this.constraints.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        object = this.database.getAllRights();
        for (int i = 0; i < ((ObjectArray)object).size(); ++i) {
            Right right = (Right)((ObjectArray)object).get(i);
            if (right.getGrantedTable() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.sequences != null && this.sequences.size() > 0) {
            Sequence sequence = (Sequence)this.sequences.get(0);
            this.sequences.remove(0);
            if (this.getTemporary() || this.database.getDependentTable(sequence, this) != null) continue;
            this.database.removeSchemaObject(session, sequence);
        }
    }

    public void checkColumnIsNotReferenced(Column column) throws SQLException {
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = (Constraint)this.constraints.get(i);
            if (!constraint.containsColumn(column)) continue;
            throw Message.getSQLException(90083, constraint.getSQL());
        }
        ObjectArray objectArray = this.getIndexes();
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            Index index = (Index)objectArray.get(i);
            if (index.getColumns().length == 1 || index.getCreateSQL() == null || index.getColumnIndex(column) < 0) continue;
            throw Message.getSQLException(90083, index.getSQL());
        }
    }

    public Row getTemplateRow() {
        return new Row(new Value[this.columns.length], this.memoryPerRow);
    }

    public SearchRow getTemplateSimpleRow(boolean bl) {
        if (bl) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row getNullRow() {
        Table table = this;
        synchronized (table) {
            if (this.nullRow == null) {
                this.nullRow = new Row(new Value[this.columns.length], 0);
                for (int i = 0; i < this.columns.length; ++i) {
                    this.nullRow.setValue(i, ValueNull.INSTANCE);
                }
            }
            return this.nullRow;
        }
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public int getType() {
        return 0;
    }

    public Column getColumn(int n) {
        return this.columns[n];
    }

    public Column getColumn(String string) throws SQLException {
        Column column = (Column)this.columnMap.get(string);
        if (column == null) {
            throw Message.getSQLException(42122, string);
        }
        return column;
    }

    public PlanItem getBestPlanItem(Session session, int[] nArray) throws SQLException {
        PlanItem planItem = new PlanItem();
        planItem.setIndex(this.getScanIndex(session));
        planItem.cost = planItem.getIndex().getCost(session, null);
        ObjectArray objectArray = this.getIndexes();
        for (int i = 1; objectArray != null && nArray != null && i < objectArray.size(); ++i) {
            Index index = (Index)objectArray.get(i);
            double d = index.getCost(session, nArray);
            if (!(d < planItem.cost)) continue;
            planItem.cost = d;
            planItem.setIndex(index);
        }
        return planItem;
    }

    public Index findPrimaryKey() {
        ObjectArray objectArray = this.getIndexes();
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            Index index = (Index)objectArray.get(i);
            if (!index.getIndexType().getPrimaryKey()) continue;
            return index;
        }
        return null;
    }

    public Index getPrimaryKey() throws SQLException {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw Message.getSQLException(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            Value value;
            Value value2 = row.getValue(i);
            Column column = this.columns[i];
            if (column.getComputed()) {
                value2 = null;
                value = column.computeValue(session, row);
            }
            if ((value = column.validateConvertUpdateSequence(session, value2)) == value2) continue;
            row.setValue(i, value);
        }
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    private void remove(ObjectArray objectArray, DbObject dbObject) {
        int n;
        if (objectArray != null && (n = objectArray.indexOf(dbObject)) >= 0) {
            objectArray.remove(n);
        }
    }

    public void removeIndex(Index index) {
        ObjectArray objectArray = this.getIndexes();
        if (objectArray != null) {
            this.remove(objectArray, index);
            if (index.getIndexType().getPrimaryKey()) {
                Column[] columnArray = index.getColumns();
                for (int i = 0; i < columnArray.length; ++i) {
                    columnArray[i].setPrimaryKey(false);
                }
            }
        }
    }

    void removeView(TableView tableView) {
        this.remove(this.views, tableView);
    }

    public void removeConstraint(Constraint constraint) {
        this.remove(this.constraints, constraint);
    }

    public void removeSequence(Session session, Sequence sequence) {
        this.remove(this.sequences, sequence);
    }

    public void removeTrigger(TriggerObject triggerObject) {
        this.remove(this.triggers, triggerObject);
    }

    public void addView(TableView tableView) {
        this.views = this.add(this.views, tableView);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || this.constraints.indexOf(constraint) < 0) {
            this.constraints = this.add(this.constraints, constraint);
        }
    }

    public ObjectArray getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = this.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject triggerObject) {
        this.triggers = this.add(this.triggers, triggerObject);
    }

    private ObjectArray add(ObjectArray objectArray, DbObject dbObject) {
        if (objectArray == null) {
            objectArray = new ObjectArray();
        }
        objectArray.add(dbObject);
        return objectArray;
    }

    public void fireBefore(Session session) throws SQLException {
        this.fire(session, true);
    }

    public void fireAfter(Session session) throws SQLException {
        this.fire(session, false);
    }

    private void fire(Session session, boolean bl) throws SQLException {
        if (this.triggers != null) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerObject triggerObject = (TriggerObject)this.triggers.get(i);
                triggerObject.fire(session, bl);
            }
        }
    }

    public boolean fireRow() {
        return this.constraints != null && this.constraints.size() > 0 || this.triggers != null && this.triggers.size() > 0;
    }

    public void fireBeforeRow(Session session, Row row, Row row2) throws SQLException {
        this.fireRow(session, row, row2, true);
        this.fireConstraints(session, row, row2, true);
    }

    private void fireConstraints(Session session, Row row, Row row2, boolean bl) throws SQLException {
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.size(); ++i) {
                Constraint constraint = (Constraint)this.constraints.get(i);
                if (constraint.isBefore() != bl) continue;
                constraint.checkRow(session, this, row, row2);
            }
        }
    }

    public void fireAfterRow(Session session, Row row, Row row2) throws SQLException {
        this.fireRow(session, row, row2, false);
        this.fireConstraints(session, row, row2, false);
    }

    private void fireRow(Session session, Row row, Row row2, boolean bl) throws SQLException {
        if (this.triggers != null) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerObject triggerObject = (TriggerObject)this.triggers.get(i);
                triggerObject.fireRow(session, row, row2, bl);
            }
        }
    }

    public boolean getGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean bl, boolean bl2) throws SQLException {
        if (bl && bl2) {
            for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
                Constraint constraint = (Constraint)this.constraints.get(i);
                constraint.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = bl;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean bl) {
        ObjectArray objectArray = this.getIndexes();
        for (int i = 1; objectArray != null && i < objectArray.size(); ++i) {
            int n;
            Index index = (Index)objectArray.get(i);
            if (!index.canGetFirstOrLast() || (n = index.getColumnIndex(column)) != 0) continue;
            return index;
        }
        return null;
    }

    public boolean getOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean bl) {
        this.onCommitDrop = bl;
    }

    public boolean getOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean bl) {
        this.onCommitTruncate = bl;
    }

    boolean getClustered() {
        return false;
    }

    public void removeIndexOrTransferOwnership(Session session, Index index) throws SQLException {
        boolean bl = false;
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = (Constraint)this.constraints.get(i);
            if (!constraint.usesIndex(index)) continue;
            constraint.setIndexOwner(index);
            this.database.update(session, constraint);
            bl = true;
        }
        if (!bl) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public ObjectArray checkDeadlock(Session session, Session session2) {
        return null;
    }
}

