/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Max;

public class MaxValidatorForNumber
implements ConstraintValidator<Max, Number> {
    private long maxValue;

    public void initialize(Max maxValue) {
        this.maxValue = maxValue.value();
    }

    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof Double) {
            if ((Double)value == Double.NEGATIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN((Double)value) || (Double)value == Double.POSITIVE_INFINITY) {
                return false;
            }
        } else if (value instanceof Float) {
            if (((Float)value).floatValue() == Float.NEGATIVE_INFINITY) {
                return true;
            }
            if (Float.isNaN(((Float)value).floatValue()) || ((Float)value).floatValue() == Float.POSITIVE_INFINITY) {
                return false;
            }
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(this.maxValue)) != 1;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(this.maxValue)) != 1;
        }
        long longValue = value.longValue();
        return longValue <= this.maxValue;
    }
}

