/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.Arrays;

public class KeyAgreeRecipientId
extends RecipientId {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public KeyAgreeRecipientId(byte[] subjectKeyId) {
        super(2);
        super.setSubjectKeyIdentifier(new DEROctetString(subjectKeyId).getDEREncoded());
        this.subjectKeyId = subjectKeyId;
    }

    public KeyAgreeRecipientId(X500Name issuer, BigInteger serialNumber) {
        super(2);
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        try {
            this.setIssuer(issuer.getDEREncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid issuer: " + e.getMessage());
        }
        this.setSerialNumber(serialNumber);
    }

    public int hashCode() {
        int code = Arrays.hashCode((byte[])this.subjectKeyId);
        if (this.serialNumber != null) {
            code ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            code ^= this.issuer.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyAgreeRecipientId)) {
            return false;
        }
        KeyAgreeRecipientId id = (KeyAgreeRecipientId)o;
        return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])id.subjectKeyId) && this.equalsObj(this.serialNumber, id.serialNumber) && this.equalsObj(this.issuer, id.issuer);
    }

    private boolean equalsObj(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    public boolean match(Object obj) {
        if (obj instanceof X509CertificateHolder) {
            X509CertificateHolder certHldr = (X509CertificateHolder)obj;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber iAndS = certHldr.getIssuerAndSerialNumber();
                return iAndS.getName().equals((Object)this.issuer) && iAndS.getSerialNumber().getValue().equals(this.getSerialNumber());
            }
            if (this.getSubjectKeyIdentifier() != null) {
                X509Extension ext = certHldr.getExtension(X509Extension.subjectKeyIdentifier);
                if (ext == null) {
                    SHA1Digest dig = new SHA1Digest();
                    byte[] hash = new byte[dig.getDigestSize()];
                    byte[] spkiEnc = certHldr.getSubjectPublicKeyInfo().getDEREncoded();
                    dig.update(spkiEnc, 0, spkiEnc.length);
                    dig.doFinal(hash, 0);
                    return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])hash);
                }
                byte[] subKeyID = ASN1OctetString.getInstance((Object)ext.getParsedValue()).getOctets();
                return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])subKeyID);
            }
        } else {
            if (obj instanceof byte[]) {
                return Arrays.areEqual((byte[])this.subjectKeyId, (byte[])((byte[])obj));
            }
            if (obj instanceof KeyAgreeRecipientInformation) {
                return ((KeyAgreeRecipientInformation)obj).getRID().equals(this);
            }
        }
        return false;
    }
}

