/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public class SMIMEEnvelopedTest
extends TestCase {
    private static String _signDN;
    private static KeyPair _signKP;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static String _reciDN2;
    private static KeyPair _reciKP2;
    private static X509Certificate _reciCert2;
    private static boolean _initialised;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _reciDN2 = "CN=Fred, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP2 = CMSTestUtil.makeKeyPair();
            _reciCert2 = CMSTestUtil.makeCertificate(_reciKP2, _reciDN2, _signKP, _signDN);
        }
    }

    public SMIMEEnvelopedTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(SMIMEEnvelopedTest.class);
    }

    public static Test suite() throws Exception {
        return new SMIMETestSetup((Test)new TestSuite(SMIMEEnvelopedTest.class));
    }

    public void setUp() throws Exception {
        SMIMEEnvelopedTest.init();
    }

    public void testHeaders() throws Exception {
        MimeBodyPart _msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addKeyTransRecipient(_reciCert);
        MimeBodyPart mp = gen.generate(_msg, SMIMEEnvelopedGenerator.DES_EDE3_CBC, "BC");
        SMIMEEnvelopedTest.assertEquals((String)"application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data", (String)mp.getHeader("Content-Type")[0]);
        SMIMEEnvelopedTest.assertEquals((String)"attachment; filename=\"smime.p7m\"", (String)mp.getHeader("Content-Disposition")[0]);
        SMIMEEnvelopedTest.assertEquals((String)"S/MIME Encrypted Message", (String)mp.getHeader("Content-Description")[0]);
    }

    public void testDESEDE3Encrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = SMIMEEnvelopedGenerator.DES_EDE3_CBC;
        this.verifyAlgorithm(algorithm, msg);
    }

    public void testParserDESEDE3Encrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = SMIMEEnvelopedGenerator.DES_EDE3_CBC;
        this.verifyParserAlgorithm(algorithm, msg);
    }

    public void testIDEAEncrypted() throws Exception {
        if (this.isPresent("IDEA")) {
            MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            String algorithm = "1.3.6.1.4.1.188.7.1.1.2";
            this.verifyAlgorithm(algorithm, msg);
        }
    }

    private boolean isPresent(String algorithm) throws Exception {
        try {
            Cipher.getInstance(algorithm, "BC");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public void testRC2Encrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = SMIMEEnvelopedGenerator.RC2_CBC;
        this.verifyAlgorithm(algorithm, msg);
    }

    public void testCASTEncrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = "1.2.840.113533.7.66.10";
        this.verifyAlgorithm(algorithm, msg);
    }

    public void testAES128Encrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = SMIMEEnvelopedGenerator.AES128_CBC;
        this.verifyAlgorithm(algorithm, msg);
    }

    public void testAES192Encrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = SMIMEEnvelopedGenerator.AES192_CBC;
        this.verifyAlgorithm(algorithm, msg);
    }

    public void testAES256Encrypted() throws Exception {
        MimeBodyPart msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        String algorithm = SMIMEEnvelopedGenerator.AES256_CBC;
        this.verifyAlgorithm(algorithm, msg);
    }

    public void testSubKeyId() throws Exception {
        MimeBodyPart _msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        MessageDigest dig = MessageDigest.getInstance("SHA1", "BC");
        dig.update(_reciCert.getPublicKey().getEncoded());
        gen.addKeyTransRecipient(_reciCert.getPublicKey(), dig.digest());
        MimeBodyPart mp = gen.generate(_msg, SMIMEEnvelopedGenerator.DES_EDE3_CBC, "BC");
        SMIMEEnveloped m = new SMIMEEnveloped(mp);
        dig.update(_reciCert.getPublicKey().getEncoded());
        KeyTransRecipientId recId = new KeyTransRecipientId(dig.digest());
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        MimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContent((Key)_reciKP.getPrivate(), "BC"));
        this.verifyMessageBytes(_msg, res);
    }

    public void testCapEncrypt() throws Exception {
        MimeBodyPart _msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        MessageDigest dig = MessageDigest.getInstance("SHA1", "BC");
        dig.update(_reciCert.getPublicKey().getEncoded());
        gen.addKeyTransRecipient(_reciCert.getPublicKey(), dig.digest());
        MimeBodyPart mp = gen.generate(_msg, SMIMEEnvelopedGenerator.RC2_CBC, 40, "BC");
        SMIMEEnveloped m = new SMIMEEnveloped(mp);
        dig.update(_reciCert.getPublicKey().getEncoded());
        KeyTransRecipientId recId = new KeyTransRecipientId(dig.digest());
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        MimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContent((Key)_reciKP.getPrivate(), "BC"));
        this.verifyMessageBytes(_msg, res);
    }

    public void testTwoRecipients() throws Exception {
        MimeBodyPart _msg = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addKeyTransRecipient(_reciCert);
        gen.addKeyTransRecipient(_reciCert2);
        MimeBodyPart mp = gen.generate(_msg, SMIMEEnvelopedGenerator.RC2_CBC, 40, "BC");
        SMIMEEnvelopedParser m = new SMIMEEnvelopedParser(mp);
        RecipientId recId = this.getRecipientId(_reciCert2);
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        FileBackedMimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContentStream((Key)_reciKP2.getPrivate(), "BC"));
        this.verifyMessageBytes(_msg, res);
        m = new SMIMEEnvelopedParser(mp);
        res.dispose();
        recId = this.getRecipientId(_reciCert);
        recipients = m.getRecipientInfos();
        recipient = recipients.get(recId);
        res = SMIMEUtil.toMimeBodyPart(recipient.getContentStream((Key)_reciKP.getPrivate(), "BC"));
        this.verifyMessageBytes(_msg, res);
        res.dispose();
    }

    private void verifyAlgorithm(String algorithmOid, MimeBodyPart msg) throws Exception {
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addKeyTransRecipient(_reciCert);
        MimeBodyPart mp = gen.generate(msg, algorithmOid, "BC");
        SMIMEEnveloped m = new SMIMEEnveloped(mp);
        RecipientId recId = this.getRecipientId(_reciCert);
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        MimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContent((Key)_reciKP.getPrivate(), "BC"));
        this.verifyMessageBytes(msg, res);
    }

    private void verifyParserAlgorithm(String algorithmOid, MimeBodyPart msg) throws Exception {
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addKeyTransRecipient(_reciCert);
        MimeBodyPart mp = gen.generate(msg, algorithmOid, "BC");
        SMIMEEnvelopedParser m = new SMIMEEnvelopedParser(mp);
        RecipientId recId = this.getRecipientId(_reciCert);
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        MimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContent((Key)_reciKP.getPrivate(), "BC"));
        this.verifyMessageBytes(msg, res);
    }

    private RecipientId getRecipientId(X509Certificate cert) throws IOException, CertificateEncodingException {
        JceKeyTransRecipientId recId = new JceKeyTransRecipientId(cert);
        return recId;
    }

    private void verifyMessageBytes(MimeBodyPart a, MimeBodyPart b) throws IOException, MessagingException {
        ByteArrayOutputStream _baos = new ByteArrayOutputStream();
        a.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _msgBytes = _baos.toByteArray();
        _baos = new ByteArrayOutputStream();
        b.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _resBytes = _baos.toByteArray();
        SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(_msgBytes, _resBytes));
    }

    static {
        _initialised = false;
    }
}

