/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.InputStream;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.test.DummyCertPathReviewer;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.mail.smime.validator.SignedMailValidator;
import org.bouncycastle.x509.PKIXCertPathReviewer;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class SignedMailValidatorTest
extends TestCase {
    static String TEST_TRUST_ACHOR = "validator.root.crt";

    public void testShortKey() throws Exception {
        String message = "validator.shortKey.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getNotifications(), "SignedMailValidator.shortSigningKey", "Warning: The signing key is only 512 bits long.");
    }

    public void testKeyUsage() throws Exception {
        String message = "validator.keyUsage.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertTrue((boolean)result.getCertPathReview().isValidCertPath());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getErrors(), "SignedMailValidator.signingNotPermitted", "The key usage extension of signer certificate does not permit using the key for email signatures.");
    }

    public void testExtKeyUsage() throws Exception {
        String message = "validator.extKeyUsage.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertTrue((boolean)result.getCertPathReview().isValidCertPath());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getErrors(), "SignedMailValidator.extKeyUsageNotPermitted", "The extended key usage extension of the signer certificate does not permit using the key for email signatures.");
    }

    public void testNoEmail() throws Exception {
        String message = "validator.noEmail.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertTrue((boolean)result.getCertPathReview().isValidCertPath());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getErrors(), "SignedMailValidator.noEmailInCert", "The signer certificate is not usable for email signatures: it contains no email address.");
    }

    public void testNotYetValid() throws Exception {
        String message = "validator.notYetValid.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getErrors(), "SignedMailValidator.certNotYetValid", "The message was signed at Aug 28, 2006 3:04:01 PM GMT. But the certificate is not valid before Dec 28, 2006 2:19:31 PM GMT.");
        PKIXCertPathReviewer review = result.getCertPathReview();
        SignedMailValidatorTest.assertFalse((boolean)review.isValidCertPath());
        this.assertContainsMessage(review.getErrors(0), "CertPathReviewer.certificateNotYetValid", "Could not validate the certificate. Certificate is not valid until Dec 28, 2006 2:19:31 PM GMT.");
    }

    public void testExpired() throws Exception {
        String message = "validator.expired.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getErrors(), "SignedMailValidator.certExpired", "The message was signed at Sep 1, 2006 9:08:35 AM GMT. But the certificate expired at Sep 1, 2006 8:39:20 AM GMT.");
        PKIXCertPathReviewer review = result.getCertPathReview();
        SignedMailValidatorTest.assertFalse((boolean)review.isValidCertPath());
        this.assertContainsMessage(review.getErrors(0), "CertPathReviewer.certificateExpired", "Could not validate the certificate. Certificate expired on Sep 1, 2006 8:39:20 AM GMT.");
    }

    public void testRevoked() throws Exception {
        String message = "validator.revoked.eml";
        PKIXParameters params = this.createDefaultParams();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        crlList.add(this.loadCRL("validator.revoked.crl"));
        CertStore crls = CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlList));
        params.addCertStore(crls);
        params.setRevocationEnabled(true);
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        PKIXCertPathReviewer review = result.getCertPathReview();
        SignedMailValidatorTest.assertFalse((boolean)review.isValidCertPath());
        this.assertContainsMessage(review.getErrors(0), "CertPathReviewer.certRevoked", "The certificate was revoked at Sep 1, 2006 9:30:00 AM GMT. Reason: Key Compromise.");
    }

    public void testLongValidity() throws Exception {
        String message = "validator.longValidity.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertTrue((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getNotifications(), "SignedMailValidator.longValidity", "Warning: The signing certificate has a very long validity period: from Sep 1, 2006 11:00:00 AM GMT until Aug 8, 2106 11:00:00 AM GMT.");
    }

    public void testSelfSignedCert() throws Exception {
        MimeBodyPart baseMsg = SMIMETestUtil.makeMimeBodyPart("Hello world!\n");
        String signDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair signKP = CMSTestUtil.makeKeyPair();
        X509Certificate signCert = CMSTestUtil.makeV1Certificate(signKP, signDN, signKP, signDN);
        HashSet<TrustAnchor> trustanchors = new HashSet<TrustAnchor>();
        TrustAnchor ta = new TrustAnchor(signCert, null);
        trustanchors.add(ta);
        X509Certificate rootCert = ta.getTrustedCert();
        ArrayList<CertStore> certStores = new ArrayList<CertStore>();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(rootCert);
        CertStore store = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
        certStores.add(store);
        CertPath path = SignedMailValidator.createCertPath(rootCert, trustanchors, certStores);
        SignedMailValidatorTest.assertTrue((String)"path size is not 1", (path.getCertificates().size() == 1 ? 1 : 0) != 0);
        certList = new ArrayList();
        certList.add(signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigner(signKP.getPrivate(), signCert, SMIMESignedGenerator.DIGEST_SHA1);
        gen.addCertificatesAndCRLs(certs);
        MimeMultipart signedMsg = gen.generate(baseMsg, "BC");
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        msg.setFrom((Address)fromUser);
        msg.setRecipient(Message.RecipientType.TO, (Address)toUser);
        msg.setContent((Object)signedMsg, signedMsg.getContentType());
        msg.saveChanges();
        PKIXParameters params = new PKIXParameters(trustanchors);
        params.setRevocationEnabled(false);
        SignedMailValidator validator = new SignedMailValidator(msg, params);
        SignerInformation signer = (SignerInformation)validator.getSignerInformationStore().getSigners().iterator().next();
        SignedMailValidator.ValidationResult res = validator.getValidationResult(signer);
        SignedMailValidatorTest.assertTrue((boolean)res.isVerifiedSignature());
        SignedMailValidatorTest.assertTrue((boolean)res.isValidSignature());
    }

    public void testCircular() throws Exception {
        String message = "circular.eml";
        PKIXParameters params = this.createDefaultParams();
        SignedMailValidator.ValidationResult result = this.doTest(message, params);
        SignedMailValidatorTest.assertTrue((boolean)result.isVerifiedSignature());
        SignedMailValidatorTest.assertFalse((boolean)result.isValidSignature());
        SignedMailValidatorTest.assertFalse((boolean)result.getCertPathReview().isValidCertPath());
        SignedMailValidatorTest.assertTrue((String)"cert path size", (result.getCertPathReview().getCertPathSize() > 2 ? 1 : 0) != 0);
    }

    public void testExtendedReviewer() throws Exception {
        SignedMailValidator validator;
        MimeMessage msg;
        Session session;
        Properties props;
        try {
            props = System.getProperties();
            session = Session.getDefaultInstance((Properties)props, null);
            msg = new MimeMessage(session, ((Object)((Object)this)).getClass().getResourceAsStream("validator.shortKey.eml"));
            validator = new SignedMailValidator(msg, this.createDefaultParams(), String.class);
            SignedMailValidatorTest.fail();
        }
        catch (IllegalArgumentException e) {
            SignedMailValidatorTest.assertTrue((boolean)e.getMessage().startsWith("certPathReviewerClass is not a subclass of"));
        }
        props = System.getProperties();
        session = Session.getDefaultInstance((Properties)props, null);
        msg = new MimeMessage(session, ((Object)((Object)this)).getClass().getResourceAsStream("validator.shortKey.eml"));
        validator = new SignedMailValidator(msg, this.createDefaultParams(), DummyCertPathReviewer.class);
        SignerInformation sInfo = (SignerInformation)validator.getSignerInformationStore().getSigners().iterator().next();
        SignedMailValidator.ValidationResult result = validator.getValidationResult(sInfo);
        SignedMailValidatorTest.assertTrue((boolean)result.isValidSignature());
        this.assertContainsMessage(result.getNotifications(), "SignedMailValidator.shortSigningKey", "Warning: The signing key is only 512 bits long.");
    }

    public void testCreateCertPath() throws Exception {
        HashSet<TrustAnchor> trustanchors = new HashSet<TrustAnchor>();
        TrustAnchor ta = this.getTrustAnchor("certpath_root.crt");
        trustanchors.add(ta);
        X509Certificate rootCert = ta.getTrustedCert();
        X509Certificate interCert1 = this.loadCert("certpath_inter1.crt");
        X509Certificate interCert2 = this.loadCert("certpath_inter2.crt");
        X509Certificate endCert1 = this.loadCert("certpath_end1.crt");
        X509Certificate endCert2 = this.loadCert("certpath_end2.crt");
        ArrayList<CertStore> certStores = new ArrayList<CertStore>();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(interCert1);
        certList.add(interCert2);
        CertStore store = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
        certStores.add(store);
        CertPath path = SignedMailValidator.createCertPath(endCert1, trustanchors, certStores);
        SignedMailValidatorTest.assertTrue((String)"path size is not 3", (path.getCertificates().size() == 3 ? 1 : 0) != 0);
        SignedMailValidatorTest.assertEquals((String)"different end certificate", (Object)path.getCertificates().get(0), (Object)endCert1);
        SignedMailValidatorTest.assertEquals((String)"different intermediate certificate", (Object)path.getCertificates().get(1), (Object)interCert1);
        SignedMailValidatorTest.assertEquals((String)"different root certificate", (Object)path.getCertificates().get(2), (Object)rootCert);
        path = SignedMailValidator.createCertPath(endCert2, trustanchors, certStores);
        SignedMailValidatorTest.assertTrue((String)"path size is not 3", (path.getCertificates().size() == 3 ? 1 : 0) != 0);
        SignedMailValidatorTest.assertEquals((String)"different end certificate", (Object)path.getCertificates().get(0), (Object)endCert2);
        SignedMailValidatorTest.assertEquals((String)"different intermediate certificate", (Object)path.getCertificates().get(1), (Object)interCert2);
        SignedMailValidatorTest.assertEquals((String)"different root certificate", (Object)path.getCertificates().get(2), (Object)rootCert);
    }

    private SignedMailValidator.ValidationResult doTest(String message, PKIXParameters params) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, ((Object)((Object)this)).getClass().getResourceAsStream(message));
        SignedMailValidator validator = new SignedMailValidator(msg, params);
        SignerInformation signer = (SignerInformation)validator.getSignerInformationStore().getSigners().iterator().next();
        return validator.getValidationResult(signer);
    }

    private void assertContainsMessage(List msgList, String messageId, String text) throws Exception {
        Iterator it = msgList.iterator();
        boolean found = false;
        while (it.hasNext()) {
            ErrorBundle message = (ErrorBundle)it.next();
            if (!message.getId().equals(messageId)) continue;
            found = true;
            SignedMailValidatorTest.assertEquals((String)text, (String)message.getText(Locale.ENGLISH, TimeZone.getTimeZone("GMT")));
            break;
        }
        SignedMailValidatorTest.assertTrue((String)"Expected message not found!", (boolean)found);
    }

    private PKIXParameters createDefaultParams() throws Exception {
        HashSet<TrustAnchor> trustanchors = new HashSet<TrustAnchor>();
        trustanchors.add(this.getTrustAnchor(TEST_TRUST_ACHOR));
        PKIXParameters defParams = new PKIXParameters(trustanchors);
        defParams.setRevocationEnabled(false);
        return defParams;
    }

    private TrustAnchor getTrustAnchor(String trustcert) throws Exception {
        X509Certificate cert = this.loadCert(trustcert);
        if (cert != null) {
            byte[] ncBytes = cert.getExtensionValue(X509Extensions.NameConstraints.getId());
            if (ncBytes != null) {
                ASN1Object extValue = X509ExtensionUtil.fromExtensionValue((byte[])ncBytes);
                return new TrustAnchor(cert, extValue.getDEREncoded());
            }
            return new TrustAnchor(cert, null);
        }
        return null;
    }

    private X509Certificate loadCert(String certfile) throws Exception {
        X509Certificate cert = null;
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(certfile);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        cert = (X509Certificate)cf.generateCertificate(in);
        return cert;
    }

    private X509CRL loadCRL(String crlfile) throws Exception {
        X509CRL crl = null;
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(crlfile);
        CertificateFactory cf = CertificateFactory.getInstance("x.509", "BC");
        crl = (X509CRL)cf.generateCRL(in);
        return crl;
    }

    public void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)SignedMailValidatorTest.suite());
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("SignedMailValidator Tests");
        suite.addTestSuite(SignedMailValidatorTest.class);
        return suite;
    }
}

