/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.util.Map;
import org.jaitools.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImageDataType {
    BYTE("Byte", 0, Byte.class),
    SHORT("Short", 2, Short.class),
    USHORT("Unsigned short", 1, Short.class),
    INT("Integer", 3, Integer.class),
    FLOAT("Float", 4, Float.class),
    DOUBLE("Double", 5, Double.class);

    private static final Map<Integer, ImageDataType> codeLookup;
    private static final Map<Class<? extends Number>, ImageDataType> classLookup;
    private final String displayName;
    private final int dataBufferCode;
    private final Class<? extends Number> clazz;

    private ImageDataType(String displayName, int dataBufferCode, Class<? extends Number> clazz) {
        this.displayName = displayName;
        this.dataBufferCode = dataBufferCode;
        this.clazz = clazz;
    }

    public int getDataBufferType() {
        return this.dataBufferCode;
    }

    public Class<? extends Number> getDataClass() {
        return this.clazz;
    }

    public static ImageDataType getForDataBufferType(int typeCode) {
        ImageDataType t = codeLookup.get(typeCode);
        if (t == null) {
            throw new IllegalArgumentException("No match for type code " + typeCode);
        }
        return t;
    }

    public static ImageDataType getForClass(Class<? extends Number> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null argument");
        }
        ImageDataType t = classLookup.get(clazz);
        if (t == null) {
            throw new IllegalArgumentException("No match for data class " + clazz.getName());
        }
        return t;
    }

    public String toString() {
        return this.displayName;
    }

    static {
        codeLookup = CollectionFactory.map();
        for (ImageDataType t : ImageDataType.values()) {
            codeLookup.put(t.dataBufferCode, t);
        }
        classLookup = CollectionFactory.map();
        for (ImageDataType t : ImageDataType.values()) {
            if (t == USHORT) continue;
            classLookup.put(t.clazz, t);
        }
    }
}

