/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public abstract class AttributeDefinition {
    private final String name;
    private final String xmlName;
    private final ModelType type;
    private final boolean allowNull;
    private final boolean allowExpression;
    private final ModelNode defaultValue;
    private final MeasurementUnit measurementUnit;
    private final String[] alternatives;
    private final String[] requires;
    private final ParameterCorrector valueCorrector;
    private final ParameterValidator validator;
    private final EnumSet<AttributeAccess.Flag> flags;
    private final OperationContext NO_OPERATION_CONTEXT_FOR_RESOLVING_MODEL_PARAMETERS = new OperationContext(){

        @Override
        public void setRollbackOnly() {
        }

        @Override
        public void runtimeUpdateSkipped() {
        }

        @Override
        public void revertRestartRequired() {
        }

        @Override
        public void revertReloadRequired() {
        }

        @Override
        public void restartRequired() {
        }

        @Override
        public void report(MessageSeverity severity, String message) {
        }

        @Override
        public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        }

        @Override
        public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public Resource removeResource(PathAddress address) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public void reloadRequired() {
        }

        @Override
        public Resource readResourceForUpdate(PathAddress address) {
            return null;
        }

        @Override
        public Resource readResource(PathAddress address) {
            return null;
        }

        @Override
        public Resource readResource(PathAddress address, boolean recursive) {
            return null;
        }

        @Override
        public Resource readResourceFromRoot(PathAddress address) {
            return null;
        }

        @Override
        public Resource readResourceFromRoot(PathAddress address, boolean recursive) {
            return null;
        }

        @Override
        public ModelNode readModelForUpdate(PathAddress address) {
            return null;
        }

        @Override
        public ModelNode readModel(PathAddress address) {
            return null;
        }

        @Override
        public final boolean isNormalServer() {
            return false;
        }

        @Override
        public boolean isRuntimeAffected() {
            return false;
        }

        @Override
        public boolean isRollbackOnly() {
            return false;
        }

        @Override
        public boolean isRollbackOnRuntimeFailure() {
            return false;
        }

        @Override
        public boolean isResourceServiceRestartAllowed() {
            return false;
        }

        @Override
        public boolean isResourceRegistryAffected() {
            return false;
        }

        @Override
        public boolean isModelAffected() {
            return false;
        }

        @Override
        public boolean isBooting() {
            return false;
        }

        @Override
        public boolean hasResult() {
            return false;
        }

        @Override
        public boolean hasFailureDescription() {
            return false;
        }

        @Override
        public ProcessType getProcessType() {
            return null;
        }

        @Override
        public RunningMode getRunningMode() {
            return null;
        }

        @Override
        @Deprecated
        public OperationContext.Type getType() {
            return null;
        }

        @Override
        public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
            return null;
        }

        @Override
        public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public Resource getRootResource() {
            return null;
        }

        @Override
        public ModelNode getResult() {
            return null;
        }

        @Override
        public ModelNode getServerResults() {
            return null;
        }

        @Override
        public ManagementResourceRegistration getResourceRegistrationForUpdate() {
            return null;
        }

        @Override
        public ImmutableManagementResourceRegistration getResourceRegistration() {
            return null;
        }

        @Override
        public ImmutableManagementResourceRegistration getRootResourceRegistration() {
            return null;
        }

        @Override
        public ModelNode getFailureDescription() {
            return null;
        }

        @Override
        public ModelNode getResponseHeaders() {
            return null;
        }

        @Override
        public OperationContext.Stage getCurrentStage() {
            return null;
        }

        @Override
        public int getAttachmentStreamCount() {
            return 0;
        }

        @Override
        public InputStream getAttachmentStream(int index) {
            return null;
        }

        @Override
        public Resource createResource(PathAddress address) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public void completeStep(OperationContext.RollbackHandler rollbackHandler) {
        }

        @Override
        public OperationContext.ResultAction completeStep() {
            return null;
        }

        @Override
        public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        }

        @Override
        public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        }

        @Override
        public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        }

        @Override
        public void addResource(PathAddress address, Resource toAdd) {
        }

        @Override
        public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        }

        @Override
        public void addStep(OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        }

        @Override
        public void acquireControllerLock() {
        }

        @Override
        public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
            return ExpressionResolver.DEFAULT.resolveExpressions(node);
        }

        @Override
        public <T> T getAttachment(OperationContext.AttachmentKey<T> key) {
            return null;
        }

        @Override
        public <T> T attach(OperationContext.AttachmentKey<T> key, T value) {
            return null;
        }

        @Override
        public <T> T attachIfAbsent(OperationContext.AttachmentKey<T> key, T value) {
            return null;
        }

        @Override
        public <T> T detach(OperationContext.AttachmentKey<T> key) {
            return null;
        }

        @Override
        public Resource getOriginalRootResource() {
            return null;
        }

        @Override
        public boolean markResourceRestarted(PathAddress resource, Object owner) {
            return false;
        }

        @Override
        public boolean revertResourceRestarted(PathAddress resource, Object owner) {
            return false;
        }
    };

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterValidator validator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, null, validator, true, alternatives, requires, flags);
    }

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterCorrector valueCorrector, ParameterValidator validator, boolean validateNull, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this.name = name;
        this.xmlName = xmlName;
        this.type = type;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
        this.defaultValue = new ModelNode();
        if (defaultValue != null) {
            this.defaultValue.set(defaultValue);
        }
        this.defaultValue.protect();
        this.measurementUnit = measurementUnit;
        this.alternatives = alternatives;
        this.requires = requires;
        this.valueCorrector = valueCorrector;
        if (validator == null) {
            this.validator = null;
        } else {
            Boolean nullCheck = validateNull ? Boolean.valueOf(allowNull) : null;
            this.validator = new NillableOrExpressionParameterValidator(validator, nullCheck, allowExpression);
        }
        this.flags = flags == null || flags.length == 0 ? EnumSet.noneOf(AttributeAccess.Flag.class) : (flags.length == 0 ? EnumSet.of(flags[0]) : EnumSet.of(flags[0], flags));
    }

    public String getName() {
        return this.name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public ModelType getType() {
        return this.type;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    public ModelNode getDefaultValue() {
        return this.defaultValue.isDefined() ? this.defaultValue : null;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public String[] getAlternatives() {
        return this.alternatives;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public EnumSet<AttributeAccess.Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public boolean isMarshallable(ModelNode resourceModel) {
        return this.isMarshallable(resourceModel, true);
    }

    public boolean isMarshallable(ModelNode resourceModel, boolean marshallDefault) {
        return resourceModel.hasDefined(this.name) && (marshallDefault || !resourceModel.get(this.name).equals(this.defaultValue));
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        return this.validateOperation(operationObject, true);
    }

    public final void validateAndSet(ModelNode operationObject, ModelNode model) throws OperationFailedException {
        ModelNode newValue = this.correctValue(operationObject.get(this.name), model.get(this.name));
        if (!newValue.equals(operationObject.get(this.name))) {
            operationObject.get(this.name).set(newValue);
        }
        ModelNode node = this.validateOperation(operationObject, false);
        model.get(this.name).set(node);
    }

    @Deprecated
    public ModelNode validateResolvedOperation(ModelNode operationObject) throws OperationFailedException {
        return this.resolveModelAttribute(this.NO_OPERATION_CONTEXT_FOR_RESOLVING_MODEL_PARAMETERS, operationObject);
    }

    public ModelNode resolveModelAttribute(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (model.has(this.name)) {
            node.set(model.get(this.name));
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            node.set(this.defaultValue);
        }
        ModelNode resolved = context.resolveExpressions(node);
        this.validator.validateParameter(this.name, resolved);
        return resolved;
    }

    public boolean isAllowed(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRequired(ModelNode operationObject) {
        boolean required;
        boolean bl = required = !this.allowNull;
        return required ? !this.hasAlternative(operationObject) : required;
    }

    public boolean hasAlternative(ModelNode operationObject) {
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void marshallAsElement(ModelNode var1, XMLStreamWriter var2) throws XMLStreamException;

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode attr = this.getNoTextDescription(false);
        attr.get("description").set(this.getAttributeTextDescription(bundle2, prefix));
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        return result;
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode attr = this.getNoTextDescription(false);
        String description = resolver.getResourceAttributeDescription(this.getName(), locale, bundle2);
        attr.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        return result;
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode param = this.getNoTextDescription(true);
        param.get("description").set(this.getAttributeTextDescription(bundle2, prefix));
        ModelNode result = operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode param = this.getNoTextDescription(true);
        String description = resolver.getOperationParameterDescription(operationName, this.getName(), locale, bundle2);
        param.get("description").set(description);
        ModelNode result = resourceDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        return result;
    }

    public String getAttributeTextDescription(ResourceBundle bundle2, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        return bundle2.getString(bundleKey);
    }

    public ModelNode getNoTextDescription(boolean forOperation) {
        AllowedValuesValidator avv;
        List<ModelNode> allowed;
        ModelNode result = new ModelNode();
        result.get("type").set(this.type);
        result.get("description");
        result.get("expressions-allowed").set(this.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        if (!forOperation && this.defaultValue != null && this.defaultValue.isDefined()) {
            result.get("default").set(this.defaultValue);
        }
        if (this.measurementUnit != null && this.measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(this.measurementUnit.getName());
        }
        if (this.alternatives != null) {
            for (String alternative : this.alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if (this.requires != null) {
            for (String required : this.requires) {
                result.get("requires").add(required);
            }
        }
        if (this.validator instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)this.validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.type) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.type) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        if (this.validator instanceof AllowedValuesValidator && (allowed = (avv = (AllowedValuesValidator)((Object)this.validator)).getAllowedValues()) != null) {
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
        return result;
    }

    protected final ModelNode correctValue(ModelNode newValue, ModelNode oldValue) {
        if (this.valueCorrector != null) {
            return this.valueCorrector.correct(newValue, oldValue);
        }
        return newValue;
    }

    private ModelNode validateOperation(ModelNode operationObject, boolean correctValue) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (operationObject.has(this.name)) {
            node.set(operationObject.get(this.name));
        }
        if (this.isAllowExpression() && node.getType() == ModelType.STRING) {
            node = ParseUtils.parsePossibleExpression(node.asString());
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            if (correctValue) {
                this.correctValue(node, node);
            }
            this.validator.validateParameter(this.name, this.defaultValue);
        } else {
            if (correctValue) {
                this.correctValue(node, node);
            }
            this.validator.validateParameter(this.name, node);
        }
        return node;
    }
}

