/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.ValidateOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CommonDescriptions {
    private static final String RESOURCE_NAME = CommonDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    public static final String READ_CONFIG_AS_XML = "read-config-as-xml";

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return CommonDescriptions.getResourceDescriptionResolver(keyPrefix, true);
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix, boolean useUnprefixedChildTypes) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, CommonDescriptions.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public static ModelNode getNamespacePrefixAttribute(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("type").set(ModelType.OBJECT);
        root.get("value-type").set(ModelType.STRING);
        root.get("description").set(bundle2.getString("namespaces"));
        root.get("required").set(false);
        root.get("head-comment-allowed").set(false);
        root.get("tail-comment-allowed").set(false);
        return root;
    }

    public static ModelNode getSchemaLocationAttribute(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("type").set(ModelType.OBJECT);
        root.get("value-type").set(ModelType.STRING);
        root.get("description").set(bundle2.getString("schema-locations"));
        root.get("required").set(false);
        root.get("head-comment-allowed").set(false);
        root.get("tail-comment-allowed").set(false);
        return root;
    }

    public static ModelNode getAddNamespaceOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add-namespace");
        root.get("description").set(bundle2.getString("namespaces.add"));
        root.get(new String[]{"request-properties", "namespace", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "namespace", "description"}).set(bundle2.getString("namespaces.add.prefix"));
        root.get(new String[]{"request-properties", "namespace", "required"}).set(true);
        root.get(new String[]{"request-properties", "uri", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "uri", "description"}).set(bundle2.getString("namespaces.add.uri"));
        root.get(new String[]{"request-properties", "uri", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveNamespaceOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove-namespace");
        root.get("description").set(bundle2.getString("namespaces.remove"));
        root.get(new String[]{"request-properties", "namespace", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "namespace", "description"}).set(bundle2.getString("namespaces.remove.namespace"));
        root.get(new String[]{"request-properties", "namespace", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getAddSchemaLocationOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add-schema-location");
        root.get("description").set(bundle2.getString("schema-locations.add"));
        root.get(new String[]{"request-properties", "uri", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "uri", "description"}).set(bundle2.getString("schema-locations.add.uri"));
        root.get(new String[]{"request-properties", "uri", "required"}).set(true);
        root.get(new String[]{"request-properties", "schema-location", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "schema-location", "description"}).set(bundle2.getString("schema-locations.add.schema-location"));
        root.get(new String[]{"request-properties", "schema-location", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveSchemaLocationOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove-schema-location");
        root.get("description").set(bundle2.getString("schema-locations.remove"));
        root.get(new String[]{"request-properties", "uri", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "uri", "description"}).set(bundle2.getString("schema-locations.remove.schema-uri"));
        root.get(new String[]{"request-properties", "uri", "required"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSystemPropertyDescription(Locale locale, String description, boolean useBoottime) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(description);
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "value", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "value", "description"}).set(bundle2.getString("system-property.value"));
        root.get(new String[]{"attributes", "value", "required"}).set(false);
        if (useBoottime) {
            root.get(new String[]{"attributes", "boot-time", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"attributes", "boot-time", "description"}).set(bundle2.getString("system-property.boottime"));
            root.get(new String[]{"attributes", "boot-time", "required"}).set(false);
            root.get(new String[]{"attributes", "boot-time", "default"}).set(true);
        }
        return root;
    }

    public static ModelNode getAddSystemPropertyOperation(Locale locale, boolean useBoottime) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("system-property.add"));
        root.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "value", "description"}).set(bundle2.getString("system-property.value"));
        root.get(new String[]{"request-properties", "value", "required"}).set(false);
        root.get(new String[]{"request-properties", "value", "nillable"}).set(true);
        if (useBoottime) {
            root.get(new String[]{"request-properties", "boot-time", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"request-properties", "boot-time", "description"}).set(bundle2.getString("system-property.boottime"));
            root.get(new String[]{"request-properties", "boot-time", "required"}).set(false);
            root.get(new String[]{"request-properties", "boot-time", "nillable"}).set(true);
            root.get(new String[]{"request-properties", "boot-time", "default"}).set(true);
        }
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getRemoveSystemPropertyOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("system-property.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getReadConfigAsXmlOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set(READ_CONFIG_AS_XML);
        root.get("description").set(bundle2.getString(READ_CONFIG_AS_XML));
        root.get("request-properties").setEmptyObject();
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("read-config-as-xml.response"));
        return root;
    }

    public static ModelNode getValidateAddressOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode descr = CommonDescriptions.getSingleParamSimpleReplyOperation(bundle2, "validate-address", "global", "value", ModelType.OBJECT, false, ModelType.OBJECT, true);
        ModelNode valueType = descr.get(new String[]{"reply-properties", "value-type"});
        valueType.get(new String[]{"valid", "description"}).set(bundle2.getString("global.validate-address.reply.valid"));
        valueType.get(new String[]{"valid", "type"}).set(ModelType.BOOLEAN);
        valueType.get(new String[]{"problem", "description"}).set(bundle2.getString("global.validate-address.reply.problem"));
        valueType.get(new String[]{"problem", "type"}).set(ModelType.STRING);
        return descr;
    }

    public static ModelNode getCompositeOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode descr = CommonDescriptions.getSingleParamSimpleReplyOperation(bundle2, "composite", "root", "steps", ModelType.LIST, false, ModelType.OBJECT, true);
        ModelNode steps = descr.get(new String[]{"request-properties", "steps"});
        steps.get("value-type").set(ModelType.OBJECT);
        return descr;
    }

    public static ModelNode getSubsystemDescribeOperation(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("subsystem.describe"));
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        root.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return root;
    }

    public static ModelNode getServiceContainerDescription(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.service-container"));
        root.get("head-comment-allowed").set(false);
        root.get("tail-comment-allowed").set(false);
        root.get("operations");
        return root;
    }

    public static ModelNode getValidateOperationDescription(Locale locale) {
        ResourceBundle bundle2 = CommonDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSingleParamOnlyOperation(bundle2, ValidateOperationHandler.OPERATION_NAME, "global", "value", ModelType.OBJECT, false);
    }

    public static ModelNode getDescriptionOnlyOperation(ResourceBundle bundle2, String operationName, String descriptionPrefix) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set(operationName);
        String descriptionKey = descriptionPrefix == null ? operationName : descriptionPrefix + "." + operationName;
        node.get("description").set(bundle2.getString(descriptionKey));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getSingleParamOnlyOperation(ResourceBundle bundle2, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean nillable) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set(operationName);
        String descriptionKey = descriptionPrefix == null ? operationName : descriptionPrefix + "." + operationName;
        node.get("description").set(bundle2.getString(descriptionKey));
        ModelNode param = node.get(new String[]{"request-properties", paramName});
        param.get("description").set(bundle2.getString(descriptionKey + "." + paramName));
        param.get("type").set(paramType);
        param.get("required").set(!nillable);
        param.get("nillable").set(nillable);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getNoArgSimpleReplyOperation(ResourceBundle bundle2, String operationName, String descriptionPrefix, ModelType replyType, boolean describeReply) {
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation(bundle2, operationName, descriptionPrefix);
        if (describeReply) {
            String replyKey = descriptionPrefix == null ? operationName + ".reply" : descriptionPrefix + "." + operationName + ".reply";
            result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString(replyKey));
        }
        result.get(new String[]{"reply-properties", "type"}).set(replyType);
        return result;
    }

    public static ModelNode getSingleParamSimpleReplyOperation(ResourceBundle bundle2, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean paramNillable, ModelType replyType, boolean describeReply) {
        ModelNode result = CommonDescriptions.getSingleParamOnlyOperation(bundle2, operationName, descriptionPrefix, paramName, paramType, paramNillable);
        if (describeReply) {
            String replyKey = descriptionPrefix == null ? operationName + ".reply" : descriptionPrefix + "." + operationName + ".reply";
            result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString(replyKey));
        }
        result.get(new String[]{"reply-properties", "type"}).set(replyType);
        return result;
    }

    public static ModelNode getNoArgSimpleListReplyOperation(ResourceBundle bundle2, String operationName, String descriptionPrefix, ModelType listValueType, boolean describeReply) {
        ModelNode result = CommonDescriptions.getNoArgSimpleReplyOperation(bundle2, operationName, descriptionPrefix, ModelType.LIST, describeReply);
        result.get(new String[]{"reply-properties", "value-type"}).set(listValueType);
        return result;
    }

    public static ModelNode getSingleParamSimpleListReplyOperation(ResourceBundle bundle2, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean paramNillable, ModelType listValueType, boolean describeReply) {
        ModelNode result = CommonDescriptions.getSingleParamSimpleReplyOperation(bundle2, operationName, descriptionPrefix, paramName, paramType, paramNillable, ModelType.LIST, describeReply);
        result.get(new String[]{"reply-properties", "value-type"}).set(listValueType);
        return result;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

