/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InterfaceDescription {
    private static final String RESOURCE_NAME = InterfaceDescription.class.getPackage().getName() + ".LocalDescriptions";
    private static final String[] ALTERNATIVES_ANY = new String[]{"any-address", "any-ipv4-address", "any-ipv6-address"};
    private static final String[] OTHERS = new String[]{InterfaceDescription.localName(Element.INET_ADDRESS), InterfaceDescription.localName(Element.LINK_LOCAL_ADDRESS), InterfaceDescription.localName(Element.LOOPBACK), InterfaceDescription.localName(Element.LOOPBACK_ADDRESS), InterfaceDescription.localName(Element.MULTICAST), InterfaceDescription.localName(Element.NIC), InterfaceDescription.localName(Element.NIC_MATCH), InterfaceDescription.localName(Element.POINT_TO_POINT), InterfaceDescription.localName(Element.PUBLIC_ADDRESS), InterfaceDescription.localName(Element.SITE_LOCAL_ADDRESS), InterfaceDescription.localName(Element.SUBNET_MATCH), InterfaceDescription.localName(Element.UP), InterfaceDescription.localName(Element.VIRTUAL), InterfaceDescription.localName(Element.ANY), InterfaceDescription.localName(Element.NOT)};
    public static final AttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create("name", ModelType.STRING).build();
    public static final AttributeDefinition ANY_ADDRESS = SimpleAttributeDefinitionBuilder.create("any-address", ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).setRestartAllServices().setValidator(new ModelTypeValidator(ModelType.BOOLEAN, true, false)).addAlternatives(OTHERS).addAlternatives("any-ipv4-address", "any-ipv6-address").build();
    public static final AttributeDefinition ANY_IPV4_ADDRESS = SimpleAttributeDefinitionBuilder.create("any-ipv4-address", ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).setRestartAllServices().setValidator(new ModelTypeValidator(ModelType.BOOLEAN, true, false)).addAlternatives(OTHERS).addAlternatives("any-address", "any-ipv6-address").build();
    public static final AttributeDefinition ANY_IPV6_ADDRESS = SimpleAttributeDefinitionBuilder.create("any-ipv6-address", ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).setRestartAllServices().setValidator(new ModelTypeValidator(ModelType.BOOLEAN, true, false)).addAlternatives(OTHERS).addAlternatives("any-address", "any-ipv4-address").build();
    public static final AttributeDefinition INET_ADDRESS = SimpleAttributeDefinitionBuilder.create("inet-address", ModelType.STRING).setAllowExpression(true).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition LINK_LOCAL_ADDRESS = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.LINK_LOCAL_ADDRESS), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition LOOPBACK = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.LOOPBACK), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition LOOPBACK_ADDRESS = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.LOOPBACK_ADDRESS), ModelType.STRING).setAllowExpression(true).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition NIC = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.NIC), ModelType.STRING).setAllowExpression(true).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition NIC_MATCH = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.NIC_MATCH), ModelType.STRING).setAllowExpression(true).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition MULTICAST = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.MULTICAST), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition POINT_TO_POINT = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.POINT_TO_POINT), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition PUBLIC_ADDRESS = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.PUBLIC_ADDRESS), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition SITE_LOCAL_ADDRESS = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.SITE_LOCAL_ADDRESS), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition SUBNET_MATCH = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.SUBNET_MATCH), ModelType.STRING).setAllowExpression(true).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition UP = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.UP), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition VIRTUAL = SimpleAttributeDefinitionBuilder.create(InterfaceDescription.localName(Element.VIRTUAL), ModelType.BOOLEAN).setAllowExpression(false).setAllowNull(true).addAlternatives(ALTERNATIVES_ANY).setRestartAllServices().build();
    public static final AttributeDefinition NOT = InterfaceDescription.createNestedComplexType("not");
    public static final AttributeDefinition ANY = InterfaceDescription.createNestedComplexType("any");
    public static final AttributeDefinition[] ROOT_ATTRIBUTES = new AttributeDefinition[]{ANY_ADDRESS, ANY_IPV4_ADDRESS, ANY_IPV6_ADDRESS, INET_ADDRESS, LINK_LOCAL_ADDRESS, LOOPBACK, LOOPBACK_ADDRESS, MULTICAST, NIC, NIC_MATCH, POINT_TO_POINT, PUBLIC_ADDRESS, SITE_LOCAL_ADDRESS, SUBNET_MATCH, UP, VIRTUAL, ANY, NOT};
    public static final AttributeDefinition[] NESTED_ATTRIBUTES = new AttributeDefinition[]{INET_ADDRESS, LINK_LOCAL_ADDRESS, LOOPBACK, LOOPBACK_ADDRESS, MULTICAST, NIC, NIC_MATCH, POINT_TO_POINT, PUBLIC_ADDRESS, SITE_LOCAL_ADDRESS, SUBNET_MATCH, UP, VIRTUAL};
    public static final Set<AttributeDefinition> NESTED_LIST_ATTRIBUTES = new HashSet<AttributeDefinition>(Arrays.asList(INET_ADDRESS, NIC, NIC_MATCH, SUBNET_MATCH));
    public static final AttributeDefinition[] WILDCARD_ATTRIBUTES = new AttributeDefinition[]{ANY_ADDRESS, ANY_IPV4_ADDRESS, ANY_IPV6_ADDRESS};
    public static final AttributeDefinition[] SIMPLE_ATTRIBUTES = new AttributeDefinition[]{LINK_LOCAL_ADDRESS, LOOPBACK, MULTICAST, POINT_TO_POINT, PUBLIC_ADDRESS, SITE_LOCAL_ADDRESS, UP, VIRTUAL};

    public static ModelNode getNamedInterfaceDescription(Locale locale) {
        ResourceBundle bundle2 = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("named_interface"));
        NAME.addResourceAttributeDescription(bundle2, "interface", root);
        InterfaceDescription.populateInterface(root, bundle2, false);
        return root;
    }

    public static ModelNode getSpecifiedInterfaceDescription(Locale locale) {
        ResourceBundle bundle2 = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("specified_interface"));
        NAME.addResourceAttributeDescription(bundle2, "interface", root);
        InterfaceDescription.populateInterface(root, bundle2, true);
        return root;
    }

    private static void populateInterface(ModelNode root, ResourceBundle bundle2, boolean specified) {
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        for (AttributeDefinition def : ROOT_ATTRIBUTES) {
            def.addResourceAttributeDescription(bundle2, "interface", root);
        }
    }

    public static ModelNode getNamedInterfaceAddOperation(Locale locale) {
        ResourceBundle bundle2 = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("interface.add"));
        for (AttributeDefinition def : ROOT_ATTRIBUTES) {
            def.addOperationParameterDescription(bundle2, "interface", root);
        }
        return root;
    }

    public static ModelNode getSpecifiedInterfaceAddOperation(Locale locale) {
        ResourceBundle bundle2 = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("interface.add"));
        for (AttributeDefinition def : ROOT_ATTRIBUTES) {
            def.addOperationParameterDescription(bundle2, "interface", root);
        }
        return root;
    }

    public static ModelNode getInterfaceRemoveOperation(Locale locale) {
        ResourceBundle bundle2 = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("interface.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static boolean isOperationDefined(ModelNode operation) {
        for (AttributeDefinition def : ROOT_ATTRIBUTES) {
            if (!operation.hasDefined(def.getName())) continue;
            return true;
        }
        return false;
    }

    private static AttributeDefinition createNestedComplexType(String name) {
        return new AttributeDefinition(name, name, null, ModelType.OBJECT, true, false, MeasurementUnit.NONE, InterfaceDescription.createNestedParamValidator(), ALTERNATIVES_ANY, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}){

            @Override
            public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
                throw new UnsupportedOperationException();
            }

            @Override
            public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
                ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
                this.addNestedDescriptions(result, prefix, bundle2);
                return result;
            }

            @Override
            public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
                ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
                this.addNestedDescriptions(result, prefix, bundle2);
                return result;
            }

            void addNestedDescriptions(ModelNode result, String prefix, ResourceBundle bundle2) {
                for (AttributeDefinition def : NESTED_ATTRIBUTES) {
                    String bundleKey = prefix == null ? def.getName() : prefix + "." + def.getName();
                    result.get(new String[]{"value-type", def.getName(), "description"}).set(bundle2.getString(bundleKey));
                }
            }

            @Override
            public ModelNode getNoTextDescription(boolean forOperation) {
                ModelNode model = super.getNoTextDescription(forOperation);
                ModelNode valueType = model.get("value-type");
                for (AttributeDefinition def : NESTED_ATTRIBUTES) {
                    AttributeDefinition current = NESTED_LIST_ATTRIBUTES.contains(def) ? InterfaceDescription.wrapAsList(def) : def;
                    ModelNode m = current.getNoTextDescription(forOperation);
                    m.remove("alternatives");
                    valueType.get(current.getName()).set(m);
                }
                return model;
            }
        };
    }

    private static ListAttributeDefinition wrapAsList(AttributeDefinition def) {
        ListAttributeDefinition list = new ListAttributeDefinition(def.getName(), true, def.getValidator()){

            @Override
            public ModelNode getNoTextDescription(boolean forOperation) {
                ModelNode model = super.getNoTextDescription(forOperation);
                this.setValueType(model);
                return model;
            }

            @Override
            protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
                this.setValueType(node);
            }

            @Override
            public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
                throw new RuntimeException();
            }

            @Override
            protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
                this.setValueType(node);
            }

            @Override
            protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
                this.setValueType(node);
            }

            private void setValueType(ModelNode node) {
                node.get("value-type").set(ModelType.STRING);
            }
        };
        return list;
    }

    static ParameterValidator createNestedParamValidator() {
        return new ModelTypeValidator(ModelType.OBJECT, true, false, true){

            @Override
            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                super.validateParameter(parameterName, value);
                for (AttributeDefinition def : NESTED_ATTRIBUTES) {
                    String name = def.getName();
                    if (!value.hasDefined(name)) continue;
                    ModelNode v = value.get(name);
                    if (NESTED_LIST_ATTRIBUTES.contains(def)) {
                        if (ModelType.LIST == v.getType()) continue;
                        throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidType(v.getType())));
                    }
                    def.getValidator().validateParameter(name, v);
                }
            }
        };
    }

    static String localName(Element element) {
        return element.getLocalName();
    }
}

