/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.permutation;

import java.util.Arrays;
import java.util.Iterator;
import org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.jgrapht.experimental.permutation.IntegerPermutationIter;
import org.jgrapht.util.MathUtil;

public class CompoundPermutationIter
implements ArrayPermutationsIter,
Iterator {
    IntegerPermutationIter[] permArray;
    private int totalPermArraySize;
    private int max;
    private int iterCounter = 0;

    public CompoundPermutationIter(int[] nArray) {
        this.init(nArray);
    }

    private void init(int[] nArray) {
        this.permArray = new IntegerPermutationIter[nArray.length];
        int n = 0;
        this.max = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int[] nArray2 = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = n++;
            }
            this.permArray[i] = new IntegerPermutationIter(nArray2);
            this.permArray[i].getNext();
            this.max = (int)((long)this.max * MathUtil.factorial(n2));
        }
        this.totalPermArraySize = n;
    }

    public Object next() {
        return this.getNext();
    }

    public int[] getNext() {
        Object object;
        if (this.iterCounter == 0) {
            ++this.iterCounter;
            return this.getPermAsArray();
        }
        int n = -1;
        int n2 = 0;
        while (n == -1) {
            object = this.permArray[n2];
            if (((IntegerPermutationIter)object).hasNext()) {
                ((IntegerPermutationIter)object).getNext();
                for (int i = 0; i < n2; ++i) {
                    this.restartPermutationGroup(i);
                }
                n = n2;
            }
            if (++n2 < this.permArray.length) continue;
            break;
        }
        ++this.iterCounter;
        if (n == -1) {
            return null;
        }
        object = this.getPermAsArray();
        return object;
    }

    public int[] getPermAsArray() {
        int[] nArray = new int[this.totalPermArraySize];
        int n = 0;
        for (int i = 0; i < this.permArray.length; ++i) {
            int[] nArray2 = this.permArray[i].getCurrent();
            System.arraycopy(nArray2, 0, nArray, n, nArray2.length);
            n += nArray2.length;
        }
        return nArray;
    }

    private void restartPermutationGroup(int n) {
        int[] nArray = this.permArray[n].getCurrent();
        Arrays.sort(nArray);
        this.permArray[n] = new IntegerPermutationIter(nArray);
        this.permArray[n].getNext();
    }

    public boolean hasNext() {
        boolean bl = this.iterCounter < this.max;
        return bl;
    }

    public int getMax() {
        return this.max;
    }

    public int[] nextPermutation() {
        return (int[])this.next();
    }

    public boolean hasNextPermutaions() {
        return this.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

