/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.aggregator.AggregationUtils;
import org.junit.jupiter.params.aggregator.ArgumentsAccessor;
import org.junit.jupiter.params.aggregator.ArgumentsAggregator;
import org.junit.jupiter.params.aggregator.DefaultArgumentsAccessor;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestParameterResolver
implements ParameterResolver {
    private final Object[] arguments;

    ParameterizedTestParameterResolver(Object[] arguments) {
        this.arguments = arguments;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Method testMethod;
        Executable declaringExecutable = parameterContext.getDeclaringExecutable();
        if (!declaringExecutable.equals(testMethod = (Method)extensionContext.getTestMethod().orElse(null))) {
            return false;
        }
        if (AggregationUtils.isAggregator(parameterContext.getParameter())) {
            return true;
        }
        int indexOfFirstAggregator = AggregationUtils.indexOfFirstAggregator(testMethod);
        if (indexOfFirstAggregator != -1) {
            return parameterContext.getIndex() < indexOfFirstAggregator;
        }
        return parameterContext.getIndex() < this.arguments.length;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return AggregationUtils.isAggregator(parameterContext.getParameter()) ? this.aggregate(parameterContext) : this.convert(parameterContext);
    }

    private Object convert(ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        Object argument = this.arguments[parameterContext.getIndex()];
        Optional annotation = AnnotationUtils.findAnnotation((AnnotatedElement)parameter, ConvertWith.class);
        ArgumentConverter argumentConverter = annotation.map(ConvertWith::value).map(clazz -> (ArgumentConverter)ReflectionUtils.newInstance((Class)clazz, (Object[])new Object[0])).map(converter -> AnnotationConsumerInitializer.initialize(parameter, converter)).orElse(DefaultArgumentConverter.INSTANCE);
        try {
            return argumentConverter.convert(argument, parameterContext);
        }
        catch (Exception ex) {
            throw this.parameterResolutionException("Error converting parameter", ex, parameterContext);
        }
    }

    private Object aggregate(ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        Optional annotation = AnnotationUtils.findAnnotation((AnnotatedElement)parameter, AggregateWith.class);
        DefaultArgumentsAccessor accessor = new DefaultArgumentsAccessor(this.arguments);
        if (annotation.isPresent()) {
            return this.aggregateSafely(((AggregateWith)annotation.get()).value(), accessor, parameterContext);
        }
        return accessor;
    }

    private Object aggregateSafely(Class<? extends ArgumentsAggregator> clazz, ArgumentsAccessor accessor, ParameterContext parameterContext) {
        try {
            ArgumentsAggregator aggregator = (ArgumentsAggregator)ReflectionSupport.newInstance(clazz, (Object[])new Object[0]);
            return aggregator.aggregateArguments(accessor, parameterContext);
        }
        catch (Exception ex) {
            throw this.parameterResolutionException("Error aggregating arguments for parameter", ex, parameterContext);
        }
    }

    private ParameterResolutionException parameterResolutionException(String message, Exception cause, ParameterContext context) {
        String fullMessage = message + " at index " + context.getIndex();
        if (StringUtils.isNotBlank((String)cause.getMessage())) {
            fullMessage = fullMessage + ": " + cause.getMessage();
        }
        return new ParameterResolutionException(fullMessage, (Throwable)cause);
    }
}

