/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.v1.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.v1.BittrexAdapters;
import org.knowm.xchange.bittrex.v1.BittrexUtils;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexDepth;
import org.knowm.xchange.bittrex.v1.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.v1.service.BittrexMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BittrexMarketDataService
extends BittrexMarketDataServiceRaw
implements MarketDataService {
    public BittrexMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return BittrexAdapters.adaptTicker(this.getBittrexTicker(BittrexUtils.toPairString(currencyPair)), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        int depth = 50;
        if (args.length > 0 && args[0] instanceof Integer && (Integer)args[0] > 0 && (Integer)args[0] <= 50) {
            depth = (Integer)args[0];
        }
        BittrexDepth bittrexDepth = this.getBittrexOrderBook(BittrexUtils.toPairString(currencyPair), depth);
        List<LimitOrder> asks = BittrexAdapters.adaptOrders(bittrexDepth.getAsks(), currencyPair, "ask", "");
        List<LimitOrder> bids = BittrexAdapters.adaptOrders(bittrexDepth.getBids(), currencyPair, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        int count = 50;
        if (args.length > 0 && args[0] instanceof Integer) {
            count = (Integer)args[0];
        }
        BittrexTrade[] trades = this.getBittrexTrades(BittrexUtils.toPairString(currencyPair), count);
        return BittrexAdapters.adaptTrades(trades, currencyPair);
    }
}

