/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx;

import java.io.InputStream;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.dsx.DSXAdapters;
import org.knowm.xchange.dsx.dto.marketdata.DSXExchangeInfo;
import org.knowm.xchange.dsx.dto.meta.DSXMetaData;
import org.knowm.xchange.dsx.service.DSXAccountService;
import org.knowm.xchange.dsx.service.DSXMarketDataService;
import org.knowm.xchange.dsx.service.DSXTradeService;
import org.knowm.xchange.utils.nonce.AtomicLongCurrentTimeIncrementalNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class DSXExchange
extends BaseExchange
implements Exchange {
    private SynchronizedValueFactory<Long> nonceFactory = new AtomicLongCurrentTimeIncrementalNonceFactory();
    private DSXMetaData dsxMetaData;
    private DSXExchangeInfo dsxExchangeInfo;

    protected void initServices() {
        this.marketDataService = new DSXMarketDataService(this);
        this.tradeService = new DSXTradeService(this);
        this.accountService = new DSXAccountService(this);
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    protected void loadExchangeMetaData(InputStream is) {
        this.dsxMetaData = (DSXMetaData)((Object)this.loadMetaData(is, DSXMetaData.class));
        this.exchangeMetaData = DSXAdapters.toMetaData(null, this.dsxMetaData);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://dsx.uk");
        exchangeSpecification.setHost("dsx.uk");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("DSX");
        exchangeSpecification.setExchangeDescription("DSX the UK first Digital Securities Exchange run by the FCA regulated ePayments.");
        return exchangeSpecification;
    }

    public void remoteInit() {
        try {
            DSXMarketDataService marketDataService = (DSXMarketDataService)this.marketDataService;
            this.dsxExchangeInfo = marketDataService.getDSXInfo();
            this.exchangeMetaData = DSXAdapters.toMetaData(this.dsxExchangeInfo, this.dsxMetaData);
        }
        catch (Exception e) {
            this.logger.warn("An exception occurred while loading the metadata");
        }
    }

    public DSXMetaData getDsxMetaData() {
        return this.dsxMetaData;
    }

    public DSXExchangeInfo getDsxExchangeInfo() {
        return this.dsxExchangeInfo;
    }
}

