/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;

public final class DSXOrderbook {
    private final List<BigDecimal[]> asks;
    private final List<BigDecimal[]> bids;
    private final BigDecimal marketBuyPrice;
    private final BigDecimal marketSellPrice;

    public DSXOrderbook(@JsonProperty(value="asks") List<BigDecimal[]> asks, @JsonProperty(value="bids") List<BigDecimal[]> bids, @JsonProperty(value="market_buy_price") BigDecimal marketBuyPrice, @JsonProperty(value="market_sell_price") BigDecimal marketSellPrice) {
        this.asks = asks;
        this.bids = bids;
        this.marketBuyPrice = marketBuyPrice;
        this.marketSellPrice = marketSellPrice;
    }

    public List<BigDecimal[]> getAsks() {
        return this.asks;
    }

    public List<BigDecimal[]> getBids() {
        return this.bids;
    }

    public BigDecimal getMarketBuyPrice() {
        return this.marketBuyPrice;
    }

    public BigDecimal getMarketSellPrice() {
        return this.marketSellPrice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DSXOrderbook [asks=");
        for (BigDecimal[] a : this.asks) {
            sb.append("[").append(a[0].toString()).append(",").append(a[1].toString()).append("],");
        }
        sb.append(" bids=");
        for (BigDecimal[] b : this.bids) {
            sb.append("[").append(b[0].toString()).append(",").append(b[1].toString()).append("],");
        }
        sb.append(", marketBuyPrice=");
        sb.append(this.marketBuyPrice);
        sb.append(", marketSellPrice=");
        sb.append(this.marketSellPrice);
        sb.append("]");
        return sb.toString();
    }
}

