/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.gatecoin.GatecoinUtils;
import org.knowm.xchange.gatecoin.dto.account.GatecoinBalance;
import org.knowm.xchange.gatecoin.dto.marketdata.GatecoinDepth;
import org.knowm.xchange.gatecoin.dto.marketdata.GatecoinTicker;
import org.knowm.xchange.gatecoin.dto.marketdata.GatecoinTransaction;
import org.knowm.xchange.gatecoin.dto.marketdata.Results.GatecoinDepthResult;
import org.knowm.xchange.gatecoin.dto.trade.GatecoinTradeHistory;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinTradeHistoryResult;
import org.knowm.xchange.utils.DateUtils;

public final class GatecoinAdapters {
    private GatecoinAdapters() {
    }

    public static Wallet adaptWallet(GatecoinBalance[] gatecoinBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (GatecoinBalance balance : gatecoinBalances) {
            Currency ccy = Currency.getInstance((String)balance.getCurrency());
            balances.add(new Balance.Builder().currency(ccy).total(balance.getBalance()).available(balance.getAvailableBalance()).frozen(balance.getOpenOrder().negate()).withdrawing(balance.getPendingOutgoing().negate()).depositing(balance.getPendingIncoming().negate()).build());
        }
        return new Wallet(balances);
    }

    public static OrderBook adaptOrderBook(GatecoinDepthResult gatecoinDepthResult, CurrencyPair currencyPair, int timeScale) {
        List<LimitOrder> asks = GatecoinAdapters.createOrders(currencyPair, Order.OrderType.ASK, gatecoinDepthResult.getAsks());
        List<LimitOrder> bids = GatecoinAdapters.createOrders(currencyPair, Order.OrderType.BID, gatecoinDepthResult.getBids());
        Date date = new Date();
        return new OrderBook(date, asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, GatecoinDepth[] orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (GatecoinDepth priceVolume : orders) {
            limitOrders.add(GatecoinAdapters.createOrder(currencyPair, priceVolume, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, GatecoinDepth priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.getVolume(), currencyPair, "", null, priceAndAmount.getPrice());
    }

    public static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static Trades adaptTrades(GatecoinTransaction[] transactions, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (GatecoinTransaction tx : transactions) {
            long tradeId = tx.getTransactionId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            trades.add(new Trade(null, tx.getQuantity(), currencyPair, tx.getPrice(), DateUtils.fromMillisUtc((long)(tx.getTransacationTime() * 1000L)), String.valueOf(tradeId)));
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Ticker adaptTicker(GatecoinTicker[] gatecoinTickers, CurrencyPair currencyPair) {
        String ccyPair = currencyPair.toString().replace('/', ' ').replaceAll("\\s", "");
        for (GatecoinTicker ticker : gatecoinTickers) {
            String responseCcyPair = ticker.getCurrencyPair();
            if (responseCcyPair.compareTo(ccyPair) != 0) continue;
            BigDecimal last = ticker.getLast();
            BigDecimal bid = ticker.getBid();
            BigDecimal ask = ticker.getAsk();
            BigDecimal high = ticker.getHigh();
            BigDecimal low = ticker.getLow();
            BigDecimal vwap = ticker.getVwap();
            BigDecimal volume = ticker.getVolume();
            Date timestamp = new Date(ticker.getTimestamp() * 1000L);
            return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).vwap(vwap).volume(volume).timestamp(timestamp).build();
        }
        return null;
    }

    public static UserTrades adaptTradeHistory(GatecoinTradeHistoryResult gatecoinUserTrades) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        long lastTradeId = 0L;
        if (gatecoinUserTrades != null) {
            GatecoinTradeHistory[] tradeHistory;
            for (GatecoinTradeHistory gatecoinUserTrade : tradeHistory = gatecoinUserTrades.getTransactions()) {
                boolean isAsk = Objects.equals(gatecoinUserTrade.getWay().toLowerCase(), "ask");
                Order.OrderType orderType = isAsk ? Order.OrderType.ASK : Order.OrderType.BID;
                BigDecimal tradableAmount = gatecoinUserTrade.getQuantity();
                BigDecimal price = gatecoinUserTrade.getPrice();
                Date timestamp = GatecoinUtils.parseUnixTSToDateTime(gatecoinUserTrade.getTransactionTime());
                long transactionId = gatecoinUserTrade.getTransactionId();
                if (transactionId > lastTradeId) {
                    lastTradeId = transactionId;
                }
                String tradeId = String.valueOf(transactionId);
                String orderId = isAsk ? gatecoinUserTrade.getAskOrderID() : gatecoinUserTrade.getBidOrderID();
                BigDecimal feeRate = gatecoinUserTrade.getFeeRate();
                BigDecimal feeAmount = feeRate.multiply(tradableAmount).multiply(price).setScale(8, 2);
                CurrencyPair currencyPair = new CurrencyPair(gatecoinUserTrade.getCurrencyPair().substring(0, 3), gatecoinUserTrade.getCurrencyPair().substring(3, 6));
                UserTrade trade = new UserTrade(orderType, tradableAmount, currencyPair, price, timestamp, tradeId, orderId, feeAmount, Currency.getInstance((String)currencyPair.counter.getCurrencyCode()));
                trades.add(trade);
            }
        }
        return new UserTrades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }
}

