/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin;

import java.io.IOException;
import java.math.BigDecimal;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.gatecoin.dto.GatecoinException;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinBalanceResult;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinDepositAddressResult;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinWithdrawResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinCancelOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinPlaceOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinTradeHistoryResult;
import si.mazi.rescu.ParamsDigest;

@Path(value="api")
@Produces(value={"application/json"})
public interface GatecoinAuthenticated {
    @GET
    @Path(value="Trade/Orders")
    public GatecoinOrderResult getOpenOrders(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3) throws IOException, GatecoinException;

    @POST
    @Path(value="Trade/Orders")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public GatecoinPlaceOrderResult placeOrder(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3, @FormParam(value="Amount") BigDecimal var4, @FormParam(value="Price") BigDecimal var5, @FormParam(value="Way") String var6, @FormParam(value="Code") String var7) throws IOException, GatecoinException;

    @DELETE
    @Path(value="Trade/Orders")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public GatecoinCancelOrderResult cancelAllOrders(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3) throws IOException, GatecoinException;

    @DELETE
    @Path(value="Trade/Orders/{OrderId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public GatecoinCancelOrderResult cancelOrder(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3, @PathParam(value="OrderId") String var4) throws IOException, GatecoinException;

    @GET
    @Path(value="Trade/Trades")
    public GatecoinTradeHistoryResult getUserTrades(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3) throws IOException, GatecoinException;

    @GET
    @Path(value="Trade/Trades")
    public GatecoinTradeHistoryResult getUserTrades(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3, @QueryParam(value="Count") int var4) throws IOException, GatecoinException;

    @GET
    @Path(value="Trade/Trades")
    public GatecoinTradeHistoryResult getUserTrades(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3, @QueryParam(value="Count") Integer var4, @QueryParam(value="TransactionID") Long var5) throws IOException, GatecoinException;

    @GET
    @Path(value="Balance/Balances")
    public GatecoinBalanceResult getUserBalance(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_USER_ID") String var2, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var3, @HeaderParam(value="API_REQUEST_DATE") String var4) throws IOException, GatecoinException;

    @GET
    @Path(value="ElectronicWallet/DepositWallets")
    public GatecoinDepositAddressResult getDepositAddress(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3) throws IOException, GatecoinException;

    @POST
    @Path(value="ElectronicWallet/Withdrawals/{DigiCurrency}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public GatecoinWithdrawResult withdrawBitcoin(@HeaderParam(value="API_PUBLIC_KEY") String var1, @HeaderParam(value="API_REQUEST_SIGNATURE") ParamsDigest var2, @HeaderParam(value="API_REQUEST_DATE") String var3, @PathParam(value="DigiCurrency") String var4, @FormParam(value="AddressName") String var5, @FormParam(value="Amount") BigDecimal var6) throws IOException, GatecoinException;
}

