/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.gatecoin.Gatecoin;
import org.knowm.xchange.gatecoin.dto.marketdata.Results.GatecoinDepthResult;
import org.knowm.xchange.gatecoin.dto.marketdata.Results.GatecoinTickerResult;
import org.knowm.xchange.gatecoin.dto.marketdata.Results.GatecoinTransactionResult;
import org.knowm.xchange.gatecoin.service.GatecoinBaseService;
import si.mazi.rescu.RestProxyFactory;

public class GatecoinMarketDataServiceRaw
extends GatecoinBaseService {
    private final Gatecoin gatecoin;

    public GatecoinMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.gatecoin = (Gatecoin)RestProxyFactory.createProxy(Gatecoin.class, (String)exchange.getExchangeSpecification().getSslUri());
    }

    public GatecoinTickerResult getGatecoinTicker() throws IOException {
        return this.gatecoin.getTicker();
    }

    public GatecoinDepthResult getGatecoinOrderBook(String currencyPair) throws IOException {
        String ccyPair = currencyPair.replace("/", "");
        return this.gatecoin.getOrderBook(ccyPair);
    }

    public GatecoinTransactionResult getGatecoinTransactions(String currencyPair) throws IOException {
        String ccyPair = currencyPair.replace("/", "");
        return this.gatecoin.getTransactions(ccyPair);
    }

    public GatecoinTransactionResult getGatecoinTransactions(String currencyPair, int count, long tid) throws IOException {
        String ccyPair = currencyPair.replace("/", "");
        return this.gatecoin.getTransactions(ccyPair, count, tid);
    }
}

