/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.gatecoin.GatecoinAuthenticated;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinCancelOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinPlaceOrderResult;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinTradeHistoryResult;
import org.knowm.xchange.gatecoin.service.GatecoinBaseService;
import org.knowm.xchange.gatecoin.service.GatecoinDigest;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class GatecoinTradeServiceRaw
extends GatecoinBaseService {
    private final GatecoinAuthenticated gatecoinAuthenticated;
    private final GatecoinDigest signatureCreator;

    public GatecoinTradeServiceRaw(Exchange exchange) {
        super(exchange);
        this.gatecoinAuthenticated = (GatecoinAuthenticated)RestProxyFactory.createProxy(GatecoinAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri());
        this.signatureCreator = GatecoinDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public GatecoinOrderResult getGatecoinOpenOrders() throws IOException {
        return this.gatecoinAuthenticated.getOpenOrders(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow());
    }

    public GatecoinPlaceOrderResult placeGatecoinOrder(BigDecimal tradableAmount, BigDecimal price, String way, String code) throws IOException {
        return this.gatecoinAuthenticated.placeOrder(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow(), tradableAmount, price, way, code);
    }

    public GatecoinCancelOrderResult cancelGatecoinOrder(String orderId) throws IOException {
        return this.gatecoinAuthenticated.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow(), orderId);
    }

    public GatecoinCancelOrderResult cancelAllGatecoinOrders() throws IOException {
        return this.gatecoinAuthenticated.cancelAllOrders(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow());
    }

    public GatecoinTradeHistoryResult getGatecoinUserTrades(Integer count, Long transactionId) throws IOException {
        return this.gatecoinAuthenticated.getUserTrades(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow(), count, transactionId);
    }

    public GatecoinTradeHistoryResult getGatecoinUserTrades(int count) throws IOException {
        return this.gatecoinAuthenticated.getUserTrades(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow(), count);
    }

    public GatecoinTradeHistoryResult getGatecoinUserTrades() throws IOException {
        return this.gatecoinAuthenticated.getUserTrades(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, GatecoinTradeServiceRaw.getNow());
    }
}

