/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.LoanInfo;
import org.knowm.xchange.poloniex.dto.account.PoloniexBalance;
import org.knowm.xchange.poloniex.dto.account.PoloniexLoan;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexCurrencyInfo;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexDepth;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexLevel;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexMarketData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexPublicTrade;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexTicker;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDeposit;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDepositsWithdrawalsResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import org.knowm.xchange.poloniex.dto.trade.PoloniexWithdrawal;

public class PoloniexAdapters {
    public static Ticker adaptPoloniexTicker(PoloniexTicker poloniexTicker, CurrencyPair currencyPair) {
        PoloniexMarketData marketData = poloniexTicker.getPoloniexMarketData();
        BigDecimal last = marketData.getLast();
        BigDecimal bid = marketData.getHighestBid();
        BigDecimal ask = marketData.getLowestAsk();
        BigDecimal high = marketData.getHigh24hr();
        BigDecimal low = marketData.getLow24hr();
        BigDecimal volume = marketData.getQuoteVolume();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).build();
    }

    public static OrderBook adaptPoloniexDepth(PoloniexDepth depth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = PoloniexAdapters.adaptPoloniexPublicOrders(depth.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = PoloniexAdapters.adaptPoloniexPublicOrders(depth.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    public static List<LimitOrder> adaptPoloniexPublicOrders(List<List<BigDecimal>> rawLevels, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<PoloniexLevel> levels = new ArrayList<PoloniexLevel>();
        for (List<BigDecimal> rawLevel : rawLevels) {
            levels.add(PoloniexAdapters.adaptRawPoloniexLevel(rawLevel));
        }
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
        for (PoloniexLevel level : levels) {
            LimitOrder limitOrder = new LimitOrder.Builder(orderType, currencyPair).tradableAmount(level.getAmount()).limitPrice(level.getLimit()).build();
            orders.add(limitOrder);
        }
        return orders;
    }

    public static PoloniexLevel adaptRawPoloniexLevel(List<BigDecimal> level) {
        PoloniexLevel poloniexLevel = new PoloniexLevel(level.get(1), level.get(0));
        return poloniexLevel;
    }

    public static Trades adaptPoloniexPublicTrades(PoloniexPublicTrade[] poloniexPublicTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (PoloniexPublicTrade poloniexTrade : poloniexPublicTrades) {
            trades.add(PoloniexAdapters.adaptPoloniexPublicTrade(poloniexTrade, currencyPair));
        }
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static Trade adaptPoloniexPublicTrade(PoloniexPublicTrade poloniexTrade, CurrencyPair currencyPair) {
        Order.OrderType type = poloniexTrade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        Date timestamp = PoloniexUtils.stringToDate(poloniexTrade.getDate());
        Trade trade = new Trade(type, poloniexTrade.getAmount(), currencyPair, poloniexTrade.getRate(), timestamp, poloniexTrade.getTradeID());
        return trade;
    }

    public static List<Balance> adaptPoloniexBalances(HashMap<String, PoloniexBalance> poloniexBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (Map.Entry<String, PoloniexBalance> item : poloniexBalances.entrySet()) {
            Currency currency = Currency.getInstance((String)item.getKey());
            balances.add(new Balance(currency, null, item.getValue().getAvailable(), item.getValue().getOnOrders()));
        }
        return balances;
    }

    public static LoanInfo adaptPoloniexLoans(HashMap<String, PoloniexLoan[]> poloniexLoans) {
        HashMap loans = new HashMap();
        for (Map.Entry<String, PoloniexLoan[]> item : poloniexLoans.entrySet()) {
            ArrayList<FixedRateLoanOrder> loanOrders = new ArrayList<FixedRateLoanOrder>();
            for (PoloniexLoan poloniexLoan : item.getValue()) {
                Date date = PoloniexUtils.stringToDate(poloniexLoan.getDate());
                loanOrders.add(new FixedRateLoanOrder(Order.OrderType.ASK, poloniexLoan.getCurrency(), poloniexLoan.getAmount(), poloniexLoan.getRange(), poloniexLoan.getId(), date, poloniexLoan.getRate()));
            }
            loans.put(item.getKey(), loanOrders);
        }
        return new LoanInfo((List)loans.get("provided"), (List)loans.get("used"));
    }

    public static OpenOrders adaptPoloniexOpenOrders(Map<String, PoloniexOpenOrder[]> poloniexOpenOrders) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (String pairString : poloniexOpenOrders.keySet()) {
            CurrencyPair currencyPair = PoloniexUtils.toCurrencyPair(pairString);
            for (PoloniexOpenOrder openOrder : poloniexOpenOrders.get(pairString)) {
                openOrders.add(PoloniexAdapters.adaptPoloniexOpenOrder(openOrder, currencyPair));
            }
        }
        return new OpenOrders(openOrders);
    }

    public static LimitOrder adaptPoloniexOpenOrder(PoloniexOpenOrder openOrder, CurrencyPair currencyPair) {
        Order.OrderType type = openOrder.getType().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        Date timestamp = PoloniexUtils.stringToDate(openOrder.getDate());
        LimitOrder limitOrder = new LimitOrder.Builder(type, currencyPair).limitPrice(openOrder.getRate()).tradableAmount(openOrder.getAmount()).id(openOrder.getOrderNumber()).timestamp(timestamp).build();
        return limitOrder;
    }

    public static UserTrade adaptPoloniexUserTrade(PoloniexUserTrade userTrade, CurrencyPair currencyPair) {
        Order.OrderType orderType = userTrade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = userTrade.getAmount();
        BigDecimal price = userTrade.getRate();
        Date date = PoloniexUtils.stringToDate(userTrade.getDate());
        String tradeId = String.valueOf(userTrade.getTradeID());
        String orderId = String.valueOf(userTrade.getOrderNumber());
        BigDecimal feeAmount = amount.multiply(price).multiply(userTrade.getFee());
        return new UserTrade(orderType, amount, currencyPair, price, date, tradeId, orderId, feeAmount, Currency.getInstance((String)currencyPair.counter.getCurrencyCode()));
    }

    public static ExchangeMetaData adaptToExchangeMetaData(Map<String, PoloniexCurrencyInfo> poloniexCurrencyInfo, Map<String, PoloniexMarketData> poloniexMarketData, ExchangeMetaData exchangeMetaData) {
        Map currencyMetaDataMap = exchangeMetaData.getCurrencies();
        CurrencyMetaData currencyArchetype = (CurrencyMetaData)currencyMetaDataMap.values().iterator().next();
        for (Map.Entry<String, PoloniexCurrencyInfo> entry : poloniexCurrencyInfo.entrySet()) {
            Currency ccy = Currency.getInstance((String)entry.getKey());
            if (currencyMetaDataMap.containsKey(ccy)) continue;
            currencyMetaDataMap.put(ccy, currencyArchetype);
        }
        Map marketMetaDataMap = exchangeMetaData.getCurrencyPairs();
        CurrencyPairMetaData marketArchetype = (CurrencyPairMetaData)marketMetaDataMap.values().iterator().next();
        for (String market : poloniexMarketData.keySet()) {
            CurrencyPair currencyPair = PoloniexUtils.toCurrencyPair(market);
            if (marketMetaDataMap.containsKey(currencyPair)) continue;
            marketMetaDataMap.put(currencyPair, marketArchetype);
        }
        return exchangeMetaData;
    }

    public static List<FundingRecord> adaptFundingRecords(PoloniexDepositsWithdrawalsResponse poloFundings) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (PoloniexDeposit d : poloFundings.getDeposits()) {
            fundingRecords.add(new FundingRecord(d.getAddress(), d.getTimestamp(), new Currency(d.getCurrency()), d.getAmount(), null, d.getTxid(), FundingRecord.Type.DEPOSIT, FundingRecord.Status.resolveStatus((String)d.getStatus()), null, null, d.getStatus()));
        }
        for (PoloniexWithdrawal w : poloFundings.getWithdrawals()) {
            String[] statusParts = w.getStatus().split(": *");
            String statusStr = statusParts[0];
            FundingRecord.Status status = FundingRecord.Status.resolveStatus((String)statusStr);
            String externalId = statusParts.length == 1 ? null : statusParts[1];
            fundingRecords.add(new FundingRecord(w.getAddress(), w.getTimestamp(), new Currency(w.getCurrency()), w.getAmount(), String.valueOf(w.getWithdrawalNumber()), externalId, FundingRecord.Type.WITHDRAWAL, status, null, null, w.getStatus()));
        }
        return fundingRecords;
    }
}

