/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.poloniex.PoloniexAuthenticated;
import org.knowm.xchange.poloniex.PoloniexException;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMoveResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOrderFlags;
import org.knowm.xchange.poloniex.dto.trade.PoloniexTradeResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import org.knowm.xchange.poloniex.service.PoloniexBaseService;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class PoloniexTradeServiceRaw
extends PoloniexBaseService {
    public PoloniexTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, PoloniexOpenOrder[]> returnOpenOrders() throws IOException {
        return this.poloniexAuthenticated.returnOpenOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexAuthenticated.AllPairs.all);
    }

    public Map<String, PoloniexOpenOrder[]> returnOrder(String orderId) throws IOException {
        return this.poloniexAuthenticated.returnOrderTrades(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
    }

    public PoloniexOpenOrder[] returnOpenOrders(CurrencyPair currencyPair) throws IOException {
        return this.poloniexAuthenticated.returnOpenOrders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexUtils.toPairString(currencyPair));
    }

    public PoloniexUserTrade[] returnTradeHistory(CurrencyPair currencyPair, Long startTime, Long endTime) throws IOException {
        return this.poloniexAuthenticated.returnTradeHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), PoloniexUtils.toPairString(currencyPair), startTime, endTime);
    }

    public HashMap<String, PoloniexUserTrade[]> returnTradeHistory(Long startTime, Long endTime) throws IOException {
        String ignore = null;
        return this.poloniexAuthenticated.returnTradeHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), "all", startTime, endTime, ignore);
    }

    public PoloniexTradeResponse buy(LimitOrder limitOrder) throws IOException {
        return this.orderEntry(limitOrder, "buy");
    }

    public PoloniexTradeResponse sell(LimitOrder limitOrder) throws IOException {
        return this.orderEntry(limitOrder, "sell");
    }

    private PoloniexTradeResponse orderEntry(LimitOrder limitOrder, String name) throws IOException {
        Integer fillOrKill = limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.FILL_OR_KILL) ? Integer.valueOf(1) : null;
        Integer immediateOrCancel = limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.IMMEDIATE_OR_CANCEL) ? Integer.valueOf(1) : null;
        Integer postOnly = limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.POST_ONLY) ? Integer.valueOf(1) : null;
        Object lendingRate = null;
        try {
            if (limitOrder.hasFlag((Order.IOrderFlags)PoloniexOrderFlags.MARGIN)) {
                name = "margin" + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method marginMethod = PoloniexAuthenticated.class.getDeclaredMethod(name, String.class, ParamsDigest.class, SynchronizedValueFactory.class, String.class, String.class, String.class, Double.class);
                PoloniexTradeResponse response = (PoloniexTradeResponse)marginMethod.invoke((Object)this.poloniexAuthenticated, this.apiKey, this.signatureCreator, this.exchange.getNonceFactory(), limitOrder.getTradableAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString(), PoloniexUtils.toPairString(limitOrder.getCurrencyPair()), lendingRate);
                return response;
            }
            Method method = PoloniexAuthenticated.class.getDeclaredMethod(name, String.class, ParamsDigest.class, SynchronizedValueFactory.class, String.class, String.class, String.class, Integer.class, Integer.class, Integer.class);
            PoloniexTradeResponse response = (PoloniexTradeResponse)method.invoke((Object)this.poloniexAuthenticated, this.apiKey, this.signatureCreator, this.exchange.getNonceFactory(), limitOrder.getTradableAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString(), PoloniexUtils.toPairString(limitOrder.getCurrencyPair()), fillOrKill, immediateOrCancel, postOnly);
            return response;
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExchangeException(e.getMessage(), (Throwable)e);
        }
    }

    public PoloniexMoveResponse move(String orderId, BigDecimal tradableAmount, BigDecimal limitPrice, PoloniexOrderFlags flag) throws IOException {
        Integer immediateOrCancel = flag == PoloniexOrderFlags.IMMEDIATE_OR_CANCEL ? Integer.valueOf(1) : null;
        Integer postOnly = flag == PoloniexOrderFlags.POST_ONLY ? Integer.valueOf(1) : null;
        try {
            return this.poloniexAuthenticated.moveOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId, tradableAmount.toPlainString(), limitPrice.toPlainString(), immediateOrCancel, postOnly);
        }
        catch (PoloniexException e) {
            throw new ExchangeException(e.getError(), (Throwable)((Object)e));
        }
    }

    public PoloniexMoveResponse move(String orderId, BigDecimal tradableAmount, BigDecimal limitPrice) throws IOException {
        return this.move(orderId, tradableAmount, limitPrice, null);
    }

    public boolean cancel(String orderId) throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.cancelOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        if (response.containsKey("error")) {
            throw new ExchangeException(response.get("error"));
        }
        return response.get("success").equals("1");
    }

    public HashMap<String, String> getFeeInfo() throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.returnFeeInfo(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.containsKey("error")) {
            throw new ExchangeException(response.get("error"));
        }
        return response;
    }
}

