/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;

@JsonDeserialize(using=YoBitPairDeserializer.class)
public class YoBitPair {
    private Integer decimal_places;
    private BigDecimal min_price;
    private BigDecimal max_price;
    private BigDecimal min_amount;
    private BigDecimal min_total;
    private Integer hidden;
    private BigDecimal fee;
    private BigDecimal fee_buyer;
    private BigDecimal fee_seller;

    public YoBitPair(Integer decimal_places, BigDecimal min_price, BigDecimal max_price, BigDecimal min_amount, BigDecimal min_total, Integer hidden, BigDecimal fee, BigDecimal fee_buyer, BigDecimal fee_seller) {
        this.decimal_places = decimal_places;
        this.min_price = min_price;
        this.max_price = max_price;
        this.min_amount = min_amount;
        this.min_total = min_total;
        this.hidden = hidden;
        this.fee = fee;
        this.fee_buyer = fee_buyer;
        this.fee_seller = fee_seller;
    }

    public Integer getDecimal_places() {
        return this.decimal_places;
    }

    public BigDecimal getMin_price() {
        return this.min_price;
    }

    public BigDecimal getMax_price() {
        return this.max_price;
    }

    public BigDecimal getMin_amount() {
        return this.min_amount;
    }

    public BigDecimal getMin_total() {
        return this.min_total;
    }

    public Integer getHidden() {
        return this.hidden;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigDecimal getFee_buyer() {
        return this.fee_buyer;
    }

    public BigDecimal getFee_seller() {
        return this.fee_seller;
    }

    public String toString() {
        return "YoBitPair [decimal_places=" + this.decimal_places + ", min_price=" + this.min_price + ", max_price=" + this.max_price + ", min_amount=" + this.min_amount + ", min_total=" + this.min_total + ", hidden=" + this.hidden + ", fee=" + this.fee + ", fee_buyer=" + this.fee_buyer + ", fee_seller=" + this.fee_seller + "]";
    }

    static class YoBitPairDeserializer
    extends JsonDeserializer<YoBitPair> {
        YoBitPairDeserializer() {
        }

        private static BigDecimal getNumberIfPresent(JsonNode numberNode) {
            String numberString = numberNode.asText();
            return numberString.isEmpty() ? null : new BigDecimal(numberString);
        }

        public static YoBitPair deserializeFromNode(JsonNode tickerNode) {
            Integer decimal_places = tickerNode.path("decimal_places").asInt();
            BigDecimal min_price = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("min_price"));
            BigDecimal max_price = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("max_price"));
            BigDecimal min_amount = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("min_amount"));
            BigDecimal min_total = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("min_total"));
            Integer hidden = tickerNode.path("hidden").asInt();
            BigDecimal fee = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("fee"));
            BigDecimal fee_buyer = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("fee_buyer"));
            BigDecimal fee_seller = YoBitPairDeserializer.getNumberIfPresent(tickerNode.path("fee_seller"));
            return new YoBitPair(decimal_places, min_price, max_price, min_amount, min_total, hidden, fee, fee_buyer, fee_seller);
        }

        public YoBitPair deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode tickerNode = (JsonNode)oc.readTree(jp);
            return YoBitPairDeserializer.deserializeFromNode(tickerNode);
        }
    }
}

