/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.VoidReadOperationThenCursorReadOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class AggregatePublisherImpl<T>
extends BatchCursorPublisher<T>
implements AggregatePublisher<T> {
    private final List<? extends Bson> pipeline;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;
    private Bson variables;

    AggregatePublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, List<? extends Bson> pipeline, AggregationLevel aggregationLevel) {
        super(clientSession, mongoOperationPublisher);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.aggregationLevel = (AggregationLevel)Assertions.notNull((String)"aggregationLevel", (Object)aggregationLevel);
    }

    @Override
    public AggregatePublisher<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregatePublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AggregatePublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<T> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregatePublisher<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregatePublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public AggregatePublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AggregatePublisher<T> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public AggregatePublisher<T> hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    @Override
    public AggregatePublisher<T> let(@Nullable Bson variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public Publisher<Void> toCollection() {
        BsonDocument lastPipelineStage = this.getLastPipelineStage();
        if (lastPipelineStage == null || !lastPipelineStage.containsKey((Object)"$out") && !lastPipelineStage.containsKey((Object)"$merge")) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out or $merge");
        }
        return this.getMongoOperationPublisher().createReadOperationMono(this::getAggregateToCollectionOperation, this.getClientSession());
    }

    @Override
    public Publisher<Document> explain() {
        return this.publishExplain(Document.class, null);
    }

    @Override
    public Publisher<Document> explain(ExplainVerbosity verbosity) {
        return this.publishExplain(Document.class, (ExplainVerbosity)Assertions.notNull((String)"verbosity", (Object)verbosity));
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass) {
        return this.publishExplain(explainResultClass, null);
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        return this.publishExplain(explainResultClass, (ExplainVerbosity)Assertions.notNull((String)"verbosity", (Object)verbosity));
    }

    private <E> Publisher<E> publishExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        Assertions.notNull((String)"explainDocumentClass", explainResultClass);
        return this.getMongoOperationPublisher().createReadOperationMono(() -> this.asAggregateOperation(1).asAsyncExplainableOperation(verbosity, (Decoder)this.getCodecRegistry().get(explainResultClass)), this.getClientSession());
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        MongoNamespace outNamespace = this.getOutNamespace();
        if (outNamespace != null) {
            AsyncReadOperation<Void> aggregateToCollectionOperation = this.getAggregateToCollectionOperation();
            FindOptions findOptions = new FindOptions().collation(this.collation).comment(this.comment).batchSize(initialBatchSize);
            AsyncReadOperation findOperation = this.getOperations().find(outNamespace, (Bson)new BsonDocument(), this.getDocumentClass(), findOptions);
            return new VoidReadOperationThenCursorReadOperation(aggregateToCollectionOperation, findOperation);
        }
        return this.asAggregateOperation(initialBatchSize);
    }

    private AsyncExplainableReadOperation<AsyncBatchCursor<T>> asAggregateOperation(int initialBatchSize) {
        return this.getOperations().aggregate(this.pipeline, this.getDocumentClass(), this.maxTimeMS, this.maxAwaitTimeMS, Integer.valueOf(initialBatchSize), this.collation, this.hint, this.hintString, this.comment, this.variables, this.allowDiskUse, this.aggregationLevel);
    }

    private AsyncReadOperation<Void> getAggregateToCollectionOperation() {
        return this.getOperations().aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.hintString, this.comment, this.variables, this.aggregationLevel);
    }

    @Nullable
    private BsonDocument getLastPipelineStage() {
        if (this.pipeline.isEmpty()) {
            return null;
        }
        Bson lastStage = (Bson)Assertions.notNull((String)"last pipeline stage", (Object)this.pipeline.get(this.pipeline.size() - 1));
        return lastStage.toBsonDocument(this.getDocumentClass(), this.getCodecRegistry());
    }

    @Nullable
    private MongoNamespace getOutNamespace() {
        BsonDocument lastPipelineStage = this.getLastPipelineStage();
        if (lastPipelineStage == null) {
            return null;
        }
        String databaseName = this.getNamespace().getDatabaseName();
        if (lastPipelineStage.containsKey((Object)"$out")) {
            if (lastPipelineStage.get((Object)"$out").isString()) {
                return new MongoNamespace(databaseName, lastPipelineStage.getString((Object)"$out").getValue());
            }
            if (lastPipelineStage.get((Object)"$out").isDocument()) {
                BsonDocument outDocument = lastPipelineStage.getDocument((Object)"$out");
                if (!outDocument.containsKey((Object)"db") || !outDocument.containsKey((Object)"coll")) {
                    throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a namespace document");
                }
                return new MongoNamespace(outDocument.getString((Object)"db").getValue(), outDocument.getString((Object)"coll").getValue());
            }
            throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a string or namespace document");
        }
        if (lastPipelineStage.containsKey((Object)"$merge")) {
            if (lastPipelineStage.isString((Object)"$merge")) {
                return new MongoNamespace(databaseName, lastPipelineStage.getString((Object)"$merge").getValue());
            }
            if (lastPipelineStage.isDocument((Object)"$merge")) {
                BsonDocument mergeDocument = lastPipelineStage.getDocument((Object)"$merge");
                if (mergeDocument.isDocument((Object)"into")) {
                    BsonDocument intoDocument = mergeDocument.getDocument((Object)"into");
                    return new MongoNamespace(intoDocument.getString((Object)"db", new BsonString(databaseName)).getValue(), intoDocument.getString((Object)"coll").getValue());
                }
                if (mergeDocument.isString((Object)"into")) {
                    return new MongoNamespace(databaseName, mergeDocument.getString((Object)"into").getValue());
                }
            } else {
                throw new IllegalStateException("Cannot return a cursor when the value for $merge stage is not a string or a document");
            }
        }
        return null;
    }
}

