/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.mortbay.jetty.plus.jaas.spi.AbstractLoginModule;
import org.mortbay.jetty.plus.jaas.spi.UserInfo;
import org.mortbay.jetty.security.Credential;
import org.mortbay.log.Log;

public abstract class AbstractDatabaseLoginModule
extends AbstractLoginModule {
    private String userQuery;
    private String rolesQuery;
    private String dbUserTable;
    private String dbUserTableUserField;
    private String dbUserTableCredentialField;
    private String dbUserRoleTable;
    private String dbUserRoleTableUserField;
    private String dbUserRoleTableRoleField;

    public abstract Connection getConnection() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserInfo(String userName) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement(this.userQuery);
            statement.setString(1, userName);
            ResultSet results = statement.executeQuery();
            String dbCredential = null;
            if (results.next()) {
                dbCredential = results.getString(1);
            }
            results.close();
            statement.close();
            statement = connection.prepareStatement(this.rolesQuery);
            statement.setString(1, userName);
            results = statement.executeQuery();
            ArrayList<String> roles = new ArrayList<String>();
            while (results.next()) {
                String roleName = results.getString(1);
                roles.add(roleName);
            }
            results.close();
            statement.close();
            UserInfo userInfo = new UserInfo(userName, Credential.getCredential((String)dbCredential), roles);
            return userInfo;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dbUserTable = (String)options.get("userTable");
        this.dbUserTableUserField = (String)options.get("userField");
        this.dbUserTableCredentialField = (String)options.get("credentialField");
        this.userQuery = "select " + this.dbUserTableCredentialField + " from " + this.dbUserTable + " where " + this.dbUserTableUserField + "=?";
        this.dbUserRoleTable = (String)options.get("userRoleTable");
        this.dbUserRoleTableUserField = (String)options.get("userRoleUserField");
        this.dbUserRoleTableRoleField = (String)options.get("userRoleRoleField");
        this.rolesQuery = "select " + this.dbUserRoleTableRoleField + " from " + this.dbUserRoleTable + " where " + this.dbUserRoleTableUserField + "=?";
        if (Log.isDebugEnabled()) {
            Log.debug((String)("userQuery = " + this.userQuery));
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("rolesQuery = " + this.rolesQuery));
        }
    }
}

