/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class Transaction
extends NamingEntry {
    public static final String USER_TRANSACTION = "UserTransaction";

    public static Transaction getTransaction(int scopeType) throws NamingException {
        return (Transaction)Transaction.lookupNamingEntry(scopeType, Transaction.class, USER_TRANSACTION);
    }

    public Transaction(UserTransaction userTransaction) throws NamingException {
        super(USER_TRANSACTION, userTransaction);
    }

    public void bindToENC() throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp");
        Log.debug((String)("Binding java:comp/" + this.getJndiName() + " to " + this.absoluteObjectNameString));
        NamingUtil.bind((Context)env, (String)this.getJndiName(), (Object)new LinkRef(this.absoluteObjectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp");
            Log.debug((String)("Unbinding java:comp/" + this.getJndiName()));
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }
}

