/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import org.openapitools.codegen.serializer.OpenAPISerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerUtils.class);

    public static String toYamlString(OpenAPI openAPI) {
        if (openAPI == null) {
            return null;
        }
        SimpleModule module = new SimpleModule("OpenAPIModule");
        module.addSerializer(OpenAPI.class, (JsonSerializer)new OpenAPISerializer());
        try {
            return Yaml.mapper().registerModule((Module)module).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).writeValueAsString((Object)openAPI).replace("\r\n", "\n");
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Can not create yaml content", (Throwable)e);
            return null;
        }
    }
}

