/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.EnumSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;

public class StaticDocCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "docs";

    public StaticDocCodegen() {
        this.featureSet = this.getFeatureSet().modify().documentationFeatures(EnumSet.allOf(DocumentationFeature.class)).dataTypeFeatures(EnumSet.allOf(DataTypeFeature.class)).wireFormatFeatures(EnumSet.allOf(WireFormatFeature.class)).securityFeatures(EnumSet.allOf(SecurityFeature.class)).globalFeatures(EnumSet.allOf(GlobalFeature.class)).parameterFeatures(EnumSet.allOf(ParameterFeature.class)).schemaSupportFeatures(EnumSet.allOf(SchemaSupportFeature.class)).build();
        this.importMapping.clear();
        this.outputFolder = "docs";
        this.modelTemplateFiles.put("model.mustache", ".html");
        this.apiTemplateFiles.put("operation.mustache", ".html");
        this.templateDir = "openapi-static";
        this.embeddedTemplateDir = "openapi-static";
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename"));
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.js"));
        this.supportingFiles.add(new SupportingFile("assets/css/bootstrap-responsive.css", this.outputFolder + "/assets/css", "bootstrap-responsive.css"));
        this.supportingFiles.add(new SupportingFile("assets/css/bootstrap.css", this.outputFolder + "/assets/css", "bootstrap.css"));
        this.supportingFiles.add(new SupportingFile("assets/css/style.css", this.outputFolder + "/assets/css", "style.css"));
        this.supportingFiles.add(new SupportingFile("assets/images/logo.png", this.outputFolder + "/assets/images", "logo.png"));
        this.supportingFiles.add(new SupportingFile("assets/js/bootstrap.js", this.outputFolder + "/assets/js", "bootstrap.js"));
        this.supportingFiles.add(new SupportingFile("assets/js/jquery-1.8.3.min.js", this.outputFolder + "/assets/js", "jquery-1.8.3.min.js"));
        this.supportingFiles.add(new SupportingFile("assets/js/main.js", this.outputFolder + "/assets/js", "main.js"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.outputFolder, "index.html"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "dynamic-html";
    }

    @Override
    public String getHelp() {
        return "Generates a dynamic HTML site.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "operations";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "models";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

