/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenCallback;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenModelFactory;
import org.openapitools.codegen.CodegenModelType;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenServer;
import org.openapitools.codegen.CodegenServerVariable;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.examples.ExampleGenerator;
import org.openapitools.codegen.meta.FeatureSet;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.serializer.SerializerUtils;
import org.openapitools.codegen.templating.MustacheEngineAdapter;
import org.openapitools.codegen.templating.mustache.CamelCaseLambda;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.templating.mustache.LowercaseLambda;
import org.openapitools.codegen.templating.mustache.TitlecaseLambda;
import org.openapitools.codegen.templating.mustache.UppercaseLambda;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.OneOfImplementorAdditionalData;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    public static FeatureSet DefaultFeatureSet = FeatureSet.newBuilder().includeDataTypeFeatures(new DataTypeFeature[]{DataTypeFeature.Int32, DataTypeFeature.Int64, DataTypeFeature.Float, DataTypeFeature.Double, DataTypeFeature.Decimal, DataTypeFeature.String, DataTypeFeature.Byte, DataTypeFeature.Binary, DataTypeFeature.Boolean, DataTypeFeature.Date, DataTypeFeature.DateTime, DataTypeFeature.Password, DataTypeFeature.File, DataTypeFeature.Array, DataTypeFeature.Maps, DataTypeFeature.CollectionFormat, DataTypeFeature.CollectionFormatMulti, DataTypeFeature.Enum, DataTypeFeature.ArrayOfEnum, DataTypeFeature.ArrayOfModel, DataTypeFeature.ArrayOfCollectionOfPrimitives, DataTypeFeature.ArrayOfCollectionOfModel, DataTypeFeature.ArrayOfCollectionOfEnum, DataTypeFeature.MapOfEnum, DataTypeFeature.MapOfModel, DataTypeFeature.MapOfCollectionOfPrimitives, DataTypeFeature.MapOfCollectionOfModel, DataTypeFeature.MapOfCollectionOfEnum}).includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Api, DocumentationFeature.Model}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Host, GlobalFeature.BasePath, GlobalFeature.Info, GlobalFeature.PartialSchemes, GlobalFeature.Consumes, GlobalFeature.Produces, GlobalFeature.ExternalDocumentation, GlobalFeature.Examples, GlobalFeature.Callbacks}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Simple, SchemaSupportFeature.Composite, SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Path, ParameterFeature.Query, ParameterFeature.Header, ParameterFeature.Body, ParameterFeature.FormUnencoded, ParameterFeature.FormMultipart, ParameterFeature.Cookie}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.BearerToken, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_AuthorizationCode}).includeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.JSON, WireFormatFeature.XML}).build();
    private static Cache<SanitizeNameOptions, String> sanitizedNameCache;
    protected GeneratorMetadata generatorMetadata;
    protected String inputSpec;
    protected String outputFolder = "";
    protected Set<String> defaultIncludes;
    protected Map<String, String> typeMapping;
    protected Map<String, String> instantiationTypes;
    protected Set<String> reservedWords;
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected String modelNamePrefix = "";
    protected String modelNameSuffix = "";
    protected String apiNamePrefix = "";
    protected String apiNameSuffix = "Api";
    protected String testPackage = "";
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> reservedWordsMappings = new HashMap<String, String>();
    protected String templateDir;
    protected String embeddedTemplateDir;
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected Map<String, String> serverVariables = new HashMap<String, String>();
    protected Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected boolean skipOverwrite;
    protected boolean removeOperationIdPrefix;
    protected boolean skipOperationExample;
    protected static final Pattern JSON_MIME_PATTERN;
    protected static final Pattern JSON_VENDOR_MIME_PATTERN;
    private static final Pattern COMMON_PREFIX_ENUM_NAME;
    protected boolean supportsMultipleInheritance;
    protected boolean supportsInheritance;
    protected boolean supportsAdditionalPropertiesWithComposedSchema;
    protected boolean supportsMixins;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library;
    protected Boolean sortParamsByRequiredFlag = true;
    protected Boolean sortModelPropertiesByRequiredFlag = false;
    protected Boolean ensureUniqueParams = true;
    protected Boolean allowUnicodeIdentifiers = false;
    protected String gitHost;
    protected String gitUserId;
    protected String gitRepoId;
    protected String releaseNote;
    protected String httpUserAgent;
    protected Boolean hideGenerationTimestamp = true;
    protected Map<String, String> specialCharReplacements = new HashMap<String, String>();
    protected Map<String, String> typeAliases = null;
    protected Boolean prependFormOrBodyParameters = false;
    protected String docExtension;
    protected String ignoreFilePathOverride;
    protected boolean enablePostProcessFile = false;
    private TemplatingEngineAdapter templatingEngine = new MustacheEngineAdapter();
    protected boolean useOneOfInterfaces = false;
    protected boolean addOneOfInterfaceImports = false;
    protected List<CodegenModel> addOneOfInterfaces = new ArrayList<CodegenModel>();
    protected boolean enableMinimalUpdate = false;
    protected boolean strictSpecBehavior = true;
    protected boolean removeEnumValuePrefix = true;
    protected boolean legacyDiscriminatorBehavior = true;
    protected boolean disallowAdditionalPropertiesIfNotPresent = true;
    protected OpenAPI openAPI;
    private Map<String, Schema> modelNameToSchemaCache;
    Map<NamedSchema, CodegenProperty> schemaCodegenPropertyCache = new HashMap<NamedSchema, CodegenProperty>();

    @Override
    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.setTemplateDir((String)this.additionalProperties.get("templateDir"));
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.setModelPackage((String)this.additionalProperties.get("modelPackage"));
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.setApiPackage((String)this.additionalProperties.get("apiPackage"));
        }
        if (this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.setHideGenerationTimestamp(this.convertPropertyToBooleanAndWriteBack("hideGenerationTimestamp"));
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", this.hideGenerationTimestamp);
        }
        if (this.additionalProperties.containsKey("sortParamsByRequiredFlag")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortParamsByRequiredFlag").toString()));
        }
        if (this.additionalProperties.containsKey("sortModelPropertiesByRequiredFlag")) {
            this.setSortModelPropertiesByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortModelPropertiesByRequiredFlag").toString()));
        }
        if (this.additionalProperties.containsKey("prependFormOrBodyParameters")) {
            this.setPrependFormOrBodyParameters(Boolean.valueOf(this.additionalProperties.get("prependFormOrBodyParameters").toString()));
        }
        if (this.additionalProperties.containsKey("ensureUniqueParams")) {
            this.setEnsureUniqueParams(Boolean.valueOf(this.additionalProperties.get("ensureUniqueParams").toString()));
        }
        if (this.additionalProperties.containsKey("allowUnicodeIdentifiers")) {
            this.setAllowUnicodeIdentifiers(Boolean.valueOf(this.additionalProperties.get("allowUnicodeIdentifiers").toString()));
        }
        if (this.additionalProperties.containsKey("apiNamePrefix")) {
            this.setApiNamePrefix((String)this.additionalProperties.get("apiNamePrefix"));
        }
        if (this.additionalProperties.containsKey("apiNameSuffix")) {
            this.setApiNameSuffix((String)this.additionalProperties.get("apiNameSuffix"));
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.setModelNamePrefix((String)this.additionalProperties.get("modelNamePrefix"));
        }
        if (this.additionalProperties.containsKey("modelNameSuffix")) {
            this.setModelNameSuffix((String)this.additionalProperties.get("modelNameSuffix"));
        }
        if (this.additionalProperties.containsKey("removeOperationIdPrefix")) {
            this.setRemoveOperationIdPrefix(Boolean.parseBoolean(this.additionalProperties.get("removeOperationIdPrefix").toString()));
        }
        if (this.additionalProperties.containsKey("skipOperationExample")) {
            this.setSkipOperationExample(Boolean.parseBoolean(this.additionalProperties.get("skipOperationExample").toString()));
        }
        if (this.additionalProperties.containsKey("docExtension")) {
            this.setDocExtension(String.valueOf(this.additionalProperties.get("docExtension").toString()));
        }
        if (this.additionalProperties.containsKey("enablePostProcessFile")) {
            this.setEnablePostProcessFile(Boolean.parseBoolean(this.additionalProperties.get("enablePostProcessFile").toString()));
        }
        if (this.additionalProperties.containsKey("generateAliasAsModel")) {
            ModelUtils.setGenerateAliasAsModel(Boolean.parseBoolean(this.additionalProperties.get("generateAliasAsModel").toString()));
        }
        if (this.additionalProperties.containsKey("removeEnumValuePrefix")) {
            this.setRemoveEnumValuePrefix(Boolean.parseBoolean(this.additionalProperties.get("removeEnumValuePrefix").toString()));
        }
        if (this.additionalProperties.containsKey("legacyDiscriminatorBehavior")) {
            this.setLegacyDiscriminatorBehavior(Boolean.parseBoolean(this.additionalProperties.get("legacyDiscriminatorBehavior").toString()));
        }
        if (this.additionalProperties.containsKey("disallowAdditionalPropertiesIfNotPresent")) {
            this.setDisallowAdditionalPropertiesIfNotPresent(Boolean.parseBoolean(this.additionalProperties.get("disallowAdditionalPropertiesIfNotPresent").toString()));
        }
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return new ImmutableMap.Builder().put((Object)"lowercase", (Object)new LowercaseLambda().generator(this)).put((Object)"uppercase", (Object)new UppercaseLambda()).put((Object)"titlecase", (Object)new TitlecaseLambda()).put((Object)"camelcase", (Object)new CamelCaseLambda(true).generator(this)).put((Object)"pascalcase", (Object)new CamelCaseLambda(false).generator(this)).put((Object)"indented", (Object)new IndentedLambda()).put((Object)"indented_8", (Object)new IndentedLambda(8, " ")).put((Object)"indented_12", (Object)new IndentedLambda(12, " ")).put((Object)"indented_16", (Object)new IndentedLambda(16, " "));
    }

    private void registerMustacheLambdas() {
        ImmutableMap lambdas = this.addMustacheLambdas().build();
        if (lambdas.size() == 0) {
            return;
        }
        if (this.additionalProperties.containsKey("lambda")) {
            this.LOGGER.error("A property called 'lambda' already exists in additionalProperties");
            throw new RuntimeException("A property called 'lambda' already exists in additionalProperties");
        }
        this.additionalProperties.put("lambda", lambdas);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        if (this.useOneOfInterfaces) {
            List models;
            Map modelsAttrs;
            for (CodegenModel cm : this.addOneOfInterfaces) {
                HashMap<String, Object> modelValue = new HashMap<String, Object>(this.additionalProperties());
                modelValue.put("model", cm);
                ArrayList importsValue = new ArrayList();
                HashMap<String, Object> objsValue = new HashMap<String, Object>();
                objsValue.put("models", Collections.singletonList(modelValue));
                objsValue.put("package", this.modelPackage());
                objsValue.put("imports", importsValue);
                objsValue.put("classname", cm.classname);
                objsValue.putAll(this.additionalProperties);
                objs.put(cm.name, objsValue);
            }
            HashMap<String, OneOfImplementorAdditionalData> additionalDataMap = new HashMap<String, OneOfImplementorAdditionalData>();
            for (Map.Entry<String, Object> modelsEntry : objs.entrySet()) {
                modelsAttrs = (Map)modelsEntry.getValue();
                models = (List)modelsAttrs.get("models");
                List modelsImports = modelsAttrs.getOrDefault("imports", new ArrayList());
                for (Object _mo : models) {
                    Map mo = (Map)_mo;
                    CodegenModel cm = (CodegenModel)mo.get("model");
                    if (cm.oneOf.size() <= 0) continue;
                    cm.vendorExtensions.put("x-is-one-of-interface", true);
                    for (String one : cm.oneOf) {
                        if (!additionalDataMap.containsKey(one)) {
                            additionalDataMap.put(one, new OneOfImplementorAdditionalData(one));
                        }
                        ((OneOfImplementorAdditionalData)additionalDataMap.get(one)).addFromInterfaceModel(cm, modelsImports);
                    }
                    this.addImportsToOneOfInterface(modelsImports);
                }
            }
            for (Map.Entry<String, Object> modelsEntry : objs.entrySet()) {
                modelsAttrs = (Map)modelsEntry.getValue();
                models = (List)modelsAttrs.get("models");
                List imports = (List)modelsAttrs.get("imports");
                for (Object _implmo : models) {
                    Map implmo = (Map)_implmo;
                    CodegenModel implcm = (CodegenModel)implmo.get("model");
                    String modelName = this.toModelName(implcm.name);
                    if (!additionalDataMap.containsKey(modelName)) continue;
                    ((OneOfImplementorAdditionalData)additionalDataMap.get(modelName)).addToImplementor(this, implcm, imports, this.addOneOfInterfaceImports);
                }
            }
        }
        return objs;
    }

    protected Map<String, Schema> getModelNameToSchemaCache() {
        if (this.modelNameToSchemaCache == null) {
            HashMap m = new HashMap();
            ModelUtils.getSchemas(this.openAPI).forEach((key, schema) -> m.put(this.toModelName((String)key), schema));
            this.modelNameToSchemaCache = Collections.unmodifiableMap(m);
        }
        return this.modelNameToSchemaCache;
    }

    public Map<String, CodegenModel> getAllModels(Map<String, Object> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                allModels.put(modelName, cm);
            }
        }
        return allModels;
    }

    @Override
    public Map<String, Object> updateAllModels(Map<String, Object> objs) {
        Map<String, CodegenModel> allModels = this.getAllModels(objs);
        for (CodegenModel codegenModel : allModels.values()) {
            if (codegenModel.getParent() != null) {
                codegenModel.setParentModel(allModels.get(codegenModel.getParent()));
            }
            if (codegenModel.getInterfaces() == null || codegenModel.getInterfaces().isEmpty()) continue;
            codegenModel.setInterfaceModels(new ArrayList<CodegenModel>(codegenModel.getInterfaces().size()));
            for (String intf : codegenModel.getInterfaces()) {
                CodegenModel intfModel = allModels.get(intf);
                if (intfModel == null) continue;
                codegenModel.getInterfaceModels().add(intfModel);
            }
        }
        for (String string : allModels.keySet()) {
            CodegenModel cm = allModels.get(string);
            CodegenModel parent = allModels.get(cm.getParent());
            while (parent != null) {
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList<CodegenModel>());
                }
                parent.getChildren().add(cm);
                parent.hasChildren = true;
                Schema parentSchema = (Schema)this.openAPI.getComponents().getSchemas().get(parent.name);
                if (parentSchema.getDiscriminator() == null) {
                    parent = allModels.get(parent.getParent());
                    continue;
                }
                parent = null;
            }
        }
        for (Map.Entry entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                for (CodegenProperty cp : cm.allVars) {
                    if (!cp.dataType.equalsIgnoreCase(cm.classname) && (!cp.isContainer || cp.items == null || !cp.items.dataType.equalsIgnoreCase(cm.classname))) continue;
                    cm.imports.remove(cm.classname);
                    cp.isSelfReference = true;
                }
            }
        }
        this.setCircularReferences(allModels);
        return objs;
    }

    public void setCircularReferences(Map<String, CodegenModel> models) {
        Map<String, List> dependencyMap = models.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getModelDependencies((CodegenModel)entry.getValue())));
        models.keySet().forEach(name -> this.setCircularReferencesOnProperties((String)name, (Map<String, List<CodegenProperty>>)dependencyMap));
    }

    private List<CodegenProperty> getModelDependencies(CodegenModel model) {
        return model.getAllVars().stream().map(prop -> {
            if (prop.isContainer) {
                return prop.items.dataType == null ? null : prop;
            }
            return prop.dataType == null ? null : prop;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void setCircularReferencesOnProperties(String root, Map<String, List<CodegenProperty>> dependencyMap) {
        ((List)dependencyMap.getOrDefault(root, new ArrayList())).forEach(prop -> {
            List<String> unvisited = Collections.singletonList(prop.isContainer ? prop.items.dataType : prop.dataType);
            prop.isCircularReference = this.isCircularReference(root, new HashSet<String>(), new ArrayList<String>(unvisited), dependencyMap);
        });
    }

    private boolean isCircularReference(String root, Set<String> visited, List<String> unvisited, Map<String, List<CodegenProperty>> dependencyMap) {
        for (int i = 0; i < unvisited.size(); ++i) {
            String next = unvisited.get(i);
            if (visited.contains(next)) continue;
            if (next.equals(root)) {
                return true;
            }
            ((List)dependencyMap.getOrDefault(next, new ArrayList())).forEach(prop -> unvisited.add(prop.isContainer ? prop.items.dataType : prop.dataType));
            visited.add(next);
        }
        return false;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null) {
                Map<String, Object> allowableValues = cm.allowableValues;
                List values = (List)allowableValues.get("values");
                List<Map<String, Object>> enumVars = this.buildEnumVars(values, cm.dataType);
                this.updateEnumVarsWithExtensions(enumVars, cm.getVendorExtensions(), cm.dataType);
                cm.allowableValues.put("enumVars", enumVars);
            }
            for (CodegenProperty var : cm.vars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.allVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.requiredVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.optionalVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.parentVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.readOnlyVars) {
                this.updateCodegenPropertyEnum(var);
            }
            for (CodegenProperty var : cm.readWriteVars) {
                this.updateCodegenPropertyEnum(var);
            }
        }
        return objs;
    }

    public String findCommonPrefixOfVars(List<Object> vars) {
        if (vars.size() > 1) {
            try {
                String[] listStr = vars.toArray(new String[vars.size()]);
                String prefix = org.apache.commons.lang3.StringUtils.getCommonPrefix((String[])listStr);
                Matcher matcher = COMMON_PREFIX_ENUM_NAME.matcher(prefix);
                return matcher.replaceAll("");
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return "";
    }

    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "." + value;
    }

    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public void setOpenAPI(OpenAPI openAPI) {
        this.openAPI = openAPI;
        ModelUtils.setDisallowAdditionalPropertiesIfNotPresent(this.getDisallowAdditionalPropertiesIfNotPresent());
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("################################################################################");
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (this.useOneOfInterfaces) {
            Paths pathItems;
            HashMap<String, Object> schemas = new HashMap<String, Object>(openAPI.getComponents().getSchemas());
            if (schemas == null) {
                schemas = new HashMap();
            }
            if ((pathItems = openAPI.getPaths()) != null) {
                for (Map.Entry e : pathItems.entrySet()) {
                    for (Map.Entry op : ((PathItem)e.getValue()).readOperationsMap().entrySet()) {
                        String opId = this.getOrGenerateOperationId((Operation)op.getValue(), (String)e.getKey(), ((PathItem.HttpMethod)op.getKey()).toString());
                        RequestBody b = ModelUtils.getReferencedRequestBody(openAPI, ((Operation)op.getValue()).getRequestBody());
                        Schema requestSchema = null;
                        if (b != null) {
                            requestSchema = ModelUtils.getSchemaFromRequestBody(b);
                        }
                        if (requestSchema != null) {
                            schemas.put(opId, requestSchema);
                        }
                        if (((Operation)op.getValue()).getResponses() == null) continue;
                        for (Map.Entry ar : ((Operation)op.getValue()).getResponses().entrySet()) {
                            ApiResponse a = ModelUtils.getReferencedApiResponse(openAPI, (ApiResponse)ar.getValue());
                            Schema responseSchema = ModelUtils.getSchemaFromResponse(a);
                            if (responseSchema == null) continue;
                            schemas.put(opId + (String)ar.getKey(), responseSchema);
                        }
                    }
                }
            }
            HashMap propertySchemas = new HashMap();
            for (Map.Entry e : schemas.entrySet()) {
                Schema s = (Schema)e.getValue();
                HashMap props = s.getProperties();
                if (props == null) {
                    props = new HashMap();
                }
                for (Map.Entry p : props.entrySet()) {
                    propertySchemas.put((String)e.getKey() + "/" + (String)p.getKey(), p.getValue());
                }
            }
            schemas.putAll(propertySchemas);
            for (Map.Entry e : schemas.entrySet()) {
                Schema addProps;
                String n = this.toModelName((String)e.getKey());
                Schema s = (Schema)e.getValue();
                String nOneOf = this.toModelName(n + "OneOf");
                if (ModelUtils.isComposedSchema(s)) {
                    if (((String)e.getKey()).contains("/")) {
                        this.addOneOfNameExtension((ComposedSchema)s, nOneOf);
                        this.addOneOfInterfaceModel((ComposedSchema)s, nOneOf, openAPI);
                        continue;
                    }
                    this.addOneOfNameExtension((ComposedSchema)s, n);
                    continue;
                }
                if (ModelUtils.isArraySchema(s)) {
                    Schema items = ((ArraySchema)s).getItems();
                    if (!ModelUtils.isComposedSchema(items)) continue;
                    this.addOneOfNameExtension((ComposedSchema)items, nOneOf);
                    this.addOneOfInterfaceModel((ComposedSchema)items, nOneOf, openAPI);
                    continue;
                }
                if (!ModelUtils.isMapSchema(s) || (addProps = this.getAdditionalProperties(s)) == null || !ModelUtils.isComposedSchema(addProps)) continue;
                this.addOneOfNameExtension((ComposedSchema)addProps, nOneOf);
                this.addOneOfInterfaceModel((ComposedSchema)addProps, nOneOf, openAPI);
            }
        }
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler;
    }

    @Override
    public TemplatingEngineAdapter processTemplatingEngine(TemplatingEngineAdapter templatingEngine) {
        return templatingEngine;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String escapeTextWhileAllowingNewLines(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String encodePath(String input) {
        return this.escapeText(input);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        this.LOGGER.warn("escapeUnsafeCharacters should be overridden in the code generator with proper logic to escape unsafe characters");
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        this.LOGGER.warn("escapeQuotationMark should be overridden in the code generator with proper logic to escape single/double quote");
        return input.replace("\"", "\\\"");
    }

    @Override
    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    @Override
    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    @Override
    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    @Override
    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    @Override
    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    @Override
    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    @Override
    public String testPackage() {
        return this.testPackage;
    }

    @Override
    public String modelPackage() {
        return this.modelPackage;
    }

    @Override
    public String apiPackage() {
        return this.apiPackage;
    }

    @Override
    public String fileSuffix() {
        return this.fileSuffix;
    }

    @Override
    public String templateDir() {
        return this.templateDir;
    }

    @Override
    public String embeddedTemplateDir() {
        if (this.embeddedTemplateDir != null) {
            return this.embeddedTemplateDir;
        }
        return this.templateDir;
    }

    @Override
    public Map<String, String> apiDocTemplateFiles() {
        return this.apiDocTemplateFiles;
    }

    @Override
    public Map<String, String> modelDocTemplateFiles() {
        return this.modelDocTemplateFiles;
    }

    @Override
    public Map<String, String> reservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    @Override
    public Map<String, String> apiTestTemplateFiles() {
        return this.apiTestTemplateFiles;
    }

    @Override
    public Map<String, String> modelTestTemplateFiles() {
        return this.modelTestTemplateFiles;
    }

    @Override
    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    @Override
    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Map<String, String> serverVariableOverrides() {
        return this.serverVariables;
    }

    @Override
    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    @Override
    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    @Override
    public String outputFolder() {
        return this.outputFolder;
    }

    @Override
    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    @Override
    public String getOutputDir() {
        return this.outputFolder();
    }

    @Override
    public String getInputSpec() {
        return this.inputSpec;
    }

    @Override
    public void setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public String getApiNameSuffix() {
        return this.apiNameSuffix;
    }

    public void setApiNameSuffix(String apiNameSuffix) {
        this.apiNameSuffix = apiNameSuffix;
    }

    public String getApiNamePrefix() {
        return this.apiNamePrefix;
    }

    public void setApiNamePrefix(String apiNamePrefix) {
        this.apiNamePrefix = apiNamePrefix;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public Boolean getSortParamsByRequiredFlag() {
        return this.sortParamsByRequiredFlag;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public Boolean getSortModelPropertiesByRequiredFlag() {
        return this.sortModelPropertiesByRequiredFlag;
    }

    public void setSortModelPropertiesByRequiredFlag(Boolean sortModelPropertiesByRequiredFlag) {
        this.sortModelPropertiesByRequiredFlag = sortModelPropertiesByRequiredFlag;
    }

    public Boolean getPrependFormOrBodyParameters() {
        return this.prependFormOrBodyParameters;
    }

    public void setPrependFormOrBodyParameters(Boolean prependFormOrBodyParameters) {
        this.prependFormOrBodyParameters = prependFormOrBodyParameters;
    }

    public Boolean getEnsureUniqueParams() {
        return this.ensureUniqueParams;
    }

    public void setEnsureUniqueParams(Boolean ensureUniqueParams) {
        this.ensureUniqueParams = ensureUniqueParams;
    }

    public Boolean getLegacyDiscriminatorBehavior() {
        return this.legacyDiscriminatorBehavior;
    }

    public void setLegacyDiscriminatorBehavior(boolean val) {
        this.legacyDiscriminatorBehavior = val;
    }

    public Boolean getDisallowAdditionalPropertiesIfNotPresent() {
        return this.disallowAdditionalPropertiesIfNotPresent;
    }

    public void setDisallowAdditionalPropertiesIfNotPresent(boolean val) {
        this.disallowAdditionalPropertiesIfNotPresent = val;
    }

    public Boolean getAllowUnicodeIdentifiers() {
        return this.allowUnicodeIdentifiers;
    }

    public void setAllowUnicodeIdentifiers(Boolean allowUnicodeIdentifiers) {
        this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
    }

    public Boolean getUseOneOfInterfaces() {
        return this.useOneOfInterfaces;
    }

    public void setUseOneOfInterfaces(Boolean useOneOfInterfaces) {
        this.useOneOfInterfaces = useOneOfInterfaces;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(this.escapeText(pattern));
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toApiVarName(String name) {
        return this.lowerCamelCase(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return StringUtils.camelize(name) + "Test";
    }

    @Override
    public String toModelDocFilename(String name) {
        return StringUtils.camelize(name);
    }

    @Override
    public GeneratorMetadata getGeneratorMetadata() {
        return this.generatorMetadata;
    }

    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey("" + (char)character))) {
            return StringUtils.escape(name, this.specialCharReplacements, null, null);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey("" + (char)character))) {
            return StringUtils.escape(name, this.specialCharReplacements, null, null);
        }
        return name;
    }

    public String toArrayModelParamName(String name) {
        return this.toParamName(name);
    }

    public String toEnumName(CodegenProperty property) {
        return org.apache.commons.lang3.StringUtils.capitalize((String)property.name) + "Enum";
    }

    @Override
    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    @Override
    public Map<String, String> toModelImportMap(String name) {
        return Collections.singletonMap(this.toModelImport(name), name);
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        CodegenType codegenType = this.getTag();
        if (codegenType == null) {
            codegenType = CodegenType.OTHER;
        }
        this.generatorMetadata = GeneratorMetadata.newBuilder().stability(Stability.STABLE).featureSet(DefaultFeatureSet).generationMessage(String.format(Locale.ROOT, "OpenAPI Generator: %s (%s)", this.getName(), codegenType.toValue())).build();
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "int", "long", "short", "char", "float", "String", "boolean", "Boolean", "Double", "Void", "Integer", "Long", "Float"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("Set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "URI");
        this.typeMapping.put("AnyType", "oas_any_type_not_mapped");
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("sortModelPropertiesByRequiredFlag", "Sort model properties to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean("prependFormOrBodyParameters", "Add form or body parameters to the beginning of the parameter list.").defaultValue(Boolean.FALSE.toString()));
        CliOption legacyDiscriminatorBehaviorOpt = CliOption.newBoolean("legacyDiscriminatorBehavior", "Set to false for generators with better support for discriminators. (Python, Java, Go, PowerShell, C#have this enabled by default).").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> legacyDiscriminatorBehaviorOpts = new HashMap<String, String>();
        legacyDiscriminatorBehaviorOpts.put("true", "The mapping in the discriminator includes descendent schemas that allOf inherit from self and the discriminator mapping schemas in the OAS document.");
        legacyDiscriminatorBehaviorOpts.put("false", "The mapping in the discriminator includes any descendent schemas that allOf inherit from self, any oneOf schemas, any anyOf schemas, any x-discriminator-values, and the discriminator mapping schemas in the OAS document AND Codegen validates that oneOf and anyOf schemas contain the required discriminator and throws an error if the discriminator is missing.");
        legacyDiscriminatorBehaviorOpt.setEnum(legacyDiscriminatorBehaviorOpts);
        this.cliOptions.add(legacyDiscriminatorBehaviorOpt);
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
        this.initializeSpecialCharacterMapping();
        this.registerMustacheLambdas();
    }

    protected void initializeSpecialCharacterMapping() {
        this.specialCharReplacements.put("$", "Dollar");
        this.specialCharReplacements.put("^", "Caret");
        this.specialCharReplacements.put("|", "Pipe");
        this.specialCharReplacements.put("=", "Equal");
        this.specialCharReplacements.put("*", "Star");
        this.specialCharReplacements.put("-", "Minus");
        this.specialCharReplacements.put("&", "Ampersand");
        this.specialCharReplacements.put("%", "Percent");
        this.specialCharReplacements.put("#", "Hash");
        this.specialCharReplacements.put("@", "At");
        this.specialCharReplacements.put("!", "Exclamation");
        this.specialCharReplacements.put("+", "Plus");
        this.specialCharReplacements.put(":", "Colon");
        this.specialCharReplacements.put(">", "Greater_Than");
        this.specialCharReplacements.put("<", "Less_Than");
        this.specialCharReplacements.put(".", "Period");
        this.specialCharReplacements.put("_", "Underscore");
        this.specialCharReplacements.put("?", "Question_Mark");
        this.specialCharReplacements.put(",", "Comma");
        this.specialCharReplacements.put("'", "Quote");
        this.specialCharReplacements.put("\"", "Double_Quote");
        this.specialCharReplacements.put("/", "Slash");
        this.specialCharReplacements.put("\\", "Back_Slash");
        this.specialCharReplacements.put("(", "Left_Parenthesis");
        this.specialCharReplacements.put(")", "Right_Parenthesis");
        this.specialCharReplacements.put("{", "Left_Curly_Bracket");
        this.specialCharReplacements.put("}", "Right_Curly_Bracket");
        this.specialCharReplacements.put("[", "Left_Square_Bracket");
        this.specialCharReplacements.put("]", "Right_Square_Bracket");
        this.specialCharReplacements.put("~", "Tilde");
        this.specialCharReplacements.put("`", "Backtick");
        this.specialCharReplacements.put("<=", "Less_Than_Or_Equal_To");
        this.specialCharReplacements.put(">=", "Greater_Than_Or_Equal_To");
        this.specialCharReplacements.put("!=", "Not_Equal");
        this.specialCharReplacements.put("~=", "Tilde_Equal");
    }

    protected String getSymbolName(String input) {
        return this.specialCharReplacements.get(input);
    }

    @Override
    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter qp = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (qp.getStyle() != null) {
                    paramPart.append(param.getName()).append("1");
                    if (Parameter.StyleEnum.FORM.equals((Object)qp.getStyle())) {
                        if (qp.getExplode() != null && qp.getExplode().booleanValue()) {
                            paramPart.append(",");
                        } else {
                            paramPart.append("&").append(param.getName()).append("=");
                            paramPart.append(param.getName()).append("2");
                        }
                    } else if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)qp.getStyle())) {
                        paramPart.append("|");
                    } else if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)qp.getStyle())) {
                        paramPart.append("%20");
                    } else {
                        this.LOGGER.warn("query parameter '{}' style not support: {}", (Object)param.getName(), (Object)qp.getStyle());
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("]");
                }
                sb.append(paramPart.toString());
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            Schema additionalProperties = this.getAdditionalProperties(schema);
            String inner = this.getSchemaType(additionalProperties);
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(this.getSchemaItems(arraySchema));
            String parentType = ModelUtils.isSet(schema) ? "set" : "array";
            return this.instantiationTypes.get(parentType) + "<" + inner + ">";
        }
        return null;
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        } else if (Boolean.TRUE.equals(codegenParameter.isBoolean)) {
            codegenParameter.example = "true";
        } else if (Boolean.TRUE.equals(codegenParameter.isLong)) {
            codegenParameter.example = "789";
        } else if (Boolean.TRUE.equals(codegenParameter.isInteger)) {
            codegenParameter.example = "56";
        } else if (Boolean.TRUE.equals(codegenParameter.isFloat)) {
            codegenParameter.example = "3.4";
        } else if (Boolean.TRUE.equals(codegenParameter.isDouble)) {
            codegenParameter.example = "1.2";
        } else if (Boolean.TRUE.equals(codegenParameter.isNumber)) {
            codegenParameter.example = "8.14";
        } else if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            codegenParameter.example = "BYTE_ARRAY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            codegenParameter.example = "2013-10-20";
        } else if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (Boolean.TRUE.equals(codegenParameter.isUuid)) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        } else if (Boolean.TRUE.equals(codegenParameter.isUri)) {
            codegenParameter.example = "https://openapi-generator.tech";
        } else if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        } else if (Boolean.TRUE.equals(codegenParameter.isFreeFormObject)) {
            codegenParameter.example = "Object";
        }
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Example example;
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
            return;
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && (example = (Example)parameter.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
            return;
        }
        Schema schema = parameter.getSchema();
        if (schema != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
            return;
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        Example example;
        MediaType mediaType;
        Content content = requestBody.getContent();
        if (content.size() > 1) {
            OnceLogger.once(this.LOGGER).warn("Multiple MediaTypes found, using only the first one");
        }
        if ((mediaType = (MediaType)content.values().iterator().next()).getExample() != null) {
            codegenParameter.example = mediaType.getExample().toString();
            return;
        }
        if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && (example = (Example)mediaType.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
            return;
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterContentType(CodegenParameter codegenParameter, MediaType mediaType) {
        if (mediaType != null && mediaType.getEncoding() != null) {
            Encoding encoding = (Encoding)mediaType.getEncoding().get(codegenParameter.baseName);
            if (encoding != null) {
                codegenParameter.contentType = encoding.getContentType();
            } else {
                this.LOGGER.debug("encoding not specified for {}", (Object)codegenParameter.baseName);
            }
        }
    }

    public String toExampleValue(Schema schema) {
        if (schema.getExample() != null) {
            return schema.getExample().toString();
        }
        return this.getPropertyDefaultValue(schema);
    }

    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            return schema.getDefault().toString();
        }
        return this.getPropertyDefaultValue(schema);
    }

    public String toDefaultParameterValue(Schema<?> schema) {
        return this.toDefaultValue(schema);
    }

    private String getPropertyDefaultValue(Schema schema) {
        if (ModelUtils.isBooleanSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isStringSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isObjectSchema(schema)) {
            return "null";
        }
        return "null";
    }

    public String toDefaultValueWithParam(String name, Schema schema) {
        return " = data." + name + ";";
    }

    public String getSchemaType(Schema schema) {
        if (schema instanceof ComposedSchema) {
            ComposedSchema cs = (ComposedSchema)schema;
            List<Schema> schemas = ModelUtils.getInterfaces(cs);
            ArrayList<String> names = new ArrayList<String>();
            for (Schema s : schemas) {
                names.add(this.getSingleSchemaType(s));
            }
            if (cs.getAllOf() != null) {
                return this.toAllOfName(names, cs);
            }
            if (cs.getAnyOf() != null) {
                return this.toAnyOfName(names, cs);
            }
            if (cs.getOneOf() != null) {
                return this.toOneOfName(names, cs);
            }
        }
        return this.getSingleSchemaType(schema);
    }

    protected Schema<?> getSchemaItems(ArraySchema schema) {
        Schema items = schema.getItems();
        if (items == null) {
            this.LOGGER.error("Undefined array inner type for `{}`. Default to String.", (Object)schema.getName());
            items = new StringSchema().description("TODO default missing array inner type to string");
            schema.setItems(items);
        }
        return items;
    }

    protected Schema<?> getSchemaAdditionalProperties(Schema schema) {
        Schema inner = this.getAdditionalProperties(schema);
        if (inner == null) {
            this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)schema.getName());
            inner = new StringSchema().description("TODO default missing map inner type to string");
            schema.setAdditionalProperties((Object)inner);
        }
        return inner;
    }

    public String toAllOfName(List<String> names, ComposedSchema composedSchema) {
        Map exts = composedSchema.getExtensions();
        if (exts != null && exts.containsKey("x-all-of-name")) {
            return (String)exts.get("x-all-of-name");
        }
        if (names.size() == 0) {
            this.LOGGER.error("allOf has no member defined: {}. Default to ERROR_ALLOF_SCHEMA", (Object)composedSchema);
            return "ERROR_ALLOF_SCHEMA";
        }
        if (names.size() == 1) {
            return names.get(0);
        }
        this.LOGGER.warn("allOf with multiple schemas defined. Using only the first one: {}", (Object)names.get(0));
        return names.get(0);
    }

    public String toAnyOfName(List<String> names, ComposedSchema composedSchema) {
        return "anyOf<" + String.join((CharSequence)",", names) + ">";
    }

    public String toOneOfName(List<String> names, ComposedSchema composedSchema) {
        Map exts = composedSchema.getExtensions();
        if (exts != null && exts.containsKey("x-one-of-name")) {
            return (String)exts.get("x-one-of-name");
        }
        return "oneOf<" + String.join((CharSequence)",", names) + ">";
    }

    @Override
    public Schema unaliasSchema(Schema schema, Map<String, String> usedImportMappings) {
        return ModelUtils.unaliasSchema(this.openAPI, schema, usedImportMappings);
    }

    protected String getSingleSchemaType(Schema schema) {
        Schema unaliasSchema = this.unaliasSchema(schema, this.importMapping);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)unaliasSchema.get$ref())) {
            String schemaName = ModelUtils.getSimpleRef(unaliasSchema.get$ref());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)schemaName)) {
                if (this.importMapping.containsKey(schemaName)) {
                    return schemaName;
                }
                return this.getAlias(schemaName);
            }
            this.LOGGER.warn("Error obtaining the datatype from ref: {}. Default to 'object'", (Object)unaliasSchema.get$ref());
            return "object";
        }
        return this.getAlias(this.getPrimitiveType(unaliasSchema));
    }

    private String getPrimitiveType(Schema schema) {
        if (schema == null) {
            throw new RuntimeException("schema cannot be null in getPrimitiveType");
        }
        if (this.typeMapping.containsKey(schema.getType() + "+" + schema.getFormat())) {
            return this.typeMapping.get(schema.getType() + "+" + schema.getFormat());
        }
        if (ModelUtils.isNullType(schema)) {
            return "null";
        }
        if (ModelUtils.isDecimalSchema(schema)) {
            return "decimal";
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            return "ByteArray";
        }
        if (ModelUtils.isFileSchema(schema)) {
            return "file";
        }
        if (ModelUtils.isBinarySchema(schema)) {
            return "binary";
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            return "boolean";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "date";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "DateTime";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (schema.getFormat() == null) {
                return "number";
            }
            if (ModelUtils.isFloatSchema(schema)) {
                return "float";
            }
            if (ModelUtils.isDoubleSchema(schema)) {
                return "double";
            }
            this.LOGGER.warn("Unknown `format` {} detected for type `number`. Defaulting to `number`", (Object)schema.getFormat());
            return "number";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (ModelUtils.isLongSchema(schema)) {
                return "long";
            }
            return schema.getType();
        }
        if (ModelUtils.isMapSchema(schema)) {
            return "map";
        }
        if (ModelUtils.isArraySchema(schema)) {
            if (ModelUtils.isSet(schema)) {
                return "set";
            }
            return "array";
        }
        if (ModelUtils.isUUIDSchema(schema)) {
            return "UUID";
        }
        if (ModelUtils.isURISchema(schema)) {
            return "URI";
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (this.typeMapping.containsKey(schema.getFormat())) {
                return schema.getFormat();
            }
            return "string";
        }
        if (this.isFreeFormObject(schema)) {
            return "object";
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            return "object";
        }
        if (this.isAnyTypeSchema(schema)) {
            return "AnyType";
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)schema.getType())) {
            if (!this.importMapping.containsKey(schema.getType())) {
                this.LOGGER.warn("Unknown type found in the schema: {}", (Object)schema.getType());
            }
            return schema.getType();
        }
        return "object";
    }

    public String lowerCamelCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (schema == null) {
            this.LOGGER.warn("Null schema found. Default type to `NULL_SCHEMA_ERR`");
            return "NULL_SCHEMA_ERR";
        }
        String oasType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(oasType)) {
            return this.typeMapping.get(oasType);
        }
        return oasType;
    }

    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toSetter(String name) {
        return "set" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(this.apiNamePrefix + "_" + name + "_" + this.apiNameSuffix);
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.modelNamePrefix + "_" + name + "_" + this.modelNameSuffix);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        if (this.typeAliases == null) {
            this.typeAliases = this.getAllAliases(allDefinitions);
        }
        if ((schema = this.unaliasSchema(schema, this.importMapping)) == null) {
            this.LOGGER.warn("Schema {} not found", (Object)name);
            return null;
        }
        CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        ModelUtils.syncValidationProperties(schema, m);
        m.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        m.title = this.escapeText(schema.getTitle());
        m.description = this.escapeText(schema.getDescription());
        m.unescapedDescription = schema.getDescription();
        m.classname = this.toModelName(name);
        m.classVarName = this.toVarName(name);
        m.classFilename = this.toModelFilename(name);
        m.modelJson = Json.pretty((Object)schema);
        m.externalDocumentation = schema.getExternalDocs();
        if (schema.getExtensions() != null && !schema.getExtensions().isEmpty()) {
            m.getVendorExtensions().putAll(schema.getExtensions());
        }
        m.isAlias = this.typeAliases.containsKey(name) || DefaultCodegen.isAliasOfSimpleTypes(schema) != false;
        m.discriminator = this.createDiscriminator(name, schema, this.openAPI);
        if (!this.getLegacyDiscriminatorBehavior().booleanValue()) {
            m.addDiscriminatorMappedModelsImports();
        }
        if (schema.getDeprecated() != null) {
            m.isDeprecated = schema.getDeprecated();
        }
        if (schema.getXml() != null) {
            m.xmlPrefix = schema.getXml().getPrefix();
            m.xmlNamespace = schema.getXml().getNamespace();
            m.xmlName = schema.getXml().getName();
        }
        if (this.isAnyTypeSchema(schema)) {
            if (Boolean.FALSE.equals(schema.getNullable())) {
                this.LOGGER.error("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)name);
            }
            m.isNullable = true;
        }
        if (ModelUtils.isArraySchema(schema)) {
            m.isArray = true;
            CodegenProperty arrayProperty = this.fromProperty(name, schema);
            m.setItems(arrayProperty.items);
            m.arrayModelType = arrayProperty.complexType;
            this.addParentContainer(m, name, schema);
        } else if (ModelUtils.isNullType(schema)) {
            m.isNull = true;
        } else if (schema instanceof ComposedSchema) {
            List<Schema> interfaces;
            Schema parent;
            ComposedSchema composed = (ComposedSchema)schema;
            LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
            ArrayList<String> required = new ArrayList<String>();
            LinkedHashMap<String, Schema> linkedHashMap = new LinkedHashMap<String, Schema>();
            ArrayList<String> allRequired = new ArrayList<String>();
            if (composed.getProperties() != null && !composed.getProperties().isEmpty()) {
                if (composed.getOneOf() != null && !composed.getOneOf().isEmpty()) {
                    this.LOGGER.warn("'oneOf' is intended to include only the additional optional OAS extension discriminator object. For more details, see https://json-schema.org/draft/2019-09/json-schema-core.html#rfc.section.9.2.1.3 and the OAS section on 'Composition and Inheritance'.");
                }
                this.addVars(m, this.unaliasPropertySchema(composed.getProperties()), composed.getRequired(), null, null);
            }
            String parentName = ModelUtils.getParentName(composed, allDefinitions);
            List<String> allParents = ModelUtils.getAllParentsName(composed, allDefinitions, false);
            Schema schema2 = parent = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parentName) || allDefinitions == null ? null : allDefinitions.get(parentName);
            if (this.supportsInheritance || this.supportsMixins) {
                m.allVars = new ArrayList<CodegenProperty>();
                if (composed.getAllOf() != null) {
                    int modelImplCnt = 0;
                    int modelDiscriminators = 0;
                    for (Schema innerSchema : composed.getAllOf()) {
                        if (m.discriminator == null && innerSchema.getDiscriminator() != null) {
                            this.LOGGER.debug("discriminator is set to null (not correctly set earlier): {}", (Object)name);
                            m.discriminator = this.createDiscriminator(name, innerSchema, this.openAPI);
                            if (!this.getLegacyDiscriminatorBehavior().booleanValue()) {
                                m.addDiscriminatorMappedModelsImports();
                            }
                            ++modelDiscriminators;
                        }
                        if (innerSchema.getXml() != null) {
                            m.xmlPrefix = innerSchema.getXml().getPrefix();
                            m.xmlNamespace = innerSchema.getXml().getNamespace();
                            m.xmlName = innerSchema.getXml().getName();
                        }
                        if (modelDiscriminators > 1) {
                            this.LOGGER.error("Allof composed schema is inheriting >1 discriminator. Only use one discriminator: {}", (Object)composed);
                        }
                        if (modelImplCnt++ <= 1) continue;
                        this.LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                        break;
                    }
                }
            }
            if (!(interfaces = ModelUtils.getInterfaces(composed)).isEmpty()) {
                if (m.interfaces == null) {
                    m.interfaces = new ArrayList<String>();
                }
                for (Schema interfaceSchema : interfaces) {
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(interfaceSchema = this.unaliasSchema(interfaceSchema, this.importMapping)).get$ref())) {
                        String languageType = this.getTypeDeclaration(interfaceSchema);
                        if (composed.getAnyOf() != null) {
                            if (m.anyOf.contains(languageType)) {
                                this.LOGGER.warn("{} (anyOf schema) already has `{}` defined and therefore it's skipped.", (Object)m.name, (Object)languageType);
                                continue;
                            }
                            m.anyOf.add(languageType);
                            continue;
                        }
                        if (composed.getOneOf() != null) {
                            if (m.oneOf.contains(languageType)) {
                                this.LOGGER.warn("{} (oneOf schema) already has `{}` defined and therefore it's skipped.", (Object)m.name, (Object)languageType);
                                continue;
                            }
                            m.oneOf.add(languageType);
                            continue;
                        }
                        if (composed.getAllOf() != null) continue;
                        this.LOGGER.error("Composed schema has incorrect anyOf, allOf, oneOf defined: {}", (Object)composed);
                        continue;
                    }
                    Schema refSchema = null;
                    String ref = ModelUtils.getSimpleRef(interfaceSchema.get$ref());
                    if (allDefinitions != null) {
                        refSchema = allDefinitions.get(ref);
                    }
                    String modelName = this.toModelName(ref);
                    m.interfaces.add(modelName);
                    this.addImport(m, modelName);
                    if (allDefinitions != null && refSchema != null) {
                        if (allParents.contains(ref) && this.supportsMultipleInheritance) {
                            this.addProperties(linkedHashMap, allRequired, refSchema);
                        } else if (parentName != null && parentName.equals(ref) && this.supportsInheritance) {
                            this.addProperties(linkedHashMap, allRequired, refSchema);
                        } else {
                            this.addProperties(properties, required, refSchema);
                            this.addProperties(linkedHashMap, allRequired, refSchema);
                        }
                    }
                    if (composed.getAnyOf() != null) {
                        m.anyOf.add(modelName);
                        continue;
                    }
                    if (composed.getOneOf() != null) {
                        m.oneOf.add(modelName);
                        continue;
                    }
                    if (composed.getAllOf() != null) {
                        m.allOf.add(modelName);
                        continue;
                    }
                    this.LOGGER.error("Composed schema has incorrect anyOf, allOf, oneOf defined: {}", (Object)composed);
                }
            }
            if (parent != null && composed.getAllOf() != null) {
                m.parentSchema = parentName;
                m.parent = this.toModelName(parentName);
                if (this.supportsMultipleInheritance) {
                    m.allParents = new ArrayList<String>();
                    for (String pname : allParents) {
                        String pModelName = this.toModelName(pname);
                        m.allParents.add(pModelName);
                        this.addImport(m, pModelName);
                    }
                } else {
                    this.addImport(m, m.parent);
                }
            }
            for (Schema component : interfaces) {
                if (component.get$ref() != null) continue;
                if (component == null) break;
                this.addProperties(properties, required, component);
                this.addProperties(linkedHashMap, allRequired, component);
                break;
            }
            if (composed.getRequired() != null) {
                required.addAll(composed.getRequired());
                allRequired.addAll(composed.getRequired());
            }
            this.addVars(m, this.unaliasPropertySchema(properties), required, this.unaliasPropertySchema(linkedHashMap), allRequired);
            if (this.supportsAdditionalPropertiesWithComposedSchema) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
            }
            if (Boolean.TRUE.equals(schema.getNullable())) {
                m.isNullable = Boolean.TRUE;
            }
        } else {
            m.dataType = this.getSchemaType(schema);
            if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
                m.isEnum = true;
                m.allowableValues = new HashMap<String, Object>();
                m.allowableValues.put("values", schema.getEnum());
            }
            if (ModelUtils.isMapSchema(schema)) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
                m.isMap = true;
            } else if (ModelUtils.isIntegerSchema(schema)) {
                m.isNumeric = Boolean.TRUE;
                if (ModelUtils.isLongSchema(schema)) {
                    m.isLong = Boolean.TRUE;
                } else {
                    m.isInteger = Boolean.TRUE;
                }
            } else if (ModelUtils.isDateTimeSchema(schema)) {
                m.isDateTime = Boolean.TRUE;
            } else if (ModelUtils.isDateSchema(schema)) {
                m.isDate = Boolean.TRUE;
            } else if (ModelUtils.isStringSchema(schema)) {
                m.isString = Boolean.TRUE;
            } else if (ModelUtils.isNumberSchema(schema)) {
                m.isNumeric = Boolean.TRUE;
                if (ModelUtils.isFloatSchema(schema)) {
                    m.isFloat = Boolean.TRUE;
                } else if (ModelUtils.isDoubleSchema(schema)) {
                    m.isDouble = Boolean.TRUE;
                } else {
                    m.isNumber = Boolean.TRUE;
                }
            } else if (ModelUtils.isFreeFormObject(this.openAPI, schema)) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
            }
            if (Boolean.TRUE.equals(schema.getNullable())) {
                m.isNullable = Boolean.TRUE;
            }
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        m.removeAllDuplicatedProperty();
        if (m.discriminator != null) {
            String discPropName = m.discriminator.getPropertyBaseName();
            ArrayList<List<CodegenProperty>> listOLists = new ArrayList<List<CodegenProperty>>();
            listOLists.add(m.requiredVars);
            listOLists.add(m.vars);
            listOLists.add(m.allVars);
            for (List list : listOLists) {
                for (CodegenProperty requiredVar : list) {
                    if (!discPropName.equals(requiredVar.baseName)) continue;
                    requiredVar.isDiscriminator = true;
                }
            }
        }
        if (m.requiredVars != null && m.requiredVars.size() > 0) {
            m.setHasRequired(true);
        }
        if (this.sortModelPropertiesByRequiredFlag.booleanValue()) {
            Comparator<CodegenProperty> comparator = new Comparator<CodegenProperty>(){

                @Override
                public int compare(CodegenProperty one, CodegenProperty another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(m.vars, comparator);
            Collections.sort(m.allVars, comparator);
        }
        this.setAddProps(schema, m);
        if (m.vars != null) {
            for (CodegenProperty prop : m.vars) {
                this.postProcessModelProperty(m, prop);
            }
            boolean bl = m.hasVars = m.vars.size() > 0;
        }
        if (m.allVars != null) {
            for (CodegenProperty prop : m.allVars) {
                this.postProcessModelProperty(m, prop);
            }
        }
        return m;
    }

    private void setAddProps(Schema schema, IJsonSchemaValidationProperties property) {
        if (schema.equals((Object)new Schema())) {
            return;
        }
        boolean additionalPropertiesIsAnyType = false;
        CodegenModel m = null;
        if (property instanceof CodegenModel) {
            m = (CodegenModel)property;
        }
        CodegenProperty addPropProp = null;
        boolean isAdditionalPropertiesTrue = false;
        if (schema.getAdditionalProperties() == null) {
            if (!this.disallowAdditionalPropertiesIfNotPresent) {
                isAdditionalPropertiesTrue = true;
                addPropProp = this.fromProperty("", new Schema());
                additionalPropertiesIsAnyType = true;
            }
        } else if (schema.getAdditionalProperties() instanceof Boolean) {
            if (Boolean.TRUE.equals(schema.getAdditionalProperties())) {
                isAdditionalPropertiesTrue = true;
                addPropProp = this.fromProperty("", new Schema());
                additionalPropertiesIsAnyType = true;
            }
        } else {
            addPropProp = this.fromProperty("", (Schema)schema.getAdditionalProperties());
            if (this.isAnyTypeSchema((Schema)schema.getAdditionalProperties())) {
                additionalPropertiesIsAnyType = true;
            }
        }
        if (additionalPropertiesIsAnyType) {
            property.setAdditionalPropertiesIsAnyType(true);
        }
        if (m != null && isAdditionalPropertiesTrue) {
            m.isAdditionalPropertiesTrue = true;
        }
        if (ModelUtils.isComposedSchema(schema) && !this.supportsAdditionalPropertiesWithComposedSchema) {
            return;
        }
        if (addPropProp != null) {
            property.setAdditionalProperties(addPropProp);
        }
    }

    private CodegenProperty discriminatorFound(String composedSchemaName, Schema sc, String discPropName, OpenAPI openAPI) {
        Schema refSchema = ModelUtils.getReferencedSchema(openAPI, sc);
        if (refSchema.getProperties() != null && refSchema.getProperties().get(discPropName) != null) {
            Schema discSchema = (Schema)refSchema.getProperties().get(discPropName);
            CodegenProperty cp = new CodegenProperty();
            if (ModelUtils.isStringSchema(discSchema)) {
                cp.isString = true;
            }
            cp.setRequired(false);
            if (refSchema.getRequired() != null && refSchema.getRequired().contains(discPropName)) {
                cp.setRequired(true);
            }
            return cp;
        }
        if (ModelUtils.isComposedSchema(refSchema)) {
            Object cp;
            ComposedSchema composedSchema = (ComposedSchema)refSchema;
            if (composedSchema.getAllOf() != null) {
                for (Schema allOf : composedSchema.getAllOf()) {
                    CodegenProperty cp2 = this.discriminatorFound(composedSchemaName, allOf, discPropName, openAPI);
                    if (cp2 == null) continue;
                    return cp2;
                }
            }
            if (composedSchema.getOneOf() != null && composedSchema.getOneOf().size() != 0) {
                cp = new CodegenProperty();
                for (Schema oneOf : composedSchema.getOneOf()) {
                    String modelName = ModelUtils.getSimpleRef(oneOf.get$ref());
                    CodegenProperty thisCp = this.discriminatorFound(composedSchemaName, oneOf, discPropName, openAPI);
                    if (thisCp == null) {
                        this.LOGGER.warn("'" + composedSchemaName + "' defines discriminator '" + discPropName + "', but the referenced OneOf schema '" + modelName + "' is missing " + discPropName);
                    }
                    if (((CodegenProperty)cp).dataType == null) {
                        cp = thisCp;
                        continue;
                    }
                    if (cp == thisCp) continue;
                    this.LOGGER.warn("'" + composedSchemaName + "' defines discriminator '" + discPropName + "', but the OneOf schema '" + modelName + "' has a different " + discPropName + " definition than the prior OneOf schema's. Make sure the " + discPropName + " type and required values are the same");
                }
                return cp;
            }
            if (composedSchema.getAnyOf() != null && composedSchema.getAnyOf().size() != 0) {
                cp = new CodegenProperty();
                for (Schema anyOf : composedSchema.getAnyOf()) {
                    String modelName = ModelUtils.getSimpleRef(anyOf.get$ref());
                    CodegenProperty thisCp = this.discriminatorFound(composedSchemaName, anyOf, discPropName, openAPI);
                    if (thisCp == null) {
                        this.LOGGER.warn("'" + composedSchemaName + "' defines discriminator '" + discPropName + "', but the referenced AnyOf schema '" + modelName + "' is missing " + discPropName);
                    }
                    if (((CodegenProperty)cp).dataType == null) {
                        cp = thisCp;
                        continue;
                    }
                    if (cp == thisCp) continue;
                    this.LOGGER.warn("'" + composedSchemaName + "' defines discriminator '" + discPropName + "', but the AnyOf schema '" + modelName + "' has a different " + discPropName + " definition than the prior AnyOf schema's. Make sure the " + discPropName + " type and required values are the same");
                }
                return cp;
            }
        }
        return null;
    }

    private Discriminator recursiveGetDiscriminator(Schema sc, OpenAPI openAPI) {
        Schema refSchema = ModelUtils.getReferencedSchema(openAPI, sc);
        Discriminator foundDisc = refSchema.getDiscriminator();
        if (foundDisc != null) {
            return foundDisc;
        }
        if (this.getLegacyDiscriminatorBehavior().booleanValue()) {
            return null;
        }
        Discriminator disc = new Discriminator();
        if (ModelUtils.isComposedSchema(refSchema)) {
            Integer n;
            Integer n2;
            HashSet<String> discriminatorsPropNames;
            Integer hasNullTypeCnt;
            Integer hasDiscriminatorCnt;
            ComposedSchema composedSchema = (ComposedSchema)refSchema;
            if (composedSchema.getAllOf() != null) {
                for (Schema allOf : composedSchema.getAllOf()) {
                    foundDisc = this.recursiveGetDiscriminator(allOf, openAPI);
                    if (foundDisc == null) continue;
                    disc.setPropertyName(foundDisc.getPropertyName());
                    disc.setMapping(foundDisc.getMapping());
                    return disc;
                }
            }
            if (composedSchema.getOneOf() != null && composedSchema.getOneOf().size() != 0) {
                hasDiscriminatorCnt = 0;
                hasNullTypeCnt = 0;
                discriminatorsPropNames = new HashSet<String>();
                for (Schema oneOf : composedSchema.getOneOf()) {
                    if (ModelUtils.isNullType(oneOf)) {
                        n2 = hasNullTypeCnt;
                        n = hasNullTypeCnt = Integer.valueOf(hasNullTypeCnt + 1);
                        continue;
                    }
                    foundDisc = this.recursiveGetDiscriminator(oneOf, openAPI);
                    if (foundDisc == null) continue;
                    discriminatorsPropNames.add(foundDisc.getPropertyName());
                    n2 = hasDiscriminatorCnt;
                    n = hasDiscriminatorCnt = Integer.valueOf(hasDiscriminatorCnt + 1);
                }
                if (discriminatorsPropNames.size() > 1) {
                    this.LOGGER.warn("The oneOf schemas have conflicting discriminator property names. oneOf schemas must have the same property name, but found " + String.join((CharSequence)", ", discriminatorsPropNames));
                }
                if (foundDisc != null && hasDiscriminatorCnt + hasNullTypeCnt == composedSchema.getOneOf().size() && discriminatorsPropNames.size() == 1) {
                    disc.setPropertyName(foundDisc.getPropertyName());
                    disc.setMapping(foundDisc.getMapping());
                    return disc;
                }
            }
            if (composedSchema.getAnyOf() != null && composedSchema.getAnyOf().size() != 0) {
                hasDiscriminatorCnt = 0;
                hasNullTypeCnt = 0;
                discriminatorsPropNames = new HashSet();
                for (Schema anyOf : composedSchema.getAnyOf()) {
                    if (ModelUtils.isNullType(anyOf)) {
                        n2 = hasNullTypeCnt;
                        n = hasNullTypeCnt = Integer.valueOf(hasNullTypeCnt + 1);
                        continue;
                    }
                    foundDisc = this.recursiveGetDiscriminator(anyOf, openAPI);
                    if (foundDisc == null) continue;
                    discriminatorsPropNames.add(foundDisc.getPropertyName());
                    n2 = hasDiscriminatorCnt;
                    n = hasDiscriminatorCnt = Integer.valueOf(hasDiscriminatorCnt + 1);
                }
                if (discriminatorsPropNames.size() > 1) {
                    this.LOGGER.warn("The anyOf schemas have conflicting discriminator property names. anyOf schemas must have the same property name, but found " + String.join((CharSequence)", ", discriminatorsPropNames));
                }
                if (foundDisc != null && hasDiscriminatorCnt + hasNullTypeCnt == composedSchema.getAnyOf().size() && discriminatorsPropNames.size() == 1) {
                    disc.setPropertyName(foundDisc.getPropertyName());
                    disc.setMapping(foundDisc.getMapping());
                    return disc;
                }
            }
        }
        return null;
    }

    protected List<CodegenDiscriminator.MappedModel> getOneOfAnyOfDescendants(String composedSchemaName, String discPropName, ComposedSchema c, OpenAPI openAPI) {
        ArrayList<List> listOLists = new ArrayList<List>();
        listOLists.add(c.getOneOf());
        listOLists.add(c.getAnyOf());
        ArrayList<CodegenDiscriminator.MappedModel> descendentSchemas = new ArrayList<CodegenDiscriminator.MappedModel>();
        for (List schemaList : listOLists) {
            if (schemaList == null) continue;
            for (Schema sc : schemaList) {
                if (ModelUtils.isNullType(sc)) continue;
                String ref = sc.get$ref();
                if (ref == null) {
                    this.LOGGER.warn("Invalid inline schema defined in oneOf/anyOf in '" + composedSchemaName + "'. Per the OpenApi spec, for this case when a composed schema defines a discriminator, the oneOf/anyOf schemas must use $ref. Change this inline definition to a $ref definition");
                }
                CodegenProperty df = this.discriminatorFound(composedSchemaName, sc, discPropName, openAPI);
                String modelName = ModelUtils.getSimpleRef(ref);
                if (df == null || !df.isString || !df.required) {
                    String msgSuffix = "";
                    if (df == null) {
                        msgSuffix = msgSuffix + discPropName + " is missing from the schema, define it as required and type string";
                    } else {
                        if (!df.isString) {
                            msgSuffix = msgSuffix + "invalid type for " + discPropName + ", set it to string";
                        }
                        if (!df.required) {
                            String spacer = "";
                            if (msgSuffix.length() != 0) {
                                spacer = ". ";
                            }
                            msgSuffix = msgSuffix + spacer + "invalid optional definition of " + discPropName + ", include it in required";
                        }
                    }
                    this.LOGGER.warn("'" + composedSchemaName + "' defines discriminator '" + discPropName + "', but the referenced schema '" + modelName + "' is incorrect. " + msgSuffix);
                }
                CodegenDiscriminator.MappedModel mm = new CodegenDiscriminator.MappedModel(modelName, this.toModelName(modelName));
                descendentSchemas.add(mm);
                Schema cs = ModelUtils.getSchema(openAPI, modelName);
                Map vendorExtensions = cs.getExtensions();
                if (vendorExtensions == null || vendorExtensions.isEmpty() || !vendorExtensions.containsKey("x-discriminator-value")) continue;
                String xDiscriminatorValue = (String)vendorExtensions.get("x-discriminator-value");
                mm = new CodegenDiscriminator.MappedModel(xDiscriminatorValue, this.toModelName(modelName));
                descendentSchemas.add(mm);
            }
        }
        return descendentSchemas;
    }

    protected List<CodegenDiscriminator.MappedModel> getAllOfDescendants(String thisSchemaName, OpenAPI openAPI) {
        ArrayList<String> queue = new ArrayList<String>();
        ArrayList<CodegenDiscriminator.MappedModel> descendentSchemas = new ArrayList<CodegenDiscriminator.MappedModel>();
        Map<String, Schema> schemas = ModelUtils.getSchemas(openAPI);
        String currentSchemaName = thisSchemaName;
        Set<String> keys = schemas.keySet();
        int count = 0;
        while (100000 > count++) {
            block1: for (String childName : keys) {
                ComposedSchema composedChild;
                List parents;
                Schema child;
                if (childName.equals(thisSchemaName) || !ModelUtils.isComposedSchema(child = schemas.get(childName)) || (parents = (composedChild = (ComposedSchema)child).getAllOf()) == null) continue;
                for (Schema parent : parents) {
                    String parentName;
                    String ref = parent.get$ref();
                    if (ref == null || (parentName = ModelUtils.getSimpleRef(ref)) == null || !parentName.equals(currentSchemaName)) continue;
                    if (queue.contains(childName) || descendentSchemas.stream().anyMatch(i -> childName.equals(i.getMappingName()))) {
                        throw new RuntimeException("Stack overflow hit when looking for " + thisSchemaName + " an infinite loop starting and ending at " + childName + " was seen");
                    }
                    queue.add(childName);
                    continue block1;
                }
            }
            if (queue.size() == 0) break;
            currentSchemaName = (String)queue.remove(0);
            CodegenDiscriminator.MappedModel mm = new CodegenDiscriminator.MappedModel(currentSchemaName, this.toModelName(currentSchemaName));
            descendentSchemas.add(mm);
            Schema cs = schemas.get(currentSchemaName);
            Map vendorExtensions = cs.getExtensions();
            if (vendorExtensions == null || vendorExtensions.isEmpty() || !vendorExtensions.containsKey("x-discriminator-value")) continue;
            String xDiscriminatorValue = (String)vendorExtensions.get("x-discriminator-value");
            mm = new CodegenDiscriminator.MappedModel(xDiscriminatorValue, this.toModelName(currentSchemaName));
            descendentSchemas.add(mm);
        }
        return descendentSchemas;
    }

    protected CodegenDiscriminator createDiscriminator(String schemaName, Schema schema, OpenAPI openAPI) {
        List<CodegenDiscriminator.MappedModel> otherDescendants;
        boolean legacyUseCase;
        Discriminator sourceDiscriminator = this.recursiveGetDiscriminator(schema, openAPI);
        if (sourceDiscriminator == null) {
            return null;
        }
        CodegenDiscriminator discriminator = new CodegenDiscriminator();
        String discPropName = sourceDiscriminator.getPropertyName();
        discriminator.setPropertyName(this.toVarName(discPropName));
        discriminator.setPropertyBaseName(sourceDiscriminator.getPropertyName());
        discriminator.setPropertyGetter(this.toGetter(discriminator.getPropertyName()));
        discriminator.setPropertyType(this.typeMapping.get("string"));
        discriminator.setMapping(sourceDiscriminator.getMapping());
        ArrayList<CodegenDiscriminator.MappedModel> uniqueDescendants = new ArrayList<CodegenDiscriminator.MappedModel>();
        if (sourceDiscriminator.getMapping() != null && !sourceDiscriminator.getMapping().isEmpty()) {
            for (Map.Entry e : sourceDiscriminator.getMapping().entrySet()) {
                String nameOrRef = (String)e.getValue();
                String name = nameOrRef.indexOf(47) >= 0 ? ModelUtils.getSimpleRef(nameOrRef) : nameOrRef;
                String modelName = this.toModelName(name);
                uniqueDescendants.add(new CodegenDiscriminator.MappedModel((String)e.getKey(), modelName));
            }
        }
        boolean bl = legacyUseCase = this.getLegacyDiscriminatorBehavior() != false && uniqueDescendants.isEmpty();
        if (!this.getLegacyDiscriminatorBehavior().booleanValue() || legacyUseCase) {
            otherDescendants = this.getAllOfDescendants(schemaName, openAPI);
            for (CodegenDiscriminator.MappedModel otherDescendant : otherDescendants) {
                boolean matched = false;
                for (CodegenDiscriminator.MappedModel uniqueDescendant : uniqueDescendants) {
                    if (!uniqueDescendant.getMappingName().equals(otherDescendant.getMappingName())) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                uniqueDescendants.add(otherDescendant);
            }
        }
        if (ModelUtils.isComposedSchema(schema) && !this.getLegacyDiscriminatorBehavior().booleanValue()) {
            otherDescendants = this.getOneOfAnyOfDescendants(schemaName, discPropName, (ComposedSchema)schema, openAPI);
            for (CodegenDiscriminator.MappedModel otherDescendant : otherDescendants) {
                if (uniqueDescendants.contains(otherDescendant)) continue;
                uniqueDescendants.add(otherDescendant);
            }
        }
        if (!this.getLegacyDiscriminatorBehavior().booleanValue()) {
            Collections.sort(uniqueDescendants);
        }
        discriminator.getMappedModels().addAll(uniqueDescendants);
        return discriminator;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        this.addParentContainer(codegenModel, codegenModel.name, schema);
    }

    protected void addProperties(Map<String, Schema> properties, List<String> required, Schema schema) {
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            if (composedSchema.getAllOf() != null) {
                for (Schema component : composedSchema.getAllOf()) {
                    this.addProperties(properties, required, component);
                }
            }
            if (schema.getRequired() != null) {
                required.addAll(schema.getRequired());
            }
            if (composedSchema.getOneOf() != null) {
                for (Schema component : composedSchema.getOneOf()) {
                    this.addProperties(properties, required, component);
                }
            }
            if (composedSchema.getAnyOf() != null) {
                for (Schema component : composedSchema.getAnyOf()) {
                    this.addProperties(properties, required, component);
                }
            }
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            Schema interfaceSchema = ModelUtils.getReferencedSchema(this.openAPI, schema);
            this.addProperties(properties, required, interfaceSchema);
            return;
        }
        if (schema.getProperties() != null) {
            properties.putAll(schema.getProperties());
        }
        if (schema.getRequired() != null) {
            required.addAll(schema.getRequired());
        }
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return StringUtils.camelize(this.toVarName(name));
    }

    public CodegenProperty fromProperty(String name, Schema p) {
        Schema referencedSchema;
        String ref;
        if (p == null) {
            this.LOGGER.error("Undefined property/schema for `{}`. Default to type:string.", (Object)name);
            return null;
        }
        this.LOGGER.debug("debugging fromProperty for {} : {}", (Object)name, (Object)p);
        NamedSchema ns = new NamedSchema(name, p);
        CodegenProperty cpc = this.schemaCodegenPropertyCache.get(ns);
        if (cpc != null) {
            this.LOGGER.debug("Cached fromProperty for {} : {}", (Object)name, (Object)p.getName());
            return cpc;
        }
        p = this.unaliasSchema(p, this.importMapping);
        CodegenProperty property = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        ModelUtils.syncValidationProperties(p, property);
        property.name = this.toVarName(name);
        property.baseName = name;
        property.openApiType = p.getType() == null ? this.getSchemaType(p) : p.getType();
        property.nameInCamelCase = StringUtils.camelize(property.name, false);
        property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInCamelCase);
        property.description = this.escapeText(p.getDescription());
        property.unescapedDescription = p.getDescription();
        property.title = p.getTitle();
        property.getter = this.toGetter(name);
        property.setter = this.toSetter(name);
        try {
            property.example = this.toExampleValue(p);
        }
        catch (Exception e) {
            this.LOGGER.error("Error in generating `example` for the property {}. Default to ERROR_TO_EXAMPLE_VALUE. Enable debugging for more info.", (Object)property.baseName);
            this.LOGGER.debug("Exception from toExampleValue: {}", (Throwable)e);
            property.example = "ERROR_TO_EXAMPLE_VALUE";
        }
        property.defaultValue = this.toDefaultValue(p);
        property.defaultValueWithParam = this.toDefaultValueWithParam(name, p);
        property.jsonSchema = Json.pretty((Object)p);
        if (p.getDeprecated() != null) {
            property.deprecated = p.getDeprecated();
        } else if (p.get$ref() != null && (ref = ModelUtils.getSimpleRef(p.get$ref())) != null && (referencedSchema = ModelUtils.getSchemas(this.openAPI).get(ref)) != null && referencedSchema.getDeprecated() != null) {
            property.deprecated = referencedSchema.getDeprecated();
        }
        if (p.getReadOnly() != null) {
            property.isReadOnly = p.getReadOnly();
        }
        if (p.getWriteOnly() != null) {
            property.isWriteOnly = p.getWriteOnly();
        }
        if (p.getNullable() != null) {
            property.isNullable = p.getNullable();
        }
        if (p.getXml() != null) {
            if (p.getXml().getAttribute() != null) {
                property.isXmlAttribute = p.getXml().getAttribute();
            }
            property.xmlPrefix = p.getXml().getPrefix();
            property.xmlName = p.getXml().getName();
            property.xmlNamespace = p.getXml().getNamespace();
        }
        if (p.getExtensions() != null && !p.getExtensions().isEmpty()) {
            property.getVendorExtensions().putAll(p.getExtensions());
        }
        String type = this.getSchemaType(p);
        if (ModelUtils.isIntegerSchema(p)) {
            property.isNumeric = Boolean.TRUE;
            if (ModelUtils.isLongSchema(p)) {
                property.isLong = Boolean.TRUE;
            } else {
                property.isInteger = Boolean.TRUE;
            }
        } else if (ModelUtils.isBooleanSchema(p)) {
            property.isBoolean = true;
            property.getter = this.toBooleanGetter(name);
        } else if (ModelUtils.isDateSchema(p)) {
            property.isString = false;
            property.isDate = true;
        } else if (ModelUtils.isDateTimeSchema(p)) {
            property.isString = false;
            property.isDateTime = true;
        } else if (ModelUtils.isDecimalSchema(p)) {
            property.isDecimal = true;
        } else if (ModelUtils.isStringSchema(p)) {
            if (ModelUtils.isByteArraySchema(p)) {
                property.isByteArray = true;
            } else if (ModelUtils.isBinarySchema(p)) {
                property.isBinary = true;
                property.isFile = true;
            } else if (ModelUtils.isFileSchema(p)) {
                property.isFile = true;
            } else if (ModelUtils.isUUIDSchema(p)) {
                property.isString = true;
                property.isUuid = true;
            } else if (ModelUtils.isURISchema(p)) {
                property.isString = true;
                property.isUri = true;
            } else if (ModelUtils.isEmailSchema(p)) {
                property.isString = true;
                property.isEmail = true;
            } else {
                property.isString = true;
            }
            property.pattern = this.toRegularExpression(p.getPattern());
        } else if (ModelUtils.isNumberSchema(p)) {
            property.isNumeric = Boolean.TRUE;
            if (ModelUtils.isFloatSchema(p)) {
                property.isFloat = Boolean.TRUE;
            } else if (ModelUtils.isDoubleSchema(p)) {
                property.isDouble = Boolean.TRUE;
            } else {
                property.isNumber = Boolean.TRUE;
            }
        } else if (this.isFreeFormObject(p)) {
            property.isFreeFormObject = true;
        } else if (this.isAnyTypeSchema(p)) {
            if (Boolean.FALSE.equals(p.getNullable())) {
                this.LOGGER.warn("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)p.getName());
            }
            property.isNullable = true;
            property.isAnyType = true;
        } else if (ModelUtils.isArraySchema(p)) {
            ArraySchema arraySchema = (ArraySchema)p;
            Schema schema = this.unaliasSchema(this.getSchemaItems(arraySchema), this.importMapping);
        } else if (ModelUtils.isMapSchema(p)) {
            Schema innerSchema = this.unaliasSchema(this.getAdditionalProperties(p), this.importMapping);
            if (innerSchema == null) {
                this.LOGGER.error("Undefined map inner type for `{}`. Default to String.", (Object)p.getName());
                innerSchema = new StringSchema().description("//TODO automatically added by openapi-generator due to undefined type");
                p.setAdditionalProperties((Object)innerSchema);
            }
        } else if (ModelUtils.isNullType(p)) {
            property.isNull = true;
        }
        if (p.getEnum() != null && !p.getEnum().isEmpty()) {
            List _enum = p.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(String.valueOf(i));
            }
            property.isEnum = true;
            HashMap<String, Object> allowableValues = new HashMap<String, Object>();
            allowableValues.put("values", _enum);
            if (allowableValues.size() > 0) {
                property.allowableValues = allowableValues;
            }
        }
        if ((referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, p)).getEnum() != null && !referencedSchema.getEnum().isEmpty()) {
            List _enum = referencedSchema.getEnum();
            HashMap<String, Object> allowableValues = new HashMap<String, Object>();
            allowableValues.put("values", _enum);
            if (allowableValues.size() > 0) {
                property.allowableValues = allowableValues;
            }
        }
        if (referencedSchema.getNullable() != null) {
            property.isNullable = referencedSchema.getNullable();
        }
        property.dataType = this.getTypeDeclaration(p);
        property.dataFormat = p.getFormat();
        property.baseType = this.getSchemaType(p);
        if (property.isEnum) {
            property.datatypeWithEnum = this.toEnumName(property);
            property.enumName = this.toEnumName(property);
        } else {
            property.datatypeWithEnum = property.dataType;
        }
        if (ModelUtils.isArraySchema(p)) {
            property.isContainer = true;
            property.isArray = true;
            property.containerType = ModelUtils.isSet(p) ? "set" : "array";
            property.baseType = this.getSchemaType(p);
            if (p.getXml() != null) {
                property.isXmlWrapped = p.getXml().getWrapped() == null ? false : p.getXml().getWrapped();
                property.xmlPrefix = p.getXml().getPrefix();
                property.xmlNamespace = p.getXml().getNamespace();
                property.xmlName = p.getXml().getName();
            }
            String itemName = null;
            if (p.getExtensions() != null && p.getExtensions().get("x-item-name") != null) {
                itemName = p.getExtensions().get("x-item-name").toString();
            }
            if (itemName == null) {
                itemName = property.name;
            }
            ArraySchema arraySchema = (ArraySchema)p;
            Schema innerSchema = this.unaliasSchema(this.getSchemaItems(arraySchema), this.importMapping);
            CodegenProperty cp = this.fromProperty(itemName, innerSchema);
            this.updatePropertyForArray(property, cp);
        } else if (ModelUtils.isMapSchema(p)) {
            property.isContainer = true;
            property.isMap = true;
            property.containerType = "map";
            property.baseType = this.getSchemaType(p);
            property.minItems = p.getMinProperties();
            property.maxItems = p.getMaxProperties();
            Schema innerSchema = this.unaliasSchema(this.getAdditionalProperties(p), this.importMapping);
            if (innerSchema == null) {
                this.LOGGER.error("Undefined map inner type for `{}`. Default to String.", (Object)p.getName());
                innerSchema = new StringSchema().description("//TODO automatically added by openapi-generator due to undefined type");
                p.setAdditionalProperties((Object)innerSchema);
            }
            CodegenProperty cp = this.fromProperty("inner", innerSchema);
            this.updatePropertyForMap(property, cp);
        } else if (this.isFreeFormObject(p)) {
            property.isFreeFormObject = true;
            property.baseType = this.getSchemaType(p);
            if (this.languageSpecificPrimitives.contains(property.dataType)) {
                property.isPrimitiveType = true;
            }
        } else if (this.isAnyTypeSchema(p)) {
            property.isAnyType = true;
            property.baseType = this.getSchemaType(p);
            if (this.languageSpecificPrimitives.contains(property.dataType)) {
                property.isPrimitiveType = true;
            }
        } else {
            this.setNonArrayMapProperty(property, type);
            Schema refOrCurrent = ModelUtils.getReferencedSchema(this.openAPI, p);
            property.isModel = (ModelUtils.isComposedSchema(refOrCurrent) || ModelUtils.isObjectSchema(refOrCurrent)) && ModelUtils.isModel(refOrCurrent);
        }
        this.addVarsRequiredVarsAdditionalProps(p, property);
        this.LOGGER.debug("debugging from property return: {}", (Object)property);
        this.schemaCodegenPropertyCache.put(ns, property);
        return property;
    }

    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            if (this.LOGGER.isWarnEnabled()) {
                this.LOGGER.warn("skipping invalid array property {}", (Object)Json.pretty((Object)property));
            }
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected void updatePropertyForMap(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            if (this.LOGGER.isWarnEnabled()) {
                this.LOGGER.warn("skipping invalid map property {}", (Object)Json.pretty((Object)property));
            }
            return;
        }
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        property.dataFormat = innerProperty.dataFormat;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForMap(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected Boolean isPropertyInnerMostEnum(CodegenProperty property) {
        CodegenProperty currentProperty = this.getMostInnerItems(property);
        return currentProperty == null ? false : currentProperty.isEnum;
    }

    protected CodegenProperty getMostInnerItems(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        while (currentProperty != null && (Boolean.TRUE.equals(currentProperty.isMap) || Boolean.TRUE.equals(currentProperty.isArray))) {
            currentProperty = currentProperty.items;
        }
        return currentProperty;
    }

    protected Map<String, Object> getInnerEnumAllowableValues(CodegenProperty property) {
        CodegenProperty currentProperty = this.getMostInnerItems(property);
        return currentProperty == null ? new HashMap() : currentProperty.allowableValues;
    }

    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMap) || Boolean.TRUE.equals(baseItem.isArray))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType, this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMap) || Boolean.TRUE.equals(baseItem.isArray))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + baseItem.baseType, ", " + this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.isContainer = false;
        if (this.languageSpecificPrimitives().contains(type)) {
            property.isPrimitiveType = true;
        } else {
            property.complexType = property.baseType;
            property.isModel = true;
        }
    }

    protected ApiResponse findMethodResponse(ApiResponses responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return (ApiResponse)responses.get(code);
    }

    protected void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse) {
        this.handleMethodResponse(operation, schemas, op, methodResponse, Collections.emptyMap());
    }

    protected void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse, Map<String, String> importMappings) {
        Schema responseSchema = this.unaliasSchema(ModelUtils.getSchemaFromResponse(methodResponse), this.importMapping);
        if (responseSchema != null) {
            CodegenProperty cm = this.fromProperty("response", responseSchema);
            if (ModelUtils.isArraySchema(responseSchema)) {
                ArraySchema as = (ArraySchema)responseSchema;
                CodegenProperty innerProperty = this.fromProperty("response", this.getSchemaItems(as));
                op.returnBaseType = innerProperty.baseType;
            } else if (ModelUtils.isMapSchema(responseSchema)) {
                CodegenProperty innerProperty = this.fromProperty("response", this.getAdditionalProperties(responseSchema));
                op.returnBaseType = innerProperty.baseType;
            } else {
                op.returnBaseType = cm.complexType != null ? cm.complexType : cm.baseType;
            }
            if (!this.isSkipOperationExample()) {
                String exampleStatusCode = "200";
                for (String key : operation.getResponses().keySet()) {
                    if (operation.getResponses().get((Object)key) != methodResponse || key.equals("default")) continue;
                    exampleStatusCode = key;
                }
                op.examples = new ExampleGenerator(schemas, this.openAPI).generateFromResponseSchema(exampleStatusCode, responseSchema, DefaultCodegen.getProducesInfo(this.openAPI, operation));
            }
            op.defaultResponse = this.toDefaultValue(responseSchema);
            op.returnType = cm.dataType;
            op.returnFormat = cm.dataFormat;
            op.hasReference = schemas != null && schemas.containsKey(op.returnBaseType);
            Schema schema = null;
            if (schemas != null) {
                schema = schemas.get(op.returnBaseType);
            }
            if (schema != null) {
                CodegenModel cmod = this.fromModel(op.returnBaseType, schema);
                op.discriminator = cmod.discriminator;
            }
            if (cm.isContainer) {
                op.returnContainer = cm.containerType;
                if ("map".equals(cm.containerType)) {
                    op.isMap = true;
                } else if ("list".equalsIgnoreCase(cm.containerType)) {
                    op.isArray = true;
                } else if ("array".equalsIgnoreCase(cm.containerType)) {
                    op.isArray = true;
                } else if ("set".equalsIgnoreCase(cm.containerType)) {
                    op.isArray = true;
                }
            } else {
                op.returnSimpleType = true;
            }
            if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                op.returnTypeIsPrimitive = true;
            }
        }
        this.addHeaders(methodResponse, op.responseHeaders);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        int offset;
        this.LOGGER.debug("fromOperation => operation: {}", (Object)operation);
        if (operation == null) {
            throw new RuntimeException("operation cannot be null in fromOperation");
        }
        Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
        CodegenOperation op = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        if (operation.getExtensions() != null && !operation.getExtensions().isEmpty()) {
            op.vendorExtensions.putAll(operation.getExtensions());
            Object isCallbackRequest = op.vendorExtensions.remove("x-callback-request");
            op.isCallbackRequest = Boolean.TRUE.equals(isCallbackRequest);
        }
        if (operation.getServers() != null && !operation.getServers().isEmpty()) {
            op.servers = this.fromServers(operation.getServers());
        } else if (servers != null && !servers.isEmpty()) {
            op.servers = this.fromServers(servers);
        }
        op.operationIdOriginal = operation.getOperationId();
        String operationId = this.getOrGenerateOperationId(operation, path, httpMethod);
        if (this.removeOperationIdPrefix && (offset = operationId.indexOf(95)) > -1) {
            operationId = operationId.substring(offset + 1);
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        op.path = this.isStrictSpecBehavior() && !path.startsWith("/") ? "/" + path : path;
        op.operationId = this.toOperationId(operationId);
        op.summary = this.escapeText(operation.getSummary());
        op.unescapedNotes = operation.getDescription();
        op.notes = this.escapeText(operation.getDescription());
        op.hasConsumes = false;
        op.hasProduces = false;
        if (operation.getDeprecated() != null) {
            op.isDeprecated = operation.getDeprecated();
        }
        this.addConsumesInfo(operation, op);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            ApiResponse methodResponse = this.findMethodResponse(operation.getResponses());
            for (String key : operation.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)key);
                this.addProducesInfo(response, op);
                CodegenResponse r = this.fromResponse(key, response);
                if (r.baseType != null && !this.defaultIncludes.contains(r.baseType) && !this.languageSpecificPrimitives.contains(r.baseType)) {
                    imports.add(r.baseType);
                }
                if ("set".equals(r.containerType) && this.typeMapping.containsKey(r.containerType)) {
                    op.uniqueItems = true;
                    imports.add(this.typeMapping.get(r.containerType));
                }
                op.responses.add(r);
                if (Boolean.TRUE.equals(r.isBinary) && Boolean.TRUE.equals(r.is2xx) && Boolean.FALSE.equals(op.isResponseBinary)) {
                    op.isResponseBinary = Boolean.TRUE;
                }
                if (!Boolean.TRUE.equals(r.isFile) || !Boolean.TRUE.equals(r.is2xx) || !Boolean.FALSE.equals(op.isResponseFile)) continue;
                op.isResponseFile = Boolean.TRUE;
            }
            op.responses.sort((a, b) -> {
                int aDefault = "0".equals(a.code) ? 1 : 0;
                int bDefault = "0".equals(b.code) ? 1 : 0;
                return aDefault - bDefault;
            });
            if (methodResponse != null) {
                this.handleMethodResponse(operation, schemas, op, methodResponse, this.importMapping);
            }
        }
        if (operation.getCallbacks() != null && !operation.getCallbacks().isEmpty()) {
            operation.getCallbacks().forEach((name, callback) -> {
                CodegenCallback c = this.fromCallback((String)name, (Callback)callback, servers);
                op.callbacks.add(c);
            });
        }
        List parameters = operation.getParameters();
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        List<Object> formParams = new ArrayList();
        ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> optionalParams = new ArrayList<CodegenParameter>();
        CodegenParameter bodyParam = null;
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody != null) {
            String contentType = this.getContentType(requestBody);
            if (contentType != null) {
                contentType = contentType.toLowerCase(Locale.ROOT);
            }
            if (contentType != null && (contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart"))) {
                formParams = this.fromRequestBodyToFormParameters(requestBody, imports);
                op.isMultipart = contentType.startsWith("multipart");
                for (CodegenParameter codegenParameter : formParams) {
                    this.setParameterContentType(codegenParameter, (MediaType)requestBody.getContent().get((Object)contentType));
                    this.postProcessParameter(codegenParameter);
                }
                if (this.prependFormOrBodyParameters.booleanValue()) {
                    for (CodegenParameter codegenParameter : formParams) {
                        allParams.add(codegenParameter.copy());
                    }
                }
            } else {
                void var22_28;
                requestBody = ModelUtils.getReferencedRequestBody(this.openAPI, requestBody);
                String string = "";
                if (op.vendorExtensions != null && op.vendorExtensions.containsKey("x-codegen-request-body-name")) {
                    String string2 = (String)op.vendorExtensions.get("x-codegen-request-body-name");
                }
                bodyParam = this.fromRequestBody(requestBody, imports, (String)var22_28);
                bodyParam.description = this.escapeText(requestBody.getDescription());
                this.postProcessParameter(bodyParam);
                bodyParams.add(bodyParam);
                if (this.prependFormOrBodyParameters.booleanValue()) {
                    allParams.add(bodyParam);
                }
                if (schemas != null) {
                    op.requestBodyExamples = new ExampleGenerator(schemas, this.openAPI).generate(null, new ArrayList<String>(DefaultCodegen.getConsumesInfo(this.openAPI, operation)), bodyParam.baseType);
                }
            }
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                Parameter parameter2 = ModelUtils.getReferencedParameter(this.openAPI, parameter);
                CodegenParameter codegenParameter = this.fromParameter(parameter2, imports);
                if (this.ensureUniqueParams.booleanValue()) {
                    while (!this.isParameterNameUnique(codegenParameter, allParams)) {
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter);
                if (parameter2 instanceof QueryParameter || "query".equalsIgnoreCase(parameter2.getIn())) {
                    queryParams.add(codegenParameter.copy());
                    continue;
                }
                if (parameter2 instanceof PathParameter || "path".equalsIgnoreCase(parameter2.getIn())) {
                    pathParams.add(codegenParameter.copy());
                    continue;
                }
                if (parameter2 instanceof HeaderParameter || "header".equalsIgnoreCase(parameter2.getIn())) {
                    headerParams.add(codegenParameter.copy());
                    continue;
                }
                if (parameter2 instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter2.getIn())) {
                    cookieParams.add(codegenParameter.copy());
                    continue;
                }
                this.LOGGER.warn("Unknown parameter type {} for {}", (Object)codegenParameter.baseType, (Object)codegenParameter.baseName);
            }
        }
        if (!this.prependFormOrBodyParameters.booleanValue()) {
            for (CodegenParameter codegenParameter : formParams) {
                if (this.ensureUniqueParams.booleanValue()) {
                    while (!this.isParameterNameUnique(codegenParameter, allParams)) {
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter.copy());
            }
            for (CodegenParameter codegenParameter : bodyParams) {
                if (this.ensureUniqueParams.booleanValue()) {
                    while (!this.isParameterNameUnique(codegenParameter, allParams)) {
                        codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
                    }
                }
                allParams.add(codegenParameter.copy());
            }
        }
        for (CodegenParameter codegenParameter : allParams) {
            if (codegenParameter.required) {
                requiredParams.add(codegenParameter.copy());
                continue;
            }
            optionalParams.add(codegenParameter.copy());
            op.hasOptionalParams = true;
        }
        for (String string : imports) {
            if (!this.needToImport(string)) continue;
            op.imports.add(string);
        }
        op.bodyParam = bodyParam;
        op.httpMethod = httpMethod.toUpperCase(Locale.ROOT);
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(allParams, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        op.allParams = allParams;
        op.bodyParams = bodyParams;
        op.pathParams = pathParams;
        op.queryParams = queryParams;
        op.headerParams = headerParams;
        op.cookieParams = cookieParams;
        op.formParams = formParams;
        op.requiredParams = requiredParams;
        op.optionalParams = optionalParams;
        op.externalDocs = operation.getExternalDocs();
        op.nickname = op.operationId;
        if (op.allParams.size() > 0) {
            op.hasParams = true;
        }
        op.hasRequiredParams = op.requiredParams.size() > 0;
        op.isRestfulShow = op.isRestfulShow();
        op.isRestfulIndex = op.isRestfulIndex();
        op.isRestfulCreate = op.isRestfulCreate();
        op.isRestfulUpdate = op.isRestfulUpdate();
        op.isRestfulDestroy = op.isRestfulDestroy();
        op.isRestful = op.isRestful();
        return op;
    }

    public boolean isParameterNameUnique(CodegenParameter p, List<CodegenParameter> parameters) {
        for (CodegenParameter parameter : parameters) {
            if (System.identityHashCode(p) == System.identityHashCode(parameter) || !p.paramName.equals(parameter.paramName)) continue;
            return false;
        }
        return true;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse r = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        if ("default".equals(responseCode) || "defaultResponse".equals(responseCode)) {
            r.code = "0";
            r.isDefault = true;
        } else {
            r.code = responseCode;
            switch (r.code.charAt(0)) {
                case '1': {
                    r.is1xx = true;
                    break;
                }
                case '2': {
                    r.is2xx = true;
                    break;
                }
                case '3': {
                    r.is3xx = true;
                    break;
                }
                case '4': {
                    r.is4xx = true;
                    break;
                }
                case '5': {
                    r.is5xx = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid response code " + responseCode);
                }
            }
        }
        Schema responseSchema = this.openAPI != null && this.openAPI.getComponents() != null ? this.unaliasSchema(ModelUtils.getSchemaFromResponse(response), this.importMapping) : ModelUtils.getSchemaFromResponse(response);
        r.schema = responseSchema;
        if (responseSchema != null) {
            ModelUtils.syncValidationProperties(responseSchema, r);
            if (responseSchema.getPattern() != null) {
                r.setPattern(this.toRegularExpression(responseSchema.getPattern()));
            }
        }
        r.message = this.escapeText(response.getDescription());
        r.jsonSchema = Json.pretty((Object)response);
        if (response.getExtensions() != null && !response.getExtensions().isEmpty()) {
            r.vendorExtensions.putAll(response.getExtensions());
        }
        this.addHeaders(response, r.headers);
        boolean bl = r.hasHeaders = !r.headers.isEmpty();
        if (r.schema != null) {
            Object allSchemas = null;
            CodegenProperty cp = this.fromProperty("response", responseSchema);
            r.isNull = cp.isNull;
            if (ModelUtils.isArraySchema(responseSchema)) {
                ArraySchema as = (ArraySchema)responseSchema;
                CodegenProperty items = this.fromProperty("response", this.getSchemaItems(as));
                r.setItems(items);
                CodegenProperty innerCp = items;
                while (innerCp != null) {
                    r.baseType = innerCp.baseType;
                    innerCp = innerCp.items;
                }
            } else if (cp.complexType != null) {
                r.baseType = cp.items != null ? cp.items.complexType : cp.complexType;
                r.isModel = true;
            } else {
                r.baseType = cp.baseType;
            }
            r.dataType = cp.dataType;
            if (Boolean.TRUE.equals(cp.isString) && Boolean.TRUE.equals(cp.isEmail)) {
                r.isEmail = true;
            } else if (Boolean.TRUE.equals(cp.isString) && Boolean.TRUE.equals(cp.isUuid)) {
                r.isUuid = true;
            } else if (Boolean.TRUE.equals(cp.isByteArray)) {
                r.isByteArray = true;
            } else if (Boolean.TRUE.equals(cp.isString)) {
                r.isString = true;
            } else if (Boolean.TRUE.equals(cp.isBoolean)) {
                r.isBoolean = true;
            } else if (Boolean.TRUE.equals(cp.isLong)) {
                r.isLong = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isInteger)) {
                r.isInteger = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isNumber)) {
                r.isNumber = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isDouble)) {
                r.isDouble = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isFloat)) {
                r.isFloat = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isDecimal)) {
                r.isDecimal = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isBinary)) {
                r.isFile = true;
                r.isBinary = true;
            } else if (Boolean.TRUE.equals(cp.isFile)) {
                r.isFile = true;
            } else if (Boolean.TRUE.equals(cp.isDate)) {
                r.isDate = true;
            } else if (Boolean.TRUE.equals(cp.isDateTime)) {
                r.isDateTime = true;
            } else if (Boolean.TRUE.equals(cp.isFreeFormObject)) {
                r.isFreeFormObject = true;
            } else if (Boolean.TRUE.equals(cp.isAnyType)) {
                r.isAnyType = true;
            } else {
                this.LOGGER.debug("Property type is not primitive: {}", (Object)cp.dataType);
            }
            if (cp.isContainer) {
                r.simpleType = false;
                r.containerType = cp.containerType;
                r.isMap = "map".equals(cp.containerType);
                r.isArray = "list".equalsIgnoreCase(cp.containerType) || "array".equalsIgnoreCase(cp.containerType) || "set".equalsIgnoreCase(cp.containerType);
            } else {
                r.simpleType = true;
            }
            r.primitiveType = r.baseType == null || this.languageSpecificPrimitives().contains(r.baseType);
            this.addVarsRequiredVarsAdditionalProps(responseSchema, r);
        }
        if (r.baseType == null) {
            r.isMap = false;
            r.isArray = false;
            r.primitiveType = true;
            r.simpleType = true;
        }
        return r;
    }

    public CodegenCallback fromCallback(String name, Callback callback, List<Server> servers) {
        CodegenCallback c = new CodegenCallback();
        c.name = name;
        if (callback.getExtensions() != null && !callback.getExtensions().isEmpty()) {
            c.vendorExtensions.putAll(callback.getExtensions());
        }
        callback.forEach((expression, pi) -> {
            CodegenCallback.Url u = new CodegenCallback.Url();
            u.expression = expression;
            if (pi.getExtensions() != null && !pi.getExtensions().isEmpty()) {
                u.vendorExtensions.putAll(pi.getExtensions());
            }
            Stream.of(Pair.of((Object)"get", (Object)pi.getGet()), Pair.of((Object)"head", (Object)pi.getHead()), Pair.of((Object)"put", (Object)pi.getPut()), Pair.of((Object)"post", (Object)pi.getPost()), Pair.of((Object)"delete", (Object)pi.getDelete()), Pair.of((Object)"patch", (Object)pi.getPatch()), Pair.of((Object)"options", (Object)pi.getOptions())).filter(p -> p.getValue() != null).forEach(p -> {
                boolean genId;
                String method = (String)p.getKey();
                Operation op = (Operation)p.getValue();
                boolean bl = genId = op.getOperationId() == null;
                if (genId) {
                    op.setOperationId(this.getOrGenerateOperationId(op, c.name + "_" + expression.replaceAll("\\{\\$.*}", ""), method));
                }
                if (op.getExtensions() == null) {
                    op.setExtensions(new HashMap());
                }
                op.getExtensions().put("x-callback-request", true);
                CodegenOperation co = this.fromOperation((String)expression, method, op, servers);
                if (genId) {
                    co.operationIdOriginal = null;
                    co.nickname = co.operationId;
                }
                u.requests.add(co);
            });
            c.urls.add(u);
        });
        return c;
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        Schema parameterSchema;
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = parameter.getName();
        codegenParameter.description = this.escapeText(parameter.getDescription());
        codegenParameter.unescapedDescription = parameter.getDescription();
        if (parameter.getRequired() != null) {
            codegenParameter.required = parameter.getRequired();
        }
        codegenParameter.jsonSchema = Json.pretty((Object)parameter);
        if (GlobalSettings.getProperty("debugParser") != null) {
            this.LOGGER.info("working on Parameter {}", (Object)parameter.getName());
            this.LOGGER.info("JSON schema: {}", (Object)codegenParameter.jsonSchema);
        }
        if (parameter.getExtensions() != null && !parameter.getExtensions().isEmpty()) {
            codegenParameter.vendorExtensions.putAll(parameter.getExtensions());
        }
        if (parameter.getSchema() != null) {
            parameterSchema = parameter.getSchema();
        } else if (parameter.getContent() != null) {
            Content content = parameter.getContent();
            if (content.size() > 1) {
                OnceLogger.once(this.LOGGER).warn("Multiple schemas found in content, returning only the first one");
            }
            Map.Entry entry2 = (Map.Entry)content.entrySet().iterator().next();
            codegenParameter.contentType = (String)entry2.getKey();
            parameterSchema = ((MediaType)entry2.getValue()).getSchema();
        } else {
            parameterSchema = null;
        }
        if (parameterSchema != null) {
            CodegenProperty codegenProperty;
            if ((parameterSchema = this.unaliasSchema(parameterSchema, Collections.emptyMap())) == null) {
                this.LOGGER.warn("warning!  Schema not found for parameter \" {} \", using String", (Object)parameter.getName());
                parameterSchema = new StringSchema().description("//TODO automatically added by openapi-generator due to missing type definition.");
            }
            ModelUtils.syncValidationProperties(parameterSchema, codegenParameter);
            if (Boolean.TRUE.equals(parameterSchema.getNullable())) {
                codegenParameter.isNullable = true;
            }
            codegenParameter.defaultValue = this.toDefaultParameterValue(parameterSchema);
            if (parameter.getStyle() != null) {
                codegenParameter.style = parameter.getStyle().toString();
                codegenParameter.isDeepObject = Parameter.StyleEnum.DEEPOBJECT == parameter.getStyle();
            }
            codegenParameter.isExplode = parameter.getExplode() == null ? false : parameter.getExplode();
            String collectionFormat = null;
            if (ModelUtils.isArraySchema(parameterSchema)) {
                CodegenProperty codegenProperty2;
                ArraySchema arraySchema = (ArraySchema)parameterSchema;
                Schema<?> inner = this.getSchemaItems(arraySchema);
                collectionFormat = this.getCollectionFormat(parameter);
                collectionFormat = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)collectionFormat) ? "csv" : collectionFormat;
                codegenParameter.items = codegenProperty2 = this.fromProperty("inner", inner);
                codegenParameter.mostInnerItems = codegenProperty2.mostInnerItems;
                codegenParameter.baseType = codegenProperty2.dataType;
                codegenParameter.isContainer = true;
                codegenParameter.isArray = true;
                while (codegenProperty2 != null) {
                    imports.add(codegenProperty2.baseType);
                    codegenProperty2 = codegenProperty2.items;
                }
            } else if (ModelUtils.isMapSchema(parameterSchema)) {
                codegenParameter.items = codegenProperty = this.fromProperty("inner", this.getAdditionalProperties(parameterSchema));
                codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                codegenParameter.baseType = codegenProperty.dataType;
                codegenParameter.isContainer = true;
                codegenParameter.isMap = true;
                while (codegenProperty != null) {
                    imports.add(codegenProperty.baseType);
                    codegenProperty = codegenProperty.items;
                }
            } else if (ModelUtils.isNullType(parameterSchema)) {
                codegenParameter.isNull = true;
            }
            codegenProperty = this.fromProperty(parameter.getName(), parameterSchema);
            codegenProperty.required = Boolean.TRUE.equals(parameter.getRequired());
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            String parameterDataType = this.getParameterDataType(parameter, parameterSchema);
            codegenParameter.dataType = parameterDataType != null ? parameterDataType : codegenProperty.dataType;
            if (ModelUtils.isObjectSchema(parameterSchema)) {
                codegenProperty.complexType = codegenParameter.dataType;
            }
            if (ModelUtils.isSet(parameterSchema)) {
                imports.add(codegenProperty.baseType);
            }
            codegenParameter.dataFormat = codegenProperty.dataFormat;
            codegenParameter.required = codegenProperty.required;
            if (codegenProperty.isEnum) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
            }
            this.updateCodegenPropertyEnum(codegenProperty);
            codegenParameter.isEnum = codegenProperty.isEnum;
            codegenParameter._enum = codegenProperty._enum;
            codegenParameter.allowableValues = codegenProperty.allowableValues;
            if (codegenProperty.items != null && codegenProperty.items.isEnum) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
                codegenParameter.items = codegenProperty.items;
                codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
            }
            codegenParameter.collectionFormat = collectionFormat;
            if ("multi".equals(collectionFormat)) {
                codegenParameter.isCollectionFormatMulti = true;
            }
            codegenParameter.paramName = this.toParamName(parameter.getName());
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
            if (ModelUtils.isIntegerSchema(parameterSchema)) {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum().longValue());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum().longValue());
            } else {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum());
            }
            codegenParameter.exclusiveMaximum = parameterSchema.getExclusiveMaximum() == null ? false : parameterSchema.getExclusiveMaximum();
            codegenParameter.exclusiveMinimum = parameterSchema.getExclusiveMinimum() == null ? false : parameterSchema.getExclusiveMinimum();
            codegenParameter.maxLength = parameterSchema.getMaxLength();
            codegenParameter.minLength = parameterSchema.getMinLength();
            codegenParameter.pattern = this.toRegularExpression(parameterSchema.getPattern());
            codegenParameter.maxItems = parameterSchema.getMaxItems();
            codegenParameter.minItems = parameterSchema.getMinItems();
            codegenParameter.uniqueItems = parameterSchema.getUniqueItems() == null ? false : parameterSchema.getUniqueItems();
            codegenParameter.multipleOf = parameterSchema.getMultipleOf();
            if (codegenParameter.maximum != null || codegenParameter.minimum != null || codegenParameter.maxLength != null || codegenParameter.minLength != null || codegenParameter.maxItems != null || codegenParameter.minItems != null || codegenParameter.pattern != null || codegenParameter.multipleOf != null) {
                codegenParameter.hasValidation = true;
            }
            this.addVarsRequiredVarsAdditionalProps(parameterSchema, codegenParameter);
        } else {
            this.LOGGER.error("Not handling {} as Body Parameter at the moment", (Object)parameter);
        }
        if (parameter instanceof QueryParameter || "query".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.isQueryParam = true;
        } else if (parameter instanceof PathParameter || "path".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.required = true;
            codegenParameter.isPathParam = true;
        } else if (parameter instanceof HeaderParameter || "header".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.isHeaderParam = true;
        } else if (parameter instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.isCookieParam = true;
        } else {
            this.LOGGER.warn("Unknown parameter type: {}", (Object)parameter.getName());
        }
        if (codegenParameter.paramName == null) {
            this.LOGGER.warn("Parameter name not defined properly. Default to UNKNOWN_PARAMETER_NAME");
            codegenParameter.paramName = "UNKNOWN_PARAMETER_NAME";
        }
        if (codegenParameter.isQueryParam && codegenParameter.isDeepObject) {
            Schema schema = ModelUtils.getSchema(this.openAPI, codegenParameter.dataType);
            codegenParameter.items = this.fromProperty(codegenParameter.paramName, schema);
            if (schema != null) {
                Map properties = schema.getProperties();
                codegenParameter.items.vars = properties.entrySet().stream().map(entry -> {
                    CodegenProperty property = this.fromProperty((String)entry.getKey(), (Schema)entry.getValue());
                    property.baseName = codegenParameter.baseName + "[" + (String)entry.getKey() + "]";
                    return property;
                }).collect(Collectors.toList());
            } else {
                this.LOGGER.warn("No object schema found for deepObject parameter" + codegenParameter + " deepObject won't have specific properties");
            }
        }
        this.setParameterExampleValue(codegenParameter, parameter);
        this.postProcessParameter(codegenParameter);
        this.LOGGER.debug("debugging codegenParameter return: {}", (Object)codegenParameter);
        return codegenParameter;
    }

    protected String getParameterDataType(Parameter parameter, Schema schema) {
        if (parameter.get$ref() != null) {
            String refName = ModelUtils.getSimpleRef(parameter.get$ref());
            return this.toModelName(refName);
        }
        return null;
    }

    public boolean isDataTypeBinary(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase(Locale.ROOT).startsWith("byte");
        }
        return false;
    }

    public boolean isDataTypeFile(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase(Locale.ROOT).equals("file");
        }
        return false;
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        if (securitySchemeMap == null) {
            return Collections.emptyList();
        }
        ArrayList<CodegenSecurity> codegenSecurities = new ArrayList<CodegenSecurity>(securitySchemeMap.size());
        for (String key : securitySchemeMap.keySet()) {
            CodegenSecurity cs;
            CodegenSecurity cs2;
            SecurityScheme securityScheme = securitySchemeMap.get(key);
            if (SecurityScheme.Type.APIKEY.equals((Object)securityScheme.getType())) {
                cs2 = this.defaultCodegenSecurity(key, securityScheme);
                cs2.isBasic = cs2.isOAuth = Boolean.valueOf(false);
                cs2.isApiKey = true;
                cs2.keyParamName = securityScheme.getName();
                cs2.isKeyInHeader = securityScheme.getIn() == SecurityScheme.In.HEADER;
                cs2.isKeyInQuery = securityScheme.getIn() == SecurityScheme.In.QUERY;
                cs2.isKeyInCookie = securityScheme.getIn() == SecurityScheme.In.COOKIE;
                codegenSecurities.add(cs2);
                continue;
            }
            if (SecurityScheme.Type.HTTP.equals((Object)securityScheme.getType())) {
                cs2 = this.defaultCodegenSecurity(key, securityScheme);
                cs2.isApiKey = cs2.isOAuth = Boolean.valueOf(false);
                cs2.isKeyInCookie = cs2.isOAuth;
                cs2.isKeyInQuery = cs2.isOAuth;
                cs2.isKeyInHeader = cs2.isOAuth;
                cs2.isBasic = true;
                if ("basic".equals(securityScheme.getScheme())) {
                    cs2.isBasicBasic = true;
                } else if ("bearer".equals(securityScheme.getScheme())) {
                    cs2.isBasicBearer = true;
                    cs2.bearerFormat = securityScheme.getBearerFormat();
                } else if ("signature".equals(securityScheme.getScheme())) {
                    cs2.isHttpSignature = true;
                    OnceLogger.once(this.LOGGER).warn("Security scheme 'HTTP signature' is a draft IETF RFC and subject to change.");
                }
                codegenSecurities.add(cs2);
                continue;
            }
            if (!SecurityScheme.Type.OAUTH2.equals((Object)securityScheme.getType())) continue;
            OAuthFlows flows = securityScheme.getFlows();
            if (securityScheme.getFlows() == null) {
                throw new RuntimeException("missing oauth flow in " + key);
            }
            if (flows.getPassword() != null) {
                cs = this.defaultOauthCodegenSecurity(key, securityScheme);
                this.setOauth2Info(cs, flows.getPassword());
                cs.isPassword = true;
                cs.flow = "password";
                codegenSecurities.add(cs);
            }
            if (flows.getImplicit() != null) {
                cs = this.defaultOauthCodegenSecurity(key, securityScheme);
                this.setOauth2Info(cs, flows.getImplicit());
                cs.isImplicit = true;
                cs.flow = "implicit";
                codegenSecurities.add(cs);
            }
            if (flows.getClientCredentials() != null) {
                cs = this.defaultOauthCodegenSecurity(key, securityScheme);
                this.setOauth2Info(cs, flows.getClientCredentials());
                cs.isApplication = true;
                cs.flow = "application";
                codegenSecurities.add(cs);
            }
            if (flows.getAuthorizationCode() == null) continue;
            cs = this.defaultOauthCodegenSecurity(key, securityScheme);
            this.setOauth2Info(cs, flows.getAuthorizationCode());
            cs.isCode = true;
            cs.flow = "accessCode";
            codegenSecurities.add(cs);
        }
        Collections.sort(codegenSecurities, new Comparator<CodegenSecurity>(){

            @Override
            public int compare(CodegenSecurity one, CodegenSecurity another) {
                return ObjectUtils.compare((Comparable)((Object)one.name), (Comparable)((Object)another.name));
            }
        });
        return codegenSecurities;
    }

    private CodegenSecurity defaultCodegenSecurity(String key, SecurityScheme securityScheme) {
        CodegenSecurity cs = (CodegenSecurity)CodegenModelFactory.newInstance(CodegenModelType.SECURITY);
        cs.name = key;
        cs.type = securityScheme.getType().toString();
        cs.isApplication = cs.isImplicit = Boolean.valueOf(false);
        cs.isPassword = cs.isImplicit;
        cs.isCode = cs.isImplicit;
        cs.isHttpSignature = false;
        cs.isBasicBasic = cs.isBasicBearer = Boolean.valueOf(false);
        cs.scheme = securityScheme.getScheme();
        if (securityScheme.getExtensions() != null) {
            cs.vendorExtensions.putAll(securityScheme.getExtensions());
        }
        return cs;
    }

    private CodegenSecurity defaultOauthCodegenSecurity(String key, SecurityScheme securityScheme) {
        CodegenSecurity cs = this.defaultCodegenSecurity(key, securityScheme);
        cs.isApiKey = cs.isBasic = Boolean.valueOf(false);
        cs.isKeyInCookie = cs.isBasic;
        cs.isKeyInQuery = cs.isBasic;
        cs.isKeyInHeader = cs.isBasic;
        cs.isOAuth = true;
        return cs;
    }

    protected void setReservedWordsLowerCase(List<String> words) {
        this.reservedWords = new HashSet<String>();
        for (String word : words) {
            this.reservedWords.add(word.toLowerCase(Locale.ROOT));
        }
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word.toLowerCase(Locale.ROOT));
    }

    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        String operationId = operation.getOperationId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)operationId)) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (String part : parts) {
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : StringUtils.camelize(part);
                builder.append(part);
            }
            operationId = this.sanitizeName(builder.toString());
            this.LOGGER.warn("Empty operationId found for path: {} {}. Renamed to auto-generated operationId: {}", new Object[]{httpMethod, path, operationId});
        }
        return operationId;
    }

    protected boolean needToImport(String type) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    protected void addHeaders(ApiResponse response, List<CodegenProperty> properties) {
        if (response.getHeaders() != null) {
            for (Map.Entry headerEntry : response.getHeaders().entrySet()) {
                Schema schema;
                String description = ((Header)headerEntry.getValue()).getDescription();
                Header header = ModelUtils.getReferencedHeader(this.openAPI, (Header)headerEntry.getValue());
                if (header.getSchema() == null) {
                    this.LOGGER.warn("No schema defined for Header '{}', using a String schema", headerEntry.getKey());
                    schema = new StringSchema();
                } else {
                    schema = header.getSchema();
                }
                CodegenProperty cp = this.fromProperty((String)headerEntry.getKey(), schema);
                cp.setDescription(this.escapeText(description));
                cp.setUnescapedDescription(description);
                if (header.getRequired() != null) {
                    cp.setRequired(header.getRequired());
                } else {
                    cp.setRequired(false);
                }
                properties.add(cp);
            }
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        String uniqueName = co.operationId;
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!uniqueName.equals(op.operationId)) continue;
            uniqueName = co.operationId + "_" + counter;
            ++counter;
        }
        if (!co.operationId.equals(uniqueName)) {
            this.LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        co.operationId = uniqueName;
        co.operationIdLowerCase = uniqueName.toLowerCase(Locale.ROOT);
        co.operationIdCamelCase = StringUtils.camelize(uniqueName);
        co.operationIdSnakeCase = StringUtils.underscore(uniqueName);
        opList.add(co);
        co.baseName = tag;
    }

    protected void addParentContainer(CodegenModel model, String name, Schema schema) {
        String mappedType;
        CodegenProperty property = this.fromProperty(name, schema);
        this.addImport(model, property.complexType);
        model.parent = this.toInstantiationType(schema);
        String containerType = property.containerType;
        String instantiationType = this.instantiationTypes.get(containerType);
        if (instantiationType != null) {
            this.addImport(model, instantiationType);
        }
        if ((mappedType = this.typeMapping.get(containerType)) != null) {
            this.addImport(model, mappedType);
        }
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    protected void addImport(CodegenModel m, String type) {
        if (type != null && this.needToImport(type)) {
            m.imports.add(type);
        }
    }

    private Map<String, Schema> unaliasPropertySchema(Map<String, Schema> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                properties.put(key, this.unaliasSchema(properties.get(key), this.importMapping()));
            }
        }
        return properties;
    }

    private void addVars(CodegenModel m, Map<String, Schema> properties, List<String> required, Map<String, Schema> allProperties, List<String> allRequired) {
        m.hasRequired = false;
        if (properties != null && !properties.isEmpty()) {
            m.hasVars = true;
            m.hasEnums = false;
            TreeSet<String> mandatory = required == null ? Collections.emptySet() : new TreeSet<String>(required);
            this.addVars(m, m.vars, properties, mandatory);
            m.mandatory = mandatory;
            m.allMandatory = m.mandatory;
        } else {
            m.emptyVars = true;
            m.hasVars = false;
            m.hasEnums = false;
        }
        if (allProperties != null) {
            TreeSet<String> allMandatory = allRequired == null ? Collections.emptySet() : new TreeSet<String>(allRequired);
            this.addVars(m, m.allVars, allProperties, allMandatory);
            m.allMandatory = allMandatory;
        } else {
            m.allVars = m.vars;
            m.allMandatory = m.mandatory;
        }
        TreeSet<String> renamedMandatory = new TreeSet<String>();
        Iterator<String> mandatoryIterator = m.mandatory.iterator();
        while (mandatoryIterator.hasNext()) {
            renamedMandatory.add(this.toVarName(mandatoryIterator.next()));
        }
        m.mandatory = renamedMandatory;
        TreeSet<String> renamedAllMandatory = new TreeSet<String>();
        Iterator<String> allMandatoryIterator = m.allMandatory.iterator();
        while (allMandatoryIterator.hasNext()) {
            renamedAllMandatory.add(this.toVarName(allMandatoryIterator.next()));
        }
        m.allMandatory = renamedAllMandatory;
    }

    private void addVars(IJsonSchemaValidationProperties m, List<CodegenProperty> vars, Map<String, Schema> properties, Set<String> mandatory) {
        if (properties == null) {
            return;
        }
        CodegenModel cm = null;
        if (m instanceof CodegenModel) {
            cm = (CodegenModel)m;
        }
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            String key = entry.getKey();
            Schema prop = entry.getValue();
            if (prop == null) {
                this.LOGGER.warn("Please report the issue. There shouldn't be null property for " + key);
                continue;
            }
            CodegenProperty cp = this.fromProperty(key, prop);
            cp.required = mandatory.contains(key);
            vars.add(cp);
            if (cm == null) continue;
            cm.hasRequired = cm.hasRequired || cp.required;
            boolean bl = cm.hasOptional = cm.hasOptional || !cp.required;
            if (cp.isEnum) {
                cm.hasEnums = true;
            }
            if (!Boolean.TRUE.equals(cp.isReadOnly)) {
                cm.hasOnlyReadOnly = false;
            }
            if (cp.isContainer) {
                this.addImport(cm, this.typeMapping.get("array"));
            }
            this.addImport(cm, cp.baseType);
            CodegenProperty innerCp = cp;
            while (innerCp != null) {
                this.addImport(cm, innerCp.complexType);
                innerCp = innerCp.items;
            }
            if (Boolean.TRUE.equals(cp.required)) {
                cm.requiredVars.add(cp);
            } else {
                cm.optionalVars.add(cp);
            }
            if (Boolean.TRUE.equals(cp.isReadOnly)) {
                cm.readOnlyVars.add(cp);
                continue;
            }
            cm.readWriteVars.add(cp);
        }
    }

    Map<String, String> getAllAliases(Map<String, Schema> schemas) {
        if (schemas == null || schemas.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Schema schema = entry.getValue();
            if (!DefaultCodegen.isAliasOfSimpleTypes(schema).booleanValue()) continue;
            String oasName = entry.getKey();
            String schemaType = this.getPrimitiveType(schema);
            aliases.put(oasName, schemaType);
        }
        return aliases;
    }

    private static Boolean isAliasOfSimpleTypes(Schema schema) {
        return !ModelUtils.isObjectSchema(schema) && !ModelUtils.isArraySchema(schema) && !ModelUtils.isMapSchema(schema) && !ModelUtils.isComposedSchema(schema) && schema.getEnum() == null;
    }

    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-_:;#]");
    }

    protected String removeNonNameElementToCamelCase(String name, String nonNameElementPattern) {
        String result = Arrays.stream(name.split(nonNameElementPattern)).map(org.apache.commons.lang3.StringUtils::capitalize).collect(Collectors.joining(""));
        if (result.length() > 0) {
            result = result.substring(0, 1).toLowerCase(Locale.ROOT) + result.substring(1);
        }
        return result;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String modelFilename(String templateName, String modelName) {
        String suffix = this.modelTemplateFiles().get(templateName);
        return this.modelFileFolder() + File.separator + this.toModelFilename(modelName) + suffix;
    }

    @Override
    public String apiDocFilename(String templateName, String tag) {
        String docExtension = this.getDocExtension();
        String suffix = docExtension != null ? docExtension : this.apiDocTemplateFiles().get(templateName);
        return this.apiDocFileFolder() + File.separator + this.toApiDocFilename(tag) + suffix;
    }

    @Override
    public String apiTestFilename(String templateName, String tag) {
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return this.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    @Override
    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    @Override
    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    @Override
    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    @Override
    public boolean isSkipOperationExample() {
        return this.skipOperationExample;
    }

    @Override
    public void setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
    }

    @Override
    public void setSkipOperationExample(boolean skipOperationExample) {
        this.skipOperationExample = skipOperationExample;
    }

    @Override
    public boolean isHideGenerationTimestamp() {
        return this.hideGenerationTimestamp;
    }

    @Override
    public void setHideGenerationTimestamp(boolean hideGenerationTimestamp) {
        this.hideGenerationTimestamp = hideGenerationTimestamp;
    }

    @Override
    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    @Override
    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            StringBuilder sb = new StringBuilder("Unknown library: " + library + "\nAvailable libraries:");
            if (this.supportedLibraries.size() == 0) {
                sb.append("\n  ").append("NONE");
            } else {
                for (String lib : this.supportedLibraries.keySet()) {
                    sb.append("\n  ").append(lib);
                }
            }
            throw new RuntimeException(sb.toString());
        }
        this.library = library;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    public final boolean isLibrary(String library) {
        return library.equals(this.library);
    }

    @Override
    public void setGitHost(String gitHost) {
        this.gitHost = gitHost;
    }

    @Override
    public String getGitHost() {
        return this.gitHost;
    }

    @Override
    public void setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
    }

    @Override
    public String getGitUserId() {
        return this.gitUserId;
    }

    @Override
    public void setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
    }

    @Override
    public String getGitRepoId() {
        return this.gitRepoId;
    }

    @Override
    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    @Override
    public String getReleaseNote() {
        return this.releaseNote;
    }

    @Override
    public String getDocExtension() {
        return this.docExtension;
    }

    @Override
    public void setDocExtension(String userDocExtension) {
        this.docExtension = userDocExtension;
    }

    @Override
    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    @Override
    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    @Override
    public String sanitizeName(String name) {
        return this.sanitizeName(name, "\\W");
    }

    @Override
    public void setTemplatingEngine(TemplatingEngineAdapter templatingEngine) {
        this.templatingEngine = templatingEngine;
    }

    @Override
    public TemplatingEngineAdapter getTemplatingEngine() {
        return this.templatingEngine;
    }

    public String sanitizeName(String name, String removeCharRegEx) {
        return this.sanitizeName(name, removeCharRegEx, new ArrayList<String>());
    }

    public String sanitizeName(String name, String removeCharRegEx, ArrayList<String> exceptionList) {
        if (name == null) {
            this.LOGGER.error("String to be sanitized is null. Default to ERROR_UNKNOWN");
            return "ERROR_UNKNOWN";
        }
        if ("$".equals(name)) {
            return "value";
        }
        SanitizeNameOptions opts = new SanitizeNameOptions(name, removeCharRegEx, exceptionList);
        return (String)sanitizedNameCache.get((Object)opts, sanitizeNameOptions -> {
            String modifiable = sanitizeNameOptions.getName();
            List<String> exceptions = sanitizeNameOptions.getExceptions();
            modifiable = this.sanitizeValue(modifiable, "\\[\\]", "", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\[", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\]", "", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\(", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\)", "", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\.", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "-", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, "\\|", "_", exceptions);
            modifiable = this.sanitizeValue(modifiable, " ", "_", exceptions);
            modifiable = modifiable.replaceAll("/", "_");
            modifiable = modifiable.replaceAll("\\\\", "_");
            modifiable = this.allowUnicodeIdentifiers != false ? Pattern.compile(sanitizeNameOptions.getRemoveCharRegEx(), 256).matcher(modifiable).replaceAll("") : modifiable.replaceAll(sanitizeNameOptions.getRemoveCharRegEx(), "");
            return modifiable;
        });
    }

    private String sanitizeValue(String value, String replaceMatch, String replaceValue, List<String> exceptionList) {
        if (exceptionList.size() == 0 || !exceptionList.contains(replaceMatch)) {
            return value.replaceAll(replaceMatch, replaceValue);
        }
        return value;
    }

    @Override
    public String sanitizeTag(String tag) {
        if ((tag = StringUtils.camelize(this.sanitizeName(tag))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    public void setParameterBooleanFlagWithCodegenProperty(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null) {
            this.LOGGER.error("Codegen Parameter cannot be null.");
            return;
        }
        if (property == null) {
            this.LOGGER.error("Codegen Property cannot be null.");
            return;
        }
        if (Boolean.TRUE.equals(property.isEmail) && Boolean.TRUE.equals(property.isString)) {
            parameter.isEmail = true;
        } else if (Boolean.TRUE.equals(property.isUuid) && Boolean.TRUE.equals(property.isString)) {
            parameter.isUuid = true;
        } else if (Boolean.TRUE.equals(property.isByteArray)) {
            parameter.isByteArray = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBinary)) {
            parameter.isBinary = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isString)) {
            parameter.isString = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBoolean)) {
            parameter.isBoolean = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isLong)) {
            parameter.isLong = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isInteger)) {
            parameter.isInteger = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDouble)) {
            parameter.isDouble = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFloat)) {
            parameter.isFloat = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDecimal)) {
            parameter.isDecimal = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isNumber)) {
            parameter.isNumber = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDate)) {
            parameter.isDate = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDateTime)) {
            parameter.isDateTime = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFreeFormObject)) {
            parameter.isFreeFormObject = true;
        } else if (Boolean.TRUE.equals(property.isAnyType)) {
            parameter.isAnyType = true;
        } else {
            this.LOGGER.debug("Property type is not primitive: {}", (Object)property.dataType);
        }
        if (Boolean.TRUE.equals(property.isFile)) {
            parameter.isFile = true;
        }
        if (Boolean.TRUE.equals(property.isModel)) {
            parameter.isModel = true;
        }
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> extensions;
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.mostInnerItems != null) {
            allowableValues = var.mostInnerItems.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        String varDataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
        Optional<Schema> referencedSchema = ModelUtils.getSchemas(this.openAPI).entrySet().stream().filter(entry -> Objects.equals(varDataType, this.toModelName((String)entry.getKey()))).map(Map.Entry::getValue).findFirst();
        String dataType = referencedSchema.isPresent() ? this.getTypeDeclaration(referencedSchema.get()) : varDataType;
        List<Map<String, Object>> enumVars = this.buildEnumVars(values, dataType);
        Map<String, Object> map = extensions = var.mostInnerItems != null ? var.mostInnerItems.getVendorExtensions() : var.getVendorExtensions();
        if (referencedSchema.isPresent()) {
            extensions = referencedSchema.get().getExtensions();
        }
        this.updateEnumVarsWithExtensions(enumVars, extensions, dataType);
        allowableValues.put("enumVars", enumVars);
        if (var.defaultValue != null) {
            String enumName = null;
            String enumDefaultValue = this.isDataTypeString(dataType) ? this.toEnumValue(var.defaultValue, dataType) : var.defaultValue;
            for (Map<String, Object> enumVar : enumVars) {
                if (!enumDefaultValue.equals(enumVar.get("value"))) continue;
                enumName = (String)enumVar.get("name");
                break;
            }
            if (enumName != null) {
                var.defaultValue = this.toEnumDefaultValue(enumName, var.datatypeWithEnum);
            }
        }
    }

    protected List<Map<String, Object>> buildEnumVars(List<Object> values, String dataType) {
        ArrayList<Map<String, Object>> enumVars = new ArrayList<Map<String, Object>>();
        int truncateIdx = 0;
        if (this.isRemoveEnumValuePrefix()) {
            String commonPrefix = this.findCommonPrefixOfVars(values);
            truncateIdx = commonPrefix.length();
        }
        for (Object value : values) {
            String enumName;
            HashMap<String, Object> enumVar = new HashMap<String, Object>();
            if (truncateIdx == 0) {
                enumName = String.valueOf(value);
            } else {
                enumName = value.toString().substring(truncateIdx);
                if ("".equals(enumName)) {
                    enumName = value.toString();
                }
            }
            enumVar.put("name", this.toEnumVarName(enumName, dataType));
            enumVar.put("value", this.toEnumValue(String.valueOf(value), dataType));
            enumVar.put("isString", this.isDataTypeString(dataType));
            enumVars.add(enumVar);
        }
        return enumVars;
    }

    protected void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String dataType) {
        if (vendorExtensions != null) {
            this.updateEnumVarsWithExtensions(enumVars, vendorExtensions, "x-enum-varnames", "name");
            this.updateEnumVarsWithExtensions(enumVars, vendorExtensions, "x-enum-descriptions", "enumDescription");
        }
    }

    private void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String extensionKey, String key) {
        if (vendorExtensions.containsKey(extensionKey)) {
            List values = (List)vendorExtensions.get(extensionKey);
            int size = Math.min(enumVars.size(), values.size());
            for (int i = 0; i < size; ++i) {
                enumVars.get(i).put(key, values.get(i));
            }
        }
    }

    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("/", "\\\\/") + "/";
        }
        return pattern;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey) {
        boolean result = this.convertPropertyToBoolean(propertyKey);
        this.writePropertyBack(propertyKey, result);
        return result;
    }

    @Override
    public String getIgnoreFilePathOverride() {
        return this.ignoreFilePathOverride;
    }

    @Override
    public void setIgnoreFilePathOverride(String ignoreFileOverride) {
        this.ignoreFilePathOverride = ignoreFileOverride;
    }

    public boolean convertPropertyToBoolean(String propertyKey) {
        Object booleanValue = this.additionalProperties.get(propertyKey);
        boolean result = Boolean.FALSE;
        if (booleanValue instanceof Boolean) {
            result = (Boolean)booleanValue;
        } else if (booleanValue instanceof String) {
            result = Boolean.parseBoolean((String)booleanValue);
        } else {
            this.LOGGER.warn("The value (generator's option) must be either boolean or string. Default to `false`.");
        }
        return result;
    }

    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    protected String getContentType(RequestBody requestBody) {
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            this.LOGGER.debug("Cannot determine the content type. Returning null.");
            return null;
        }
        return (String)new ArrayList(requestBody.getContent().keySet()).get(0);
    }

    private void setOauth2Info(CodegenSecurity codegenSecurity, OAuthFlow flow) {
        codegenSecurity.authorizationUrl = flow.getAuthorizationUrl();
        codegenSecurity.tokenUrl = flow.getTokenUrl();
        codegenSecurity.refreshUrl = flow.getRefreshUrl();
        if (flow.getScopes() != null && !flow.getScopes().isEmpty()) {
            ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
            for (Map.Entry scopeEntry : flow.getScopes().entrySet()) {
                HashMap scope = new HashMap();
                scope.put("scope", scopeEntry.getKey());
                scope.put("description", this.escapeText((String)scopeEntry.getValue()));
                scopes.add(scope);
            }
            codegenSecurity.scopes = scopes;
        }
    }

    private void addConsumesInfo(Operation operation, CodegenOperation codegenOperation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(this.openAPI, operation.getRequestBody());
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return;
        }
        Set consumes = requestBody.getContent().keySet();
        ArrayList<Map<String, String>> mediaTypeList = new ArrayList<Map<String, String>>();
        for (String key : consumes) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            if ("*/*".equals(key)) continue;
            mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(key)));
            mediaTypeList.add(mediaType);
        }
        if (!mediaTypeList.isEmpty()) {
            codegenOperation.consumes = mediaTypeList;
            codegenOperation.hasConsumes = true;
        }
    }

    public static Set<String> getConsumesInfo(OpenAPI openAPI, Operation operation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return Collections.emptySet();
        }
        return requestBody.getContent().keySet();
    }

    public boolean hasFormParameter(OpenAPI openAPI, Operation operation) {
        Set<String> consumesInfo = DefaultCodegen.getConsumesInfo(openAPI, operation);
        if (consumesInfo == null || consumesInfo.isEmpty()) {
            return false;
        }
        for (String consume : consumesInfo) {
            if (consume == null || !consume.toLowerCase(Locale.ROOT).startsWith("application/x-www-form-urlencoded") && !consume.toLowerCase(Locale.ROOT).startsWith("multipart")) continue;
            return true;
        }
        return false;
    }

    public boolean hasBodyParameter(OpenAPI openAPI, Operation operation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
        if (requestBody == null) {
            return false;
        }
        Schema schema = ModelUtils.getSchemaFromRequestBody(requestBody);
        return ModelUtils.getReferencedSchema(openAPI, schema) != null;
    }

    private void addProducesInfo(ApiResponse inputResponse, CodegenOperation codegenOperation) {
        ApiResponse response = ModelUtils.getReferencedApiResponse(this.openAPI, inputResponse);
        if (response == null || response.getContent() == null || response.getContent().isEmpty()) {
            return;
        }
        Set produces = response.getContent().keySet();
        if (codegenOperation.produces == null) {
            codegenOperation.produces = new ArrayList<Map<String, String>>();
        }
        HashSet<String> existingMediaTypes = new HashSet<String>();
        for (Map<String, String> mediaType : codegenOperation.produces) {
            existingMediaTypes.add(mediaType.get("mediaType"));
        }
        for (String key : produces) {
            String encodedKey = "*/*".equals(key) ? key : this.escapeText(this.escapeQuotationMark(key));
            if (existingMediaTypes.contains(encodedKey)) continue;
            HashMap<String, String> mediaType = new HashMap<String, String>();
            mediaType.put("mediaType", encodedKey);
            codegenOperation.produces.add(mediaType);
            codegenOperation.hasProduces = Boolean.TRUE;
        }
    }

    public static Set<String> getProducesInfo(OpenAPI openAPI, Operation operation) {
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            return null;
        }
        TreeSet<String> produces = new TreeSet<String>();
        for (ApiResponse r : operation.getResponses().values()) {
            ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, r);
            if (response.getContent() == null) continue;
            produces.addAll(response.getContent().keySet());
        }
        return produces;
    }

    protected String getCollectionFormat(Parameter parameter) {
        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle())) {
            if (Boolean.TRUE.equals(parameter.getExplode())) {
                return "multi";
            }
            return "csv";
        }
        if (Parameter.StyleEnum.SIMPLE.equals((Object)parameter.getStyle())) {
            return "csv";
        }
        if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle())) {
            return "pipes";
        }
        if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle())) {
            return "ssv";
        }
        return null;
    }

    @Override
    public CodegenType getTag() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getHelp() {
        return null;
    }

    public List<CodegenParameter> fromRequestBodyToFormParameters(RequestBody body, Set<String> imports) {
        ArrayList<CodegenParameter> parameters = new ArrayList<CodegenParameter>();
        this.LOGGER.debug("debugging fromRequestBodyToFormParameters= {}", (Object)body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        schema = ModelUtils.getReferencedSchema(this.openAPI, schema);
        ArrayList<String> allRequired = new ArrayList<String>();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        this.addProperties(properties, allRequired, schema);
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                CodegenParameter codegenParameter;
                Schema s = (Schema)entry.getValue();
                if (ModelUtils.isArraySchema(s)) {
                    CodegenProperty codegenProperty;
                    ArraySchema arraySchema = (ArraySchema)s;
                    Schema<?> inner = this.getSchemaItems(arraySchema);
                    codegenParameter = this.fromFormProperty((String)entry.getKey(), inner, imports);
                    codegenParameter.items = codegenProperty = this.fromProperty("inner", inner);
                    codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                    codegenParameter.baseType = codegenProperty.dataType;
                    codegenParameter.isPrimitiveType = false;
                    codegenParameter.isContainer = true;
                    codegenParameter.isArray = true;
                    codegenParameter.description = this.escapeText(s.getDescription());
                    codegenParameter.dataType = this.getTypeDeclaration((Schema)arraySchema);
                    if (codegenParameter.baseType != null && codegenParameter.enumName != null) {
                        codegenParameter.datatypeWithEnum = codegenParameter.dataType.replace(codegenParameter.baseType, codegenParameter.enumName);
                    } else {
                        this.LOGGER.warn("Could not compute datatypeWithEnum from {}, {}", (Object)codegenParameter.baseType, (Object)codegenParameter.enumName);
                    }
                    String collectionFormat = this.getCollectionFormat(codegenParameter);
                    codegenParameter.collectionFormat = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)collectionFormat) ? "csv" : collectionFormat;
                    this.setParameterNullable(codegenParameter, codegenProperty);
                    while (codegenProperty != null) {
                        imports.add(codegenProperty.baseType);
                        codegenProperty = codegenProperty.items;
                    }
                } else {
                    if (ModelUtils.isMapSchema(s)) {
                        this.LOGGER.error("Map of form parameters not supported. Please report the issue to https://github.com/openapitools/openapi-generator if you need help.");
                        continue;
                    }
                    codegenParameter = this.fromFormProperty((String)entry.getKey(), (Schema)entry.getValue(), imports);
                }
                if (!codegenParameter.required && schema.getRequired() != null) {
                    codegenParameter.required = schema.getRequired().contains(entry.getKey());
                }
                parameters.add(codegenParameter);
            }
        }
        return parameters;
    }

    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        this.LOGGER.debug("Debugging fromFormProperty {}: {}", (Object)name, (Object)propertySchema);
        CodegenProperty codegenProperty = this.fromProperty(name, propertySchema);
        ModelUtils.syncValidationProperties(propertySchema, codegenProperty);
        codegenParameter.isFormParam = Boolean.TRUE;
        codegenParameter.baseName = codegenProperty.baseName;
        codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
        codegenParameter.baseType = codegenProperty.baseType;
        codegenParameter.dataType = codegenProperty.dataType;
        codegenParameter.dataFormat = codegenProperty.dataFormat;
        codegenParameter.description = this.escapeText(codegenProperty.description);
        codegenParameter.unescapedDescription = codegenProperty.getDescription();
        codegenParameter.jsonSchema = Json.pretty((Object)propertySchema);
        codegenParameter.defaultValue = codegenProperty.getDefaultValue();
        if (codegenProperty.getVendorExtensions() != null && !codegenProperty.getVendorExtensions().isEmpty()) {
            codegenParameter.vendorExtensions = codegenProperty.getVendorExtensions();
        }
        if (propertySchema.getRequired() != null && !propertySchema.getRequired().isEmpty() && propertySchema.getRequired().contains(codegenProperty.baseName)) {
            codegenParameter.required = Boolean.TRUE;
        }
        this.updateCodegenPropertyEnum(codegenProperty);
        codegenParameter.isEnum = codegenProperty.isEnum;
        codegenParameter._enum = codegenProperty._enum;
        codegenParameter.allowableValues = codegenProperty.allowableValues;
        if (codegenProperty.isEnum) {
            codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            codegenParameter.enumName = codegenProperty.enumName;
        }
        if (codegenProperty.items != null && codegenProperty.items.isEnum) {
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
        }
        if (codegenProperty.complexType != null) {
            imports.add(codegenProperty.complexType);
        }
        if (ModelUtils.isIntegerSchema(propertySchema)) {
            codegenParameter.maximum = propertySchema.getMaximum() == null ? null : String.valueOf(propertySchema.getMaximum().longValue());
            codegenParameter.minimum = propertySchema.getMinimum() == null ? null : String.valueOf(propertySchema.getMinimum().longValue());
        } else {
            codegenParameter.maximum = propertySchema.getMaximum() == null ? null : String.valueOf(propertySchema.getMaximum());
            codegenParameter.minimum = propertySchema.getMinimum() == null ? null : String.valueOf(propertySchema.getMinimum());
        }
        codegenParameter.exclusiveMaximum = propertySchema.getExclusiveMaximum() == null ? false : propertySchema.getExclusiveMaximum();
        codegenParameter.exclusiveMinimum = propertySchema.getExclusiveMinimum() == null ? false : propertySchema.getExclusiveMinimum();
        codegenParameter.maxLength = propertySchema.getMaxLength();
        codegenParameter.minLength = propertySchema.getMinLength();
        codegenParameter.pattern = this.toRegularExpression(propertySchema.getPattern());
        codegenParameter.maxItems = propertySchema.getMaxItems();
        codegenParameter.minItems = propertySchema.getMinItems();
        codegenParameter.uniqueItems = propertySchema.getUniqueItems() == null ? false : propertySchema.getUniqueItems();
        codegenParameter.multipleOf = propertySchema.getMultipleOf();
        if (codegenParameter.maximum != null || codegenParameter.minimum != null || codegenParameter.maxLength != null || codegenParameter.minLength != null || codegenParameter.maxItems != null || codegenParameter.minItems != null || codegenParameter.pattern != null || codegenParameter.multipleOf != null) {
            codegenParameter.hasValidation = true;
        }
        this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
        this.setParameterExampleValue(codegenParameter);
        this.setParameterNullable(codegenParameter, codegenProperty);
        return codegenParameter;
    }

    protected void addBodyModelSchema(CodegenParameter codegenParameter, String name, Schema schema, Set<String> imports, String bodyParameterName, boolean forceSimpleRef) {
        CodegenModel codegenModel = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            schema.setName(name);
            codegenModel = this.fromModel(name, schema);
        }
        if (codegenModel != null) {
            codegenParameter.isModel = true;
        }
        if (codegenModel != null && (codegenModel.hasVars || forceSimpleRef)) {
            codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModel.classname : bodyParameterName;
            codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            codegenParameter.baseType = codegenModel.classname;
            codegenParameter.dataType = this.getTypeDeclaration(codegenModel.classname);
            codegenParameter.description = codegenModel.description;
            codegenParameter.isNullable = codegenModel.isNullable;
            imports.add(codegenParameter.baseType);
        } else {
            CodegenProperty codegenProperty = this.fromProperty("property", schema);
            if (codegenProperty != null && codegenProperty.getComplexType() != null && codegenProperty.getComplexType().contains(" | ")) {
                String codegenModelName;
                List<String> parts = Arrays.asList(codegenProperty.getComplexType().split(" \\| "));
                imports.addAll(parts);
                codegenParameter.baseName = codegenModelName = codegenProperty.getComplexType();
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenParameter.baseName;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                codegenParameter.description = codegenProperty.getDescription();
                codegenParameter.isNullable = codegenProperty.isNullable;
            } else if (ModelUtils.isMapSchema(schema)) {
                this.LOGGER.error("Map should be supported. Please report to openapi-generator github repo about the issue.");
            } else if (codegenProperty != null) {
                String codegenModelDescription;
                String codegenModelName;
                if (codegenModel != null) {
                    codegenModelName = codegenModel.classname;
                    codegenModelDescription = codegenModel.description;
                } else {
                    this.LOGGER.warn("The following schema has undefined (null) baseType. It could be due to form parameter defined in OpenAPI v2 spec with incorrect consumes. A correct 'consumes' for form parameters should be 'application/x-www-form-urlencoded' or 'multipart/?'");
                    this.LOGGER.warn("schema: {}", (Object)schema);
                    this.LOGGER.warn("codegenModel is null. Default to UNKNOWN_BASE_TYPE");
                    codegenModelName = "UNKNOWN_BASE_TYPE";
                    codegenModelDescription = "UNKNOWN_DESCRIPTION";
                }
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModelName : bodyParameterName;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenModelName;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                codegenParameter.description = codegenModelDescription;
                imports.add(codegenParameter.baseType);
                if (codegenProperty.complexType != null) {
                    imports.add(codegenProperty.complexType);
                }
            }
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            this.setParameterNullable(codegenParameter, codegenProperty);
        }
    }

    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        if (body == null) {
            this.LOGGER.error("body in fromRequestBody cannot be null!");
            throw new RuntimeException("body in fromRequestBody cannot be null!");
        }
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = "UNKNOWN_BASE_NAME";
        codegenParameter.paramName = "UNKNOWN_PARAM_NAME";
        codegenParameter.description = this.escapeText(body.getDescription());
        codegenParameter.required = body.getRequired() != null ? body.getRequired() : Boolean.FALSE;
        codegenParameter.isBodyParam = Boolean.TRUE;
        if (body.getExtensions() != null) {
            codegenParameter.vendorExtensions.putAll(body.getExtensions());
        }
        String name = null;
        this.LOGGER.debug("Request body = {}", (Object)body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        if (schema == null) {
            throw new RuntimeException("Request body cannot be null. Possible cause: missing schema in body parameter (OAS v2): " + body);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            name = ModelUtils.getSimpleRef(schema.get$ref());
        }
        Schema validationSchema = this.unaliasSchema(schema, this.importMapping);
        schema = ModelUtils.getReferencedSchema(this.openAPI, schema);
        ModelUtils.syncValidationProperties(validationSchema, codegenParameter);
        if (ModelUtils.isMapSchema(schema)) {
            if (ModelUtils.isGenerateAliasAsModel(schema) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
                this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, true);
            } else {
                Schema inner = this.getAdditionalProperties(schema);
                if (inner == null) {
                    this.LOGGER.error("No inner type supplied for map parameter `{}`. Default to type:string", (Object)schema.getName());
                    inner = new StringSchema().description("//TODO automatically added by openapi-generator");
                    schema.setAdditionalProperties((Object)inner);
                }
                CodegenProperty codegenProperty = this.fromProperty("property", schema);
                imports.add(codegenProperty.baseType);
                CodegenProperty innerCp = codegenProperty;
                while (innerCp != null) {
                    if (innerCp.complexType != null) {
                        imports.add(innerCp.complexType);
                    }
                    innerCp = innerCp.items;
                }
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? "request_body" : bodyParameterName;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.items = codegenProperty.items;
                codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                codegenParameter.dataType = this.getTypeDeclaration(schema);
                codegenParameter.baseType = this.getSchemaType(inner);
                codegenParameter.isContainer = Boolean.TRUE;
                codegenParameter.isMap = Boolean.TRUE;
                codegenParameter.isNullable = codegenProperty.isNullable;
                this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
                this.setParameterNullable(codegenParameter, codegenProperty);
            }
        } else if (ModelUtils.isArraySchema(schema)) {
            if (ModelUtils.isGenerateAliasAsModel(schema) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
                this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, true);
            } else {
                CodegenProperty innerCp;
                ArraySchema arraySchema = (ArraySchema)schema;
                Schema<?> inner = this.getSchemaItems(arraySchema);
                CodegenProperty codegenProperty = this.fromProperty("property", (Schema)arraySchema);
                imports.add(codegenProperty.baseType);
                CodegenProperty mostInnerItem = innerCp = codegenProperty;
                while (innerCp != null) {
                    if (innerCp.complexType != null) {
                        imports.add(innerCp.complexType);
                    }
                    mostInnerItem = innerCp;
                    innerCp = innerCp.items;
                }
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mostInnerItem.complexType) ? "request_body" : mostInnerItem.complexType) : bodyParameterName;
                codegenParameter.paramName = this.toArrayModelParamName(codegenParameter.baseName);
                codegenParameter.items = codegenProperty.items;
                codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                codegenParameter.dataType = this.getTypeDeclaration((Schema)arraySchema);
                codegenParameter.baseType = this.getSchemaType(inner);
                codegenParameter.isContainer = Boolean.TRUE;
                codegenParameter.isArray = Boolean.TRUE;
                codegenParameter.isNullable = codegenProperty.isNullable;
                this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
                this.setParameterNullable(codegenParameter, codegenProperty);
                while (codegenProperty != null) {
                    imports.add(codegenProperty.baseType);
                    codegenProperty = codegenProperty.items;
                }
            }
        } else if (this.isFreeFormObject(schema)) {
            CodegenProperty codegenProperty = this.fromProperty("FREE_FORM_REQUEST_BODY", schema);
            if (codegenProperty != null) {
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? "body" : bodyParameterName;
                codegenParameter.isPrimitiveType = true;
                codegenParameter.baseType = codegenProperty.baseType;
                codegenParameter.dataType = codegenProperty.dataType;
                codegenParameter.description = codegenProperty.description;
                codegenParameter.isNullable = codegenProperty.isNullable;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            }
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            this.setParameterNullable(codegenParameter, codegenProperty);
        } else if (ModelUtils.isObjectSchema(schema) || ModelUtils.isComposedSchema(schema)) {
            this.addBodyModelSchema(codegenParameter, name, schema, imports, bodyParameterName, false);
        } else {
            CodegenProperty codegenProperty = this.fromProperty("PRIMITIVE_REQUEST_BODY", schema);
            if (codegenProperty != null) {
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? "body" : bodyParameterName;
                codegenParameter.isNull = codegenProperty.isNull;
                codegenParameter.isPrimitiveType = true;
                codegenParameter.baseType = codegenProperty.baseType;
                codegenParameter.dataType = codegenProperty.dataType;
                codegenParameter.description = codegenProperty.description;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.pattern = codegenProperty.pattern;
                codegenParameter.isNullable = codegenProperty.isNullable;
                if (codegenProperty.complexType != null) {
                    imports.add(codegenProperty.complexType);
                }
            }
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            this.setParameterNullable(codegenParameter, codegenProperty);
        }
        this.addVarsRequiredVarsAdditionalProps(schema, codegenParameter);
        this.addJsonSchemaForBodyRequestInCaseItsNotPresent(codegenParameter, body);
        this.setParameterExampleValue(codegenParameter, body);
        return codegenParameter;
    }

    private void addVarsRequiredVarsAdditionalProps(Schema schema, IJsonSchemaValidationProperties property) {
        this.setAddProps(schema, property);
        if (!"object".equals(schema.getType())) {
            return;
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema objSchema = (ObjectSchema)schema;
            HashSet<String> requiredVars = new HashSet<String>();
            if (objSchema.getRequired() != null) {
                requiredVars.addAll(objSchema.getRequired());
            }
            if (objSchema.getProperties() != null && objSchema.getProperties().size() > 0) {
                property.setHasVars(true);
            }
            this.addVars(property, property.getVars(), objSchema.getProperties(), requiredVars);
            List<CodegenProperty> requireCpVars = property.getVars().stream().filter(p -> Boolean.TRUE.equals(p.required)).collect(Collectors.toList());
            property.setRequiredVars(requireCpVars);
            if (property.getRequiredVars() != null && property.getRequiredVars().size() > 0) {
                property.setHasRequired(true);
            }
        }
    }

    private void addJsonSchemaForBodyRequestInCaseItsNotPresent(CodegenParameter codegenParameter, RequestBody body) {
        if (codegenParameter.jsonSchema == null) {
            codegenParameter.jsonSchema = Json.pretty((Object)body);
        }
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    protected void updateOption(String key, String defaultValue) {
        for (CliOption cliOption : this.cliOptions) {
            if (!cliOption.getOpt().equals(key)) continue;
            cliOption.setDefault(defaultValue);
            break;
        }
    }

    protected void removeOption(String key) {
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!key.equals(this.cliOptions.get(i).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
    }

    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    protected void generateJSONSpecFile(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            objs.put("openapi-json", SerializerUtils.toJsonString(openAPI));
        }
    }

    public void generateYAMLSpecFile(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        String yaml = SerializerUtils.toYamlString(openAPI);
        if (yaml != null) {
            objs.put("openapi-yaml", yaml);
        }
    }

    public boolean isDataTypeString(String dataType) {
        return "String".equals(dataType);
    }

    @Override
    public List<CodegenServer> fromServers(List<Server> servers) {
        if (servers == null) {
            return Collections.emptyList();
        }
        LinkedList<CodegenServer> codegenServers = new LinkedList<CodegenServer>();
        for (Server server : servers) {
            CodegenServer cs = new CodegenServer();
            cs.description = this.escapeText(server.getDescription());
            cs.url = server.getUrl();
            cs.variables = this.fromServerVariables((Map<String, ServerVariable>)server.getVariables());
            codegenServers.add(cs);
        }
        return codegenServers;
    }

    @Override
    public List<CodegenServerVariable> fromServerVariables(Map<String, ServerVariable> variables) {
        if (variables == null) {
            return Collections.emptyList();
        }
        Map<String, String> variableOverrides = this.serverVariableOverrides();
        LinkedList<CodegenServerVariable> codegenServerVariables = new LinkedList<CodegenServerVariable>();
        for (Map.Entry<String, ServerVariable> variableEntry : variables.entrySet()) {
            CodegenServerVariable codegenServerVariable = new CodegenServerVariable();
            ServerVariable variable = variableEntry.getValue();
            List enums = variable.getEnum();
            codegenServerVariable.defaultValue = variable.getDefault();
            codegenServerVariable.description = this.escapeText(variable.getDescription());
            codegenServerVariable.enumValues = enums;
            codegenServerVariable.name = variableEntry.getKey();
            if (variableOverrides != null && !variableOverrides.isEmpty()) {
                String value;
                codegenServerVariable.value = value = variableOverrides.getOrDefault(variableEntry.getKey(), variable.getDefault());
                if (enums != null && !enums.isEmpty() && !enums.contains(value) && this.LOGGER.isWarnEnabled()) {
                    this.LOGGER.warn("Variable override of '{}' is not listed in the enum of allowed values ({}).", (Object)value, (Object)org.apache.commons.lang3.StringUtils.join((Iterable)enums, (String)","));
                }
            } else {
                codegenServerVariable.value = variable.getDefault();
            }
            codegenServerVariables.add(codegenServerVariable);
        }
        return codegenServerVariables;
    }

    protected void setParameterNullable(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null || property == null) {
            return;
        }
        parameter.isNullable = property.isNullable;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        this.LOGGER.debug("Post processing file {} ({})", (Object)file, (Object)fileType);
    }

    @Override
    public boolean isEnablePostProcessFile() {
        return this.enablePostProcessFile;
    }

    @Override
    public void setEnablePostProcessFile(boolean enablePostProcessFile) {
        this.enablePostProcessFile = enablePostProcessFile;
    }

    @Override
    public boolean isEnableMinimalUpdate() {
        return this.enableMinimalUpdate;
    }

    @Override
    public void setEnableMinimalUpdate(boolean enableMinimalUpdate) {
        this.enableMinimalUpdate = enableMinimalUpdate;
    }

    @Override
    public boolean isStrictSpecBehavior() {
        return this.strictSpecBehavior;
    }

    @Override
    public void setStrictSpecBehavior(boolean strictSpecBehavior) {
        this.strictSpecBehavior = strictSpecBehavior;
    }

    @Override
    public FeatureSet getFeatureSet() {
        return this.generatorMetadata.getFeatureSet();
    }

    @Override
    public boolean isRemoveEnumValuePrefix() {
        return this.removeEnumValuePrefix;
    }

    @Override
    public void setRemoveEnumValuePrefix(boolean removeEnumValuePrefix) {
        this.removeEnumValuePrefix = removeEnumValuePrefix;
    }

    public void addOneOfNameExtension(ComposedSchema s, String name) {
        if (s.getOneOf() != null && s.getOneOf().size() > 0) {
            s.addExtension("x-one-of-name", (Object)name);
        }
    }

    public void addOneOfInterfaceModel(ComposedSchema cs, String type, OpenAPI openAPI) {
        if (cs.getOneOf() == null) {
            return;
        }
        CodegenModel cm = new CodegenModel();
        cm.discriminator = this.createDiscriminator("", (Schema)cs, openAPI);
        if (!this.getLegacyDiscriminatorBehavior().booleanValue()) {
            cm.addDiscriminatorMappedModelsImports();
        }
        for (Schema o : Optional.ofNullable(cs.getOneOf()).orElse(Collections.emptyList())) {
            if (o.get$ref() == null) {
                if (cm.discriminator != null && o.get$ref() == null) {
                    this.LOGGER.warn("Ignoring inline object in oneOf definition of {}, since discriminator is used", (Object)type);
                    continue;
                }
                this.LOGGER.warn("Inline models are not supported in oneOf definition right now");
                continue;
            }
            cm.oneOf.add(this.toModelName(ModelUtils.getSimpleRef(o.get$ref())));
        }
        cm.name = type;
        cm.classname = type;
        cm.vendorExtensions.put("x-is-one-of-interface", true);
        cm.interfaceModels = new ArrayList<CodegenModel>();
        this.addOneOfInterfaces.add(cm);
    }

    public void addImportsToOneOfInterface(List<Map<String, String>> imports) {
    }

    protected void modifyFeatureSet(Consumer<FeatureSet.Builder> processor) {
        FeatureSet.Builder builder = this.getFeatureSet().modify();
        processor.accept(builder);
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).featureSet(builder.build()).build();
    }

    public boolean isAnyTypeSchema(Schema schema) {
        if (schema == null) {
            OnceLogger.once(this.LOGGER).error("Schema cannot be null in isAnyTypeSchema check");
            return false;
        }
        if (this.isFreeFormObject(schema)) {
            return false;
        }
        return schema.getClass().equals(Schema.class) && schema.get$ref() == null && schema.getType() == null && (schema.getProperties() == null || schema.getProperties().isEmpty()) && schema.getAdditionalProperties() == null && schema.getNot() == null && schema.getEnum() == null;
    }

    protected boolean isFreeFormObject(Schema schema) {
        return ModelUtils.isFreeFormObject(this.openAPI, schema);
    }

    protected Schema getAdditionalProperties(Schema schema) {
        return ModelUtils.getAdditionalProperties(this.openAPI, schema);
    }

    protected static boolean isJsonMimeType(String mime) {
        return mime != null && JSON_MIME_PATTERN.matcher(mime).matches();
    }

    protected static boolean isJsonVendorMimeType(String mime) {
        return mime != null && JSON_VENDOR_MIME_PATTERN.matcher(mime).matches();
    }

    protected String getCollectionFormat(CodegenParameter codegenParameter) {
        return null;
    }

    static {
        int cacheSize = Integer.parseInt(GlobalSettings.getProperty("org.openapitools.codegen.utils.namecache.cachesize", "500"));
        int cacheExpiry = Integer.parseInt(GlobalSettings.getProperty("org.openapitools.codegen.utils.namecache.expireafter.seconds", "10"));
        sanitizedNameCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
        JSON_VENDOR_MIME_PATTERN = Pattern.compile("(?i)application\\/vnd.(.*)+json(;.*)?");
        COMMON_PREFIX_ENUM_NAME = Pattern.compile("[a-zA-Z0-9]+\\z");
    }

    private static class SanitizeNameOptions {
        private String name;
        private String removeCharRegEx;
        private List<String> exceptions;

        public SanitizeNameOptions(String name, String removeCharRegEx, List<String> exceptions) {
            this.name = name;
            this.removeCharRegEx = removeCharRegEx;
            this.exceptions = exceptions != null ? Collections.unmodifiableList(exceptions) : Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public String getRemoveCharRegEx() {
            return this.removeCharRegEx;
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SanitizeNameOptions that = (SanitizeNameOptions)o;
            return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getRemoveCharRegEx(), that.getRemoveCharRegEx()) && Objects.equals(this.getExceptions(), that.getExceptions());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getRemoveCharRegEx(), this.getExceptions());
        }
    }

    private static class NamedSchema {
        private String name;
        private Schema schema;

        private NamedSchema(String name, Schema s) {
            this.name = name;
            this.schema = s;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedSchema that = (NamedSchema)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.schema);
        }
    }
}

