/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPythonCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonConnexionServerCodegen
extends AbstractPythonCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractPythonConnexionServerCodegen.class);
    public static final String CONTROLLER_PACKAGE = "controllerPackage";
    public static final String DEFAULT_CONTROLLER = "defaultController";
    public static final String SUPPORT_PYTHON2 = "supportPython2";
    public static final String FEATURE_CORS = "featureCORS";
    public static final String USE_NOSE = "useNose";
    public static final String PYTHON_SRC_ROOT = "pythonSrcRoot";
    public static final String USE_PYTHON_SRC_ROOT_IN_IMPORTS = "usePythonSrcRootInImports";
    public static final String MOVE_TESTS_UNDER_PYTHON_SRC_ROOT = "testsUsePythonSrcRoot";
    static final String MEDIA_TYPE = "mediaType";
    protected int serverPort = 8080;
    protected String controllerPackage;
    protected String defaultController;
    protected Map<Character, String> regexModifiers;
    protected boolean fixBodyName;
    protected boolean featureCORS = Boolean.FALSE;
    protected boolean useNose = Boolean.FALSE;
    protected String pythonSrcRoot;
    protected boolean usePythonSrcRootInImports = Boolean.FALSE;
    protected boolean moveTestsUnderPythonSrcRoot = Boolean.FALSE;

    public AbstractPythonConnexionServerCodegen(String templateDirectory, boolean fixBodyNameValue) {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.fixBodyName = fixBodyNameValue;
        this.modelPackage = "models";
        this.testPackage = "test";
        this.languageSpecificPrimitives.add("List");
        this.languageSpecificPrimitives.add("Dict");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.outputFolder = "generated-code" + File.separatorChar + "connexion";
        this.apiTemplateFiles.put("controller.mustache", ".py");
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTestTemplateFiles().put("controller_test.mustache", ".py");
        this.embeddedTemplateDir = this.templateDir = templateDirectory;
        this.additionalProperties.put("serverPort", this.serverPort);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
        this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_server"));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(CONTROLLER_PACKAGE, "controller package").defaultValue("controllers"));
        this.cliOptions.add(new CliOption(DEFAULT_CONTROLLER, "default controller").defaultValue("default_controller"));
        this.cliOptions.add(new CliOption(SUPPORT_PYTHON2, "support python2. This option has been deprecated and will be removed in the 5.x release.").defaultValue("false"));
        this.cliOptions.add(new CliOption("serverPort", "TCP port to listen to in app.run").defaultValue("8080"));
        this.cliOptions.add(CliOption.newBoolean(FEATURE_CORS, "use flask-cors for handling CORS requests").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(USE_NOSE, "use the nose test framework").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(PYTHON_SRC_ROOT, "put python sources in this subdirectory of output folder (defaults to \"\" for). Use this for src/ layout.").defaultValue(""));
        this.cliOptions.add(new CliOption(USE_PYTHON_SRC_ROOT_IN_IMPORTS, "include pythonSrcRoot in import namespaces.").defaultValue("false"));
        this.cliOptions.add(new CliOption(MOVE_TESTS_UNDER_PYTHON_SRC_ROOT, "generates test under the pythonSrcRoot folder.").defaultValue("false"));
    }

    protected void addSupportingFiles() {
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi_server");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey(CONTROLLER_PACKAGE)) {
            this.controllerPackage = this.additionalProperties.get(CONTROLLER_PACKAGE).toString();
        } else {
            this.controllerPackage = "controllers";
            this.additionalProperties.put(CONTROLLER_PACKAGE, this.controllerPackage);
        }
        if (this.additionalProperties.containsKey(DEFAULT_CONTROLLER)) {
            this.defaultController = this.additionalProperties.get(DEFAULT_CONTROLLER).toString();
        } else {
            this.defaultController = "default_controller";
            this.additionalProperties.put(DEFAULT_CONTROLLER, this.defaultController);
        }
        if (Boolean.TRUE.equals(this.additionalProperties.get(SUPPORT_PYTHON2))) {
            this.additionalProperties.put(SUPPORT_PYTHON2, Boolean.TRUE);
            this.typeMapping.put("long", "long");
        }
        if (this.additionalProperties.containsKey(FEATURE_CORS)) {
            this.setFeatureCORS((String)this.additionalProperties.get(FEATURE_CORS));
        }
        if (this.additionalProperties.containsKey(USE_NOSE)) {
            this.setUseNose((String)this.additionalProperties.get(USE_NOSE));
        }
        if (this.additionalProperties.containsKey(USE_PYTHON_SRC_ROOT_IN_IMPORTS)) {
            this.setUsePythonSrcRootInImports((String)this.additionalProperties.get(USE_PYTHON_SRC_ROOT_IN_IMPORTS));
        }
        if (this.additionalProperties.containsKey(MOVE_TESTS_UNDER_PYTHON_SRC_ROOT)) {
            this.setMoveTestsUnderPythonSrcRoot((String)this.additionalProperties.get(MOVE_TESTS_UNDER_PYTHON_SRC_ROOT));
        }
        if (this.additionalProperties.containsKey(PYTHON_SRC_ROOT)) {
            String pythonSrcRoot = (String)this.additionalProperties.get(PYTHON_SRC_ROOT);
            if (this.moveTestsUnderPythonSrcRoot) {
                this.testPackage = pythonSrcRoot + "." + this.testPackage;
            }
            if (this.usePythonSrcRootInImports) {
                this.setPackageName(pythonSrcRoot + "." + this.packageName);
                pythonSrcRoot = "";
            }
            this.setPythonSrcRoot(pythonSrcRoot);
        } else {
            this.setPythonSrcRoot("");
        }
        this.supportingFiles.add(new SupportingFile("__main__.mustache", this.packagePath(), "__main__.py"));
        this.supportingFiles.add(new SupportingFile("util.mustache", this.packagePath(), "util.py"));
        this.supportingFiles.add(new SupportingFile("typing_utils.mustache", this.packagePath(), "typing_utils.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.controllerPackage), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("security_controller_.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.controllerPackage), "security_controller_.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.modelPackage), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("base_model_.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.modelPackage), "base_model_.py"));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", this.packagePath() + File.separatorChar + "openapi", "openapi.yaml"));
        this.addSupportingFiles();
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.controllerPackage = this.packageName + "." + this.controllerPackage;
    }

    public void setFeatureCORS(String val) {
        this.featureCORS = Boolean.parseBoolean(val);
    }

    public void setUseNose(String val) {
        this.useNose = Boolean.parseBoolean(val);
    }

    public void setPythonSrcRoot(String val) {
        String pySrcRoot = val == null ? "" : val.replaceAll("[/\\\\]+$", "");
        this.pythonSrcRoot = pySrcRoot.isEmpty() || ".".equals(pySrcRoot) ? "" : pySrcRoot + File.separator;
        this.additionalProperties.put(PYTHON_SRC_ROOT, org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.pythonSrcRoot, null));
    }

    public void setUsePythonSrcRootInImports(String val) {
        this.usePythonSrcRootInImports = Boolean.parseBoolean(val);
    }

    public void setMoveTestsUnderPythonSrcRoot(String val) {
        this.moveTestsUnderPythonSrcRoot = Boolean.parseBoolean(val);
    }

    public String pythonSrcOutputFolder() {
        return this.outputFolder + File.separator + this.pythonSrcRoot;
    }

    private static String packageToPath(String pkg) {
        return pkg.replace(".", File.separator);
    }

    @Override
    public String apiPackage() {
        return this.controllerPackage;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getHelp() {
        return "Generates a Python server library using the Connexion project. By default, it will also generate service classes -- which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name == null || name.length() == 0) {
            return "DefaultController";
        }
        return StringUtils.camelize(name, false) + "Controller";
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String apiFileFolder() {
        String pkgPath = this.apiPackage().replace('.', File.separatorChar);
        return this.pythonSrcOutputFolder() + pkgPath;
    }

    @Override
    public String modelFileFolder() {
        String pkgPath = this.modelPackage().replace('.', File.separatorChar);
        return this.pythonSrcOutputFolder() + pkgPath;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            ArrayList pathnames = new ArrayList(paths.keySet());
            for (String pathname : pathnames) {
                Map operationMap;
                PathItem path = (PathItem)paths.get(pathname);
                if (pathname.contains("{")) {
                    String fixedPath = "";
                    for (String string : pathname.substring(1).split("/")) {
                        void var11_16;
                        String snake_case_token;
                        if (string.startsWith("{") && !string.equals(snake_case_token = "{" + this.toParamName(string.substring(1, string.length() - 1)) + "}")) {
                            String string2 = snake_case_token;
                        }
                        fixedPath = fixedPath + "/" + (String)var11_16;
                    }
                    if (!fixedPath.equals(pathname)) {
                        this.LOGGER.warn("Path '{}' is not consistent with Python variable names. It will be replaced by '{}'", (Object)pathname, (Object)fixedPath);
                        paths.remove(pathname);
                        path.addExtension("x-python-connexion-openapi-name", (Object)pathname);
                        paths.put(fixedPath, path);
                    }
                }
                if ((operationMap = path.readOperationsMap()) == null) continue;
                for (Map.Entry entry : operationMap.entrySet()) {
                    String operationId;
                    PathItem.HttpMethod method = (PathItem.HttpMethod)entry.getKey();
                    Operation operation = (Operation)entry.getValue();
                    String tag = "default";
                    if (operation.getTags() != null && operation.getTags().size() > 0) {
                        tag = (String)operation.getTags().get(0);
                    }
                    if ((operationId = operation.getOperationId()) == null) {
                        operationId = this.getOrGenerateOperationId(operation, pathname, method.toString());
                    }
                    operation.setOperationId(this.toOperationId(operationId));
                    if (operation.getExtensions() == null || operation.getExtensions().get("x-openapi-router-controller") == null) {
                        operation.addExtension("x-openapi-router-controller", (Object)(this.controllerPackage + "." + this.toApiFilename(tag)));
                    }
                    if (operation.getParameters() != null) {
                        for (Parameter parameter : operation.getParameters()) {
                            String pythonParameterName;
                            String swaggerParameterName = parameter.getName();
                            if (!swaggerParameterName.equals(pythonParameterName = this.toParamName(swaggerParameterName))) {
                                this.LOGGER.warn("Parameter name '{}' is not consistent with Python variable names. It will be replaced by '{}'", (Object)swaggerParameterName, (Object)pythonParameterName);
                                parameter.addExtension("x-python-connexion-openapi-name", (Object)swaggerParameterName);
                                parameter.setName(pythonParameterName);
                            }
                            if (!swaggerParameterName.isEmpty()) continue;
                            this.LOGGER.error("Missing parameter name in {}.{}", (Object)pathname, (Object)parameter.getIn());
                        }
                    }
                    RequestBody body = operation.getRequestBody();
                    if (!this.fixBodyName || body == null || body.getExtensions() != null && body.getExtensions().containsKey("x-body-name")) continue;
                    String bodyParameterName = "body";
                    if (operation.getExtensions() != null && operation.getExtensions().containsKey("x-codegen-request-body-name")) {
                        bodyParameterName = (String)operation.getExtensions().get("x-codegen-request-body-name");
                    } else {
                        operation.addExtension("x-codegen-request-body-name", (Object)bodyParameterName);
                    }
                    body.addExtension("x-body-name", (Object)bodyParameterName);
                }
            }
            ArrayList fixedPathnames = new ArrayList(paths.keySet());
            Collections.sort(fixedPathnames);
            for (String pathname : fixedPathnames) {
                PathItem pathItem = (PathItem)paths.remove(pathname);
                paths.put(pathname, pathItem);
            }
        }
        this.addSecurityExtensions(openAPI);
    }

    private void addSecurityExtension(SecurityScheme securityScheme, String extensionName, String functionName) {
        if (securityScheme.getExtensions() == null || !securityScheme.getExtensions().containsKey(extensionName)) {
            securityScheme.addExtension(extensionName, (Object)functionName);
        }
    }

    private void addSecurityExtensions(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components != null && components.getSecuritySchemes() != null) {
            Map securitySchemes = components.getSecuritySchemes();
            block6: for (Map.Entry securitySchemesEntry : securitySchemes.entrySet()) {
                String securityName = (String)securitySchemesEntry.getKey();
                SecurityScheme securityScheme = (SecurityScheme)securitySchemesEntry.getValue();
                String baseFunctionName = this.controllerPackage + ".security_controller_.";
                switch (securityScheme.getType()) {
                    case APIKEY: {
                        this.addSecurityExtension(securityScheme, "x-apikeyInfoFunc", baseFunctionName + "info_from_" + securityName);
                        continue block6;
                    }
                    case HTTP: {
                        if ("basic".equals(securityScheme.getScheme())) {
                            this.addSecurityExtension(securityScheme, "x-basicInfoFunc", baseFunctionName + "info_from_" + securityName);
                            continue block6;
                        }
                        if (!"bearer".equals(securityScheme.getScheme())) continue block6;
                        this.addSecurityExtension(securityScheme, "x-bearerInfoFunc", baseFunctionName + "info_from_" + securityName);
                        continue block6;
                    }
                    case OPENIDCONNECT: {
                        this.LOGGER.warn("Security type {} is not supported by connexion yet", (Object)securityScheme.getType().toString());
                    }
                    case OAUTH2: {
                        this.addSecurityExtension(securityScheme, "x-tokenInfoFunc", baseFunctionName + "info_from_" + securityName);
                        this.addSecurityExtension(securityScheme, "x-scopeValidateFunc", baseFunctionName + "validate_scope_" + securityName);
                        continue block6;
                    }
                }
                this.LOGGER.warn("Unknown security type {}", (Object)securityScheme.getType().toString());
            }
        }
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList arrayList = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
        }
        return opsByPathList;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            ArrayList pathnames = new ArrayList(paths.keySet());
            for (Object pythonPathname : pathnames) {
                Map operationMap;
                String openapiPathname;
                PathItem path = (PathItem)paths.get(pythonPathname);
                Map pathExtensions = path.getExtensions();
                if (pathExtensions != null && (openapiPathname = (String)pathExtensions.remove("x-python-connexion-openapi-name")) != null && !openapiPathname.equals(pythonPathname)) {
                    this.LOGGER.info("Path '{}' is not consistent with the original OpenAPI definition. It will be replaced back by '{}'", pythonPathname, (Object)openapiPathname);
                    paths.remove(pythonPathname);
                    paths.put(openapiPathname, path);
                }
                if ((operationMap = path.readOperationsMap()) == null) continue;
                for (Map.Entry operationMapEntry : operationMap.entrySet()) {
                    PathItem.HttpMethod method = (PathItem.HttpMethod)operationMapEntry.getKey();
                    Operation operation = (Operation)operationMapEntry.getValue();
                    if (operation.getParameters() == null) continue;
                    for (Parameter parameter : operation.getParameters()) {
                        Map parameterExtensions = parameter.getExtensions();
                        if (parameterExtensions == null) continue;
                        String swaggerParameterName = (String)parameterExtensions.remove("x-python-connexion-openapi-name");
                        if (swaggerParameterName != null) {
                            String pythonParameterName = parameter.getName();
                            if (!swaggerParameterName.equals(pythonParameterName)) {
                                this.LOGGER.info("Reverting name of parameter '{}' of operation '{}' back to '{}'", new Object[]{pythonParameterName, operation.getOperationId(), swaggerParameterName});
                                parameter.setName(swaggerParameterName);
                                continue;
                            }
                            this.LOGGER.debug("Name of parameter '{}' of operation '{}' was unchanged.", (Object)pythonParameterName, (Object)operation.getOperationId());
                            continue;
                        }
                        this.LOGGER.debug("x-python-connexion-openapi-name was not set on parameter '{}' of operation '{}'", (Object)parameter.getName(), (Object)operation.getOperationId());
                    }
                }
            }
            ArrayList recoveredPathnames = new ArrayList(paths.keySet());
            Collections.sort(recoveredPathnames);
            for (String pathname : recoveredPathnames) {
                PathItem pathItem = (PathItem)paths.remove(pathname);
                paths.put(pathname, pathItem);
            }
        }
        this.generateJSONSpecFile(objs);
        this.generateYAMLSpecFile(objs);
        for (Map<String, Object> operations : AbstractPythonConnexionServerCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = AbstractPythonConnexionServerCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    public String packagePath() {
        String pkgPath = this.packageName.replace('.', File.separatorChar);
        return this.pythonSrcRoot + pkgPath;
    }

    @Override
    public String toModelImport(String name) {
        String modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = modelImport + this.modelPackage() + ".";
            }
            modelImport = modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)property.pattern)) {
            this.addImport(model, "import re");
        }
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                mo.put("pyImports", this.toPyImports(cm, cm.imports));
            }
        }
        return result;
    }

    private List<Map<String, String>> toPyImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> pyImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> pyImport = new HashMap<String, String>();
            pyImport.put("import", this.toModelImport(im));
            pyImports.add(pyImport);
        }
        return pyImports;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation operation : operationList) {
            Map<Object, Object> consume;
            HashMap<String, String> skipTests = new HashMap<String, String>();
            if (operation.consumes != null) {
                if (operation.consumes.size() == 1) {
                    consume = operation.consumes.get(0);
                    if (!"application/json".equals(consume.get(MEDIA_TYPE)) && !((String)consume.get(MEDIA_TYPE)).endsWith("+json")) {
                        skipTests.put("reason", (String)consume.get(MEDIA_TYPE) + " not supported by Connexion");
                        if ("multipart/form-data".equals(consume.get(MEDIA_TYPE))) {
                            operation.isMultipart = Boolean.TRUE;
                        }
                    }
                    operation.vendorExtensions.put("x-preferred-consume", consume);
                } else if (operation.consumes.size() > 1) {
                    consume = operation.consumes.get(0);
                    skipTests.put("reason", "Connexion does not support multiple consumes. See https://github.com/zalando/connexion/pull/760");
                    operation.vendorExtensions.put("x-preferred-consume", consume);
                    if ("multipart/form-data".equals(consume.get(MEDIA_TYPE))) {
                        operation.isMultipart = Boolean.TRUE;
                    }
                }
            } else if (operation.bodyParam != null) {
                consume = new HashMap<String, String>();
                consume.put(MEDIA_TYPE, "application/json");
                operation.vendorExtensions.put("x-preferred-consume", consume);
                skipTests.put("reason", "*/* not supported by Connexion. Use application/json instead. See https://github.com/zalando/connexion/pull/760");
            }
            if (operation.produces != null) {
                for (Map<String, String> produce : operation.produces) {
                    operation.vendorExtensions.put("x-preferred-produce", produce);
                    if (!produce.get(MEDIA_TYPE).equals("application/json")) continue;
                    break;
                }
            }
            if (!skipTests.isEmpty()) {
                operation.vendorExtensions.put("x-skip-test", skipTests);
            }
            if (operation.requestBodyExamples == null) continue;
            for (Map<String, String> example : operation.requestBodyExamples) {
                if (example.get("contentType") == null || !example.get("contentType").equals("application/json")) continue;
                operation.bodyParam.example = example.get("example");
            }
        }
        return objs;
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }
}

