/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;

public class AvroSchemaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String AVRO = "avro-schema";
    protected String packageName = "model";

    public AvroSchemaCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.parameterFeatures(EnumSet.noneOf(ParameterFeature.class)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).wireFormatFeatures(EnumSet.noneOf(WireFormatFeature.class)).documentationFeatures(EnumSet.noneOf(DocumentationFeature.class)).globalFeatures(EnumSet.noneOf(GlobalFeature.class)).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism, SchemaSupportFeature.Union}).clientModificationFeatures(EnumSet.noneOf(ClientModificationFeature.class)));
        this.outputFolder = "generated-code/avro-schema";
        this.modelTemplateFiles.put("model.mustache", ".avsc");
        this.modelPackage = this.packageName;
        this.importMapping.clear();
        this.templateDir = AVRO;
        this.embeddedTemplateDir = AVRO;
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("null", "boolean", "int", "integer", "long", "float", "double", "bytes", "string", "BigDecimal", "UUID", "number", "date", "DateTime"));
        this.defaultIncludes = new HashSet(this.languageSpecificPrimitives);
        this.instantiationTypes.put("array", "Array");
        this.instantiationTypes.put("list", "Array");
        this.instantiationTypes.put("map", "Object");
        this.typeMapping.clear();
        this.typeMapping.put("number", "double");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("ByteArray", "bytes");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("BigDecimal", "string");
        this.cliOptions.add(new CliOption("packageName", "package for generated classes (where supported)"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.modelPackage = this.packageName = (String)this.additionalProperties.get("packageName");
        }
        this.additionalProperties.put("packageName", this.packageName);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SCHEMA;
    }

    @Override
    public String getName() {
        return AVRO;
    }

    @Override
    public String getHelp() {
        return "Generates a Avro model (beta).";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        super.setNonArrayMapProperty(property, type);
        if (property.isModel) {
            property.dataType = StringUtils.camelize(this.modelNamePrefix + property.dataType + this.modelNameSuffix);
        }
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }
}

