/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlantumlDocumentationCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String ALL_OF_SUFFIX = "AllOf";
    final Logger LOGGER = LoggerFactory.getLogger(PlantumlDocumentationCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "plantuml";
    }

    @Override
    public String getHelp() {
        return "Generates a plantuml documentation.";
    }

    public PlantumlDocumentationCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "plantuml";
        this.templateDir = "plantuml";
        this.embeddedTemplateDir = "plantuml";
        this.supportingFiles.add(new SupportingFile("schemas.mustache", "", "schemas.plantuml"));
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Object models = objs.get("models");
        List modelsList = (List)models;
        List codegenModelList = modelsList.stream().filter(listItem -> listItem instanceof HashMap).map(listItem -> (CodegenModel)((HashMap)listItem).get("model")).collect(Collectors.toList());
        List<CodegenModel> inlineAllOfCodegenModelList = codegenModelList.stream().filter(codegenModel -> codegenModel.getClassname().endsWith(ALL_OF_SUFFIX)).collect(Collectors.toList());
        List<CodegenModel> nonInlineAllOfCodegenModelList = codegenModelList.stream().filter(codegenModel -> !codegenModel.getClassname().endsWith(ALL_OF_SUFFIX)).collect(Collectors.toList());
        List<CodegenModel> subtypeCodegenModelList = codegenModelList.stream().filter(codegenModel -> !codegenModel.allOf.isEmpty()).collect(Collectors.toList());
        List<Map<String, Object>> entities = this.calculateEntities(nonInlineAllOfCodegenModelList, inlineAllOfCodegenModelList);
        objs.put("entities", entities);
        List<Map<String, Object>> relationships = this.calculateCompositionRelationshipsFrom(entities);
        objs.put("relationships", relationships);
        List<Object> inheritances = this.calculateInheritanceRelationships(subtypeCodegenModelList);
        objs.put("inheritances", inheritances);
        return super.postProcessSupportingFileData(objs);
    }

    private List<Map<String, Object>> calculateEntities(List<CodegenModel> nonInlineAllOfCodegenModelList, List<CodegenModel> inlineAllOfCodegenModelList) {
        Map<String, CodegenModel> inlineAllOfCodegenModelMap = inlineAllOfCodegenModelList.stream().collect(Collectors.toMap(cm -> cm.getClassname(), cm -> cm));
        return nonInlineAllOfCodegenModelList.stream().map(codegenModel -> this.createEntityFor((CodegenModel)codegenModel, inlineAllOfCodegenModelMap)).collect(Collectors.toList());
    }

    private Map<String, Object> createEntityFor(CodegenModel nonInlineAllOfCodegenModel, Map<String, CodegenModel> inlineAllOfCodegenModelMap) {
        if (nonInlineAllOfCodegenModel.allOf.isEmpty()) {
            return this.createEntityFor(nonInlineAllOfCodegenModel, nonInlineAllOfCodegenModel.getAllVars());
        }
        Optional<String> inheritingInlineAllOfName = nonInlineAllOfCodegenModel.allOf.stream().filter(allOfName -> allOfName.endsWith(ALL_OF_SUFFIX)).findFirst();
        if (inheritingInlineAllOfName.isPresent() && inlineAllOfCodegenModelMap.containsKey(inheritingInlineAllOfName.get())) {
            CodegenModel inheritingInlineAllOfModel = inlineAllOfCodegenModelMap.get(inheritingInlineAllOfName.get());
            return this.createEntityFor(nonInlineAllOfCodegenModel, inheritingInlineAllOfModel.getAllVars());
        }
        return this.createEntityFor(nonInlineAllOfCodegenModel, Collections.emptyList());
    }

    private Map<String, Object> createEntityFor(CodegenModel codegenModel, List<CodegenProperty> properties) {
        HashMap<String, Object> entity = new HashMap<String, Object>();
        entity.put("name", this.removeSuffix(codegenModel.getClassname(), ALL_OF_SUFFIX));
        List fields = properties.stream().map(var -> this.createFieldFor((CodegenProperty)var)).collect(Collectors.toList());
        entity.put("fields", fields);
        return entity;
    }

    private Object createFieldFor(CodegenProperty codegenProperty) {
        HashMap<String, Object> field = new HashMap<String, Object>();
        field.put("name", codegenProperty.getBaseName());
        field.put("isRequired", codegenProperty.getRequired());
        field.put("isList", codegenProperty.isArray);
        field.put("complexDataType", this.getComplexDataTypeFor(codegenProperty));
        String dataType = codegenProperty.isArray && codegenProperty.getItems() != null ? "List<" + this.toModelName(codegenProperty.getItems().getDataType()) + ">" : this.toModelName(codegenProperty.getDataType());
        field.put("dataType", dataType);
        return field;
    }

    private List<Map<String, Object>> calculateCompositionRelationshipsFrom(List<Map<String, Object>> entities) {
        Map<String, List> entityFieldsMap = entities.stream().collect(Collectors.toMap(entity -> (String)entity.get("name"), entity -> (List)entity.get("fields")));
        return entityFieldsMap.entrySet().stream().map(entry -> this.createRelationshipsFor((String)entry.getKey(), (List)entry.getValue())).flatMap(relationshipList -> relationshipList.stream()).collect(Collectors.toList());
    }

    private List<Map<String, Object>> createRelationshipsFor(String entityName, List<Map<String, Object>> fields) {
        return fields.stream().filter(field -> field.get("complexDataType") != null).map(complexField -> this.createRelationshipFor((Map<String, Object>)complexField, entityName)).collect(Collectors.toList());
    }

    private Map<String, Object> createRelationshipFor(Map<String, Object> complexField, String entityName) {
        HashMap<String, Object> relationship = new HashMap<String, Object>();
        relationship.put("parent", entityName);
        relationship.put("child", complexField.get("complexDataType"));
        relationship.put("name", complexField.get("name"));
        relationship.put("isList", complexField.get("isList"));
        return relationship;
    }

    private String getComplexDataTypeFor(CodegenProperty codegenProperty) {
        if (codegenProperty.isModel) {
            return this.toModelName(codegenProperty.getDataType());
        }
        if (codegenProperty.isArray && codegenProperty.getItems().isModel) {
            return this.toModelName(codegenProperty.getItems().getDataType());
        }
        return null;
    }

    private List<Object> calculateInheritanceRelationships(List<CodegenModel> subtypeCodegenModelList) {
        return subtypeCodegenModelList.stream().map(subtypeModel -> this.getInterfacesForSubtype((CodegenModel)subtypeModel)).flatMap(subTypeInterfaces -> ((List)subTypeInterfaces.getValue()).stream().map(parent -> this.createInheritance((String)parent, (String)subTypeInterfaces.getKey()))).collect(Collectors.toList());
    }

    private Map.Entry<String, List<String>> getInterfacesForSubtype(CodegenModel subtypeModel) {
        List interfaceList = subtypeModel.getInterfaces().stream().filter(inf -> !inf.endsWith(ALL_OF_SUFFIX)).collect(Collectors.toList());
        return new AbstractMap.SimpleEntry<String, List<String>>(subtypeModel.getClassname(), interfaceList);
    }

    private Object createInheritance(String parentName, String childName) {
        HashMap<String, String> inheritance = new HashMap<String, String>();
        inheritance.put("parent", parentName);
        inheritance.put("child", childName);
        return inheritance;
    }

    private String removeSuffix(String value, String suffix) {
        if (value != null && suffix != null && value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

