/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpReducedClientCodegen
extends AbstractCSharpCodegen {
    protected static final String MCS_NET_VERSION_KEY = "x-mcs-sdk";
    protected static final String SUPPORTS_UWP = "supportsUWP";
    protected static final String SUPPORTS_RETRY = "supportsRetry";
    protected static final String NET_STANDARD = "netStandard";
    protected static final String RESTSHARP = "restsharp";
    protected static final String HTTPCLIENT = "httpclient";
    protected static final String TARGET_FRAMEWORK_IDENTIFIER = "targetFrameworkIdentifier";
    protected static final String TARGET_FRAMEWORK_VERSION = "targetFrameworkVersion";
    private final Logger LOGGER = LoggerFactory.getLogger(CSharpReducedClientCodegen.class);
    private static final List<FrameworkStrategy> frameworkStrategies = Arrays.asList(FrameworkStrategy.NETSTANDARD_1_3, FrameworkStrategy.NETSTANDARD_1_4, FrameworkStrategy.NETSTANDARD_1_5, FrameworkStrategy.NETSTANDARD_1_6, FrameworkStrategy.NETSTANDARD_2_0, FrameworkStrategy.NETSTANDARD_2_1, FrameworkStrategy.NETCOREAPP_2_0, FrameworkStrategy.NETCOREAPP_2_1, FrameworkStrategy.NETFRAMEWORK_4_7, FrameworkStrategy.NET_5_0);
    private static FrameworkStrategy defaultFramework = FrameworkStrategy.NETSTANDARD_2_0;
    protected final Map<String, String> frameworks;
    protected String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected String clientPackage = "Org.OpenAPITools.Client";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String targetFramework;
    protected String testTargetFramework;
    protected String targetFrameworkNuget;
    protected boolean supportsRetry;
    protected boolean supportsAsync;
    protected boolean netStandard;
    protected boolean validatable;
    protected Map<Character, String> regexModifiers;
    protected boolean nonPublicApi;
    protected boolean caseInsensitiveResponseHeaders;
    protected String releaseNote;
    protected String licenseId;
    protected String packageTags;
    protected boolean useOneOfDiscriminatorLookup;
    protected boolean needsCustomHttpMethod;
    protected boolean needsUriBuilder;

    public CSharpReducedClientCodegen() {
        this.targetFramework = CSharpReducedClientCodegen.defaultFramework.name;
        this.testTargetFramework = CSharpReducedClientCodegen.defaultFramework.testTargetFramework;
        this.targetFrameworkNuget = this.targetFramework;
        this.supportsRetry = Boolean.TRUE;
        this.supportsAsync = Boolean.TRUE;
        this.netStandard = Boolean.FALSE;
        this.validatable = Boolean.TRUE;
        this.nonPublicApi = Boolean.FALSE;
        this.caseInsensitiveResponseHeaders = Boolean.FALSE;
        this.releaseNote = "Minor update";
        this.useOneOfDiscriminatorLookup = false;
        this.needsCustomHttpMethod = false;
        this.needsUriBuilder = false;
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.SignatureAuth)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.setSupportNullable(Boolean.TRUE);
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "csharp-netcore";
        this.embeddedTemplateDir = "csharp-netcore";
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("interfacePrefix", "Prefix interfaces with a community standard or widely accepted prefix.", this.interfacePrefix);
        this.addOption("licenseId", "The identifier of the license", this.licenseId);
        this.addOption("releaseNote", "Release note, default to 'Minor update'.", this.releaseNote);
        this.addOption("packageTags", "Tags to identify the package", this.packageTags);
        CliOption framework = new CliOption("targetFramework", "The target .NET framework version. To target multiple frameworks, use `;` as the separator, e.g. `netstandard2.1;netcoreapp3.1`");
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
        ImmutableMap.Builder frameworkBuilder = new ImmutableMap.Builder();
        for (FrameworkStrategy frameworkStrategy : frameworkStrategies) {
            frameworkBuilder.put((Object)frameworkStrategy.name, (Object)frameworkStrategy.description);
        }
        this.frameworks = frameworkBuilder.build();
        framework.defaultValue(this.targetFramework);
        framework.setEnum(this.frameworks);
        this.cliOptions.add(framework);
        CliOption modelPropertyNaming = new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name");
        this.cliOptions.add(modelPropertyNaming.defaultValue("PascalCase"));
        this.addSwitch("nullableReferenceTypes", "Use nullable annotations in the project. Only supported on C# 8 / ASP.NET Core 3.1 or newer.", this.nullReferenceTypesFlag);
        this.addSwitch("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.", this.hideGenerationTimestamp);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch("optionalMethodArgument", "C# Optional method argument, e.g. void square(int x=10) (.net 4.0+ only).", this.optionalMethodArgumentFlag);
        this.addSwitch("optionalAssemblyInfo", "Generate AssemblyInfo.cs.", this.optionalAssemblyInfoFlag);
        this.addSwitch("optionalEmitDefaultValues", "Set DataMember's EmitDefaultValue.", this.optionalEmitDefaultValuesFlag);
        this.addSwitch("conditionalSerialization", "Serialize only those properties which are initialized by user, accepted values are true or false, default value is false.", this.conditionalSerialization);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("nonPublicApi", "Generates code with reduced access modifiers; allows embedding elsewhere without exposing non-public API calls to consumers.", this.nonPublicApi);
        this.addSwitch("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false", this.allowUnicodeIdentifiers);
        this.addSwitch("netCoreProjectFile", "Use the new format (.NET Core) for .NET project files (.csproj).", this.netCoreProjectFileFlag);
        this.addSwitch("validatable", "Generates self-validatable models.", this.validatable);
        this.addSwitch("useOneOfDiscriminatorLookup", "Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and only one match in oneOf's schemas) will be skipped.", this.caseInsensitiveResponseHeaders);
        this.addSwitch("caseInsensitiveResponseHeaders", "Make API response's headers case-insensitive", this.caseInsensitiveResponseHeaders);
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IgnoreCase");
        this.regexModifiers.put(Character.valueOf('m'), "Multiline");
        this.regexModifiers.put(Character.valueOf('s'), "Singleline");
        this.regexModifiers.put(Character.valueOf('x'), "IgnorePatternWhitespace");
        this.supportedLibraries.put(HTTPCLIENT, "HttpClient (https://docs.microsoft.com/en-us/dotnet/api/system.net.http.httpclient) (Experimental. May subject to breaking changes without further notice.)");
        this.supportedLibraries.put(RESTSHARP, "RestSharp (https://github.com/restsharp/RestSharp)");
        CliOption libraryOption = new CliOption("library", "HTTP library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(RESTSHARP);
        this.cliOptions.add(libraryOption);
        this.setLibrary(RESTSHARP);
    }

    @Override
    @Deprecated
    protected Set<String> getNullableTypes() {
        return new HashSet<String>(Arrays.asList("decimal", "bool", "int", "uint", "long", "ulong", "float", "double", "DateTime", "DateTimeOffset", "Guid"));
    }

    @Override
    protected Set<String> getValueTypes() {
        return new HashSet<String>(Arrays.asList("decimal", "bool", "int", "uint", "long", "ulong", "float", "double"));
    }

    @Override
    protected void setTypeMapping() {
        super.setTypeMapping();
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("decimal", "decimal");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("AnyType", "Object");
        if (HTTPCLIENT.equals(this.getLibrary())) {
            this.typeMapping.put("file", "FileParameter");
        }
    }

    @Override
    protected void patchProperty(Map<String, CodegenModel> enumRefs, CodegenModel model, CodegenProperty property) {
        super.patchProperty(enumRefs, model, property);
        if (!property.isContainer && (this.getNullableTypes().contains(property.dataType) || property.isEnum)) {
            property.vendorExtensions.put("x-csharp-value-type", true);
        }
    }

    @Override
    protected void updateCodegenParameterEnum(CodegenParameter parameter, CodegenModel model) {
        super.updateCodegenParameterEnumLegacy(parameter, model);
        if (!parameter.required && parameter.vendorExtensions.get("x-csharp-value-type") != null) {
            parameter.dataType = parameter.dataType + "?";
        }
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.apiPackage();
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Schema parentModel;
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && (parentModel = allDefinitions.get(this.toModelName(codegenModel.parent))) != null) {
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            if (codegenModel.hasEnums) {
                codegenModel = this.reconcileInlineEnums(codegenModel, parentCodegenModel);
            }
            HashMap<String, CodegenProperty> propertyHash = new HashMap<String, CodegenProperty>(codegenModel.vars.size());
            for (CodegenProperty property : codegenModel.vars) {
                propertyHash.put(property.name, property);
            }
            for (CodegenProperty property : codegenModel.readWriteVars) {
                if (property.defaultValue != null || parentCodegenModel.discriminator == null || !property.name.equals(parentCodegenModel.discriminator.getPropertyName())) continue;
                property.defaultValue = "\"" + name + "\"";
            }
            CodegenProperty last = null;
            for (CodegenProperty property : parentCodegenModel.vars) {
                if (propertyHash.containsKey(property.name)) continue;
                CodegenProperty parentVar = property.clone();
                parentVar.isInherited = true;
                last = parentVar;
                this.LOGGER.debug("adding parent variable {}", (Object)property.name);
                codegenModel.parentVars.add(parentVar);
            }
        }
        if (codegenModel != null && codegenModel.readWriteVars != null && codegenModel.readWriteVars.size() > 1) {
            int length;
            for (int i = length = codegenModel.readWriteVars.size() - 1; i > length / 2; --i) {
                CodegenProperty codegenProperty = codegenModel.readWriteVars.get(i);
                if (codegenModel.readWriteVars.indexOf(codegenProperty) >= i) continue;
                codegenModel.readWriteVars.remove(i);
            }
        }
        return codegenModel;
    }

    @Override
    public String getHelp() {
        return "Generates a C# client library (.NET Standard, .NET Core).";
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    @Override
    public String getName() {
        return "csharp-netcore";
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            if (this.isSupportNullable() && ModelUtils.isNullable(p) && this.getNullableTypes().contains(type)) {
                return type + "?";
            }
            return type;
        }
        return null;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public boolean isNonPublicApi() {
        return this.nonPublicApi;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.modelPackage();
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
        this.postProcessEmitDefaultValue(property.vendorExtensions);
        super.postProcessModelProperty(model, property);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        this.postProcessEmitDefaultValue(parameter.vendorExtensions);
        if (!parameter.dataType.endsWith("?") && !parameter.required && (this.nullReferenceTypesFlag || this.getNullableTypes().contains(parameter.dataType))) {
            parameter.dataType = parameter.dataType + "?";
        }
    }

    public void postProcessEmitDefaultValue(Map<String, Object> vendorExtensions) {
        vendorExtensions.put("x-emit-default-value", this.optionalEmitDefaultValuesFlag);
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public void processOpts() {
        String[] frameworks;
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        if (this.additionalProperties.containsKey("disallowAdditionalPropertiesIfNotPresent")) {
            this.setDisallowAdditionalPropertiesIfNotPresent(Boolean.parseBoolean(this.additionalProperties.get("disallowAdditionalPropertiesIfNotPresent").toString()));
        }
        if (this.additionalProperties.containsKey("optionalEmitDefaultValues")) {
            this.setOptionalEmitDefaultValuesFlag(this.convertPropertyToBooleanAndWriteBack("optionalEmitDefaultValues"));
        } else {
            this.additionalProperties.put("optionalEmitDefaultValues", this.optionalEmitDefaultValuesFlag);
        }
        if (this.additionalProperties.containsKey("conditionalSerialization")) {
            this.setConditionalSerialization(this.convertPropertyToBooleanAndWriteBack("conditionalSerialization"));
        } else {
            this.additionalProperties.put("conditionalSerialization", this.conditionalSerialization);
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.apiPackage)) {
            this.setApiPackage("Api");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelPackage)) {
            this.setModelPackage("Model");
        }
        this.clientPackage = "Client";
        if (RESTSHARP.equals(this.getLibrary())) {
            this.additionalProperties.put("useRestSharp", true);
            this.needsCustomHttpMethod = true;
        } else if (HTTPCLIENT.equals(this.getLibrary())) {
            this.setLibrary(HTTPCLIENT);
            this.additionalProperties.put("useHttpClient", true);
            this.needsUriBuilder = true;
        } else {
            throw new RuntimeException("Invalid HTTP library " + this.getLibrary() + ". Only restsharp, httpclient are supported.");
        }
        String inputFramework = this.additionalProperties.getOrDefault("targetFramework", CSharpReducedClientCodegen.defaultFramework.name);
        ArrayList<FrameworkStrategy> strategies = new ArrayList<FrameworkStrategy>();
        if (inputFramework.contains(";")) {
            frameworks = inputFramework.split(";");
            this.additionalProperties.put("multiTarget", true);
        } else {
            frameworks = new String[]{inputFramework};
        }
        for (String framework : frameworks) {
            boolean strategyMatched = false;
            for (FrameworkStrategy frameworkStrategy : frameworkStrategies) {
                if (framework.equals(frameworkStrategy.name)) {
                    strategies.add(frameworkStrategy);
                    strategyMatched = true;
                }
                if (frameworkStrategy == FrameworkStrategy.NETSTANDARD_2_0 || !RESTSHARP.equals(this.getLibrary())) continue;
                this.LOGGER.warn("If using built-in templates, RestSharp only supports netstandard 2.0 or later.");
            }
            if (strategyMatched) continue;
            throw new IllegalArgumentException("The input (" + inputFramework + ") contains Invalid .NET framework version: " + framework + ". List of supported versions: " + frameworkStrategies.stream().map(p -> p.name).collect(Collectors.joining(", ")));
        }
        this.configureAdditionalPropertiesForFrameworks(this.additionalProperties, strategies);
        this.setTargetFrameworkNuget(strategies);
        this.setTargetFramework(strategies);
        this.setTestTargetFramework(strategies);
        this.setSupportsAsync(Boolean.TRUE);
        this.setNetStandard(strategies.stream().anyMatch(p -> Boolean.TRUE.equals(p.isNetStandard)));
        if (!this.netStandard) {
            this.setNetCoreProjectFileFlag(true);
        }
        if (this.additionalProperties.containsKey("generatePropertyChanged")) {
            this.LOGGER.warn("{} is not supported in the .NET Standard generator.", (Object)"generatePropertyChanged");
            this.additionalProperties.remove("generatePropertyChanged");
        }
        AtomicReference excludeTests = new AtomicReference();
        this.syncBooleanProperty(this.additionalProperties, "excludeTests", excludeTests::set, false);
        this.syncStringProperty(this.additionalProperties, "clientPackage", s -> {}, this.clientPackage);
        this.syncStringProperty(this.additionalProperties, "apiPackage", this::setApiPackage, this.apiPackage);
        this.syncStringProperty(this.additionalProperties, "modelPackage", this::setModelPackage, this.modelPackage);
        this.syncStringProperty(this.additionalProperties, "packageGuid", this::setPackageGuid, this.packageGuid);
        this.syncStringProperty(this.additionalProperties, "targetFrameworkNuget", this::setTargetFrameworkNuget, this.targetFrameworkNuget);
        this.syncStringProperty(this.additionalProperties, "testTargetFramework", this::setTestTargetFramework, this.testTargetFramework);
        this.syncBooleanProperty(this.additionalProperties, NET_STANDARD, this::setNetStandard, this.netStandard);
        this.syncBooleanProperty(this.additionalProperties, "validatable", this::setValidatable, this.validatable);
        this.syncBooleanProperty(this.additionalProperties, "supportsAsync", this::setSupportsAsync, this.supportsAsync);
        this.syncBooleanProperty(this.additionalProperties, SUPPORTS_RETRY, this::setSupportsRetry, this.supportsRetry);
        this.syncBooleanProperty(this.additionalProperties, "optionalMethodArgument", this::setOptionalMethodArgumentFlag, this.optionalMethodArgumentFlag);
        this.syncBooleanProperty(this.additionalProperties, "nonPublicApi", this::setNonPublicApi, this.isNonPublicApi());
        this.syncBooleanProperty(this.additionalProperties, "useOneOfDiscriminatorLookup", this::setUseOneOfDiscriminatorLookup, this.useOneOfDiscriminatorLookup);
        String testPackageName = this.testPackageName();
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        String clientPackageDir = packageFolder + File.separator + this.clientPackage;
        String modelPackageDir = packageFolder + File.separator + this.modelPackage;
        String testPackageFolder = this.testFolder + File.separator + testPackageName;
        this.additionalProperties.put("testPackageName", testPackageName);
        int packageDepth = packageFolder.length() - packageFolder.replace(File.separator, "").length();
        Object binRelativePath = "..\\";
        for (int i = 0; i < packageDepth; ++i) {
            binRelativePath = (String)binRelativePath + "..\\";
        }
        binRelativePath = (String)binRelativePath + "vendor";
        this.additionalProperties.put("binRelativePath", binRelativePath);
        if (HTTPCLIENT.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("FileParameter.mustache", clientPackageDir, "FileParameter.cs"));
        }
        this.supportingFiles.add(new SupportingFile("IApiAccessor.mustache", clientPackageDir, "IApiAccessor.cs"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", clientPackageDir, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", clientPackageDir, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", clientPackageDir, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", clientPackageDir, "ApiResponse.cs"));
        this.supportingFiles.add(new SupportingFile("ExceptionFactory.mustache", clientPackageDir, "ExceptionFactory.cs"));
        this.supportingFiles.add(new SupportingFile("OpenAPIDateConverter.mustache", clientPackageDir, "OpenAPIDateConverter.cs"));
        this.supportingFiles.add(new SupportingFile("ClientUtils.mustache", clientPackageDir, "ClientUtils.cs"));
        if (this.needsCustomHttpMethod) {
            this.supportingFiles.add(new SupportingFile("HttpMethod.mustache", clientPackageDir, "HttpMethod.cs"));
        }
        if (this.needsUriBuilder) {
            this.supportingFiles.add(new SupportingFile("WebRequestPathBuilder.mustache", clientPackageDir, "WebRequestPathBuilder.cs"));
        }
        if (ProcessUtils.hasHttpSignatureMethods(this.openAPI)) {
            this.supportingFiles.add(new SupportingFile("HttpSigningConfiguration.mustache", clientPackageDir, "HttpSigningConfiguration.cs"));
        }
        if (this.supportsAsync) {
            this.supportingFiles.add(new SupportingFile("IAsynchronousClient.mustache", clientPackageDir, "IAsynchronousClient.cs"));
        }
        this.supportingFiles.add(new SupportingFile("ISynchronousClient.mustache", clientPackageDir, "ISynchronousClient.cs"));
        this.supportingFiles.add(new SupportingFile("RequestOptions.mustache", clientPackageDir, "RequestOptions.cs"));
        this.supportingFiles.add(new SupportingFile("Multimap.mustache", clientPackageDir, "Multimap.cs"));
        if (this.supportsRetry) {
            this.supportingFiles.add(new SupportingFile("RetryConfiguration.mustache", clientPackageDir, "RetryConfiguration.cs"));
        }
        this.supportingFiles.add(new SupportingFile("IReadableConfiguration.mustache", clientPackageDir, "IReadableConfiguration.cs"));
        this.supportingFiles.add(new SupportingFile("GlobalConfiguration.mustache", clientPackageDir, "GlobalConfiguration.cs"));
        if (Boolean.FALSE.equals(excludeTests.get())) {
            this.modelTestTemplateFiles.put("model_test.mustache", ".cs");
            this.apiTestTemplateFiles.put("api_test.mustache", ".cs");
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("appveyor.mustache", "", "appveyor.yml"));
        this.supportingFiles.add(new SupportingFile("AbstractOpenAPISchema.mustache", modelPackageDir, "AbstractOpenAPISchema.cs"));
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.setTypeMapping();
    }

    public void setNetStandard(Boolean netStandard) {
        this.netStandard = netStandard;
    }

    public void setOptionalAssemblyInfoFlag(boolean flag) {
        this.optionalAssemblyInfoFlag = flag;
    }

    public void setOptionalEmitDefaultValuesFlag(boolean flag) {
        this.optionalEmitDefaultValuesFlag = flag;
    }

    public void setConditionalSerialization(boolean flag) {
        this.conditionalSerialization = flag;
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setSupportsAsync(Boolean supportsAsync) {
        this.supportsAsync = supportsAsync;
    }

    public void setSupportsRetry(Boolean supportsRetry) {
        this.supportsRetry = supportsRetry;
    }

    public void setTargetFramework(String dotnetFramework) {
        if (!this.frameworks.containsKey(dotnetFramework)) {
            throw new IllegalArgumentException("Invalid .NET framework version: " + dotnetFramework + ". List of supported versions: " + frameworkStrategies.stream().map(p -> p.name).collect(Collectors.joining(", ")));
        }
        this.targetFramework = dotnetFramework;
        this.LOGGER.info("Generating code for .NET Framework {}", (Object)this.targetFramework);
    }

    public void setTargetFramework(List<FrameworkStrategy> strategies) {
        for (FrameworkStrategy strategy : strategies) {
            if (this.frameworks.containsKey(strategy.name)) continue;
            throw new IllegalArgumentException("Invalid .NET framework version: " + strategy.name + ". List of supported versions: " + frameworkStrategies.stream().map(p -> p.name).collect(Collectors.joining(", ")));
        }
        this.targetFramework = strategies.stream().map(p -> p.name).collect(Collectors.joining(";"));
        this.LOGGER.info("Generating code for .NET Framework {}", (Object)this.targetFramework);
    }

    public void setTestTargetFramework(String testTargetFramework) {
        this.testTargetFramework = testTargetFramework;
    }

    public void setTestTargetFramework(List<FrameworkStrategy> strategies) {
        this.testTargetFramework = strategies.stream().map(p -> p.testTargetFramework).collect(Collectors.joining(";"));
    }

    public void setTargetFrameworkNuget(String targetFrameworkNuget) {
        this.targetFrameworkNuget = targetFrameworkNuget;
    }

    public void setTargetFrameworkNuget(List<FrameworkStrategy> strategies) {
        this.targetFrameworkNuget = strategies.stream().map(p -> p.getNugetFrameworkIdentifier()).collect(Collectors.joining(";"));
    }

    public void setValidatable(boolean validatable) {
        this.validatable = validatable;
    }

    public void setCaseInsensitiveResponseHeaders(Boolean caseInsensitiveResponseHeaders) {
        this.caseInsensitiveResponseHeaders = caseInsensitiveResponseHeaders;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    @Override
    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    public void setPackageTags(String packageTags) {
        this.packageTags = packageTags;
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(value) != null) {
            return StringUtils.camelize(this.getSymbolName(value));
        }
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("double") || datatype.startsWith("float")) {
            Object varName = "NUMBER_" + value;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll(" ", "_");
        var = StringUtils.camelize(var);
        if ((var = var.replaceAll("\\W+", "")).matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        if (this.propertySpecialKeywords.contains(name)) {
            return StringUtils.camelize("property_" + name);
        }
        return name;
    }

    @Override
    protected void patchVendorExtensionNullableValueType(CodegenParameter parameter) {
        super.patchVendorExtensionNullableValueTypeLegacy(parameter);
    }

    private CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel.hasEnums) {
            List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
            List<CodegenProperty> codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
                if (!parentModelCodegenProperty.isEnum) continue;
                Iterator<CodegenProperty> iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = iterator.next();
                    if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenProperty)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    private void syncBooleanProperty(Map<String, Object> additionalProperties, String key, Consumer<Boolean> setter, Boolean defaultValue) {
        if (additionalProperties.containsKey(key)) {
            setter.accept(this.convertPropertyToBooleanAndWriteBack(key));
        } else {
            additionalProperties.put(key, defaultValue);
            setter.accept(defaultValue);
        }
    }

    private void syncStringProperty(Map<String, Object> additionalProperties, String key, Consumer<String> setter, String defaultValue) {
        if (additionalProperties.containsKey(key)) {
            setter.accept((String)additionalProperties.get(key));
        } else {
            additionalProperties.put(key, defaultValue);
            setter.accept(defaultValue);
        }
    }

    protected void configureAdditionalPropertiesForFrameworks(Map<String, Object> properties, List<FrameworkStrategy> strategies) {
        properties.putIfAbsent("targetFramework", strategies.stream().map(p -> p.name).collect(Collectors.joining(";")));
        properties.put(TARGET_FRAMEWORK_IDENTIFIER, strategies.stream().map(p -> p.getTargetFrameworkIdentifier()).collect(Collectors.joining(";")));
        properties.put(TARGET_FRAMEWORK_VERSION, strategies.stream().map(p -> p.getTargetFrameworkVersion()).collect(Collectors.joining(";")));
        properties.putIfAbsent(MCS_NET_VERSION_KEY, "4.6-api");
        properties.put(NET_STANDARD, strategies.stream().anyMatch(p -> Boolean.TRUE.equals(p.isNetStandard)));
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            Schema additionalProperties = ModelUtils.getAdditionalProperties(schema);
            String inner = this.getSchemaType(additionalProperties);
            if (ModelUtils.isMapSchema(additionalProperties)) {
                inner = this.toInstantiationType(additionalProperties);
            }
            return (String)this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return (String)this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (cm.oneOf != null && !cm.oneOf.isEmpty() && cm.oneOf.contains("ModelNull")) {
                cm.isNullable = true;
                cm.oneOf.remove("ModelNull");
            }
            if (cm.anyOf == null || cm.anyOf.isEmpty() || !cm.anyOf.contains("ModelNull")) continue;
            cm.isNullable = true;
            cm.anyOf.remove("ModelNull");
        }
        return objs;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f      #");
        System.out.println("################################################################################");
    }

    @Override
    protected void updateModelForObject(CodegenModel m, Schema schema) {
        if (schema.getProperties() != null || schema.getRequired() != null && !(schema instanceof ComposedSchema)) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        if (ModelUtils.isMapSchema(schema)) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
        } else {
            m.setIsMap(false);
            if (ModelUtils.isFreeFormObject(schema)) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
            }
        }
        this.setAddProps(schema, m);
    }

    private static abstract class FrameworkStrategy {
        private final Logger LOGGER = LoggerFactory.getLogger(CSharpReducedClientCodegen.class);
        static FrameworkStrategy NETSTANDARD_1_3 = new FrameworkStrategy("netstandard1.3", ".NET Standard 1.3 compatible", "netcoreapp2.0"){};
        static FrameworkStrategy NETSTANDARD_1_4 = new FrameworkStrategy("netstandard1.4", ".NET Standard 1.4 compatible", "netcoreapp2.0"){};
        static FrameworkStrategy NETSTANDARD_1_5 = new FrameworkStrategy("netstandard1.5", ".NET Standard 1.5 compatible", "netcoreapp2.0"){};
        static FrameworkStrategy NETSTANDARD_1_6 = new FrameworkStrategy("netstandard1.6", ".NET Standard 1.6 compatible", "netcoreapp2.0"){};
        static FrameworkStrategy NETSTANDARD_2_0 = new FrameworkStrategy("netstandard2.0", ".NET Standard 2.0 compatible", "netcoreapp2.0"){};
        static FrameworkStrategy NETSTANDARD_2_1 = new FrameworkStrategy("netstandard2.1", ".NET Standard 2.1 compatible", "netcoreapp3.0"){};
        static FrameworkStrategy NETCOREAPP_2_0 = new FrameworkStrategy("netcoreapp2.0", ".NET Core 2.0 compatible", "netcoreapp2.0", Boolean.FALSE){};
        static FrameworkStrategy NETCOREAPP_2_1 = new FrameworkStrategy("netcoreapp2.1", ".NET Core 2.1 compatible", "netcoreapp2.1", Boolean.FALSE){};
        static FrameworkStrategy NETFRAMEWORK_4_7 = new FrameworkStrategy("net47", ".NET Framework 4.7 compatible", "net47", Boolean.FALSE){};
        static FrameworkStrategy NET_5_0 = new FrameworkStrategy("net5.0", ".NET 5.0 compatible", "net5.0", Boolean.FALSE){};
        protected String name;
        protected String description;
        protected String testTargetFramework;
        private Boolean isNetStandard = Boolean.TRUE;

        FrameworkStrategy(String name, String description, String testTargetFramework) {
            this.name = name;
            this.description = description;
            this.testTargetFramework = testTargetFramework;
        }

        FrameworkStrategy(String name, String description, String testTargetFramework, Boolean isNetStandard) {
            this.name = name;
            this.description = description;
            this.testTargetFramework = testTargetFramework;
            this.isNetStandard = isNetStandard;
        }

        protected void configureAdditionalProperties(Map<String, Object> properties) {
            properties.putIfAbsent("targetFramework", this.name);
            properties.put(CSharpReducedClientCodegen.TARGET_FRAMEWORK_IDENTIFIER, this.getTargetFrameworkIdentifier());
            properties.put(CSharpReducedClientCodegen.TARGET_FRAMEWORK_VERSION, this.getTargetFrameworkVersion());
            properties.putIfAbsent(CSharpReducedClientCodegen.MCS_NET_VERSION_KEY, "4.6-api");
            properties.put(CSharpReducedClientCodegen.NET_STANDARD, this.isNetStandard);
            if (properties.containsKey(CSharpReducedClientCodegen.SUPPORTS_UWP)) {
                this.LOGGER.warn(".NET {} generator does not support the UWP option. Use the csharp generator instead.", (Object)this.name);
                properties.remove(CSharpReducedClientCodegen.SUPPORTS_UWP);
            }
        }

        protected String getNugetFrameworkIdentifier() {
            return this.name.toLowerCase(Locale.ROOT);
        }

        protected String getTargetFrameworkIdentifier() {
            if (this.isNetStandard.booleanValue()) {
                return ".NETStandard";
            }
            return ".NETCoreApp";
        }

        protected String getTargetFrameworkVersion() {
            if (this.isNetStandard.booleanValue()) {
                return "v" + this.name.replace("netstandard", "");
            }
            return "v" + this.name.replace("netcoreapp", "");
        }
    }
}

