/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZapierClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "projectName";
    private final Logger LOGGER = LoggerFactory.getLogger(ZapierClientCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "zapier";
    }

    @Override
    public String getHelp() {
        return "Generates a zapier client.";
    }

    public ZapierClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "zapier";
        this.modelTemplateFiles.put("model.mustache", ".js");
        this.apiTemplateFiles.put("api.mustache", ".js");
        this.templateDir = "zapier";
        this.embeddedTemplateDir = "zapier";
        this.apiPackage = "apis";
        this.testPackage = "samples";
        this.modelPackage = "models";
        this.apiTestTemplateFiles.put("sample.mustache", ".js");
        this.supportingFiles.add(new SupportingFile("actions.mustache", "operations", "actions.js"));
        this.supportingFiles.add(new SupportingFile("utils.mustache", "utils", "utils.js"));
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.js"));
        this.supportingFiles.add(new SupportingFile("authentication.mustache", "", "authentication.js"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("number", "integer", "string", "boolean", "array", "file", "object"));
        this.instantiationTypes.put("array", "array");
        this.instantiationTypes.put("set", "array");
        this.instantiationTypes.put("list", "array");
        this.instantiationTypes.put("map", "object");
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "array");
        this.typeMapping.put("set", "array");
        this.typeMapping.put("map", "object");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "integer");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("decimal", "number");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("integer", "integer");
        this.typeMapping.put("binary", "file");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
    }

    @Override
    protected void initializeSpecialCharacterMapping() {
        super.initializeSpecialCharacterMapping();
        this.specialCharReplacements.remove("_");
    }

    @Override
    public String toParamName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains(String.valueOf((char)character)))) {
            return StringUtils.escape(name, this.specialCharReplacements, null, null);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        return name;
    }

    @Override
    public String toModelImport(String name) {
        return "const " + name + " = require('../" + this.modelPackage() + "/" + name + "');";
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (!this.needToImport(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (null == type) {
            this.LOGGER.error("No Type defined for Schema {}", (Object)p);
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelFilename(String name) {
        return name;
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return null;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse r = super.fromResponse(responseCode, response);
        try {
            Map map = (Map)Json.mapper().readerFor(Map.class).readValue(Json.pretty((Object)response.getContent()));
            Map.Entry entry = (Map.Entry)map.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("no response object available"));
            Map example = (Map)entry.getValue();
            r.examples = this.toExamples((Map)example.get("examples"));
        }
        catch (Exception e) {
            this.LOGGER.debug(e.toString());
        }
        return r;
    }

    @Override
    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, String> kv = new HashMap<String, String>();
            Map map = (Map)entry.getValue();
            String example = "";
            try {
                example = Json.mapper().writeValueAsString((Object)map.getOrDefault("value", map));
            }
            catch (Exception exception) {
                // empty catch block
            }
            kv.put("example", example);
            output.add(kv);
        }
        return output;
    }
}

