/*
 * Decompiled with CFR 0.152.
 */
package geodb.aggregate;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import geodb.GeoDB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.api.AggregateFunction;

public abstract class GeoAggregateFunction
implements AggregateFunction {
    private Geometry createGeometry(ByteArrayInputStream stream) {
        InputStreamInStream inputStreamInStream = new InputStreamInStream((InputStream)stream);
        Geometry geometry = null;
        try {
            geometry = new WKBReader().read((InStream)inputStreamInStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("given geometry can not be found", e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("given geometry is not valid", e);
        }
        return geometry;
    }

    protected abstract void add(Geometry var1);

    protected abstract Geometry getGeometryResult();

    public final void add(Object arg0) throws SQLException {
        Geometry geometry;
        if (arg0 != null && (geometry = this.createGeometry((ByteArrayInputStream)arg0)) != null) {
            this.add(geometry);
        }
    }

    public final Object getResult() throws SQLException {
        Geometry geometryResult = this.getGeometryResult();
        if (geometryResult != null) {
            return GeoDB.gToWKB(geometryResult);
        }
        return null;
    }

    public final int getType(int[] arg0) throws SQLException {
        return 2004;
    }
}

