/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import java.util.HashSet;
import java.util.Set;

public class DistinctIteration<E, X extends Exception>
extends FilterIteration<E, X> {
    private final Set<E> excludeSet = this.makeSet();

    public DistinctIteration(Iteration<? extends E, ? extends X> iter) {
        super(iter);
    }

    @Override
    protected boolean accept(E object) throws X {
        if (this.inExcludeSet(object)) {
            return false;
        }
        this.add(object);
        return true;
    }

    private boolean inExcludeSet(E object) {
        return this.excludeSet.contains(object);
    }

    protected boolean add(E object) throws X {
        return this.excludeSet.add(object);
    }

    protected Set<E> makeSet() {
        return new HashSet();
    }
}

