/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.util.Objects;
import java.util.function.Function;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.model.Variable;
import org.optaplanner.constraint.streams.drools.common.AbstractAccumulator;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;

final class BiAccumulator<A, B, ResultContainer_, Result_>
extends AbstractAccumulator<ResultContainer_, Result_> {
    private final String varA;
    private final String varB;
    private final TriFunction<ResultContainer_, A, B, Runnable> accumulator;
    private Function<Tuple, A> valueExtractorA;
    private Function<Tuple, B> valueExtractorB;

    public BiAccumulator(Variable<A> varA, Variable<B> varB, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        super(collector.supplier(), collector.finisher());
        this.accumulator = Objects.requireNonNull(collector.accumulator());
        this.varA = varA.getName();
        this.varB = varB.getName();
    }

    @Override
    protected Runnable accumulate(ResultContainer_ context, Tuple leftTuple, InternalFactHandle handle, Declaration[] innerDeclarations) {
        A a = this.valueExtractorA.apply(leftTuple);
        B b = this.valueExtractorB.apply(leftTuple);
        return (Runnable)this.accumulator.apply(context, a, b);
    }

    @Override
    protected void initialize(Tuple leftTuple, Declaration[] innerDeclarations) {
        for (Declaration declaration : innerDeclarations) {
            if (declaration.getBindingName().equals(this.varA)) {
                this.valueExtractorA = BiAccumulator.getValueExtractor(declaration, leftTuple);
                continue;
            }
            if (!declaration.getBindingName().equals(this.varB)) continue;
            this.valueExtractorB = BiAccumulator.getValueExtractor(declaration, leftTuple);
        }
    }
}

