/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.ajaxerrorhandler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.ajaxerrorhandler.AjaxErrorHandler;
import org.primefaces.renderkit.CoreRenderer;

public class AjaxErrorHandlerRenderer
extends CoreRenderer {
    private static final String HOSTNAME_ALREADY_DEFINED_KEY = AjaxErrorHandlerRenderer.class.getCanonicalName() + ".HOSTNAME_ALREADY_DEFINED";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeScript(context, (AjaxErrorHandler)component);
    }

    protected void encodeScript(FacesContext context, AjaxErrorHandler ajaxErrorHandler) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ajaxErrorHandler.getClientId(context);
        String widgetVar = ajaxErrorHandler.resolveWidgetVar();
        this.startScript(writer, clientId);
        if (widgetVar != null) {
            writer.write("$(function(){");
            writer.write(widgetVar);
            writer.write(" = PrimeFacesExt.getAjaxErrorHandlerInstance();});");
        }
        if (context.getExternalContext().getRequestMap().get(HOSTNAME_ALREADY_DEFINED_KEY) == null) {
            writer.write("$(function(){PrimeFacesExt.getAjaxErrorHandlerInstance().setHostname('");
            writer.write(this.getHostname());
            writer.write("');});");
            context.getExternalContext().getRequestMap().put(HOSTNAME_ALREADY_DEFINED_KEY, true);
        }
        writer.write("$(function(){PrimeFacesExt.getAjaxErrorHandlerInstance().addErrorSettings({");
        boolean optionWritten = false;
        optionWritten |= this.writeStringOption(writer, AjaxErrorHandler.PropertyKeys.type.toString(), ajaxErrorHandler.getType(), optionWritten);
        optionWritten |= this.writeStringOption(writer, AjaxErrorHandler.PropertyKeys.title.toString(), ajaxErrorHandler.getTitle(), optionWritten);
        optionWritten |= this.writeStringOption(writer, AjaxErrorHandler.PropertyKeys.body.toString(), ajaxErrorHandler.getBody(), optionWritten);
        optionWritten |= this.writeStringOption(writer, AjaxErrorHandler.PropertyKeys.button.toString(), ajaxErrorHandler.getButton(), optionWritten);
        if (!StringUtils.isEmpty((CharSequence)ajaxErrorHandler.getButtonOnclick())) {
            optionWritten |= this.writeFunctionOption(writer, AjaxErrorHandler.PropertyKeys.buttonOnclick.toString(), "function(){" + ajaxErrorHandler.getButtonOnclick() + "}", optionWritten);
        }
        if (!StringUtils.isEmpty((CharSequence)ajaxErrorHandler.getOnerror())) {
            optionWritten |= this.writeFunctionOption(writer, AjaxErrorHandler.PropertyKeys.onerror.toString(), "function(error, response){" + ajaxErrorHandler.getOnerror() + "}", optionWritten);
        }
        writer.write("});});");
        this.endScript(writer);
    }

    protected boolean writeStringOption(ResponseWriter writer, String type, String value, boolean optionWritten) throws IOException {
        boolean writeOption;
        boolean bl = writeOption = !StringUtils.isEmpty((CharSequence)value);
        if (writeOption) {
            if (optionWritten) {
                writer.write(",");
            }
            writer.write("'");
            writer.write(type);
            writer.write("':'");
            writer.write(value);
            writer.write("'");
        }
        return writeOption;
    }

    protected boolean writeFunctionOption(ResponseWriter writer, String type, String value, boolean optionWritten) throws IOException {
        boolean writeOption;
        boolean bl = writeOption = !StringUtils.isEmpty((CharSequence)value);
        if (writeOption) {
            if (optionWritten) {
                writer.write(",");
            }
            writer.write("'");
            writer.write(type);
            writer.write("':");
            writer.write(value);
        }
        return writeOption;
    }

    protected String getHostname() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "???unknown???";
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

