/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.analogclock;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.analogclock.AnalogClock;
import org.primefaces.extensions.component.analogclock.model.AnalogClockColorModel;
import org.primefaces.extensions.util.ExtWidgetBuilder;
import org.primefaces.renderkit.CoreRenderer;

public class AnalogClockRenderer
extends CoreRenderer {
    public static final String RENDERER_TYPE = "org.primefaces.extensions.component.AnalogClockRenderer";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AnalogClock analogClock = (AnalogClock)component;
        this.encodeMarkup(context, analogClock);
        this.encodeScript(context, analogClock);
    }

    protected void encodeMarkup(FacesContext context, AnalogClock clock) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)clock);
        writer.writeAttribute("id", (Object)clock.getClientId(), null);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AnalogClock analogClock) throws IOException {
        String clientId = analogClock.getClientId();
        String widgetVar = analogClock.resolveWidgetVar();
        ExtWidgetBuilder ewb = ExtWidgetBuilder.get(context);
        ewb.initWithDomReady("AnalogClock", widgetVar, clientId);
        ewb.attr("mode", analogClock.getMode());
        ewb.attr("time", analogClock.getStartTime() != null ? Long.valueOf(analogClock.getStartTime().getTime()) : null);
        if (analogClock.getColorTheme() != null) {
            if (analogClock.getColorTheme() instanceof String) {
                ewb.attr("colorTheme", analogClock.getColorTheme().toString());
            } else {
                AnalogClockColorModel model = (AnalogClockColorModel)analogClock.getColorTheme();
                ewb.attr("themeObject", this.escapeText(model.toJson()));
            }
        }
        if (analogClock.getWidth() != null) {
            ewb.attr("width", analogClock.getWidth().toString());
        }
        ewb.finish();
    }
}

