/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JTableCancelCellEditingTask;
import org.fest.swing.driver.JTableCellEditorQuery;
import org.fest.swing.driver.JTableCellValidator;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.driver.JTableStopCellEditingTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJTableCellWriter
implements JTableCellWriter {
    protected final Robot robot;
    protected final JTableLocation location = new JTableLocation();
    private TableCellEditor cellEditor;
    private static final long EDITOR_LOOKUP_TIMEOUT = 5000L;

    public AbstractJTableCellWriter(Robot robot) {
        this.robot = robot;
    }

    @Override
    @RunsInEDT
    public void cancelCellEditing(JTable table, int row, int column) {
        if (this.cellEditor == null) {
            this.doCancelCellEditing(table, row, column);
            return;
        }
        this.doCancelCellEditing();
    }

    @RunsInEDT
    private void doCancelCellEditing(JTable table, int row, int column) {
        JTableCancelCellEditingTask.cancelEditing(table, row, column);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void doCancelCellEditing() {
        JTableCancelCellEditingTask.cancelEditing(this.cellEditor);
        this.robot.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void stopCellEditing(JTable table, int row, int column) {
        if (this.cellEditor == null) {
            this.doStopCellEditing(table, row, column);
            return;
        }
        this.doStopCellEditing();
    }

    @RunsInEDT
    private void doStopCellEditing(JTable table, int row, int column) {
        JTableStopCellEditingTask.validateAndStopEditing(table, row, column);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void doStopCellEditing() {
        JTableStopCellEditingTask.stopEditing(this.cellEditor);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    protected static TableCellEditor cellEditor(final JTable table, final int row, final int column) {
        return GuiActionRunner.execute(new GuiQuery<TableCellEditor>(){

            @Override
            protected TableCellEditor executeInEDT() throws Throwable {
                return table.getCellEditor(row, column);
            }
        });
    }

    @RunsInCurrentThread
    protected static void scrollToCell(JTable table, int row, int column, JTableLocation location) {
        table.scrollRectToVisible(location.cellBounds(table, row, column));
    }

    @Override
    @RunsInEDT
    public Component editorForCell(JTable table, int row, int column) {
        return AbstractJTableCellWriter.cellEditorComponent(table, row, column);
    }

    @RunsInEDT
    private static Component cellEditorComponent(final JTable table, final int row, final int column) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                JTableCellValidator.validateIndices(table, row, column);
                return JTableCellEditorQuery.cellEditorIn(table, row, column);
            }
        });
    }

    @RunsInCurrentThread
    protected static <T extends Component> T editor(JTable table, int row, int column, Class<T> supportedType) {
        AbstractJTableCellWriter.validate(table, row, column);
        Component editor = JTableCellEditorQuery.cellEditorIn(table, row, column);
        if (supportedType.isInstance(editor)) {
            return (T)((Component)supportedType.cast(editor));
        }
        throw AbstractJTableCellWriter.cannotFindOrActivateEditor(row, column);
    }

    @RunsInEDT
    protected static Point cellLocation(final JTable table, final int row, final int column, final JTableLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                AbstractJTableCellWriter.validate(table, row, column);
                AbstractJTableCellWriter.scrollToCell(table, row, column, location);
                return location.pointAt(table, row, column);
            }
        });
    }

    @RunsInCurrentThread
    protected static void validate(JTable table, int row, int column) {
        JTableCellValidator.validateIndices(table, row, column);
        ComponentStateValidator.validateIsEnabledAndShowing(table);
        JTableCellValidator.validateCellIsEditable(table, row, column);
    }

    @RunsInEDT
    protected final <T extends Component> T waitForEditorActivation(JTable table, int row, int column, Class<T> supportedType) {
        return this.waitForEditorActivation(new TypeMatcher(supportedType, true), table, row, column, supportedType);
    }

    @RunsInEDT
    protected final <T extends Component> T waitForEditorActivation(ComponentMatcher matcher, JTable table, int row, int column, Class<T> supportedType) {
        ComponentFoundCondition condition = new ComponentFoundCondition("", this.robot.finder(), matcher, (Container)table);
        try {
            Pause.pause((Condition)condition, 5000L);
        }
        catch (WaitTimedOutError e) {
            throw AbstractJTableCellWriter.cannotFindOrActivateEditor(row, column);
        }
        return (T)((Component)supportedType.cast(condition.found()));
    }

    protected static ActionFailedException cannotFindOrActivateEditor(int row, int column) {
        String msg = Strings.concat("Unable to find or activate editor for cell [", String.valueOf(row), ",", String.valueOf(column), "]");
        throw ActionFailedException.actionFailure(msg);
    }

    protected final TableCellEditor cellEditor() {
        return this.cellEditor;
    }

    protected final void cellEditor(TableCellEditor newCellEditor) {
        this.cellEditor = newCellEditor;
    }
}

