/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.io.File;
import javax.swing.JFileChooser;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

final class JFileChooserSelectFileTask {
    @RunsInEDT
    static void validateAndSelectFile(final JFileChooser fileChooser, final File file) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(fileChooser);
                JFileChooserSelectFileTask.validateFileToChoose(fileChooser, file);
                fileChooser.setSelectedFile(file);
            }
        });
    }

    @RunsInEDT
    static void validateAndSelectFiles(final JFileChooser fileChooser, final File[] files) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(fileChooser);
                if (files.length > 1 && !fileChooser.isMultiSelectionEnabled()) {
                    throw new IllegalStateException(Strings.concat("Expecting file chooser ", Formatting.format(fileChooser), " to handle multiple selection"));
                }
                for (File file : files) {
                    JFileChooserSelectFileTask.validateFileToChoose(fileChooser, file);
                }
                fileChooser.setSelectedFiles(files);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateFileToChoose(JFileChooser fileChooser, File file) {
        int mode = fileChooser.getFileSelectionMode();
        boolean isFolder = file.isDirectory();
        if (mode == 0 && isFolder) {
            throw JFileChooserSelectFileTask.cannotSelectFile(file, "the file chooser cannot open directories");
        }
        if (mode == 1 && !isFolder) {
            throw JFileChooserSelectFileTask.cannotSelectFile(file, "the file chooser can only open directories");
        }
    }

    private static IllegalArgumentException cannotSelectFile(File file, String reason) {
        return new IllegalArgumentException(Strings.concat("Unable to select file ", file, ": ", reason));
    }

    private JFileChooserSelectFileTask() {
    }
}

