/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.driver.BasicJTableCellReader;
import org.fest.swing.driver.BasicJTableCellWriter;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableCellEditableQuery;
import org.fest.swing.driver.JTableCellValidator;
import org.fest.swing.driver.JTableColumnCountQuery;
import org.fest.swing.driver.JTableContentsQuery;
import org.fest.swing.driver.JTableHasSelectionQuery;
import org.fest.swing.driver.JTableHeaderQuery;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.driver.JTableMatchingCellQuery;
import org.fest.swing.driver.JTableRowCountQuery;
import org.fest.swing.driver.JTableSingleRowCellSelectedQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.query.JTableColumnByIdentifierQuery;
import org.fest.swing.util.Arrays;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableDriver
extends JComponentDriver {
    private static final String CONTENTS_PROPERTY = "contents";
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_ROWS_PROPERTY = "selectedRows";
    private static final String SELECTION_PROPERTY = "selection";
    private static final String VALUE_PROPERTY = "value";
    private final JTableLocation location = new JTableLocation();
    private JTableCellReader cellReader;
    private JTableCellWriter cellWriter;

    public JTableDriver(Robot robot) {
        super(robot);
        this.cellReader(new BasicJTableCellReader());
        this.cellWriter(new BasicJTableCellWriter(robot));
    }

    @RunsInEDT
    public JTableHeader tableHeaderOf(JTable table) {
        return JTableHeaderQuery.tableHeader(table);
    }

    @RunsInEDT
    public String selectionValue(JTable table) {
        return JTableDriver.selectionValue(table, this.cellReader);
    }

    @RunsInEDT
    private static String selectionValue(final JTable table, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                if (table.getSelectedRowCount() == 0) {
                    return null;
                }
                return cellReader.valueAt(table, table.getSelectedRow(), table.getSelectedColumn());
            }
        });
    }

    @RunsInEDT
    public TableCell cell(JTable table, TableCellFinder cellFinder) {
        if (cellFinder == null) {
            throw new NullPointerException("The cell finder to use should not be null");
        }
        TableCell cell = cellFinder.findCell(table, this.cellReader);
        JTableCellValidator.validateCellIndices(table, cell);
        return cell;
    }

    @RunsInEDT
    public TableCell cell(JTable table, String value) {
        return JTableMatchingCellQuery.cellWithValue(table, new StringTextMatcher(value), this.cellReader);
    }

    @RunsInEDT
    public TableCell cell(JTable table, Pattern pattern) {
        return JTableMatchingCellQuery.cellWithValue(table, new PatternTextMatcher(pattern), this.cellReader);
    }

    @RunsInEDT
    public String value(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        return JTableDriver.cellValue(table, cell, this.cellReader);
    }

    @RunsInEDT
    private static String cellValue(final JTable table, final TableCell cell, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JTableCellValidator.validateCellIndices(table, cell);
                return cellReader.valueAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInEDT
    public String value(JTable table, int row, int column) {
        return JTableDriver.cellValue(table, row, column, this.cellReader);
    }

    @RunsInEDT
    private static String cellValue(final JTable table, final int row, final int column, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JTableCellValidator.validateIndices(table, row, column);
                return cellReader.valueAt(table, row, column);
            }
        });
    }

    @RunsInEDT
    public Font font(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        return JTableDriver.cellFont(table, cell, this.cellReader);
    }

    @RunsInEDT
    private static Font cellFont(final JTable table, final TableCell cell, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Font>(){

            @Override
            protected Font executeInEDT() {
                JTableCellValidator.validateCellIndices(table, cell);
                return cellReader.fontAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInEDT
    public Color background(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        return JTableDriver.cellBackground(table, cell, this.cellReader);
    }

    @RunsInEDT
    private static Color cellBackground(final JTable table, final TableCell cell, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            protected Color executeInEDT() {
                JTableCellValidator.validateCellIndices(table, cell);
                return cellReader.backgroundAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInEDT
    public Color foreground(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        return JTableDriver.cellForeground(table, cell, this.cellReader);
    }

    @RunsInEDT
    private static Color cellForeground(final JTable table, final TableCell cell, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            protected Color executeInEDT() {
                JTableCellValidator.validateCellIndices(table, cell);
                return cellReader.foregroundAt(table, cell.row, cell.column);
            }
        });
    }

    public void selectCells(final JTable table, final TableCell[] cells) {
        this.validateCellsToSelect(cells);
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return cells.length;
            }

            void selectElement(int index) {
                JTableDriver.this.selectCell(table, cells[index]);
            }
        }.multiSelect();
    }

    private void validateCellsToSelect(TableCell[] cells) {
        if (cells == null) {
            throw new NullPointerException("Array of table cells to select should not be null");
        }
        if (org.fest.util.Arrays.isEmpty(cells)) {
            throw new IllegalArgumentException("Array of table cells to select should not be empty");
        }
    }

    @RunsInEDT
    public void requireNoSelection(JTable table) {
        JTableDriver.assertNoSelection(table);
    }

    @RunsInEDT
    private static void assertNoSelection(final JTable table) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                if (!JTableHasSelectionQuery.hasSelection(table)) {
                    return;
                }
                String message = Strings.concat("[", ComponentDriver.propertyName(table, JTableDriver.SELECTION_PROPERTY).value(), "] expected no selection but was:<rows=", org.fest.util.Arrays.format(JTableDriver.selectedRowsOf(table)), ", columns=", org.fest.util.Arrays.format(table.getSelectedColumns()), ">");
                Fail.fail(message);
            }
        });
    }

    @RunsInEDT
    public void selectCell(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        this.selectCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void click(JTable table, TableCell cell, MouseButton mouseButton, int times) {
        if (times <= 0) {
            throw new IllegalArgumentException("The number of times to click a cell should be greater than zero");
        }
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location);
        this.robot.click(table, pointAtCell, mouseButton, times);
    }

    @RunsInEDT
    public void drag(JTable table, TableCell cell) {
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location);
        this.drag((Component)table, pointAtCell);
    }

    @RunsInEDT
    public void drop(JTable table, TableCell cell) {
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location);
        this.drop((Component)table, pointAtCell);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenuAt(JTable table, TableCell cell) {
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location);
        return this.robot.showPopupMenu(table, pointAtCell);
    }

    @RunsInEDT
    private static Point scrollToPointAtCell(final JTable table, final TableCell cell, final JTableLocation location) {
        JTableCellValidator.validateNotNull(cell);
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                JTableDriver.scrollToCell(table, cell, location);
                return location.pointAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInCurrentThread
    private static void scrollToCell(JTable table, TableCell cell, JTableLocation location) {
        ComponentStateValidator.validateIsEnabledAndShowing(table);
        JTableCellValidator.validateCellIndices(table, cell);
        table.scrollRectToVisible(location.cellBounds(table, cell));
    }

    @RunsInEDT
    public Point pointAt(JTable table, TableCell cell) {
        return JTableDriver.pointAtCell(table, cell, this.location);
    }

    @RunsInEDT
    private static Point pointAtCell(final JTable table, final TableCell cell, final JTableLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                JTableCellValidator.validateCellIndices(table, cell);
                return location.pointAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInEDT
    public void requireContents(JTable table, String[][] contents) {
        String[][] actual = this.contents(table);
        if (!Arrays.equal(actual, contents)) {
            JTableDriver.failNotEqual(actual, contents, JTableDriver.propertyName(table, CONTENTS_PROPERTY));
        }
    }

    private static void failNotEqual(String[][] actual, String[][] expected, Description description) {
        String descriptionValue = description != null ? description.value() : null;
        String message = descriptionValue == null ? "" : Strings.concat("[", descriptionValue, "]");
        Fail.fail(Strings.concat(message, " expected:<", Arrays.format(expected), "> but was:<", Arrays.format(actual), ">"));
    }

    @RunsInEDT
    public String[][] contents(JTable table) {
        return JTableContentsQuery.tableContents(table, this.cellReader);
    }

    @RunsInEDT
    public void requireCellValue(JTable table, TableCell cell, String value) {
        TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireCellValue(JTable table, TableCell cell, Pattern pattern) {
        TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell)).matches(pattern);
    }

    @RunsInEDT
    private Description cellValueProperty(JTable table, TableCell cell) {
        return JTableDriver.cellProperty(table, Strings.concat(VALUE_PROPERTY, " ", cell));
    }

    @RunsInEDT
    public void enterValueInCell(JTable table, TableCell cell, String value) {
        JTableCellValidator.validateNotNull(cell);
        this.cellWriter.enterValue(table, cell.row, cell.column, value);
    }

    @RunsInEDT
    public void requireEditable(JTable table, TableCell cell) {
        JTableDriver.requireEditableEqualTo(table, cell, true);
    }

    @RunsInEDT
    public void requireNotEditable(JTable table, TableCell cell) {
        JTableDriver.requireEditableEqualTo(table, cell, false);
    }

    @RunsInEDT
    private static void requireEditableEqualTo(final JTable table, final TableCell cell, boolean editable) {
        JTableCellValidator.validateNotNull(cell);
        boolean cellEditable = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return JTableCellEditableQuery.isCellEditable(table, cell);
            }
        });
        Assertions.assertThat(cellEditable).as(JTableDriver.cellProperty(table, Strings.concat(EDITABLE_PROPERTY, " ", cell))).isEqualTo(editable);
    }

    @RunsInEDT
    private static Description cellProperty(JTable table, String propertyName) {
        return JTableDriver.propertyName(table, propertyName);
    }

    @RunsInEDT
    public Component cellEditor(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        return this.cellWriter.editorForCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void startCellEditing(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        this.cellWriter.startCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void stopCellEditing(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        this.cellWriter.stopCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void cancelCellEditing(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        this.cellWriter.cancelCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void validate(JTable table, TableCell cell) {
        JTableDriver.validateCellIndexBounds(table, cell);
    }

    private static void validateCellIndexBounds(final JTable table, final TableCell cell) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTableCellValidator.validateCellIndices(table, cell);
            }
        });
    }

    public void cellReader(JTableCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }

    public void cellWriter(JTableCellWriter newCellWriter) {
        CommonValidations.validateCellWriter(newCellWriter);
        this.cellWriter = newCellWriter;
    }

    @RunsInEDT
    public int rowCountOf(JTable table) {
        return JTableRowCountQuery.rowCountOf(table);
    }

    @RunsInEDT
    public int columnIndex(JTable table, Object columnId) {
        return JTableDriver.findColumnIndex(table, columnId);
    }

    @RunsInEDT
    private static int findColumnIndex(final JTable table, final Object columnId) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                int index = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
                if (index < 0) {
                    JTableDriver.failColumnIndexNotFound(columnId);
                }
                return index;
            }
        });
    }

    private static ActionFailedException failColumnIndexNotFound(Object columnId) {
        throw ActionFailedException.actionFailure(Strings.concat("Unable to find a column with id ", Strings.quote(columnId)));
    }

    @RunsInEDT
    public void requireRowCount(JTable table, int rowCount) {
        Assertions.assertThat(this.rowCountOf(table)).as(JTableDriver.propertyName(table, "rowCount")).isEqualTo(rowCount);
    }

    @RunsInEDT
    public void requireColumnCount(JTable table, int columnCount) {
        Assertions.assertThat(JTableColumnCountQuery.columnCountOf(table)).as(JTableDriver.propertyName(table, "columnCount")).isEqualTo(columnCount);
    }

    @RunsInEDT
    public void selectRows(final JTable table, final int ... rows) {
        if (rows == null) {
            throw new NullPointerException("The array of row indices should not be null");
        }
        if (Arrays.isEmptyIntArray(rows)) {
            throw new IllegalArgumentException("The array of row indices should not be empty");
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return rows.length;
            }

            void selectElement(int index) {
                JTableDriver.this.selectCell(table, rows[index], 0);
            }
        }.multiSelect();
    }

    @RunsInEDT
    private void selectCell(JTable table, int row, int column) {
        Pair<Boolean, Point> cellSelectionInfo = JTableDriver.cellSelectionInfo(table, row, column, this.location);
        if (((Boolean)cellSelectionInfo.i).booleanValue()) {
            return;
        }
        this.robot.click(table, (Point)cellSelectionInfo.ii, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    private static Pair<Boolean, Point> cellSelectionInfo(final JTable table, final int row, final int column, final JTableLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                if (JTableSingleRowCellSelectedQuery.isCellSelected(table, row, column)) {
                    return new Pair<Boolean, Object>(true, null);
                }
                JTableDriver.scrollToCell(table, row, column, location);
                Point pointAtCell = location.pointAt(table, row, column);
                return new Pair<Boolean, Point>(false, pointAtCell);
            }
        });
    }

    @RunsInCurrentThread
    private static void scrollToCell(JTable table, int row, int column, JTableLocation location) {
        ComponentStateValidator.validateIsEnabledAndShowing(table);
        JTableCellValidator.validateIndices(table, row, column);
        table.scrollRectToVisible(location.cellBounds(table, row, column));
    }

    @RunsInEDT
    public void requireSelectedRows(JTable table, int ... rows) {
        int[] selectedRows = JTableDriver.selectedRowsOf(table);
        Assertions.assertThat(selectedRows).as(JTableDriver.propertyName(table, SELECTED_ROWS_PROPERTY)).contains(rows);
    }

    @RunsInEDT
    private static int[] selectedRowsOf(final JTable table) {
        return GuiActionRunner.execute(new GuiQuery<int[]>(){

            @Override
            protected int[] executeInEDT() {
                return table.getSelectedRows();
            }
        });
    }

    @VisibleForTesting
    JTableCellReader cellReader() {
        return this.cellReader;
    }
}

