/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import java.applet.Applet;
import java.util.HashMap;
import java.util.Map;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.applet.AppletViewer;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.launcher.AppletParameter;
import org.fest.swing.launcher.NewAppletViewerQuery;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletLauncher {
    private final Applet applet;
    private final Map<String, String> parameters = new HashMap<String, String>();

    @RunsInEDT
    public static AppletLauncher applet(String appletType) {
        if (appletType == null) {
            throw new NullPointerException("The name of the applet type should not be null");
        }
        if (Strings.isEmpty(appletType)) {
            throw new IllegalArgumentException("The name of the applet type should not be empty");
        }
        Class<?> type = AppletLauncher.load(appletType);
        if (!Applet.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(Strings.concat("The given type is not a subclass of ", Applet.class.getName()));
        }
        return AppletLauncher.instantiate(type);
    }

    @RunsInEDT
    private static Class<?> load(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw AppletLauncher.cannotLoadType(typeName, e);
        }
        catch (Exception e) {
            throw AppletLauncher.cannotLoadType(typeName, e);
        }
    }

    private static UnexpectedException cannotLoadType(String typeName, Exception e) {
        throw new UnexpectedException(Strings.concat("Unable to load class ", typeName), e);
    }

    @RunsInEDT
    public static AppletLauncher applet(Class<? extends Applet> appletType) {
        if (appletType == null) {
            throw new NullPointerException("The applet type should not be null");
        }
        return AppletLauncher.instantiate(appletType);
    }

    private static AppletLauncher instantiate(final Class<?> appletType) {
        try {
            Object applet = GuiActionRunner.execute(new GuiQuery<Object>(){

                @Override
                protected Object executeInEDT() throws Exception {
                    return appletType.newInstance();
                }
            });
            return AppletLauncher.applet((Applet)applet);
        }
        catch (Exception e) {
            throw AppletLauncher.cannotInstantiateApplet(appletType.getName(), e);
        }
    }

    private static UnexpectedException cannotInstantiateApplet(String appletType, Exception cause) {
        throw new UnexpectedException(Strings.concat("Unable to create a new instance of ", appletType), cause);
    }

    public static AppletLauncher applet(Applet applet) {
        return new AppletLauncher(applet);
    }

    private AppletLauncher(Applet applet) {
        if (applet == null) {
            throw new NullPointerException("The applet to launch should not be null");
        }
        this.applet = applet;
    }

    public AppletLauncher withParameters(Map<String, String> newParameters) {
        if (newParameters == null) {
            throw new NullPointerException("The map of parameters should not be null");
        }
        this.parameters.clear();
        this.parameters.putAll(newParameters);
        return this;
    }

    public AppletLauncher withParameters(AppletParameter ... newParameters) {
        if (newParameters == null) {
            throw new NullPointerException("The array of parameters should not be null");
        }
        this.parameters.clear();
        for (AppletParameter parameter : newParameters) {
            this.add(parameter);
        }
        return this;
    }

    private void add(AppletParameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("Found a null parameter");
        }
        this.parameters.put(parameter.name, parameter.value);
    }

    public AppletViewer start() {
        return NewAppletViewerQuery.showAppletViewerWith(this.applet, this.parameters);
    }
}

