/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.Window;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.monitor.ProtectingTimerTask;
import org.fest.swing.monitor.WindowVisibilityMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class Windows {
    static int WINDOW_READY_DELAY = 10000;
    @GuardedBy(value="lock")
    final Map<Window, TimerTask> pending = new WeakHashMap<Window, TimerTask>();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> open = new WeakHashMap<Window, Boolean>();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> closed = new WeakHashMap<Window, Boolean>();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> hidden = new WeakHashMap<Window, Boolean>();
    private final Timer windowReadyTimer;
    private final Object lock = new Object();

    Windows() {
        this.windowReadyTimer = new Timer("Window Ready Timer", true);
    }

    void attachNewWindowVisibilityMonitor(Window target) {
        WindowVisibilityMonitor monitor = new WindowVisibilityMonitor(this);
        target.addWindowListener(monitor);
        target.addComponentListener(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInCurrentThread
    void markExisting(Window w) {
        Object object = this.lock;
        synchronized (object) {
            this.addWindowTo(w, this.open);
            if (!w.isShowing()) {
                this.addWindowTo(w, this.hidden);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsHidden(Window w) {
        Object object = this.lock;
        synchronized (object) {
            this.addWindowTo(w, this.hidden);
            this.removeWindowFrom(w, this.pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsShowing(final Window w) {
        Object object = this.lock;
        synchronized (object) {
            TimerTask task = new TimerTask(){

                public void run() {
                    Windows.this.markAsReady(w);
                }
            };
            this.windowReadyTimer.schedule((TimerTask)new ProtectingTimerTask(task), WINDOW_READY_DELAY);
            this.pending.put(w, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsReady(Window w) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.pending.containsKey(w)) {
                return;
            }
            this.removeWindowFrom(w, this.closed, this.hidden, this.pending);
            this.addWindowTo(w, this.open);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsClosed(Window w) {
        Object object = this.lock;
        synchronized (object) {
            this.removeWindowFrom(w, this.open, this.hidden, this.pending);
            this.addWindowTo(w, this.closed);
        }
    }

    private void addWindowTo(Window w, Map<Window, Boolean> map) {
        map.put(w, true);
    }

    private void removeWindowFrom(Window w, Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            map.remove(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed(Component c) {
        Object object = this.lock;
        synchronized (object) {
            return this.closed.containsKey(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReady(Window w) {
        Object object = this.lock;
        synchronized (object) {
            return this.open.containsKey(w) && !this.hidden.containsKey(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHidden(Window w) {
        Object object = this.lock;
        synchronized (object) {
            return this.hidden.containsKey(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isShowingButNotReady(Window w) {
        Object object = this.lock;
        synchronized (object) {
            return this.pending.containsKey(w);
        }
    }
}

