/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Dimension;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import org.pushingpixels.flamingo.api.common.AsynchronousLoadListener;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.ProgressEvent;
import org.pushingpixels.flamingo.api.common.ProgressListener;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public abstract class AbstractFileViewPanel<T>
extends JCommandButtonPanel {
    protected Map<String, JCommandButton> buttonMap = new HashMap<String, JCommandButton>();
    protected ProgressListener progressListener;
    protected Set<JCommandButton> loadedSet;
    private SwingWorker<Void, Leaf> mainWorker;

    public AbstractFileViewPanel(int startingDimension, ProgressListener progressListener) {
        super(startingDimension);
        this.progressListener = progressListener;
        this.loadedSet = new HashSet<JCommandButton>();
        this.setToShowGroupLabels(false);
    }

    public AbstractFileViewPanel(CommandButtonDisplayState startingState, ProgressListener progressListener) {
        super(startingState);
        this.progressListener = progressListener;
        this.loadedSet = new HashSet<JCommandButton>();
        this.setToShowGroupLabels(false);
    }

    public void setFolder(final List<StringValuePair<T>> leafs) {
        this.removeAllGroups();
        this.addButtonGroup("");
        this.buttonMap.clear();
        int fileCount = 0;
        final HashMap<String, JCommandButton> newButtons = new HashMap<String, JCommandButton>();
        for (StringValuePair<T> leaf : leafs) {
            String name = (String)leaf.getKey();
            if (!this.toShowFile(leaf)) continue;
            int initialSize = this.currDimension;
            if (initialSize < 0) {
                initialSize = this.currState.getPreferredIconSize();
            }
            JCommandButton button = new JCommandButton(name, new EmptyResizableIcon(initialSize));
            button.setHorizontalAlignment(2);
            button.setDisplayState(this.currState);
            if (this.currState == CommandButtonDisplayState.FIT_TO_ICON) {
                button.updateCustomDimension(this.currDimension);
            }
            this.addButtonToLastGroup(button);
            newButtons.put(name, button);
            this.buttonMap.put(name, button);
            ++fileCount;
        }
        this.doLayout();
        this.repaint();
        final int totalCount = fileCount;
        this.mainWorker = new SwingWorker<Void, Leaf>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (totalCount > 0 && AbstractFileViewPanel.this.progressListener != null) {
                    AbstractFileViewPanel.this.progressListener.onProgress(new ProgressEvent(AbstractFileViewPanel.this, 0, totalCount, 0));
                }
                for (StringValuePair leafPair : leafs) {
                    if (this.isCancelled()) break;
                    String name = (String)leafPair.getKey();
                    if (!AbstractFileViewPanel.this.toShowFile(leafPair)) continue;
                    InputStream stream = AbstractFileViewPanel.this.getLeafContent(leafPair.getValue());
                    Leaf leaf = new Leaf(name, stream);
                    leaf.setLeafProp("source", leafPair.getValue());
                    for (Map.Entry<String, Object> propEntry : leafPair.getProps().entrySet()) {
                        leaf.setLeafProp(propEntry.getKey(), propEntry.getValue());
                    }
                    this.publish(leaf);
                }
                return null;
            }

            @Override
            protected void process(List<Leaf> leaves) {
                for (Leaf leaf : leaves) {
                    Dimension dim;
                    String name = leaf.getLeafName();
                    InputStream stream = leaf.getLeafStream();
                    ResizableIcon icon = AbstractFileViewPanel.this.getResizableIcon(leaf, stream, AbstractFileViewPanel.this.currState, dim = new Dimension(AbstractFileViewPanel.this.currDimension, AbstractFileViewPanel.this.currDimension));
                    if (icon == null) continue;
                    final JCommandButton commandButton = (JCommandButton)newButtons.get(name);
                    commandButton.setIcon(icon);
                    if (icon instanceof AsynchronousLoading) {
                        ((AsynchronousLoading)((Object)icon)).addAsynchronousLoadListener(new AsynchronousLoadListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void completed(boolean success) {
                                AbstractFileViewPanel abstractFileViewPanel = AbstractFileViewPanel.this;
                                synchronized (abstractFileViewPanel) {
                                    if ((this).AbstractFileViewPanel.this.loadedSet.contains(commandButton)) {
                                        return;
                                    }
                                    (this).AbstractFileViewPanel.this.loadedSet.add(commandButton);
                                    if ((this).AbstractFileViewPanel.this.progressListener != null) {
                                        (this).AbstractFileViewPanel.this.progressListener.onProgress(new ProgressEvent(AbstractFileViewPanel.this, 0, totalCount, (this).AbstractFileViewPanel.this.loadedSet.size()));
                                        if ((this).AbstractFileViewPanel.this.loadedSet.size() == totalCount) {
                                            (this).AbstractFileViewPanel.this.progressListener.onProgress(new ProgressEvent(AbstractFileViewPanel.this, 0, totalCount, totalCount));
                                        }
                                    }
                                }
                            }
                        });
                    }
                    AbstractFileViewPanel.this.configureCommandButton(leaf, commandButton, icon);
                    commandButton.setDisplayState(AbstractFileViewPanel.this.currState);
                    if (AbstractFileViewPanel.this.currState != CommandButtonDisplayState.FIT_TO_ICON) continue;
                    commandButton.updateCustomDimension(AbstractFileViewPanel.this.currDimension);
                }
            }
        };
        this.mainWorker.execute();
    }

    public int getLoadedIconCount() {
        return this.loadedSet.size();
    }

    public void cancelMainWorker() {
        if (this.mainWorker == null) {
            return;
        }
        if (this.mainWorker.isDone() || this.mainWorker.isCancelled()) {
            return;
        }
        this.mainWorker.cancel(false);
    }

    public Map<String, JCommandButton> getButtonMap() {
        return Collections.unmodifiableMap(this.buttonMap);
    }

    protected abstract boolean toShowFile(StringValuePair<T> var1);

    protected abstract ResizableIcon getResizableIcon(Leaf var1, InputStream var2, CommandButtonDisplayState var3, Dimension var4);

    protected abstract void configureCommandButton(Leaf var1, JCommandButton var2, ResizableIcon var3);

    protected abstract InputStream getLeafContent(T var1);

    public static class Leaf {
        protected String leafName;
        protected InputStream leafStream;
        protected Map<String, Object> leafProps;

        public Leaf(String leafName, InputStream leafStream) {
            this.leafName = leafName;
            this.leafStream = leafStream;
            this.leafProps = new HashMap<String, Object>();
        }

        public String getLeafName() {
            return this.leafName;
        }

        public InputStream getLeafStream() {
            return this.leafStream;
        }

        public Object getLeafProp(String propName) {
            return this.leafProps.get(propName);
        }

        public void setLeafProp(String propName, Object propValue) {
            this.leafProps.put(propName, propValue);
        }

        public Map<String, Object> getLeafProps() {
            return Collections.unmodifiableMap(this.leafProps);
        }
    }
}

