/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.bcb;

import java.util.List;
import javax.swing.Icon;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.common.StringValuePair;

final class BreadcrumbItemChoices<T> {
    private BreadcrumbItem<T>[] choices;
    private BreadcrumbItem ancestor;
    private int selectedIndex = 0;

    public BreadcrumbItemChoices(BreadcrumbItem ancestor, List<StringValuePair<T>> entries) {
        this.ancestor = ancestor;
        this.choices = new BreadcrumbItem[entries.size()];
        int index = 0;
        for (StringValuePair<T> pair : entries) {
            this.choices[index] = new BreadcrumbItem((String)pair.getKey(), pair.getValue());
            this.choices[index].setIcon((Icon)pair.get("icon"));
            ++index;
        }
        this.selectedIndex = -1;
    }

    public int getPosition(String s) {
        assert (s != null && s.length() > 0);
        int i = 0;
        while (i < this.choices.length) {
            BreadcrumbItem<T> it = this.choices[i];
            if (s.equals(it.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public BreadcrumbItem[] getChoices() {
        return this.choices;
    }

    public BreadcrumbItem getAncestor() {
        return this.ancestor;
    }
}

