/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import org.fest.assertions.Assertions;
import org.fest.swing.awt.AWT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;

public class ActionCommandButtonTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    int count;
    JCommandButton button;

    @Override
    @Before
    public void onSetUp() {
        URL resource = ActionCommandButtonTestCase.class.getClassLoader().getResource("utest/common/edit-paste.svg");
        Assertions.assertThat(resource).isNotNull();
        final SvgBatikResizableIcon icon = SvgBatikResizableIcon.getSvgIcon(resource, new Dimension(32, 32));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)icon)).isLoading();
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.buttonFrame = new JFrame();
                ActionCommandButtonTestCase.this.buttonFrame.setLayout(new FlowLayout());
                ActionCommandButtonTestCase.this.button = new JCommandButton("test", icon);
                ActionCommandButtonTestCase.this.button.setDisplayState(CommandButtonDisplayState.BIG);
                ActionCommandButtonTestCase.this.buttonFrame.add(ActionCommandButtonTestCase.this.button);
                ActionCommandButtonTestCase.this.buttonFrame.setSize(300, 200);
                ActionCommandButtonTestCase.this.buttonFrame.setLocationRelativeTo(null);
                ActionCommandButtonTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                ActionCommandButtonTestCase.this.buttonFrame.setVisible(true);
                ActionCommandButtonTestCase.this.count = 0;
                ActionCommandButtonTestCase.this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ++(this).ActionCommandButtonTestCase.this.count;
                    }
                });
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = ActionCommandButtonTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                ActionCommandButtonTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void sanityCheck() {
        String buttonText = GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.getText();
            }
        });
        Assertions.assertThat(buttonText).isEqualTo("test");
    }

    @Test
    public void activateButtonWithMouse() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void activateButtonWithSpace() {
        this.robot().moveMouse(this.button);
        this.robot().pressAndReleaseKeys(32);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void activateButtonWithAPI() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.doActionClick();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void fireActionOnPress() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.getActionModel().setFireActionOnPress(false);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.getActionModel().isFireActionOnPress();
            }
        })).isFalse();
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.getActionModel().setFireActionOnPress(true);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.getActionModel().isFireActionOnPress();
            }
        })).isTrue();
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(2);
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(2);
    }

    @Test
    public void fireActionOnRollover() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setFireActionOnRollover(false);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isFireActionOnRollover();
            }
        })).isFalse();
        this.robot().moveMouse(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setFireActionOnRollover(true);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isFireActionOnRollover();
            }
        })).isTrue();
        this.robot().moveMouse(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void autoRepeatWithMouseRelease() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setAutoRepeatAction(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isAutoRepeatAction();
            }
        })).isTrue();
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        Pause.pause(1000L);
        this.robot().releaseMouseButtons();
        Assertions.assertThat(this.count).isGreaterThan(1);
    }

    @Test
    public void autoRepeatWithButtonDisabling() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setAutoRepeatAction(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isAutoRepeatAction();
            }
        })).isTrue();
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        Pause.pause(1000L);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.getActionModel().setEnabled(false);
            }
        });
        int currCount = this.count;
        Assertions.assertThat(currCount).isGreaterThan(1);
        Pause.pause(1000L);
        Assertions.assertThat(this.count).isEqualTo(currCount);
        this.robot().releaseMouseButtons();
    }

    @Test
    public void autoRepeatWhenActionIsFiredByRollover() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setFireActionOnRollover(true);
                ActionCommandButtonTestCase.this.button.setAutoRepeatAction(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isAutoRepeatAction();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isFireActionOnRollover();
            }
        })).isTrue();
        this.robot().moveMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Pause.pause(1000L);
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isGreaterThan(1);
    }

    @Test
    public void fireActionOnRolloverWithUserPressingTheMouse() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setFireActionOnRollover(false);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isFireActionOnRollover();
            }
        })).isFalse();
        this.robot().moveMouse(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setFireActionOnRollover(true);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isFireActionOnRollover();
            }
        })).isTrue();
        this.robot().moveMouse(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void autoRepeatWhenActionIsFiredByRolloverAndMouseIsMoving() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setFireActionOnRollover(true);
                ActionCommandButtonTestCase.this.button.setAutoRepeatAction(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isAutoRepeatAction();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.isFireActionOnRollover();
            }
        })).isTrue();
        this.robot().moveMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Pause.pause(1000L);
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        int currCount = this.count;
        Assertions.assertThat(currCount).isGreaterThan(1);
        Pause.pause(1000L);
        this.robot().moveMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Pause.pause(1000L);
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isGreaterThan(currCount + 1);
    }

    @Test
    public void pressButtonAndDisableBeforeRelease() {
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.getActionModel().setEnabled(false);
            }
        });
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void pressButtonAndMoveAwayBeforeRelease() {
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void changeText() {
        String buttonText = GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.getText();
            }
        });
        Assertions.assertThat(buttonText).isEqualTo("test");
        String newText = "New text";
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setText("New text");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() throws Throwable {
                return ActionCommandButtonTestCase.this.button.getText();
            }
        })).isEqualTo("New text");
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void changeIcon() {
        Dimension iconDimension = GuiActionRunner.execute(new GuiQuery<Dimension>(){

            @Override
            protected Dimension executeInEDT() throws Throwable {
                ResizableIcon icon = ActionCommandButtonTestCase.this.button.getIcon();
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
        });
        URL cutIconUrl = ActionCommandButtonTestCase.class.getClassLoader().getResource("utest/common/edit-cut.svg");
        Assertions.assertThat(cutIconUrl).isNotNull();
        final SvgBatikResizableIcon cutIcon = SvgBatikResizableIcon.getSvgIcon(cutIconUrl, new Dimension(16, 16));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)cutIcon)).isLoading();
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                ActionCommandButtonTestCase.this.button.setIcon(cutIcon);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Dimension>(){

            @Override
            protected Dimension executeInEDT() throws Throwable {
                ResizableIcon icon = ActionCommandButtonTestCase.this.button.getIcon();
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
        })).isEqualTo(iconDimension);
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }
}

