/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;

public class CommandButtonSizesTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    JCommandButton button1;
    JCommandButton button2;

    @Override
    @Before
    public void onSetUp() {
        final edit_paste icon1 = new edit_paste();
        final edit_cut icon2 = new edit_cut();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.buttonFrame = new JFrame();
                CommandButtonSizesTestCase.this.buttonFrame.setLayout(new FlowLayout());
                CommandButtonSizesTestCase.this.button1 = new JCommandButton("test1", icon1);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonSizesTestCase.this.buttonFrame.add(CommandButtonSizesTestCase.this.button1);
                CommandButtonSizesTestCase.this.button2 = new JCommandButton("test2", icon2);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonSizesTestCase.this.buttonFrame.add(CommandButtonSizesTestCase.this.button2);
                CommandButtonSizesTestCase.this.buttonFrame.setSize(300, 200);
                CommandButtonSizesTestCase.this.buttonFrame.setLocationRelativeTo(null);
                CommandButtonSizesTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                CommandButtonSizesTestCase.this.buttonFrame.setVisible(true);
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = CommandButtonSizesTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                CommandButtonSizesTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void actionOnlyBigAndActionOnlyBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button1.getPreferredSize().height - CommandButtonSizesTestCase.this.button2.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyBigAndPopupOnlyBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                if (CommandButtonSizesTestCase.this.button1.getPreferredSize().height == CommandButtonSizesTestCase.this.button2.getPreferredSize().height) {
                    return true;
                }
                return false;
            }
        })).isTrue();
    }

    @Test
    public void splitBigAndSplitBigHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button1.getPreferredSize().height - CommandButtonSizesTestCase.this.button2.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyBigAndSplitBigHaveDifferentHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.BIG);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.BIG);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isEqualTo(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return new JSeparator((int)0).getPreferredSize().height;
            }
        }));
    }

    @Test
    public void actionOnlyTileAndActionOnlyTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndSplitTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndSplit2TileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyTileAndPopupOnlyTileHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitTileAndSplitTileHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().width - CommandButtonSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }

    @Test
    public void popupOnlyTileAndSplitTileHaveDifferentWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.TILE);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.TILE);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().width - CommandButtonSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isEqualTo(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return new JSeparator((int)1).getPreferredSize().width;
            }
        }));
    }

    @Test
    public void actionOnlyMediumAndActionOnlyMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndSplitMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndSplit2MediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlyMediumAndPopupOnlyMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitMediumAndSplitMediumHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().width - CommandButtonSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }

    @Test
    public void popupOnlyMediumAndSplitMediumHaveDifferentWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.MEDIUM);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().width - CommandButtonSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isEqualTo(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return new JSeparator((int)1).getPreferredSize().width;
            }
        }));
    }

    @Test
    public void actionOnlySmallAndActionOnlySmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndSplitSmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndSplit2SmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void actionOnlySmallAndPopupOnlySmallHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }

    @Test
    public void splitSmallAndSplitSmallHaveSameWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().width - CommandButtonSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isZero();
    }

    @Test
    public void popupOnlySmallAndSplitSmallHaveDifferentWidth() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.SMALL);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().width - CommandButtonSizesTestCase.this.button1.getPreferredSize().width;
            }
        })).isEqualTo(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return new JSeparator((int)1).getPreferredSize().width;
            }
        }));
    }

    @Test
    public void actionOnlySmallAndActionOnlyMediumHaveSameHeight() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandButtonSizesTestCase.this.button1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                CommandButtonSizesTestCase.this.button1.setDisplayState(CommandButtonDisplayState.SMALL);
                CommandButtonSizesTestCase.this.button2.setDisplayState(CommandButtonDisplayState.MEDIUM);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() throws Throwable {
                return CommandButtonSizesTestCase.this.button2.getPreferredSize().height - CommandButtonSizesTestCase.this.button1.getPreferredSize().height;
            }
        })).isZero();
    }
}

