/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;

public class PopupCommandButtonTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    JCommandButton button;
    StringBuffer stringBuffer;
    JCommandMenuButton[] menuButtons;
    static final int MENU_BUTTON_COUNT = 5;

    @Override
    @Before
    public void onSetUp() {
        URL resource = PopupCommandButtonTestCase.class.getClassLoader().getResource("utest/common/edit-paste.svg");
        Assertions.assertThat(resource).isNotNull();
        final SvgBatikResizableIcon icon = SvgBatikResizableIcon.getSvgIcon(resource, new Dimension(32, 32));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)icon)).isLoading();
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                PopupCommandButtonTestCase.this.stringBuffer = new StringBuffer();
                PopupCommandButtonTestCase.this.buttonFrame = new JFrame();
                PopupCommandButtonTestCase.this.button = new JCommandButton("test", icon);
                PopupCommandButtonTestCase.this.button.setDisplayState(CommandButtonDisplayState.BIG);
                PopupCommandButtonTestCase.this.button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                PopupCommandButtonTestCase.this.button.setPopupCallback(new PopupPanelCallback(){

                    @Override
                    public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                        JCommandPopupMenu result = new JCommandPopupMenu();
                        (this).PopupCommandButtonTestCase.this.menuButtons = new JCommandMenuButton[5];
                        int i = 0;
                        while (i < 5) {
                            final int index = i;
                            (this).PopupCommandButtonTestCase.this.menuButtons[i] = new JCommandMenuButton("popup " + i, new EmptyResizableIcon(16));
                            (this).PopupCommandButtonTestCase.this.menuButtons[i].addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ((this).this).PopupCommandButtonTestCase.this.stringBuffer.append(index);
                                }
                            });
                            result.addMenuButton((this).PopupCommandButtonTestCase.this.menuButtons[i]);
                            ++i;
                        }
                        return result;
                    }
                });
                PopupCommandButtonTestCase.this.buttonFrame.setLayout(new FlowLayout());
                PopupCommandButtonTestCase.this.buttonFrame.add(PopupCommandButtonTestCase.this.button);
                PopupCommandButtonTestCase.this.buttonFrame.setSize(300, 200);
                PopupCommandButtonTestCase.this.buttonFrame.setLocationRelativeTo(null);
                PopupCommandButtonTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                PopupCommandButtonTestCase.this.buttonFrame.setVisible(true);
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = PopupCommandButtonTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                PopupCommandButtonTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void activatePopupWithMouse() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
    }

    @Test
    public void activatePopupWithAPI() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                PopupCommandButtonTestCase.this.button.doPopupClick();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
    }

    @Test
    public void popupDismissalByClickingOutsideTheButton() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        this.robot().click((Component)this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
    }

    @Test
    public void popupDismissalByClickingTheButton() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
    }

    @Test
    public void clickTheFirstMenuButton() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.menuButtons[0].isVisible();
            }
        })).isTrue();
        this.robot().click(this.menuButtons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo("0");
    }

    @Test
    public void clickTheFirstAndSecondMenuButton() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.menuButtons[0].isVisible();
            }
        })).isTrue();
        this.robot().click(this.menuButtons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo("0");
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.menuButtons[1].isVisible();
            }
        })).isTrue();
        this.robot().click(this.menuButtons[1]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo("01");
    }

    @Test
    public void clickAllMenuButtons() {
        int i = 0;
        while (i < 5) {
            this.robot().click(this.button);
            this.robot().waitForIdle();
            final int index = i;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return PopupCommandButtonTestCase.this.menuButtons[index].isVisible();
                }
            })).isTrue();
            this.robot().click(this.menuButtons[i]);
            this.robot().waitForIdle();
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
                }
            })).isFalse();
            ++i;
        }
        String expected = "";
        int i2 = 0;
        while (i2 < 5) {
            expected = String.valueOf(expected) + i2;
            ++i2;
        }
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo(expected);
    }

    @Test
    public void checkPopupDisable() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                PopupCommandButtonTestCase.this.button.getPopupModel().setEnabled(false);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isEnabled();
            }
        })).isFalse();
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                PopupCommandButtonTestCase.this.button.getPopupModel().setEnabled(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isEnabled();
            }
        })).isTrue();
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return PopupCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
    }
}

