/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.JAuthenticator;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.PreferenceDialog;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.swing.gvt.AbstractJGVTComponent;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.AbstractJSVGComponent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.util.ApplicationSecurityEnforcer;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Platform;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.util.resources.ResourceManager;

public class Main
implements Application {
    public static final String UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION = ".load";
    public static final String PROPERTY_USER_HOME = "user.home";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String BATIK_CONFIGURATION_SUBDIRECTORY = ".batik";
    public static final String SQUIGGLE_CONFIGURATION_FILE = "preferences.xml";
    public static final String SQUIGGLE_POLICY_FILE = "__svgbrowser.policy";
    public static final String POLICY_GRANT_SCRIPT_NETWORK_ACCESS = "grant {\n  permission java.net.SocketPermission \"*\", \"listen, connect, resolve, accept\";\n};\n\n";
    public static final String POLICY_GRANT_SCRIPT_FILE_ACCESS = "grant {\n  permission java.io.FilePermission \"<<ALL FILES>>\", \"read\";\n};\n\n";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST = "preference.key.visited.uri.list";
    public static final String PREFERENCE_KEY_VISITED_URI_LIST_LENGTH = "preference.key.visited.uri.list.length";
    public static final String URI_SEPARATOR = " ";
    public static final String DEFAULT_DEFAULT_FONT_FAMILY = "Arial, Helvetica, sans-serif";
    public static final String SVG_INITIALIZATION = "resources/init.svg";
    protected String svgInitializationURI;
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.Main";
    public static final String SQUIGGLE_SECURITY_POLICY = "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.Main", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected static ImageIcon frameIcon = new ImageIcon(Main.class.getResource(resources.getString("Frame.icon")));
    protected XMLPreferenceManager preferenceManager;
    public static final int MAX_VISITED_URIS = 10;
    protected Vector lastVisited = new Vector();
    protected int maxVisitedURIs = 10;
    protected String[] arguments;
    protected boolean overrideSecurityPolicy = false;
    protected ApplicationSecurityEnforcer securityEnforcer;
    protected Map handlers = new HashMap();
    protected List viewerFrames;
    protected PreferenceDialog preferenceDialog;
    protected String uiSpecialization;

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    public Main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        Object object5;
        Serializable serializable2;
        this.handlers.put("-font-size", new FontSizeHandler());
        this.viewerFrames = new LinkedList();
        this.arguments = stringArray;
        if (Platform.isOSX) {
            this.uiSpecialization = "OSX";
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            try {
                serializable2 = Class.forName("com.apple.eawt.Application");
                object5 = Class.forName("com.apple.eawt.ApplicationListener");
                serializable = Class.forName("com.apple.eawt.ApplicationEvent");
                object4 = ((Class)serializable2).getMethod("getApplication", new Class[0]);
                object3 = ((Class)serializable2).getMethod("addApplicationListener", new Class[]{object5});
                object2 = ((Class)serializable).getMethod("setHandled", Boolean.TYPE);
                object = ((Class)serializable2).getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
                InvocationHandler invocationHandler = new InvocationHandler((Method)object2){
                    final /* synthetic */ Method val$setHandled;
                    {
                        this.val$setHandled = method;
                    }

                    public Object invoke(Object object, Method method, Object[] objectArray) {
                        String string = method.getName();
                        if (string.equals("handleAbout")) {
                            JSVGViewerFrame jSVGViewerFrame = Main.this.viewerFrames.isEmpty() ? null : (JSVGViewerFrame)Main.this.viewerFrames.get(0);
                            AboutDialog aboutDialog = new AboutDialog(jSVGViewerFrame);
                            aboutDialog.setSize(aboutDialog.getPreferredSize());
                            aboutDialog.setLocationRelativeTo(jSVGViewerFrame);
                            aboutDialog.setVisible(true);
                            aboutDialog.toFront();
                        } else if (string.equals("handlePreferences")) {
                            JSVGViewerFrame jSVGViewerFrame = Main.this.viewerFrames.isEmpty() ? null : (JSVGViewerFrame)Main.this.viewerFrames.get(0);
                            Main.this.showPreferenceDialog(jSVGViewerFrame);
                        } else if (!string.equals("handleQuit")) {
                            return null;
                        }
                        try {
                            this.val$setHandled.invoke(objectArray[0], Boolean.TRUE);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                };
                Object object6 = ((Method)object4).invoke(null, (Object[])null);
                ((Method)object).invoke(object6, Boolean.TRUE);
                Object object7 = Proxy.newProxyInstance(Main.class.getClassLoader(), new Class[]{object5}, invocationHandler);
                ((Method)object3).invoke(object6, object7);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.uiSpecialization = null;
            }
        }
        serializable2 = new HashMap<String, String>(11);
        serializable2.put("preference.key.languages", Locale.getDefault().getLanguage());
        serializable2.put("preference.key.show.rendering", Boolean.FALSE);
        serializable2.put("preference.key.auto.adjust.window", Boolean.TRUE);
        serializable2.put("preference.key.selection.xor.mode", Boolean.FALSE);
        serializable2.put("preference.key.enable.double.buffering", Boolean.TRUE);
        serializable2.put("preference.key.show.debug.trace", Boolean.FALSE);
        serializable2.put("preference.key.proxy.host", "");
        serializable2.put("preference.key.proxy.port", "");
        serializable2.put("preference.key.cssmedia", "screen");
        serializable2.put("preference.key.default.font.family", DEFAULT_DEFAULT_FONT_FAMILY);
        serializable2.put("preference.key.is.xml.parser.validating", Boolean.FALSE);
        serializable2.put("preference.key.enforce.secure.scripting", Boolean.TRUE);
        serializable2.put("preference.key.grant.script.file.access", Boolean.FALSE);
        serializable2.put("preference.key.grant.script.network.access", Boolean.FALSE);
        serializable2.put("preference.key.load.java.script", Boolean.TRUE);
        serializable2.put("preference.key.load.ecmascript", Boolean.TRUE);
        serializable2.put("preference.key.allowed.script.origin", new Integer(2));
        serializable2.put("preference.key.allowed.external.resource.origin", new Integer(1));
        serializable2.put(PREFERENCE_KEY_VISITED_URI_LIST, "");
        serializable2.put(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH, new Integer(10));
        serializable2.put("preference.key.animation.rate.limiting.mode", new Integer(1));
        serializable2.put("preference.key.animation.rate.limiting.cpu", new Float(0.75f));
        serializable2.put("preference.key.animation.rate.limiting.fps", new Float(10.0f));
        serializable2.put("preference.key.user.stylesheet.enabled", Boolean.TRUE);
        this.securityEnforcer = new ApplicationSecurityEnforcer(this.getClass(), SQUIGGLE_SECURITY_POLICY);
        try {
            this.preferenceManager = new XMLPreferenceManager(SQUIGGLE_CONFIGURATION_FILE, (Map)((Object)serializable2));
            object5 = System.getProperty(PROPERTY_USER_HOME);
            serializable = new File((String)object5, BATIK_CONFIGURATION_SUBDIRECTORY);
            ((File)serializable).mkdir();
            XMLPreferenceManager.setPreferenceDirectory(((File)serializable).getCanonicalPath());
            this.preferenceManager.load();
            this.setPreferences();
            this.initializeLastVisited();
            Authenticator.setDefault(new JAuthenticator());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object5 = new AboutDialog();
        ((BorderLayout)((JWindow)object5).getContentPane().getLayout()).setVgap(8);
        serializable = new JProgressBar(0, 3);
        ((JWindow)object5).getContentPane().add((Component)serializable, "South");
        object4 = ((Window)object5).getToolkit().getScreenSize();
        object3 = ((Container)object5).getPreferredSize();
        ((Window)object5).setLocation((((Dimension)object4).width - ((Dimension)object3).width) / 2, (((Dimension)object4).height - ((Dimension)object3).height) / 2);
        ((Window)object5).setSize((Dimension)object3);
        ((Window)object5).setVisible(true);
        object2 = new JSVGViewerFrame(this);
        object = ((JSVGViewerFrame)object2).getJSVGCanvas();
        ((AbstractJSVGComponent)object).addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter((JProgressBar)serializable){
            final /* synthetic */ JProgressBar val$pb;
            {
                this.val$pb = jProgressBar;
            }

            public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                this.val$pb.setValue(1);
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
                this.val$pb.setValue(2);
            }
        });
        ((AbstractJSVGComponent)object).addGVTTreeBuilderListener(new GVTTreeBuilderAdapter((JProgressBar)serializable){
            final /* synthetic */ JProgressBar val$pb;
            {
                this.val$pb = jProgressBar;
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                this.val$pb.setValue(3);
            }
        });
        ((AbstractJGVTComponent)object).addGVTTreeRendererListener(new GVTTreeRendererAdapter((AboutDialog)object5, (JSVGViewerFrame)object2){
            final /* synthetic */ AboutDialog val$initDialog;
            final /* synthetic */ JSVGViewerFrame val$v;
            {
                this.val$initDialog = aboutDialog;
                this.val$v = jSVGViewerFrame;
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
                this.val$initDialog.dispose();
                this.val$v.dispose();
                System.gc();
                Main.this.run();
            }
        });
        ((Component)object).setSize(100, 100);
        this.svgInitializationURI = Main.class.getResource(SVG_INITIALIZATION).toString();
        ((AbstractJSVGComponent)object).loadSVGDocument(this.svgInitializationURI);
    }

    public void installCustomPolicyFile() throws IOException {
        String string = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (this.overrideSecurityPolicy || string == null || "".equals(string)) {
            ParsedURL parsedURL = new ParsedURL(this.securityEnforcer.getPolicyURL());
            String string2 = System.getProperty(PROPERTY_USER_HOME);
            File file = new File(string2, BATIK_CONFIGURATION_SUBDIRECTORY);
            File file2 = new File(file, SQUIGGLE_POLICY_FILE);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(parsedURL.openStream()));
            FileWriter fileWriter = new FileWriter(file2);
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) != -1) {
                ((Writer)fileWriter).write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            boolean bl = this.preferenceManager.getBoolean("preference.key.grant.script.network.access");
            boolean bl2 = this.preferenceManager.getBoolean("preference.key.grant.script.file.access");
            if (bl) {
                fileWriter.write(POLICY_GRANT_SCRIPT_NETWORK_ACCESS);
            }
            if (bl2) {
                fileWriter.write(POLICY_GRANT_SCRIPT_FILE_ACCESS);
            }
            ((Writer)fileWriter).close();
            this.overrideSecurityPolicy = true;
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, file2.toURL().toString());
        }
    }

    public void run() {
        try {
            Object object;
            int n;
            for (n = 0; n < this.arguments.length && (object = (OptionHandler)this.handlers.get(this.arguments[n])) != null; ++n) {
                n = object.handleOption(n);
            }
            object = this.createAndShowJSVGViewerFrame();
            while (n < this.arguments.length) {
                if (this.arguments[n].length() == 0) {
                    ++n;
                    continue;
                }
                File file = new File(this.arguments[n]);
                String string = null;
                try {
                    if (file.canRead()) {
                        string = file.toURL().toString();
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (string == null) {
                    string = this.arguments[n];
                    ParsedURL parsedURL = null;
                    parsedURL = new ParsedURL(this.arguments[n]);
                    if (!parsedURL.complete()) {
                        string = null;
                    }
                }
                if (string != null) {
                    if (object == null) {
                        object = this.createAndShowJSVGViewerFrame();
                    }
                    ((JSVGViewerFrame)object).showSVGDocument(string);
                    object = null;
                } else {
                    JOptionPane.showMessageDialog((Component)object, resources.getString("Error.skipping.file") + this.arguments[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        System.out.println();
        System.out.println(resources.getString("Command.header"));
        System.out.println(resources.getString("Command.syntax"));
        System.out.println();
        System.out.println(resources.getString("Command.options"));
        for (String string : this.handlers.keySet()) {
            System.out.println(((OptionHandler)this.handlers.get(string)).getDescription());
        }
    }

    public JSVGViewerFrame createAndShowJSVGViewerFrame() {
        JSVGViewerFrame jSVGViewerFrame = new JSVGViewerFrame(this);
        jSVGViewerFrame.setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        jSVGViewerFrame.setIconImage(frameIcon.getImage());
        jSVGViewerFrame.setTitle(resources.getString("Frame.title"));
        jSVGViewerFrame.setVisible(true);
        this.viewerFrames.add(jSVGViewerFrame);
        this.setPreferences(jSVGViewerFrame);
        return jSVGViewerFrame;
    }

    public void closeJSVGViewerFrame(JSVGViewerFrame jSVGViewerFrame) {
        jSVGViewerFrame.getJSVGCanvas().stopProcessing();
        this.viewerFrames.remove(jSVGViewerFrame);
        if (this.viewerFrames.size() == 0) {
            System.exit(0);
        }
        jSVGViewerFrame.dispose();
    }

    public Action createExitAction(JSVGViewerFrame jSVGViewerFrame) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
    }

    public void openLink(String string) {
        JSVGViewerFrame jSVGViewerFrame = this.createAndShowJSVGViewerFrame();
        jSVGViewerFrame.getJSVGCanvas().loadSVGDocument(string);
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public boolean isXMLParserValidating() {
        return this.preferenceManager.getBoolean("preference.key.is.xml.parser.validating");
    }

    public void showPreferenceDialog(JSVGViewerFrame jSVGViewerFrame) {
        if (this.preferenceDialog == null) {
            this.preferenceDialog = new PreferenceDialog((Frame)jSVGViewerFrame, this.preferenceManager);
        }
        if (this.preferenceDialog.showDialog() == 0) {
            try {
                this.preferenceManager.save();
                this.setPreferences();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setPreferences() throws IOException {
        Iterator iterator = this.viewerFrames.iterator();
        while (iterator.hasNext()) {
            this.setPreferences((JSVGViewerFrame)iterator.next());
        }
        System.setProperty("proxyHost", this.preferenceManager.getString("preference.key.proxy.host"));
        System.setProperty("proxyPort", this.preferenceManager.getString("preference.key.proxy.port"));
        this.installCustomPolicyFile();
        this.securityEnforcer.enforceSecurity(this.preferenceManager.getBoolean("preference.key.enforce.secure.scripting"));
    }

    private void setPreferences(JSVGViewerFrame jSVGViewerFrame) {
        boolean bl = this.preferenceManager.getBoolean("preference.key.enable.double.buffering");
        jSVGViewerFrame.getJSVGCanvas().setDoubleBufferedRendering(bl);
        boolean bl2 = this.preferenceManager.getBoolean("preference.key.show.rendering");
        jSVGViewerFrame.getJSVGCanvas().setProgressivePaint(bl2);
        boolean bl3 = this.preferenceManager.getBoolean("preference.key.show.debug.trace");
        jSVGViewerFrame.setDebug(bl3);
        boolean bl4 = this.preferenceManager.getBoolean("preference.key.auto.adjust.window");
        jSVGViewerFrame.setAutoAdjust(bl4);
        boolean bl5 = this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
        jSVGViewerFrame.getJSVGCanvas().setSelectionOverlayXORMode(bl5);
        int n = this.preferenceManager.getInteger("preference.key.animation.rate.limiting.mode");
        if (n < 0 || n > 2) {
            n = 1;
        }
        switch (n) {
            case 0: {
                jSVGViewerFrame.getJSVGCanvas().setAnimationLimitingNone();
                break;
            }
            case 1: {
                float f = this.preferenceManager.getFloat("preference.key.animation.rate.limiting.cpu");
                if (f <= 0.0f || f > 1.0f) {
                    f = 0.75f;
                }
                jSVGViewerFrame.getJSVGCanvas().setAnimationLimitingCPU(f);
                break;
            }
            case 2: {
                float f = this.preferenceManager.getFloat("preference.key.animation.rate.limiting.fps");
                if (f <= 0.0f) {
                    f = 10.0f;
                }
                jSVGViewerFrame.getJSVGCanvas().setAnimationLimitingFPS(f);
                break;
            }
        }
    }

    public String getLanguages() {
        String string = this.preferenceManager.getString("preference.key.languages");
        return string == null ? Locale.getDefault().getLanguage() : string;
    }

    public String getUserStyleSheetURI() {
        boolean bl = this.preferenceManager.getBoolean("preference.key.user.stylesheet.enabled");
        String string = this.preferenceManager.getString("preference.key.user.stylesheet");
        if (!bl || string.length() == 0) {
            return null;
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                return file.toURL().toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public String getDefaultFontFamily() {
        return this.preferenceManager.getString("preference.key.default.font.family");
    }

    public String getMedia() {
        String string = this.preferenceManager.getString("preference.key.cssmedia");
        return string == null ? "screen" : string;
    }

    public boolean isSelectionOverlayXORMode() {
        return this.preferenceManager.getBoolean("preference.key.selection.xor.mode");
    }

    public boolean canLoadScriptType(String string) {
        if ("text/ecmascript".equals(string) || "application/ecmascript".equals(string) || "text/javascript".equals(string) || "application/javascript".equals(string)) {
            return this.preferenceManager.getBoolean("preference.key.load.ecmascript");
        }
        if ("application/java-archive".equals(string)) {
            return this.preferenceManager.getBoolean("preference.key.load.java.script");
        }
        return this.preferenceManager.getBoolean(string + UNKNOWN_SCRIPT_TYPE_LOAD_KEY_EXTENSION);
    }

    public int getAllowedScriptOrigin() {
        int n = this.preferenceManager.getInteger("preference.key.allowed.script.origin");
        return n;
    }

    public int getAllowedExternalResourceOrigin() {
        int n = this.preferenceManager.getInteger("preference.key.allowed.external.resource.origin");
        return n;
    }

    public void addVisitedURI(String string) {
        if (this.svgInitializationURI.equals(string)) {
            return;
        }
        int n = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH);
        if (n < 0) {
            n = 0;
        }
        if (this.lastVisited.contains(string)) {
            this.lastVisited.removeElement(string);
        }
        while (this.lastVisited.size() > 0 && this.lastVisited.size() > n - 1) {
            this.lastVisited.removeElementAt(0);
        }
        if (n > 0) {
            this.lastVisited.addElement(string);
        }
        StringBuffer stringBuffer = new StringBuffer(this.lastVisited.size() * 8);
        for (int i = 0; i < this.lastVisited.size(); ++i) {
            stringBuffer.append(URLEncoder.encode(this.lastVisited.get(i).toString()));
            stringBuffer.append(URI_SEPARATOR);
        }
        this.preferenceManager.setString(PREFERENCE_KEY_VISITED_URI_LIST, stringBuffer.toString());
        try {
            this.preferenceManager.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getVisitedURIs() {
        String[] stringArray = new String[this.lastVisited.size()];
        this.lastVisited.toArray(stringArray);
        return stringArray;
    }

    public String getUISpecialization() {
        return this.uiSpecialization;
    }

    protected void initializeLastVisited() {
        int n;
        String string = this.preferenceManager.getString(PREFERENCE_KEY_VISITED_URI_LIST);
        StringTokenizer stringTokenizer = new StringTokenizer(string, URI_SEPARATOR);
        int n2 = stringTokenizer.countTokens();
        if (n2 > (n = this.preferenceManager.getInteger(PREFERENCE_KEY_VISITED_URI_LIST_LENGTH))) {
            n2 = n;
        }
        for (int i = 0; i < n2; ++i) {
            this.lastVisited.addElement(URLDecoder.decode(stringTokenizer.nextToken()));
        }
    }

    protected class FontSizeHandler
    implements OptionHandler {
        protected FontSizeHandler() {
        }

        public int handleOption(int n) {
            int n2 = Integer.parseInt(Main.this.arguments[++n]);
            Font font = new Font("Dialog", 0, n2);
            FontUIResource fontUIResource = new FontUIResource(font);
            UIManager.put("CheckBox.font", fontUIResource);
            UIManager.put("PopupMenu.font", fontUIResource);
            UIManager.put("TextPane.font", fontUIResource);
            UIManager.put("MenuItem.font", fontUIResource);
            UIManager.put("ComboBox.font", fontUIResource);
            UIManager.put("Button.font", fontUIResource);
            UIManager.put("Tree.font", fontUIResource);
            UIManager.put("ScrollPane.font", fontUIResource);
            UIManager.put("TabbedPane.font", fontUIResource);
            UIManager.put("EditorPane.font", fontUIResource);
            UIManager.put("TitledBorder.font", fontUIResource);
            UIManager.put("Menu.font", fontUIResource);
            UIManager.put("TextArea.font", fontUIResource);
            UIManager.put("OptionPane.font", fontUIResource);
            UIManager.put("DesktopIcon.font", fontUIResource);
            UIManager.put("MenuBar.font", fontUIResource);
            UIManager.put("ToolBar.font", fontUIResource);
            UIManager.put("RadioButton.font", fontUIResource);
            UIManager.put("RadioButtonMenuItem.font", fontUIResource);
            UIManager.put("ToggleButton.font", fontUIResource);
            UIManager.put("ToolTip.font", fontUIResource);
            UIManager.put("ProgressBar.font", fontUIResource);
            UIManager.put("TableHeader.font", fontUIResource);
            UIManager.put("Panel.font", fontUIResource);
            UIManager.put("List.font", fontUIResource);
            UIManager.put("ColorChooser.font", fontUIResource);
            UIManager.put("PasswordField.font", fontUIResource);
            UIManager.put("TextField.font", fontUIResource);
            UIManager.put("Table.font", fontUIResource);
            UIManager.put("Label.font", fontUIResource);
            UIManager.put("InternalFrameTitlePane.font", fontUIResource);
            UIManager.put("CheckBoxMenuItem.font", fontUIResource);
            return n;
        }

        public String getDescription() {
            return resources.getString("Command.font-size");
        }
    }

    protected static interface OptionHandler {
        public int handleOption(int var1);

        public String getDescription();
    }
}

