/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGItem;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public abstract class AbstractSVGPointList
extends AbstractSVGList
implements SVGPointList {
    public static final String SVG_POINT_LIST_SEPARATOR = " ";

    protected String getItemSeparator() {
        return SVG_POINT_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    public SVGPoint initialize(SVGPoint sVGPoint) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.initializeImpl(sVGPoint));
    }

    public SVGPoint getItem(int n) throws DOMException {
        return (SVGPoint)((Object)this.getItemImpl(n));
    }

    public SVGPoint insertItemBefore(SVGPoint sVGPoint, int n) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.insertItemBeforeImpl(sVGPoint, n));
    }

    public SVGPoint replaceItem(SVGPoint sVGPoint, int n) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.replaceItemImpl(sVGPoint, n));
    }

    public SVGPoint removeItem(int n) throws DOMException {
        return (SVGPoint)((Object)this.removeItemImpl(n));
    }

    public SVGPoint appendItem(SVGPoint sVGPoint) throws DOMException, SVGException {
        return (SVGPoint)((Object)this.appendItemImpl(sVGPoint));
    }

    protected SVGItem createSVGItem(Object object) {
        SVGPoint sVGPoint = (SVGPoint)object;
        return new SVGPointItem(sVGPoint.getX(), sVGPoint.getY());
    }

    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        PointsParser pointsParser = new PointsParser();
        PointsListBuilder pointsListBuilder = new PointsListBuilder(listHandler);
        pointsParser.setPointsHandler(pointsListBuilder);
        pointsParser.parse(string);
    }

    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGPoint)) {
            this.createSVGException((short)0, "expected.point", null);
        }
    }

    protected class PointsListBuilder
    implements PointsHandler {
        protected ListHandler listHandler;

        public PointsListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startPoints() throws ParseException {
            this.listHandler.startList();
        }

        public void point(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPointItem(f, f2));
        }

        public void endPoints() throws ParseException {
            this.listHandler.endList();
        }
    }

    protected class SVGPointItem
    extends AbstractSVGItem
    implements SVGPoint {
        protected float x;
        protected float y;

        public SVGPointItem(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        protected String getStringValue() {
            return Float.toString(this.x) + ',' + Float.toString(this.y);
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
            this.resetAttribute();
        }

        public void setY(float f) {
            this.y = f;
            this.resetAttribute();
        }

        public SVGPoint matrixTransform(SVGMatrix sVGMatrix) {
            return SVGOMPoint.matrixTransform(this, sVGMatrix);
        }
    }
}

